/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.mappers;

import com.priocom.web.ActionHandler;
import com.priocom.web.ActionNotFoundException;
import com.priocom.web.UriActionMapper;
import com.priocom.web.handlers.NamedActionForwardHandler;
import com.priocom.web.utils.ServletUtils;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractClassMethodUriMapper
implements UriActionMapper {
    public static final String ACTION_PARAM_PREFIX = "action$";

    protected String getActionMethodName(HttpServletRequest httpServletRequest) {
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            if (!paramName.startsWith(ACTION_PARAM_PREFIX)) continue;
            if ((paramName = paramName.substring(ACTION_PARAM_PREFIX.length())).endsWith(".x")) {
                paramName = paramName.substring(0, paramName.lastIndexOf(".x"));
            } else if (paramName.endsWith(".y")) continue;
            return paramName;
        }
        String servletPath = ServletUtils.getOriginalServletPath(httpServletRequest);
        int dot = servletPath.lastIndexOf(46);
        String actionMethodName = servletPath.substring(servletPath.lastIndexOf(47) + 1, dot);
        return actionMethodName;
    }

    public ActionHandler getAction(HttpServletRequest httpServletRequest) throws ActionNotFoundException {
        String actionObjectName = this.getActionObjectName(httpServletRequest);
        String actionMethodName = this.getActionMethodName(httpServletRequest);
        if (actionObjectName == null || actionMethodName == null) {
            throw new ActionNotFoundException("Can't extract action name");
        }
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        return this.createHandler(actionObjectName, actionMethodName, servletContext);
    }

    protected abstract String getActionObjectName(HttpServletRequest var1);

    protected abstract NamedActionForwardHandler createHandler(String var1, String var2, ServletContext var3);
}

