/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.handlers;

import com.priocom.web.ActionHandler;
import com.priocom.web.Handler;
import com.priocom.web.ResultViewBuilder;
import com.priocom.web.utils.ServletUtils;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewHandler
implements Handler {
    private final String name;
    private final ResultViewBuilder builder;
    private final String modelRequestAttribute;

    public ViewHandler(String name, ResultViewBuilder builder, String modelRequestAttribute) {
        this.name = name;
        this.builder = builder;
        this.modelRequestAttribute = modelRequestAttribute;
    }

    public Handler process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Handler prevHandler) {
        ActionHandler action;
        try {
            action = (ActionHandler)prevHandler;
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Action handler expected before view handler: " + prevHandler);
        }
        httpServletRequest.setAttribute(this.modelRequestAttribute, action.getTemplateModel());
        String view = this.builder.getView(httpServletRequest, httpServletResponse, action, this.name);
        if (view == null) {
            throw new RuntimeException("Couldn't dispatch to view named: " + this.name);
        }
        this.dispatch(httpServletRequest, httpServletResponse, view);
        return null;
    }

    protected void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String view) {
        ServletUtils.dispatch((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, view);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ViewHandler) {
            ViewHandler that = (ViewHandler)obj;
            return this.name.equals(that.name);
        }
        return false;
    }
}

