/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.handlers;

import com.priocom.web.Handler;
import com.priocom.web.UriActionMapper;
import com.priocom.web.handlers.NamedActionHandler;
import java.io.IOException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NamedActionRedirectHandler
extends NamedActionHandler {
    private final UriActionMapper actionIdentifier;
    private final String[] parameterNames;
    private final String[] parameterValues;

    public NamedActionRedirectHandler(String objectName, String methodName, UriActionMapper actionIdentifier) {
        this(objectName, methodName, new String[0], new String[0], actionIdentifier);
    }

    public NamedActionRedirectHandler(String objectName, String methodName, String[] parameterNames, String[] parameterValues, UriActionMapper actionIdentifier) {
        super(objectName, methodName);
        this.parameterNames = parameterNames;
        this.parameterValues = parameterValues;
        this.actionIdentifier = actionIdentifier;
    }

    public Handler process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Handler prevHandler) {
        String redirect = this.getRedirectUrl(httpServletRequest.getContextPath());
        try {
            httpServletResponse.sendRedirect(redirect);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Can't redirect to url: " + redirect, ioe);
        }
        return null;
    }

    public String getRedirectUrl(String context) {
        URI uri = this.actionIdentifier.getURI(this);
        String redirect = uri.toString();
        if (!uri.isAbsolute()) {
            redirect = String.valueOf(context) + redirect;
        }
        if (this.parameterNames.length > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(redirect);
            buffer.append('?');
            int i = 0;
            while (i < this.parameterNames.length) {
                if (i != 0) {
                    buffer.append('&');
                }
                buffer.append(this.parameterNames[i]);
                buffer.append('=');
                buffer.append(this.parameterValues[i]);
                ++i;
            }
            redirect = buffer.toString();
        }
        return redirect;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamedActionRedirectHandler) {
            NamedActionRedirectHandler that = (NamedActionRedirectHandler)obj;
            if (this.parameterNames == null && that.parameterNames == null) {
                return super.equals(obj);
            }
            if (this.parameterNames.length != that.parameterNames.length) {
                return false;
            }
            int i = 0;
            while (i < this.parameterNames.length) {
                if (!this.parameterNames[i].equals(that.parameterNames[i])) {
                    return false;
                }
                if (!this.parameterValues[i].equals(that.parameterValues[i])) {
                    return false;
                }
                ++i;
            }
            return super.equals(obj);
        }
        return false;
    }

    public String toString() {
        return this.getRedirectUrl("");
    }
}

