/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.handlers;

import com.priocom.web.ActionOutcomeProcessor;
import com.priocom.web.Handler;
import com.priocom.web.PropertiesPopulator;
import com.priocom.web.handlers.ActionBuilder;
import com.priocom.web.handlers.ExecutionEventListener;
import com.priocom.web.handlers.NamedActionHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class NamedActionForwardHandler
extends NamedActionHandler {
    private final PropertiesPopulator propertiesPopulator;
    private final ActionOutcomeProcessor outcomeProcessor;
    private final ActionBuilder actionBuilder;

    public NamedActionForwardHandler(String objectName, String methodName, PropertiesPopulator propertiesPopulator, ActionOutcomeProcessor outcomeProcessor, ActionBuilder actionBuilder) {
        super(objectName, methodName);
        this.propertiesPopulator = propertiesPopulator;
        this.outcomeProcessor = outcomeProcessor;
        this.actionBuilder = actionBuilder;
    }

    protected abstract Class getActionClass();

    private Method getActionMethod() {
        Class cls = this.getActionClass();
        try {
            return cls.getMethod(this.getMethodName(), new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Handler process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Handler prevHandler) {
        Object action = this.actionBuilder.createAction(httpServletRequest, this.getActionClass());
        ExecutionEventListener executionEventListener = action instanceof ExecutionEventListener ? (ExecutionEventListener)action : null;
        this.propertiesPopulator.populateActionFromRequest(action, httpServletRequest);
        try {
            Object outcome = null;
            if (executionEventListener != null) {
                outcome = executionEventListener.preExecute(this.getMethodName());
            }
            if (outcome == null) {
                outcome = this.getActionMethod().invoke(action, new Object[0]);
            }
            Handler handler = this.outcomeProcessor.getHandler(outcome, action);
            this.templateModel = action;
            return handler;
        }
        catch (IllegalAccessException e) {
            String message = String.valueOf(action.getClass().getName()) + "." + this.getActionMethod().getName() + "() isn't public";
            throw new RuntimeException(message, e);
        }
        catch (InvocationTargetException e) {
            String message = "Failed to actionMethod " + action.getClass().getName() + "." + this.getActionMethod().getName() + "()";
            throw new RuntimeException(message, e.getTargetException());
        }
        catch (ClassCastException e) {
            String message = "Bad actionMethod (should return Handler) or use special outcome processor " + action.getClass().getName() + "." + this.getActionMethod().getName() + "()";
            throw new RuntimeException(message, e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NamedActionForwardHandler)) {
            return false;
        }
        return super.equals(obj);
    }
}

