/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web.download;

import com.priocom.web.download.Downloadable;
import com.priocom.web.download.Downloader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class DefaultDownloader
implements Downloader {
    public void download(HttpServletResponse response, Downloadable downloadable) {
        ServletOutputStream outputStream = null;
        try {
            try {
                outputStream = response.getOutputStream();
                response.setContentType(downloadable.getContentType());
                response.setHeader("Content-Disposition", "attachment; filename=" + downloadable.getFileName());
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Pragma-directive", "no-cache");
                response.setHeader("Cache-Directive", "no-cache");
                response.setHeader("Expires", "0");
                response.setContentLength(downloadable.getSize());
                DefaultDownloader.transfer(outputStream, downloadable.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static int transfer(OutputStream outputStream, InputStream inputStream) throws IOException {
        int b;
        int i = 0;
        BufferedOutputStream bos = new BufferedOutputStream(outputStream);
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        while ((b = bis.read()) != -1) {
            bos.write(b);
            ++i;
        }
        bos.flush();
        bis.close();
        return i;
    }
}

