/*
 * Decompiled with CFR 0.152.
 */
package com.priocom.web;

import com.priocom.web.ActionContext;
import com.priocom.web.ActionHandler;
import com.priocom.web.ActionNotFoundException;
import com.priocom.web.ErrorStore;
import com.priocom.web.Handler;
import com.priocom.web.UriActionMapper;
import com.priocom.web.handlers.ActionBuilder;
import com.priocom.web.mappers.PackageJavaUriActionMapper;
import com.priocom.web.outcome.DefaultActionOutcomeProcessor;
import com.priocom.web.populators.HttpRequestPopulator;
import com.priocom.web.upload.MultipartRequestWrapper;
import com.priocom.web.utils.ServletUtils;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUpload;

public class ActionServlet
extends HttpServlet {
    public static final String REQUEST_URI = "originalRequestUri";

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request = new MultipartRequestWrapper(request, new FileUpload());
        ServletContext context = request.getSession().getServletContext();
        ActionContext.setServletContext(context);
        String requestUri = (String)request.getAttribute(REQUEST_URI);
        if (requestUri == null) {
            String servletPath = ServletUtils.getOriginalServletPath(request);
            request.setAttribute(REQUEST_URI, servletPath);
        }
        try {
            try {
                Handler nextHandler;
                ErrorStore errorStore = this.getErrorStore(request);
                errorStore.clear();
                this.beginRequestProcessing(request, response);
                Handler handler = this.getActionIdentifier(request, response).getAction(request);
                ActionHandler prevHandler = null;
                do {
                    nextHandler = handler.process(request, response, prevHandler);
                    prevHandler = handler;
                } while ((handler = nextHandler) != null);
            }
            catch (ActionNotFoundException anfe) {
                response.sendError(404, anfe.getMessage());
            }
            catch (RuntimeException e) {
                ErrorStore errorStore = this.getErrorStore(request);
                errorStore.add(e);
                throw e;
            }
        }
        finally {
            this.endRequestProcessing(request, response);
            ActionContext.setServletContext(null);
        }
    }

    private ErrorStore getErrorStore(HttpServletRequest request) {
        if (request.getAttribute("errorStore") == null) {
            request.setAttribute("errorStore", new ErrorStore());
        }
        return (ErrorStore)request.getAttribute("errorStore");
    }

    protected UriActionMapper getActionIdentifier(HttpServletRequest request, HttpServletResponse response) {
        String actionPrefix = "/";
        String actionPackage = "";
        String actionSuffix = ".flow";
        DefaultActionOutcomeProcessor outcomeProcessor = new DefaultActionOutcomeProcessor();
        HttpRequestPopulator propertiesPopulator = new HttpRequestPopulator();
        ActionBuilder actionBuilder = new ActionBuilder(){

            public Object createAction(HttpServletRequest request, Class actionClass) {
                try {
                    return actionClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return new PackageJavaUriActionMapper(actionPrefix, actionPackage, actionSuffix, propertiesPopulator, outcomeProcessor, actionBuilder);
    }

    protected void endRequestProcessing(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void beginRequestProcessing(HttpServletRequest request, HttpServletResponse response) {
    }
}

