/*
 * Decompiled with CFR 0.152.
 */
package org.freeshell.zs.mediasniper;

import java.io.File;
import java.net.URL;
import java.util.Calendar;
import org.freeshell.zs.common.Debug;
import org.freeshell.zs.common.Downloader;
import org.freeshell.zs.common.HtmlManipulator;
import org.freeshell.zs.mediasniper.MediaSniper;

class Download
implements Runnable {
    private static final long REFRESH_INTERVAL_MILLISECONDS = 100L;
    private final MediaSniper parent;
    private final String title;
    private final URL url;
    private final String urlString;
    private volatile File file;
    private final String time;
    private volatile int length = -1;
    private volatile String lengthString = "unknown";
    private volatile Downloader downloader = null;
    private volatile boolean isCompleted = false;

    Download(MediaSniper parent, String title, URL url, File file) {
        this.parent = parent;
        this.title = title;
        this.url = url;
        this.urlString = url.toString();
        this.file = file;
        this.time = String.format("%1$tF %1$tT", Calendar.getInstance());
    }

    String getTitle() {
        return this.title;
    }

    String getUrlString() {
        return this.urlString;
    }

    File getFile() {
        return this.file;
    }

    String getFilename() {
        String p = this.file.getPath();
        String downloadDirectory = this.parent.properties.getFile("download.directory").getPath();
        if (!downloadDirectory.endsWith(File.separator)) {
            downloadDirectory = downloadDirectory + File.separator;
        }
        if (p.startsWith(downloadDirectory)) {
            return p.substring(downloadDirectory.length());
        }
        return p;
    }

    boolean setFilename(String newFilename) {
        File newFile = this.parent.localFilenameManager.replaceFilename(this.file, this.parent.properties.getFile("download.directory"), newFilename);
        if (newFile == null) {
            return false;
        }
        this.file = newFile;
        return true;
    }

    int getLength() {
        if (this.length == -1) {
            this.length = this.downloader == null ? -1 : this.downloader.getLength();
        }
        return this.length;
    }

    String getLengthString() {
        if ("unknown".equals(this.lengthString)) {
            int len = this.getLength();
            this.lengthString = len < 0 ? "unknown" : (len < 1024 ? String.format("%d b", len) : (len < 0x100000 ? String.format("%.1f kb", (double)len / 1024.0) : (len < 0x40000000 ? String.format("%.1f Mb", (double)len / 1048576.0) : String.format("%.1f Gb", (double)len / 1.073741824E9))));
        }
        return this.lengthString;
    }

    String getProgressString() {
        if (this.downloader == null) {
            return "Waiting to start";
        }
        return this.downloader.getProgressString();
    }

    int getProgressPercent() {
        if (this.downloader == null) {
            return -1;
        }
        return this.downloader.getProgressPercent();
    }

    boolean isCompleted() {
        return this.isCompleted;
    }

    String getToolTipText() {
        return "<html>Title: <b>" + this.title + "</b><br />" + "URL: " + HtmlManipulator.quoteHtml(this.urlString) + "<br />" + "Size: " + this.getLengthString() + "<br />" + "Local filename: <b>" + HtmlManipulator.quoteHtml(this.getFilename()) + "</b><br />" + "Time added: " + this.time + "</html>";
    }

    public void run() {
        this.downloader = new Downloader(this.url, this.file);
        new Thread(this.downloader).start();
        while (true) {
            if (this.downloader.isProgressUpdated()) {
                this.parent.refreshDownloadOnTable(this);
            }
            if (this.downloader.isCompleted()) {
                try {
                    this.downloader.waitUntilCompleted();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.parent.refreshDownloadOnTable(this);
                this.isCompleted = true;
                return;
            }
            Debug.sleep(100L);
        }
    }
}

