/*
 * Decompiled with CFR 0.152.
 */
package org.freeshell.zs.mediasniper;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Definition {
    private final String name;
    private final Map<String, String> map = new HashMap<String, String>();
    private final Map<String, Pattern> patternMap = new HashMap<String, Pattern>();

    Definition(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    String get(String key) throws NullPointerException {
        String value = this.map.get(key);
        if (value == null) {
            throw new NullPointerException("key does not exist in the map");
        }
        return value;
    }

    void put(String key, String value) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        this.map.put(key, value);
        if (key.endsWith(".match")) {
            try {
                this.patternMap.put(key, Pattern.compile(value));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    Pattern getPattern(String key) throws NullPointerException {
        Pattern pattern = this.patternMap.get(key);
        if (pattern == null) {
            throw new NullPointerException("key does not exist in the pattern map");
        }
        return pattern;
    }

    String evaluateTargetString(String targetKey, Map<String, String[]> matchedPatterns) throws NullPointerException {
        if (targetKey == null) {
            throw new NullPointerException("targetKey must not be null");
        }
        String targetValue = this.map.get(targetKey);
        if (targetValue == null) {
            throw new NullPointerException("targetKey does not exist in the map");
        }
        for (Map.Entry<String, String[]> e : matchedPatterns.entrySet()) {
            String s = e.getKey();
            String[] groups = e.getValue();
            for (int k = 0; k < groups.length; ++k) {
                targetValue = targetValue.replaceAll(Pattern.quote("<" + s + "." + k + ">"), groups[k]);
            }
        }
        return targetValue;
    }

    static String[] capturingGroupsAsArray(Matcher m) {
        String[] groups = new String[m.groupCount() + 1];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = m.group(i);
        }
        return groups;
    }
}

