/*
 * Decompiled with CFR 0.152.
 */
package org.freeshell.zs.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SwingManipulator {
    public static void addStandardEditingPopupMenu(JTextComponent[] fields) {
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem cutMenuItem = new JMenuItem("Cut", 116);
        cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component c = popupMenu.getInvoker();
                if (c instanceof JTextComponent) {
                    ((JTextComponent)c).cut();
                }
            }
        });
        popupMenu.add(cutMenuItem);
        JMenuItem copyMenuItem = new JMenuItem("Copy", 67);
        copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component c = popupMenu.getInvoker();
                if (c instanceof JTextComponent) {
                    ((JTextComponent)c).copy();
                }
            }
        });
        popupMenu.add(copyMenuItem);
        JMenuItem pasteMenuItem = new JMenuItem("Paste", 80);
        pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component c = popupMenu.getInvoker();
                if (c instanceof JTextComponent) {
                    ((JTextComponent)c).paste();
                }
            }
        });
        popupMenu.add(pasteMenuItem);
        popupMenu.addSeparator();
        JMenuItem selectAllMenuItem = new JMenuItem("Select All", 65);
        selectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Component c = popupMenu.getInvoker();
                if (c instanceof JTextComponent) {
                    ((JTextComponent)c).selectAll();
                }
            }
        });
        popupMenu.add(selectAllMenuItem);
        for (final JTextComponent f : fields) {
            f.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    this.processMouseEvent(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.processMouseEvent(e);
                }

                private void processMouseEvent(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        popupMenu.show(e.getComponent(), e.getX(), e.getY());
                        popupMenu.setInvoker(f);
                    }
                }
            });
        }
    }

    public static String getTextJTextField(JTextField f) {
        try {
            return f.getText();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public static char[] getPasswordJPasswordField(JPasswordField f) {
        try {
            return f.getPassword();
        }
        catch (NullPointerException e) {
            return new char[0];
        }
    }

    public static void updateProgressBar(final JProgressBar progress, final String text, final int percent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (percent >= 0 && percent <= 100) {
                    progress.setValue(percent);
                    progress.setIndeterminate(false);
                    if (percent < 100) {
                        progress.setString(text + " (" + percent + "%)");
                    } else {
                        progress.setString(text);
                    }
                } else {
                    progress.setString(text);
                    progress.setIndeterminate(true);
                }
            }
        });
    }

    public static void updateLabel(final JLabel label, final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                label.setText(text);
            }
        });
    }

    public static int showOptionTextDialog(final Component parentComponent, final String label, final String text, final int rows, final String title, final int optionType, final int messageType, final Icon icon, final Object[] options, final int initialValue) throws HeadlessException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ChoiceDialog
        implements Runnable {
            public int choiceIndex;

            ChoiceDialog() {
            }

            @Override
            public void run() {
                Object initialOption = null;
                if (options != null && initialValue >= 0 && initialValue < options.length) {
                    initialOption = options[initialValue];
                }
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)new JLabel(label + ":"), "North");
                JTextArea textArea = new JTextArea(text, rows, 50);
                textArea.setEditable(false);
                textArea.setWrapStyleWord(true);
                textArea.setLineWrap(true);
                textArea.setToolTipText(label);
                textArea.setFont(new Font("Dialog", 0, textArea.getFont().getSize() - 2));
                panel.add((Component)new JScrollPane(textArea, 20, 31), "Center");
                this.choiceIndex = JOptionPane.showOptionDialog(parentComponent, panel, title, optionType, messageType, icon, options, initialOption);
            }
        }
        ChoiceDialog r = new ChoiceDialog();
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return r.choiceIndex;
    }

    public static void showErrorDialog(Component parent, String title, String message) {
        SwingManipulator.showOptionTextDialog(parent, "An error has occurred", message, 5, title, -1, 0, null, null, 0);
    }

    public static void showWarningDialog(Component parent, String title, String message) {
        SwingManipulator.showOptionTextDialog(parent, "A warning has been issued", message, 5, title, -1, 2, null, null, 0);
    }

    public static void showInfoDialog(Component parent, String title, String label, String message, int rows) {
        SwingManipulator.showOptionTextDialog(parent, label, message, rows, title, -1, 1, null, null, 0);
    }
}

