
<%
'================== The GNU General Public License ================

'ImageIsle - An Image Management Web Application created by
'White Pacific Software. Copyright (C) 2005 White Pacific Software

'This program is free software; you can redistribute it and/or modify
'it under the terms of the GNU General Public License as published by
'the Free Software Foundation using version 2 of the License
'or any later version.

'This license must remain intact inside all distributions and/or
'copies of this application.

'www.whitepacificsoftware.com

'======================================================================






'...............................................
On Error Resume Next
'...............................................

'************************* SYSTEM MODULES *************************
'Program Version: 1.0000
'--------------------
'Prior Versions: -none-
'--------------------
'SystemModules.asp version: 1.0000
'--------------------
'******************************************************************

'\\\\\\\\\\\\\\\\\\\\\\\ CREATE MODULE/SKINS FUNCTIONS ////////////////////
'This first subsection of the Systems folder contains all the functions and features necessary to
'build the module and skins lists, as shown in the dropdowns at the top of the interface.
'The functions found here actually go into the web application folders,
'find the Modules and Skins master folders, detect all modules and skin
'subfolders installed there, find their configuration.xml files in those folders,
'and builds Application scoped arrays in the web application in ASP that hold those paths
'and variables. Those arrays are then used in the system to do things like:

'1. Build the Modules and Skins dropdown menu lists at the top of the web pages
'2. Allows all modules to access each other's database for cross-module data access
'3. Enable simple drag-and-drop funtionality when adding new Module or Skin folders to the app thats done automatically
'4. Allows control on how each module interacts in the system using the configuration.xml file found in each module
'5. Allows "instant update" if you change any module's configuration.xml settings or change module folder names.

'FULL ARRAY FUNCTION
'Detects and builds complex array based on all modules/skin folders found in the system
'and  stores the module/skin values plus those stored in the configuration.xml files
'inside a multidimensional array thats assigned to application scope variables.
'Any module or file can then access those variables as needed.
'The full array is rebuilt here only when the web app is first started, or configuration.xml file is changed (modified), or 
'when a new module/skin folder has been dropped into the "Modules"/"Skins" folder by a user.
'This is thus a new function that gets all child folders of a given path and stores then in an array, along with configuration values.
'Note: This array rebuilds the application arrays ONLY if there is a failed comparison match
'between this array and the Session("II_QUICK_ARRAY") created below. Failed comparisons
'indicates that a new module/skin has been added or someone has modified a module's configuration.xml
'file inside one of the added module/skins folders.
'In those cases, this method is called and the module list and session and application arrays are fully updated for all users,
'and module and skin dropdowns, as well as application arrays, are repopulated to reflect those changes.

Sub BuildFullArray(ThePath,TheFolderType)
On Error Resume Next

'response.write("<br />REBUILD MODULE ARRAY!")

'Reset the Application("II_SECURITY_ARRAY") if having to rebuild the MODULE_ARRAY! It will also be rebuilt after the MODULE_ARRAY is rebuilt
'Application.Lock
'Application("II_SECURITY_ARRAY") = empty
'Application.Unlock

if (IsEmpty(ThePath) or ThePath = "") then
    Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> Please check the 'SystemSettings.asp' file in the System folder and make sure that there is a valid path to your Skins and Module folders.<br />"
    Application.Lock
    Application("II_MODULE_PATH") = null
    Application.Unlock
    Application.Lock
    Application("II_SKIN_PATH") = null
    Application.Unlock
else

    Dim TheFolderObject,theFolder,theSubFolder,FolderArray(),ParentFolderObject,i,newFolderArray,theConfigFile,configFilePath,numberOfConfigItems,namesOfConfigItems
    'Set the number of nodes or items stored from module/skin configuration.xml files and allowed in the application array here....
    numberOfConfigItems = Application("II_CONFIGURATION_XML_NUMBER")
    'Sets an array list of acceptable values/names as found in the attrinute names of item nodes
    'in the configuration.xml file. It is based on SystemSettings.asp application variable values allowed
    namesOfConfigItems = Application("II_CONFIGURATION_XML_VALUES")

    if (IsNull(numberOfConfigItems) or IsEmpty(numberOfConfigItems)) then
        numberOfConfigItems = 0
    end if
    if (IsNull(namesOfConfigItems) or IsEmpty(namesOfConfigItems)) then
        namesOfConfigItems = 0
    end if

    'note: only last dimension may be redimmed and preserved. Neg. value set here to start with...
    ReDim FolderArray((numberOfConfigItems-1),-1)

    Dim tempPath
    tempPath = Server.MapPath(ThePath)
    if IsNull(tempPath) then
        Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> Error finding the module and skins folders. None are found in their respective folders. Check that the web path (" & ThePath & ") to the modules and/or skins folder is correct. (check SystemSettings.asp)<br />"
        Application.Lock
        Application("II_MODULE_PATH") = null
        Application.Unlock
        Application.Lock
        Application("II_SKIN_PATH") = null
        Application.Unlock
        'Call EmptyDropDown(0)
    else

        Set TheFolderObject = CreateObject("Scripting.FileSystemObject")
	    If TheFolderObject.FolderExists(tempPath) Then

                Set ParentFolderObject = TheFolderObject.GetFolder(tempPath)

                if (ParentFolderObject.SubFolders.Count > 0) then

                    For Each theFolder In ParentFolderObject.SubFolders
                        configFilePath = tempPath & "\" & theFolder.Name & "\" & "configuration.xml"
                        'only ubound of last array in multimdimensional arrays may be redimensioned...
                        ReDim Preserve FolderArray((numberOfConfigItems-1),UBound(FolderArray,2)+1)

						'Assign the actual new folder name typed by the user in the file system for the module to the module array
						'*** IMPORTANT : Because many modules are dependent on the "mother module" called "ImageManager"
						'for access to images, the "systemdatabases.asp" system will need to search all module's configuration "folder_name"
						'value to find "ImageManager" if it does not exist as a physical folder name (user changed it)
                        FolderArray(0,UBound(FolderArray,2)) = theFolder.Name

                        'Now add the configuration.xml "datemodified" value, if found
	                    If TheFolderObject.FileExists(configFilePath) Then
                            Set theConfigFile = TheFolderObject.GetFile(configFilePath)
                            FolderArray(1,UBound(FolderArray,2)) = theConfigFile.DateLastModified
		    	    'always release objects in loops...
                    	    Set theConfigFile = nothing
                    	    theConfigFile = Empty
	                    Else
                            FolderArray(1,UBound(FolderArray,2)) = ""
	                    End If


                        '******** GET CONFIGURATION.XML DATA FOR THIS MODULE/SKIN ********
                        'Now build the full array with configuration.xml data, if found
                        dim ConfigXMLFile,isLoaded,myNodeList,newArray1,newArray2,k,j,l,n
                        isLoaded = false

                        'Load configuration.xml data
                        If TheFolderObject.FileExists(configFilePath) Then

                            set ConfigXMLFile = Server.CreateObject("Microsoft.XMLDOM")
                            With ConfigXMLFile
                            .async = False
                            .validateOnParse = False
                            .preserveWhiteSpace = True
                            .resolveExternals = False
                            End With
                            ConfigXMLFile.setProperty "SelectionLanguage", "XPath"

                            isLoaded = ConfigXMLFile.load(configFilePath)
                            if (isLoaded) then
                                'load data into xml object using XPATH...
                                Set myNodeList = ConfigXMLFile.documentElement.selectNodes("/configuration/*")
                                'Set myNodeList = ConfigXMLFile.documentElement.selectSingleNode("/configuration/item/@name")
                                'response.write("<hr />TYPE: " & TheFolderType)
		                            if myNodeList.length > 0 then
                                        ReDim newArray1(myNodeList.length)
                                        ReDim newArray2(myNodeList.length)
                                        'First build complete list of all "items" stored in this configuration.xml file
                                        For k = 0 To myNodeList.length - 1
                                            newArray1(k) = myNodeList.item(k).attributes(0).value 'get name/attribute of node
                                            newArray2(k) = myNodeList.item(k).Text 'get text value of node
                                        Next
                                        'SUCCESS! Now add data to FolderArray...
                                        'Order all xml node values by the correct name of attribute based on application array and set value
                                        if (IsArray(namesOfConfigItems)) then
                                            n = 0
                                            For j = 0 to Ubound(namesOfConfigItems)
                                            if (Lcase(Cstr(namesOfConfigItems(j))) = "folder_name" or Lcase(Cstr(namesOfConfigItems(j))) = "folder_path" or Lcase(Cstr(namesOfConfigItems(j))) = "datetime_modified") then
                                            else
                                                For l = 0 to Ubound(newArray1)
                                                    if (Lcase(Cstr(namesOfConfigItems(j))) = Lcase(Cstr(newArray1(l)))) then
                                                        if ((n+2) <= (numberOfConfigItems-1)) then
                                                            FolderArray(n+2,UBound(FolderArray,2)) = newArray2(l)
                                                            exit for
                                                        end if
                                                    end if
                                                Next
                                            n = n+1
                                            end if
                                            Next
                                        else
                                        'Do not store values from the configuration.xml file if somehow the application values ahve been erased
                                        'that control the names and order of allowed values (ie. array is lost or missing!)
                                        end if

		                            else
                                    'NO XML FOUND IN FILE...
                                    'note: for now, assume that the creator intended that no data to exist, so allow an empty configuration.xml file
		                            end if
                                    Erase newArray1
                                    Erase newArray2
                                    Set myNodeList = nothing

                            else
                                'Configuration.xml is not well-formed. Alert user of error!
                                Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> There was an error in one of the files inside your skin or module folders inside your web site! A Configuration.xml file for one of your modules/skins did not load correcly into the system! Checking parser for xml errors (see error list below):"
                                'IS THE XML FILE BAD-CANNOT BE PARSED?: Run loading xml error checker...
                                If ConfigXMLFile.parseError.errorCode <> 0 Then
	                            Session("II_MESSAGE") = Session("II_MESSAGE") & "<hr />Configuration.xml file parse error: <strong style='color:#006633;'>" & ConfigXMLFile.parseError.reason & "</strong> Your xml file may be damaged or corrupted.<br />Please check your Configuration.xml file located here: <strong style='color:#660066;'>" & configFilePath & "</strong><br />"
 	                            'Display XML parse error message in detail for troubleshooting the xml error in the file...
	                            Session("II_MESSAGE") = Session("II_MESSAGE") & "Configuration.xml Information:<br />" _
		                            &  "File URL:      " & ConfigXMLFile.parseError.url & "<br />" _
		                            &  "Line No.       " & ConfigXMLFile.parseError.line & "<br />" _
		                            &  "Character:     " & ConfigXMLFile.parseError.linepos & "<br />" _
		                            &  "File Position: " & ConfigXMLFile.parseError.filepos & "<br />" _
		                            &  "Source Text:   " & ConfigXMLFile.parseError.srcText & "<br />" _
		                            &  "Error Code:    " & ConfigXMLFile.parseError.errorCode & "<br />" _
		                            &  "Description:   " & ConfigXMLFile.parseError.reason & "<hr />" _
                                    &  "<strong style='color:#660000;'>Please Note:</strong> This error will not affect the module directly, so it will load and this error will go away. But please note that parts of that module that use data may not work, or all module pages may not work, until you correct the xml file listed above. This error may cause issues later if your module tries to pull data from its database. For this reason please go into configuration.xml at the path above and try and clean up the xml so it is well-formed. You may open the file with Notepad or other plain text editor and try and retype the text to correct the error. If you are having trouble understanding the error or XML in general, please visit our web site for more information or download similar modules if available: <a href='" & Application("II_COMPANY_URL") & "' target='_blank'>" & Application("II_COMPANY_NAME") & "</a>"
                                end If
                            end if

		    	    'always release objects in loops...
                    	    Set ConfigXMLFile = nothing
                    	    ConfigXMLFile = Empty

                        else
                        'No configuration.xml file found...which is ok. All values should be empty then by default...
                        'TODO:build empty config values into arrays here...
                        End If
                        '****************************************************************

                    Next

                    '(OPTIONAL CODE) GET ALL SUB FOLDERS: recursively stores arrays inside the folder array
                    'so that youy can detect subfolders inside each module/skin folder.
                    'Use this optional recursive loop of subfolders if you need to later pull subfolders
                    'inside of your module/skin folders, for some reason. This is very helpful in doing that!

                    'For Each theSubFolder In ParentFolderObject.SubFolders
                    'newFolderArray = QuickArray(theSubFolder)
                        'For i = 0 To UBound(newFolderArray)
                        'ReDim Preserve FolderArray(UBound(FolderArray) + 1)
                        'FolderArray(UBound(FolderArray)) = newFolderArray(i)
                        'i = i + 1
                        'Next
                    'Next

                end if

                Set ParentFolderObject = nothing
                ParentFolderObject = Empty

                if Ubound(FolderArray,2) < 0 then
                    Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> Error finding either the  module or skins folders. None are found in their respective folders. Check that the web path (" & ThePath & ") to the modules and/or skins folder is correct. (check SystemSettings.asp)<br />"
                    'Call EmptyDropDown(0)
                end if

                if (TheFolderType = 1) then
                    Application.Lock
                    Application("II_MODULE_ARRAY") = FolderArray
                    Application.Unlock
                elseif (TheFolderType = 2) then
                    Application.Lock
                    Application("II_SKIN_ARRAY") = FolderArray
                    Application.Unlock      
                end if

        else
            Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> Error finding either the module or skins parent folder as set in your 'SystemSettings.asp' file. Please go to SystemSettings.asp and make sure you are pointing to your correct module or skin folder. (check SystemSettings.asp)<br />"
            Application.Lock
            Application("II_MODULE_PATH") = null
            Application.Unlock
            Application.Lock
            Application("II_SKIN_PATH") = null
            Application.Unlock
            'Call EmptyDropDown(0)
        end if

        Set TheFolderObject = nothing
        TheFolderObject = Empty

    end if

    Erase FolderArray    

end if

If Err.number <> 0 then
    Call CaptureThisError("SystemModules.asp:BuildFullArray:check this page and method for the error.")
    Err.Clear
End If
End Sub


'******************************************************************

'QUICK ARRAY FUNCTION
'This array is only used for comparison with the main application array set (MODULE_ARRAY/SKIN_ARRAY)
'Detects and stores a quick lite array of which module/skins folders have been installed in the system.
'Those are then used to check against the application scope folder arrays to see if anything
'new was added to the system (modules and skins folders under their respective parent folders).
'If the arrays dont match exactly, then the system knows that a user has added a new module or skin
'and the system rebuilds the application scope arrays and rebuilds the module and
'skin dropdown menus, showing the new modules/skins added in the system to the user so
'they can be quickly access.
'Note: Runs through given folder and stores array of subfolder names and configuration.xml modifgication date/times for each
'These are used in the comparison with the application arrays. If differences detected, the full application arrays
'are rebuilt from scratch and all configuration.xml data sucked in...

Sub QuickArray(ThePath)
On Error Resume Next

if (IsEmpty(ThePath) or ThePath = "") then
    Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> Please check the 'SystemSettings.asp' file in the System folder and make sure that there is a valid path to your Skins and Module folders.<br />"
    Application.Lock
    Application("II_MODULE_PATH") = null
    Application.Unlock
    Application.Lock
    Application("II_SKIN_PATH") = null
    Application.Unlock
else
    Dim TheFolderObject,theFolder,theSubFolder,FolderArray(),ParentFolderObject,i,newFolderArray,theConfigFile,configFilePath
    Redim FolderArray(1,-1)

    Dim tempPath
    tempPath = Server.MapPath(ThePath)

    if (IsNull(tempPath) or IsEmpty(tempPath)) then
        Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> Error finding the module and skins folders. None are found in their respective folders. Check that the web path (" & ThePath & ") to the modules and/or skins folder is correct. (check SystemSettings.asp)<br />"
        Application.Lock
        Application("II_MODULE_PATH") = null
        Application.Unlock
        Application.Lock
        Application("II_SKIN_PATH") = null
        Application.Unlock
        'Call EmptyDropDown(0)
    else

        Set TheFolderObject = CreateObject("Scripting.FileSystemObject")
	    If TheFolderObject.FolderExists(tempPath) Then
                Set ParentFolderObject = TheFolderObject.GetFolder(tempPath)
                if (ParentFolderObject.SubFolders.Count > 0) then

                    For Each theFolder In ParentFolderObject.SubFolders
                        configFilePath = tempPath & "\" & theFolder.Name & "\" & "configuration.xml"
                        'only ubound of last array in multimdimensional arrays may be redimensioned...
                        ReDim Preserve FolderArray(1,Ubound(FolderArray,2)+1)
                        FolderArray(0,UBound(FolderArray,2)) = theFolder.Name
	                    If TheFolderObject.FileExists(configFilePath) Then
                            Set theConfigFile = TheFolderObject.GetFile(configFilePath)
                            FolderArray(1,UBound(FolderArray,2)) = theConfigFile.DateLastModified
	                    Else
                            FolderArray(1,UBound(FolderArray,2)) = ""
	                    End If
                    Next

                    Set theConfigFile = nothing
                    theConfigFile = Empty

                    '(OPTIONAL CODE) GET ALL SUB FOLDERS: recursively stores arrays inside the folder array
                    'so that youy can detect subfolders inside each module/skin folder.
                    'Use this optional recursive loop of subfolders if you need to later pull subfolders
                    'inside of your module/skin folders, for some reason. This is very helpful in doing that!

                    'For Each theSubFolder In ParentFolderObject.SubFolders
                    'newFolderArray = QuickArray(theSubFolder)
                        'For i = 0 To UBound(newFolderArray)
                        'ReDim Preserve FolderArray(UBound(FolderArray) + 1)
                        'FolderArray(UBound(FolderArray)) = newFolderArray(i)
                        'i = i + 1
                        'Next
                    'Next

                end if

                Set ParentFolderObject = nothing
                ParentFolderObject = Empty

                if Ubound(FolderArray,2) < 0 then
                    Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> Error finding either the module or skins folders. None are found in their respective folders. Check that the web path (" & ThePath & ") to the modules and/or skins folder is correct. (check SystemSettings.asp)<br />"
                    'Call EmptyDropDown(0)
                end if
                Session("II_QUICK_ARRAY") = FolderArray
        else
            Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> Error finding either the module or skins parent folder as set in your 'SystemSettings.asp' file. Please go to SystemSettings.asp and make sure you are pointing to your correct module or skin folder. (check SystemSettings.asp)<br />"
                    Application.Lock
                    Application("II_MODULE_PATH") = null
                    Application.Unlock
                    Application.Lock
                    Application("II_SKIN_PATH") = null
                    Application.Unlock
                    'Call EmptyDropDown(0)
        end if
        Set TheFolderObject = nothing
        TheFolderObject = Empty
    end if

    Erase FolderArray

end if

If Err.number <> 0 then
    Call CaptureThisError("SystemModules.asp:QuickArray:check this page and method for the error.")
    Err.Clear
End If
End Sub

'******************************************************************

'FULL DROPDOWN FUNCTION
'If the fulldropdown routine has been called, it means the system is
'rebuilding the basic dropdown menu list for either skins or modules.
'This drop down select form control appears the the top of the wbe application
'in the interface and is nessary for selecting and adding skins and modules
'to the system.
Sub FullDropDown(TheFolderType)
On Error Resume Next

    Dim TheArray,x,j,appArray,configArray,getNameIndex,getStatusIndex,currentIndex,u

    if (TheFolderType = 1) then
        appArray = Application("II_MODULE_ARRAY")
    elseif (TheFolderType = 2) then
        appArray = Application("II_SKIN_ARRAY")
    else
        appArray = null
    end if

    if (IsArray(appArray)) then
        Redim TheArray(Ubound(appArray,1),Ubound(appArray,2))

        'Detect if "name" node in configuration.xml array is used and found, and use that for dropdown text value, if found
        'Also, detects the presence of a "status" node with value "off", which manually turns off a module/skin subfolder, if found
        configArray = Application("II_CONFIGURATION_XML_VALUES")
        getNameIndex = 0
        if (IsArray(configArray)) then
            For j = 0 to Ubound(configArray)
                if (Lcase(Cstr(configArray(j))) = "name" or Lcase(Cstr(configArray(j))) = "module_name") then
                    getNameIndex = j
                end if
                if (Lcase(Cstr(configArray(j))) = "status" or Lcase(Cstr(configArray(j))) = "onoff") then
                    getStatusIndex = j
                end if
            Next
        end if
        'otherwise, use the folder's name
        if (getNameIndex <= 0) then
            'note: 0 is the default where the folder name of the module/skin is stored, and can be used if no "name" attribute is found
            getNameIndex = 0 
        end if

        'Begin check if status is "off" for any module. If so, reduce size of array and dont include that module/skin...
        currentIndex = 0
        For u = 0 to Ubound(appArray,2)
            'check if the status of a module/skin in configuration.xml is set to "off". If so, dont include this is the dropdown array!
            if (Lcase(Cstr(appArray(getStatusIndex,u))) <> "off" and Lcase(Cstr(appArray(getStatusIndex,u))) <> "no") then
                TheArray(0,currentIndex) = appArray(0,u)
                'checks for the "name" assigned in configuration.xml to a module/skin in the dropdown display. defaults to folder name if not found
                if (appArray(getNameIndex,u) = "" or IsEmpty(appArray(getNameIndex,u))) then
                    'store the folder name by default if no "name" value assigned or found for this module/skin
                    TheArray(1,currentIndex) = appArray(0,u)
                else
                    TheArray(1,currentIndex) = appArray(getNameIndex,u)
                end if
                currentIndex = currentIndex + 1
            end if
        Next

        if (currentIndex-1) < 0 then
            currentIndex = 0
            Redim Preserve TheArray(Ubound(appArray,1),-1) 'set to negative array index, so no items appear in the dropdowns!
        else
            currentIndex = currentIndex - 1
            'Clean up array since it was resized if sttus node value was off...
            Redim Preserve TheArray(Ubound(appArray,1),currentIndex)
        end if

        if (TheFolderType = 1) then
            Application.Lock
            Application("II_MODULE_MENU") = TheArray
            Application.Unlock
        elseif (TheFolderType = 2) then
            Application.Lock
            Application("II_SKIN_MENU") = TheArray
            Application.Unlock
        else
            'do nothing for now
        end if

    Erase TheArray
    end if

If Err.number <> 0 then
    Call CaptureThisError("SystemModules.asp:FullDropDown:check this page and method for the error.")
    Err.Clear
End If
End Sub

'******************************************************************

'EMPTY DROPDOWN FUNCTION
'If the module/skin calls generate errors, or all folders have been moved, deleted or lost from
'the systems "Modules" or "Skins" folders (or no module/skin folders added), then
'display empty menu item for the drop downs.
Sub EmptyDropDown(TheFolderType)
On Error Resume Next

    'For now, dont add any new option elements to tghe dropdowns if empty.
    'The default option value will take care of the menu and provide a default value.

    'Dim EmptyArray(1,0)
        'EmptyArray(0,0) = ""
        'EmptyArray(1,0) = ""
        'if (TheFolderType = 1) then
            'EmptyArray(0,0) = ""
            'EmptyArray(1,0) = "none"
            'Application.Lock
            'Application("II_MODULE_MENU") = EmptyArray
            'Application.Unlock
        'elseif (TheFolderType = 2) then
            'EmptyArray(0,0) = ""
            'EmptyArray(1,0) = "none"
            'Application.Lock
            'Application("II_SKIN_MENU") = EmptyArray
            'Application.Unlock
        'else
            'do nothing for now
        'end if

Erase EmptyArray

If Err.number <> 0 then
    Call CaptureThisError("SystemModules.asp:EmptyDropDown:check this page and method for the error.")
    Err.Clear
End If
End Sub

'******************************************************************

'MISSING FOLDER ALERT MESSAGE FUNCTION
'If someone deletes all module/skin folders from their parent, or parent foldxers are empty,
'alert the system and user that no modules/skins found! This function thus sends alert to
'session 'message' and displays alert in web page

Sub AlertMessage(TheFolderType)
On Error Resume Next

    if (TheFolderType = 1) then
        Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> No <strong>modules</strong> were detected in your application. <strong style='color:#660033;'>Check your 'Modules' folder inside the web application and see if any module folders exist!</strong> Also, make sure the status of your module/skin (as found in each module/skin subfolder's 'configuration.xml' file) is set to 'on'. You may also download more Modules for your web application at <a href='http://www.whitepacificsoftware.com/' target='_blank'>www.whitepacificsoftware.com</a><br />"
        Application.Lock
        Application("II_MODULE_ARRAY")= null
        Application.Unlock
    elseif (TheFolderType = 2) then
        Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> No <strong>skins</strong> were detected in your application. <strong style='color:#660033;'>Check your 'Skins' folder inside the web application and see if any skin folders exist!</strong> Also, make sure the status of your module/skin (as found in each module/skin subfolder's 'configuration.xml' file) is set to 'on'. You may also download more Skins for your web application at <a href='http://www.whitepacificsoftware.com/' target='_blank'>www.whitepacificsoftware.com</a><br />"
        Application.Lock
        Application("II_SKIN_ARRAY") = null
        Application.Unlock
    else
        Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> No <strong>folders</strong> were detected in your application. Check your 'Modules' and 'Skins' folders inside the web application and see if they are empty or have moved. Also, make sure the status of your module/skin (as found in each module/skin subfolder's 'configuration.xml' file) is set to 'on'. You may also download more Modules and Skins for your web application at <a href='http://www.whitepacificsoftware.com/' target='_blank'>www.whitepacificsoftware.com</a><br />"
        Application.Lock
        Application("II_MODULE_ARRAY")= null
        Application.Unlock
        Application.Lock
        Application("II_SKIN_ARRAY") = null
        Application.Unlock
    end if

If Err.number <> 0 then
    Call CaptureThisError("SystemModules.asp:AlertMessage:check this page and method for the error.")
    Err.Clear
End If
End Sub

'******************************************************************

'LOAD MODULE/SKIN DIRECTORY FUNCTION ****************
'Every web page that includes this System file always checks the app to see
'if new modules or skins have been added to the system. It does this
'by running functions that get all subfolders contained inside the MODULES
'and SKINS folders and then checks if there is a valid configuration.xml
'file within each folder. The configuration file determines if the module
'or skin is active and available, as well as the location of its database
'and other resources used by the module or skin. This function enables this feature
'by running through series of checks to see what if any folders exists inside the parent
'Modules and Skins folders. If detected list doesnt match application scope array list
'then rebuilds module/skin folder lists using functions described above, and all
'variables in the array are rebuilt from the module/skin folder lists and installed
'in the new array.

'About the Parameters...
'"TheWebPath" - a web root absolute path built from application variable values
'you set in Settings.asp
'"TheFolderType" - Currently, uses only two types of folder checks (Skins and Modules)
'Note: In the future, as more dropdown menus and features are needed, more may be added.
'For now, the two types are mapped to numbers as follows:
'1 (checks for "Modules")
'2 (checks for "Skins")

Sub CheckFolders(TheWebPath,TheFolderType)
On Error Resume Next

Dim DoesMatch,whichArray
'Session("II_MESSAGE") = ""
whichArray = null
if (TheFolderType = 1) then
    whichArray = Application("II_MODULE_ARRAY")
elseif (TheFolderType = 2) then
    whichArray = Application("II_SKIN_ARRAY")
end if

    if (IsNull(TheWebPath) or IsEmpty(TheWebPath) or IsNull(TheFolderType) or IsEmpty(TheFolderType) or not IsNumeric(TheFolderType) or TheFolderType > 2 or TheFolderType < 1) then
    Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong class='message_alert'>Alert!</strong> Error finding modules and skins. None are found in the system. Check that the web path (" & TheWebPath & ") to the modules and/or skins folder is correct. (SystemSettings.asp or SystemSystems.asp)<br />"
    Application.Lock
    Application("II_MODULE_PATH") = null
    Application.Unlock
    Application.Lock
    Application("II_SKIN_PATH") = null
    Application.Unlock
    'Call EmptyDropDown(0) 'not used as dropdown menus show default menu items by default now

    else
		'.......................................
		'Capture any old errors and the resume fresh error check here before running method
		If Err.number <> 0 then
			Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
			Err.Clear
		End If
		'......................................
      Call QuickArray(TheWebPath)
		On Error Resume Next
      if (IsArray(Session("II_QUICK_ARRAY"))) then
        if (Ubound(Session("II_QUICK_ARRAY"),2) < 0) then
			'.......................................
			'Capture any old errors and the resume fresh error check here before running method
			If Err.number <> 0 then
				Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
				Err.Clear
			End If
			'......................................
            Call AlertMessage(TheFolderType)
			On Error Resume Next
            'Call EmptyDropDown(TheFolderType)
        else
            'quick array found folders...was built, so check application arrays for values
            if (IsNull(whichArray) or IsEmpty(whichArray)) then
				'.......................................
				'Capture any old errors and the resume fresh error check here before running method
				If Err.number <> 0 then
					Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
					Err.Clear
				End If
				'......................................
                'Rebuild application array from scratch...
                Call BuildFullArray(TheWebPath,TheFolderType)
				On Error Resume Next
                'Reset the array values...
                if (TheFolderType = 1) then
                    whichArray = Application("II_MODULE_ARRAY")
                elseif (TheFolderType = 2) then
                    whichArray = Application("II_SKIN_ARRAY")
                end if
                'check if arrays were stored...
                if (IsArray(whichArray)) then
                    if (Ubound(whichArray,2) < 0) then
						'.......................................
						'Capture any old errors and the resume fresh error check here before running method
						If Err.number <> 0 then
							Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
							Err.Clear
						End If
						'......................................
                        Call AlertMessage(TheFolderType)
						On Error Resume Next
                        'Call EmptyDropDown(TheFolderType)
                    else
						'.......................................
						'Capture any old errors and the resume fresh error check here before running method
						If Err.number <> 0 then
							Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
							Err.Clear
						End If
						'......................................
                        'Build full array based on values stored in the application array when BuildFullArray was called above
                        Call FullDropdown(TheFolderType)
						On Error Resume Next
                        exit sub
                    end if
                else
				'.......................................
				'Capture any old errors and the resume fresh error check here before running method
				If Err.number <> 0 then
					Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
					Err.Clear
				End If
				'......................................
                Call AlertMessage(TheFolderType)
				On Error Resume Next
                'Call EmptyDropDown(TheFolderType)
                end if
            else
            'QUICK CHECK COMPARISON: Once the Web Application has stored permanent arrays of all modules and skin, the code below performs "lazy evaluation" and does very conservative checks to to see if anyone has modified a configuration.xml file (date change) or added/removed/changed name of module/skin subfolders. If so, then the system rebuild the application array and reindexes everything and reloads config.xml data! This simple quick check below prevents the system from doing very expensive array rebuilds, and only performs that type of build into the application arrays IF the quick array check of folder names/config dates fails below. Valid arrays found in both quick and application variables, so now compare for differences.

                dim r,s,isMatched,TheQuickArray,TheFullArray,whichName
                'Set array values
                TheQuickArray = Session("II_QUICK_ARRAY")
                if (TheFolderType = 1) then
                    TheFullArray = Application("II_MODULE_ARRAY")
                elseif (TheFolderType = 2) then
                    TheFullArray = Application("II_SKIN_ARRAY")
                end if
                isMatched = false 'no match by default will be false here, but true if all items match below...
                if (IsArray(TheQuickArray) and IsArray(TheFullArray)) then
                    'COMPARE Quick check array and current application scope array to see if a new folder was added...
                    if (Ubound(TheQuickArray,2) = Ubound(TheFullArray,2)) then
                        For r = 0 to Ubound(TheQuickArray,2)
                            isMatched = false
                            For s = 0 to Ubound(TheFullArray,2)
                                'IF BOTH FOLDER NAMES AND CONFIGURATION.XML MODIFIED DATE/TIMES MATCH, then no need to rebuild full array below...
                                if (TheQuickArray(0,r) = TheFullArray(0,s)) and (TheQuickArray(1,r) = TheFullArray(1,s)) then
                                    isMatched = true
                                    exit for
                                end if
                            Next
                            if not isMatched then
                                'If one false match occurs, exit all loops and checks, as match failed...
                                exit for
                            end if
                        Next
                    end if
                 end if

                'IF THEY DONT MATCH, BUILD NEW FULL ARRAY AND ASSIGN TO APPLICATION VARIABLES
                if not isMatched then
					'.......................................
					'Capture any old errors and the resume fresh error check here before running method
					If Err.number <> 0 then
						Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
						Err.Clear
					End If
					'......................................
                    'Go ahead and rebuild the application array set for this type (skin or module) and reindex all data in the subfolders
                    Call BuildFullArray(TheWebPath,TheFolderType)
					On Error Resume Next
                    if TheFolderType = 1 then
                        TheFullArray = Application("II_MODULE_ARRAY")
                    elseif TheFolderType = 2 then
                        TheFullArray = Application("II_SKIN_ARRAY") 
                    end if
                    if (IsArray(TheFullArray)) then
                        if (Ubound(TheFullArray) < 0) then
							'.......................................
							'Capture any old errors and the resume fresh error check here before running method
							If Err.number <> 0 then
								Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
								Err.Clear
							End If
							'......................................
                            Call AlertMessage(TheFolderType)
							On Error Resume Next
                            'Call EmptyDropDown(TheFolderType)
                        else
							'.......................................
							'Capture any old errors and the resume fresh error check here before running method
							If Err.number <> 0 then
								Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
								Err.Clear
							End If
							'......................................
                            Call FullDropdown(TheFolderType)
							On Error Resume Next
                            if TheFolderType = 1 then
                                whichName = "Module"
                            elseif TheFolderType = 2 then
                                whichName = "Skin"
                            else
                                whichName = "Item"
                            end if
                            Session("II_MESSAGE") = Session("II_MESSAGE") & "<strong style='color:#006633;'>Update successful!</strong> The system has detected a change or update in one of your <strong>" & whichName & "</strong> folders or files. Changes are complete!<br />"
                            exit sub
                        end if
                    else
						'.......................................
						'Capture any old errors and the resume fresh error check here before running method
						If Err.number <> 0 then
							Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
							Err.Clear
						End If
						'......................................
                        Call AlertMessage(TheFolderType)
						On Error Resume Next
                        'Call EmptyDropDown(TheFolderType)
                    end if
                else
                    'Matched!!! no need to update anything...
                    exit sub
                end if

            end if
         end if
      else
		'.......................................
		'Capture any old errors and the resume fresh error check here before running method
		If Err.number <> 0 then
			Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
			Err.Clear
		End If
		'......................................
         Call AlertMessage(TheFolderType)
			On Error Resume Next
         'Call EmptyDropDown(TheFolderType)
      end if
    end if

If Err.number <> 0 then
    Call CaptureThisError("SystemModules.asp:CheckFolder:check this page and method for the error.")
    Err.Clear
End If
End Sub
'***********************************************************

'xxxxxxxxxxxxxxxxx NOW RUN FOLDER CHECK xxxxxxxxxxxxxxxxxxxx
'IMPORTANT: This conditional check MUST be made in order to detect modules and skins
'and build the arrays used by the dropdowns to build their menus.
'Note: Added new check that allows user to add variable in SystemSettings.asp
'that turns off module/skin checking, once a program folder has been added,
'making the web app much faster!

'MODULE FOLDER CHECK...
If (not CHECK_FOR_NEW_MODULES = "no") then
    dim modulePath
    modulePath = Application("II_WEBROOT_PATH") & "/" & Application("II_MODULE_PATH") & "/"
	If Err.number <> 0 then
		Call CaptureThisError("SystemModules.asp:Check this file for the error.")
		Err.Clear
	End If
    Call CheckFolders(modulePath,1)
	On Error Resume Next
End If

'SKIN FOLDER CHECK...
If (not CHECK_FOR_NEW_SKINS = "no") then
    dim skinPath
    skinPath = Application("II_WEBROOT_PATH") & "/" & Application("II_SKIN_PATH") & "/"
	If Err.number <> 0 then
		Call CaptureThisError("SystemModules.asp:Check this file for the error.")
		Err.Clear
	End If
    Call CheckFolders(skinPath,2)
	On Error Resume Next
End If

'TEST MODULE_ARRAY values...
'Session("II_MESSAGE") = Session("II_MESSAGE") & Application("II_MODULE_ARRAY")(0,0)
'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

'\\\\\\\\\\\\\\\\ END MODULE/SKIN FUNCTIONS ////////////////






'...........................................................
'check for include page errors
If Err.number <> 0 then
    Call CaptureThisError("SystemModules.asp:Check this file for the error.")
    Err.Clear
End If
'...........................................................
%>
