
<%
'================== The GNU General Public License ================

'ImageIsle - An Image Management Web Application created by
'White Pacific Software. Copyright (C) 2005 White Pacific Software

'This program is free software; you can redistribute it and/or modify
'it under the terms of the GNU General Public License as published by
'the Free Software Foundation using version 2 of the License
'or any later version.

'This license must remain intact inside all distributions and/or
'copies of this application.

'www.whitepacificsoftware.com

'======================================================================



'---------------- CAPTURE-ALL-ERRORS --------------------
'This include must appear at the top of the page, and its sister "ErrorMessageFooter.asp" include at the bottom of the page.
'The "ErrorMEssageWriter.asp" writes out the array of errors picked up by the system and prints them in the actual page at the bottom.
'Use this set of error includes to capture all errors present in the web application and display them harmlessly at the bottom of the page.
'The page will print out all errors in the three error arrays created below.
'Note: The "On Error Resume Next" captures all page errors and prevents
'them from being displayed in the main page when possible, making the web pages more user-friendly. It may be used at the top of the page and
'inside functions and subroutines to capture separate errors.
'Be sure to use this with the "If Err.number <> 0 then" sample code block below, which captures the error and stores
'it in the error arrays for later display at the bottom of the web page.
'Note: you may safely comment out all error-catching code or includes code that displays the error as well as the "OnError Resume"
'in this include if you wish to stop displaying errors, but keep in tact the subroutines below as they
'are used by many calls throughout the system.
'Comment out the mentioned items if you want to show your natural server ASP
'errors and are trying to troubleshoot difficult errors being generated in your web pages.

'======== Notes on Error Types and what this system will NOT catch =====================
'ERROR TYPES" There are three types of errors in the web system, some of which are caught, and some which are not. In general this feature below will catch run-time errors only. If you type in ASP VBScript code that generates the other two types, the error catch will not work, but display in the browser, so be sure to test your scripts thoroughly before distributing as modules or add-ons to this software. The three types are:
'A. Pre-processor errors : IIs and the web server generates these when it cannot process a page, like failed include paths, etc. Users may get a nasty server 500 error page or page not found, as the web server generates an error itself and reroutes these by default to certain error pages built into the server, so can not always be controlled.
'B. Script Compile errors: If you type code that is broken, like failing to type correct VBScript, then the server will return a white page with the error listing. This and the pre-compiler error types are not caught by the systems error checker functions as they are based on bad code thats failed on the system or server layer. But users may get a message error display from the ASP dll inside of a white page.
'C. Run-time: Any errors generated at run-time, or when code is executed will be caught by the error systems in this software and include things like division by 0, bad xml parsing, missing file paths, etc. The error code will catch these, which generally are caused by bad data, bad code logic, or bad data type checking.


'...................BEGIN : Capture All Page Errors Here..................
'This MUST remain at the top of all pages so that errors are captured!
On Error Resume Next
'...................Build Special Arrays to Hold Your Errors...............
'Create the basic arrays that will hold four types of error data ASP creates and stores them in a safe Session array as html.
'Page Scoped variables that will be updated and added to by the method below.
Dim y,ErrorNumber(),ErrorSource(),ErrorDescription(),ErrorArea()
Redim ErrorNumber(-1)
Redim ErrorSource(-1)
Redim ErrorDescription(-1)
'This custom array allows you to add general method name or code section you are working in.
Redim ErrorArea(-1)
'...............Build Capture Routine to Store all Page Errors.............
'Capture the errors using this routine
Public Sub CaptureThisError(Area)
    if (not IsEmpty(Area) and Area <> "") then
        y = Ubound(ErrorNumber)+1
        Redim Preserve ErrorNumber(y)
        Redim Preserve ErrorSource(y)
        Redim Preserve ErrorDescription(y)
        Redim Preserve ErrorArea(y)
        ErrorNumber(y) = Err.number
        ErrorSource(y) = Err.source
        ErrorDescription(y) = Err.description
        ErrorArea(y) = Area

		dim i,theString
		theString = ""
		if (Ubound(ErrorNumber) > -1) then 'if any errors found in the array
			theString = "<div class='error_panel1'>&nbsp;---- Web Site Alerts and Errors ----</div>"
				for i = 0 to Ubound(ErrorNumber)
					if (ErrorNumber(i) = 0) then
						theString = theString + "<div class='error_panel2'>"
						theString = theString + ErrorArea(i)
						theString = theString + "</div>"
					else
						theString = theString + "<div class='error_panel3'>"
						theString = theString + "Error ID Number: <strong>" & ErrorNumber(i) & "</strong><br />"
						theString = theString + "Error Source: <strong>" & ErrorSource(i) & "</strong><br />"
						theString = theString + "Error Description: <strong>" & ErrorDescription(i) & "</strong><br />"
						theString = theString + "Error Page Area: " & ErrorArea(i)
						theString = theString + "</div>"
					end if
				Next
		end if
		Session("II_ERRORS") = Session("II_ERRORS") & theString
    end if
End Sub
'----------------- Sample Error Capture Code -----------------------------

'Add this code below to any function and/or subroutine so errors are captured.
'Note: This code only captures ONE error at a time, then clears errors, so
'you will want to use multiple instances and wrap around different code you want to check.

    'On Error Resume Next

        '...your code to test for errors goes here...

    'If Err.number <> 0 then
        'Call CaptureThisError("...add your method name or code area description here for easier debugging...")
        'Err.Clear
    'End If 

'-------------------------------------------------------------
'TEST ERRORS...uncomment these for testing the error system.

    'ERROR TEST: Generate a test error...
    'random-undeclared-variable

    'ANOTHER PAGE LEVEL ERROR TEST: Generate another test error (uncomment below to generate error message at bottom of page)
    'Dim Recordset1
    'Set Recordset1 = Server.CreateObject("ADODB.Recordset?")
    'Set Recordset1 = Server.CreateObject("ADODB.Recordset?")

    'If Err.number <> 0 then
        'Call CaptureThisError("ErrorMessageHeader.asp:check this file for the error.")
        'Err.Clear
    'End If
	'Always resume errors here, after a clear, so later errors are captured....
	'On Error Resume Next
'-------------------------------------------------------------
    'Write out know page errors (written by default at the bottom of the page in ErrorBottom.asp)
    'Response.Write(Session("II_ERRORS"))
'-------------------------------------------------------------

%>
