<%@ Page Language="c#" AutoEventWireup="true"%>
<%@import namespace="System.IO" %>
<%@import namespace="System.Web.UI.HtmlControls" %>
<%@import namespace="System.Drawing" %>
<%@import namespace="System.Drawing.Imaging" %>
<%@import namespace="System.Text" %>

<%
    /*================== The GNU General Public License ================

    ImageIsle - An Image Management Web Application created by
    White Pacific Software. Copyright (C) 2005 White Pacific Software

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation using version 2 of the License
    or any later version.

    This license must remain intact inside all distributions and/or
    copies of this application.

    ===================================================================*/
%>

<script language="C#" runat="server">

// +++++++++++ IMAGE ROTATOR ++++++++++++++++
public void Page_Load(Object s, EventArgs e)
{

	// Set maximum pixel size for thumbnails created here. Thumbs can be this size or smaller, or will be reduced in pixel dimension to fit
	int MAX_THUMBNAIL_SIZE = 80;

	string theMessage = "Success! The images was rotated 90 degrees.";
	string theImagePath = "";
	string theError = "";
	string theImageNameOriginal = "";
	string theImageNameSmall = "";
	string theQueryString = "";
	int theImageID = 0;
	int aThumbnailCreationErrorOccurred = 0;
	int num1 = 0;
	int theLargeHeight = 0;
	int theLargeWidth = 0;
	int theSmallHeight = 0;
	int theSmallWidth = 0;
	int canRotate = 0;

	// The Stringbuilder will build a list of all image id's that successfully had thumbnails created for them.
	System.Text.StringBuilder theIDString = new System.Text.StringBuilder();
	theIDString.Append("");

	try
	{
		if (Request.Form != null)
		{
			// Loop through all form fields submitted on the post...
			foreach (string item in Request.Form)
			{
				// RESET ALL IMAGE VALUES AFTER IMAGEID
				if (theImageNameOriginal != "" && theImageNameSmall != "")
				{
					theImagePath = "";
					theImageNameOriginal = "";
					theImageNameSmall = "";
					theImageID = 0;
					num1 = 0;
				}

				// Get Image Path to full size image on the server for this item in the collection
				if (item.IndexOf("imagepath") >= 0)
				{
					// PROCESS IMAGE PATH...
					if(Request.Form[item] != null)
					{
						if(Convert.ToString(Request.Form[item]) != String.Empty)
						{
							// Get the web virtual path for the image
							theImagePath = Convert.ToString(Request.Form[item]);
							// Response.Write("<br />theImagePath1: " + theImagePath);
							// Convert the virtual image into a physical server path
							theImagePath = Server.MapPath(theImagePath);
							// Response.Write("<br />theImagePath2: " + theImagePath);
						}
						else
						{
							// IMAGE PATH ERROR: If there is an error and the path is missing or incorrect, you can use a default error path
							// This ASP.NET path is the web virtual path to the folder holding the current web page from the web root
							theImagePath = this.TemplateSourceDirectory + "/Temp/";
							// Response.Write("<br />theImagePath1: " + theImagePath);
							// Convert the virtual image into a physical server path
							theImagePath = Server.MapPath(theImagePath);
							//Response.Write("<br />theImagePath2: " + theImagePath);
						}
					}
				}

				// Get Image Name to full size image on the server for this item in the collection
				if (item.IndexOf("imagename") >= 0)
				{
					// PROCESS IMAGE NAME...
					if(Request.Form[item] != null)
					{
						if(Convert.ToString(Request.Form[item]) != String.Empty)
						{
							theImageNameOriginal = Convert.ToString(Request.Form[item]);
							// Response.Write("<br />theImageNameOriginal: " + theImageNameOriginal);

							if (theImageNameOriginal.IndexOf(".") > 0)
							{
								// If the total number of characters in the image file name exceeds 240, then file name may be too big so truncate here
								num1 = theImageNameOriginal.IndexOf(".");
								if(num1 <= 240)
								{
									theImageNameSmall = theImageNameOriginal.Substring(0,num1) + "_small.jpg";
									//theImageNameSmall = theImageNameOriginal.Substring(0,num1) + "_small." + theImageNameOriginal.Substring(num1+1,(theImageNameOriginal.Length-(num1+1)));
									// Response.Write("<br />theImageNameSmall: " + theImageNameSmall);
								}
								else
								{
									// For files with really long file names, strip out extra characters before adding "_small" name change
									num1 = 240;
									theImageNameSmall = theImageNameOriginal.Substring(0,num1) + "_small.jpg";
									//theImageNameSmall = theImageNameOriginal.Substring(0,num1) + "_small." + theImageNameOriginal.Substring(num1+1,(theImageNameOriginal.Length-(num1+1)));
									// Response.Write("<br />theImageNameSmall: " + theImageNameSmall);
								}
							}
							else
							{
								theImageNameSmall = theImageNameOriginal + "_small";
								// Response.Write("<br />theImageNameSmall: " + theImageNameOriginal + "_small");
							}
						}
					}
				}



				// ++++++++++++++++++++ ASP.NET THUMBNAIL GENERATOR ++++++++++++++++++++
				// Note: For Loop goes through each form control. There are three form values per image that will be processed (path, name and id)
				// After the file name is cleaned up and processed, then the thumbnail needs to be created.
				// If the thumbnail creation fails for any reason, then DONT pass back image id, so it will
				// not be stored in the database in the calling ASP page!
				// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				try
				{
					if (theImageNameOriginal != "" && theImageNameSmall != "" && theImagePath != "")
					{

						aThumbnailCreationErrorOccurred = 0;
						// Response.Write("<br />BUILD THUMBNAIL: " + theImagePath + theImageNameOriginal);

						// Create Image Object from existing image file saved to the server

						// Optional image cleanup script
						//System.Drawing.Imaging.ImageAttributes attr = new System.Drawing.Imaging.ImageAttributes();
						//attr.SetWrapMode(System.Drawing.Drawing2D.WrapMode.TileFlipXY);
						//attr.Dispose();

						// CREATE LARGE AND SMALL IMAGES...
						System.Drawing.Image theLargeImage = System.Drawing.Image.FromFile(theImagePath + theImageNameOriginal);
						System.Drawing.Image theSmallImage = System.Drawing.Image.FromFile(theImagePath + theImageNameOriginal);

						// Set the thumbnail size based on max size
						// Currently its set to MAX_THUMBNAIL_SIZE
						if ((int)theSmallImage.Height > (int)theSmallImage.Width)
						{
							if ((int)theSmallImage.Height > MAX_THUMBNAIL_SIZE)
							{
								theSmallWidth = Convert.ToInt32((double)theSmallImage.Width * (MAX_THUMBNAIL_SIZE/(double)theSmallImage.Height));
								theSmallHeight = MAX_THUMBNAIL_SIZE;
							}
							else
							{
								theSmallWidth = (int)theSmallImage.Width;
								theSmallHeight = (int)theSmallImage.Height;
							}
						}
						else if ((int)theSmallImage.Width > (int)theSmallImage.Height)
						{
							if ((int)theSmallImage.Width > MAX_THUMBNAIL_SIZE)
							{
								theSmallHeight = Convert.ToInt32((double)theSmallImage.Height * (MAX_THUMBNAIL_SIZE/(double)theSmallImage.Width));
								theSmallWidth = MAX_THUMBNAIL_SIZE;
							}
							else
							{
								theSmallHeight = (int)theSmallImage.Height;
								theSmallWidth = (int)theSmallImage.Width;
							}
						}
						else
						{
							if ((int)theSmallImage.Width > MAX_THUMBNAIL_SIZE || (int)theSmallImage.Height > MAX_THUMBNAIL_SIZE)
							{
								theSmallHeight = Convert.ToInt32((double)theSmallImage.Height * MAX_THUMBNAIL_SIZE/(double)theSmallImage.Height);
								theSmallWidth = Convert.ToInt32((double)theSmallImage.Width * MAX_THUMBNAIL_SIZE/(double)theSmallImage.Width);
							}
							else
							{
								theSmallHeight = (int)theSmallImage.Height;
								theSmallWidth = (int)theSmallImage.Width;
							}
						}

						// Get the original or large image's height and width
						theLargeWidth = theLargeImage.Width;
						theLargeHeight = theLargeImage.Height;

						// TESTING...
						// Response.Write("<br />BUILD THUMBNAIL: " + theSmallImage.PhysicalDimension);
						// Response.Write("<br />BUILD THUMBNAIL: " + theSmallImage.Size);
						// Response.Write("<br />(int)theSmallImage.Height: " + (int)theSmallImage.Height);
						// Response.Write("<br />(int)theSmallImage.Width: " + (int)theSmallImage.Width);
						// Response.Write("<br />theSmallHeight: " + theSmallHeight);
						// Response.Write("<br />theSmallWidth: " + theSmallWidth);

						// Rotate The Images ...

						theLargeImage.RotateFlip(System.Drawing.RotateFlipType.Rotate90FlipNone);
						theSmallImage.RotateFlip(System.Drawing.RotateFlipType.Rotate90FlipNone);

						// Create the actual original and thumbnail image using a Bitmap Object,
						// which is a placeholder for the Graphics Object below...
						System.Drawing.Bitmap theLargeBitmap = new System.Drawing.Bitmap(theLargeWidth,theLargeHeight);
						System.Drawing.Bitmap theSmallBitmap = new System.Drawing.Bitmap(theSmallWidth,theSmallHeight);

						// Rotate The Bitmaps ...
						theLargeBitmap.RotateFlip(System.Drawing.RotateFlipType.Rotate90FlipNone);
						theSmallBitmap.RotateFlip(System.Drawing.RotateFlipType.Rotate90FlipNone);

						// The GDI+ or Graphics Object system offers superior redraws of the image
						// when resizing and is very efficient in creating cleaner custom thumbnails
						System.Drawing.Graphics theLargeGraphic = System.Drawing.Graphics.FromImage(theLargeBitmap);
						System.Drawing.Graphics theSmallGraphic = System.Drawing.Graphics.FromImage(theSmallBitmap);

						// Using the Graphics Object, smooth and interpolate the image before drawing it back to the Image Object
						theLargeGraphic.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
						theLargeGraphic.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic;
						theLargeGraphic.DrawImage(theLargeImage,0,0,theLargeBitmap.Width, theLargeBitmap.Height); 
						theSmallGraphic.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
						theSmallGraphic.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic;
						theSmallGraphic.DrawImage(theSmallImage,0,0,theSmallBitmap.Width, theSmallBitmap.Height);

						theLargeImage.Dispose();
						theSmallImage.Dispose();

						// Save thumbnail images to the server...
						theLargeBitmap.Save(theImagePath + theImageNameOriginal, System.Drawing.Imaging.ImageFormat.Jpeg);
						theSmallBitmap.Save(theImagePath + theImageNameSmall, System.Drawing.Imaging.ImageFormat.Jpeg);

						// Use open-source png's as well for thumbs, if needed...
						// System.Drawing.Imaging.ImageFormat.Png);

						// Always close these object instances on the server!
						theLargeBitmap.Dispose();
						theSmallBitmap.Dispose();
						theLargeGraphic.Dispose();       
						theSmallGraphic.Dispose();         
						
					}
				}
				catch (Exception exc)
				{
					theError = theError + "<br />" + exc.ToString();
					Response.Write(theError);
					aThumbnailCreationErrorOccurred = 1;
					theMessage = "Alert! It was not possible to rotate this image.(1)";
				}
				// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++





				// Get Image ID (database id) of the full size image on the server for this item in the collection
				// Note: If there were any errors creating the thumbnail (for example, so images use indexed values so will error when tralsating to theBitmaps and jpegs), then do not pass id, as thumbnail failed.
				if (item.IndexOf("imageid") >= 0)
				{
					// Response.Write("<br />Get form imageid value...");
					// PROCESS IMAGEID...
					if(Request.Form[item] != null)
					{
						if(Convert.ToInt32(Request.Form[item]) > 0)
						{
							theImageID = Convert.ToInt32(Request.Form[item]);
							// Response.Write("<br />theImageID: " + theImageID);

							// Now add to list of id's that will be sent back to the calling page,
							// indicating that those database records may be saved with image thumbnails.

							//theIDString.Append(theImageID + "_");
						}
					}
				}
			}
			// End Loop
			// Response.Write("<br />ID STRING (images that created thumbs): " + theIDString.ToString());
		}
		else
		{
			theMessage = theMessage + "Sorry, no images were uploaded or processed.";
		}
	}
	catch (Exception exc)
	{
		theError = theError + "<br />" + exc.ToString();
		Response.Write(theError);
		aThumbnailCreationErrorOccurred = 1;
		theMessage = "Alert! It was not possible to rotate this image.(2)";
	}

	if (theImageID >= 0 && aThumbnailCreationErrorOccurred != 1)
	{
		canRotate = 1;
	}

	// WRITE OUT ALL MESSAGES HERE IF NEEDED FOR TESTING...(comment out redirect below as well to test errors in this page)
	// Response.Write("<hr /><strong>MESSAGES:</strong> " + theMessage);

	// WRITE OUT ALL ERRORS HERE IF NEEDED FOR TESTING...(comment out redirect below as well to test errors in this page)
	// Response.Write("<hr /><strong>PAGE ERRORS:</strong> " + theError);

	// WRITE OUT THE QUERYSTRING...(comment out redirect below as well to test errors in this page)
	theQueryString = "?imageid=" + theImageID + "&rotate=" + canRotate + "&message=" + theMessage;
	// Response.Write("<hr /><strong>THE QUERYSTRING:</strong> " + theQueryString);

	// Redirect back to the "add.asp" page...
	Response.Redirect("edit.asp" + theQueryString,true);

}
// +++++++++++++++++++++++++++++++++++++++++++++++

</script>

