<?php
	// You may alter these two values if necessary.
	$config['max_file_size'] = 500000;
	$config['num_images_allowed'] = 25;
	
	
	include('contactsheet_files/photo_upload.php');
	include('contactsheet_files/functions.php');
	$config['num_temp_folders'] = 9;
	
	$i = 0;
	while ($i < $config['num_images_allowed']) {
		$i++;
		$inputs .= 
			'<tr>
				<td>Image #' .$i . ': </td>
				<td><input type="file" name="image_file_' . $i  . '" size="60" /></td>
			</tr>';
	}
	
	if ($_POST['action'] == 'make_sheet') {
		include('contactsheet_files/count.php');
		
		if ($_POST['max_pixels'] == '' || !checkValidChars($_POST['max_pixels'],'0123456789')) {
			$result_div .= getResultDiv('Please enter a numeric value for the maximum dimention');
		}
		if ($count > $config['num_temp_folders']) {
			$new_count = 1;
		} else {
			$new_count = $count+1;
		}
		$file = fopen('contactsheet_files/count.php','w+');
		$contents = '<?php $count= ' . $new_count . '; ?>';
		fwrite($file,$contents);
		fclose($file);
		$i = 0;
		while ($i < $config['num_images_allowed']) {
			$i++;
			if ($_FILES['image_file_'  . $i]['tmp_name'] != '') {
				$total_photos = $i;
			}
		}
		$table_dimention = ceil(sqrt($total_photos));
		$i = 0;
		$row_i = 0;
		while ($i < $config['num_images_allowed']) {
			$i++;
			$row_i++;
			$file_array = explode('.',$_FILES['image_file_'  . $i]['name']);
			$array_count = count($file_array);
			if ($file_array[$array_count-1] != 'jpg' && $file_array[$array_count-1] != 'jpeg' && $file_array[$array_count-1] != '') {
				$result_div .= getResultDiv('Sorry, this script only works for JPEG files');
			} else {
				if ($_FILES['image_file_'  . $i]['tmp_name'] != '') {
					if ($_FILES['image_file_'  . $i]['size'] > $config['max_file_size']) {
						$result_div .= getResultDiv('File + ' .$i . ' is too large. Please try a smaller file');
					} else {
						$photo = new PhotoUpload($_FILES['image_file_'  . $i]);
						$photo->uploadImage('contactsheet_files/images/' . $count . '/',$i);
						$photo->resizeImage($_POST['max_pixels'],$i .'.jpg','3','');
						$large_name = $photo->new_image_name;
						$photo->removeOriginal();
						if ($row_i > $table_dimention) {
							$img_block .= '</tr><tr>';
							$row_i = 1;
						}
						$img_block .= '<td>#' . $i . '<br /><img src="contactsheet_files/images/' . $count . '/' . $large_name . '" /></td>';
					}
				}
			}
		}
		if ($img_block != '') {
			$img_block = '<table cellspacing="1" class="sheet-table"><tr>' . $img_block . '</tr></table>';
			$code = '
				<h1 class="align-center">' .$_POST['page_title'] . '</h1>
				<hr>
				<table class="wide">
					<tr>
						<td class="half-width"></td>
						<td>' . $img_block . '</td>
						<td class="half-width"></td>
					</tr>
				</table>
				<hr />
				<p class="align-center"><a href="contactsheet.php">Back</a></p>
				<hr />
				<p class="align-center"><a href="http://www.impliedbydesign.com">Online Contact Sheet Creator</a> is a free script offered by <a href="http://www.impliedbydesign.com">Implied By Design</a></p>';
		}
		$form = $_POST;
	} else {
		$form['max_pixels'] = 50;
		$form['page_title'] = 'Contact Sheet';
	}
?>
<html>
<head>
	<title>Online Contact Sheet Creator</title>
	<script type="text/javascript" src="contactsheet_files/contactsheet.js"></script>
	<link rel="stylesheet" type="text/css" href="contactsheet_files/styles.css">
</head>
<body>
<?php if ($code != '') { echo $code; } else { ?>
<h1>Online Contact Sheet Creator</h1>
<p>To use the Online Contact Sheet Creator, do the following:</p>
<ol>
	<li>One by one, select the images you want to add to the contact sheet using the form below.</li>
	<li>Click the "Create Contact Sheet" button.</li>
	<li>Save the page and images by clicking the <strong>File > Save Page As</strong> option in your browser. <strong> If you are given the option, download the entire page and associated files. Note:</strong> if you don't have PHP installed, make sure to save the file with a .html extension. (instead of .php)</li>
	<li>Upload the page and downloaded files to your web server to make it visible.</li>
</ol>
<hr />
<?php echo $result_div; ?>
<form action="contactsheet.php" onsubmit="return checkform(this);" method="post" enctype="multipart/form-data">
	<input type="hidden" name="MAX_FILE_SIZE" value="<?php echo $config['max_file_size']; ?>" />
	<input type="hidden" name="action" value="make_sheet" />
	<table>
		<tr>
			<td>Page Title: </td>
			<td><input type="text" name="page_title" size="30" maxlength="150" value="<?php echo $form['page_title']; ?>" /></td>
		</tr>
		<tr>
			<td>Max Width or Height: </td>
			<td><input type="text" name="max_pixels" size="5" maxlength="4" value="<?php echo $form['max_pixels']; ?>" /> pixels</td>
		</tr>
		<?php echo $inputs; ?>
	</table>
	<input type="submit" value="Create Contact Sheet &gt;&gt;" />
</form>
<p class="align-center"><a href="http://www.impliedbydesign.com">Online Contact Sheet Creator</a> is a free script offered by <a href="http://www.impliedbydesign.com">Implied By Design</a></p>
<?php } ?>
</body>
</html>