/*
 * Decompiled with CFR 0.152.
 */
package zipsnap;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zipsnap.Catalog;
import zipsnap.CompressionIO;
import zipsnap.ErrorWarningHandler;
import zipsnap.FileIO;
import zipsnap.FileUnit;
import zipsnap.SnapshotUnit;
import zipsnap.StringManipulator;
import zipsnap.UserIO;

public class ZipSnap {
    static final String programTitle = "ZipSnap 2.1   Copyright 2007 Zach Scrivena   2007-08-26";
    static final double version = 2.1;
    static final int bufferSize = 0x100000;
    static final int minSizeForCompression = 256;
    static final Date currentTime = new Date();
    private static String archive = null;
    private static File archiveDir = null;
    private static String archiveDirName = null;
    static File currentDir = null;
    private static String currentDirName = null;
    static boolean simulateOnly = false;
    private static Command command;
    static boolean useCrc;
    private static long timeTolerance;
    private static boolean all;
    private static int snapshotIndex;
    private static boolean forceAdd;
    static char defaultActionOnOverwrite;
    static char defaultActionOnDelete;
    private static VolumeType volumeType;
    static int compressionLevel;
    static final List<File> searchPaths;
    private static FilterType filterType;
    private static String filterString;
    static boolean filterFullPathname;
    static Pattern filterPattern;

    public static void main(String[] args) {
        System.out.print("\nZipSnap 2.1   Copyright 2007 Zach Scrivena   2007-08-26\n");
        ErrorWarningHandler.setPauseOnWarning(true);
        try {
            ZipSnap.processArguments(args);
            if (filterString != null) {
                if (filterType == FilterType.GLOB) {
                    filterPattern = ZipSnap.getGlobFilterPattern();
                } else if (filterType == FilterType.REGEX) {
                    filterPattern = ZipSnap.getRegexFilterPattern();
                }
            }
            if (command == Command.ADD) {
                ZipSnap.addSnapshotToArchive();
            } else if (command == Command.RESTORE) {
                ZipSnap.restoreSnapshotFromArchive();
            } else if (command == Command.INFO) {
                ZipSnap.displayArchiveInfo();
            }
            System.out.print("\n\nZipSnap is done!");
            int numWarnings = ErrorWarningHandler.getNumWarnings();
            if (numWarnings > 0) {
                System.out.print("\n(" + numWarnings + " " + (numWarnings == 1 ? "warning" : "warnings") + " encountered)");
            }
            System.out.print("\n\n");
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("An unexpected error has occurred:\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        System.exit(0);
    }

    /*
     * Unable to fully structure code
     */
    private static void processArguments(String[] args) {
        block67: {
            block71: {
                block73: {
                    block72: {
                        block70: {
                            block69: {
                                block68: {
                                    err = null;
                                    if (args.length != 0) break block68;
                                    ZipSnap.printUsage();
                                    System.exit(0);
                                    break block67;
                                }
                                if (args.length >= 2) break block69;
                                err = "Insufficient arguments:\nA command and a ZipSnap archive directory must be specified.";
                                break block67;
                            }
                            ZipSnap.archive = args[args.length - 1];
                            command = args[0];
                            if (!"a".equals(command)) break block70;
                            ZipSnap.command = Command.ADD;
                            break block71;
                        }
                        if (!"r".equals(command)) break block72;
                        ZipSnap.command = Command.RESTORE;
                        break block71;
                    }
                    if ("i".equals(command)) break block73;
                    err = "Invalid command \"" + command + "\" specified:\nCommand must be \"a\", \"r\", or \"i\".";
                    break block67;
                }
                ZipSnap.command = Command.INFO;
            }
            swZip = 0;
            swJar = 0;
            swList = 0;
            for (i = 1; i < args.length - 1; ++i) {
                sw = args[i];
                if (ZipSnap.command == Command.ADD || ZipSnap.command == Command.RESTORE || ZipSnap.command == Command.INFO) {
                    if ("-i".equals(sw) || "--ignorewarnings".equals(sw)) {
                        ErrorWarningHandler.setPauseOnWarning(false);
                        continue;
                    }
                    if (sw.startsWith("-f:") || sw.startsWith("--filter:")) {
                        a = sw.substring(sw.indexOf(58) + 1);
                        if (a.isEmpty()) {
                            err = "Empty --filter parameter specified:\nGlob filter string must be nonempty.";
                            break block67;
                        }
                        ZipSnap.filterString = a;
                        ZipSnap.filterType = FilterType.GLOB;
                        ZipSnap.filterFullPathname = false;
                        continue;
                    }
                    if (sw.startsWith("-F:") || sw.startsWith("--FILTER:")) {
                        a = sw.substring(sw.indexOf(58) + 1);
                        if (a.isEmpty()) {
                            err = "Empty --FILTER parameter specified:\nGlob filter string must be nonempty.";
                            break block67;
                        }
                        ZipSnap.filterString = a;
                        ZipSnap.filterType = FilterType.GLOB;
                        ZipSnap.filterFullPathname = true;
                        continue;
                    }
                    if (sw.startsWith("-e:") || sw.startsWith("--filterregex:")) {
                        a = sw.substring(sw.indexOf(58) + 1);
                        if (a.isEmpty()) {
                            err = "Empty --filterregex parameter specified:\nRegex filter string must be nonempty.";
                            break block67;
                        }
                        ZipSnap.filterString = a;
                        ZipSnap.filterType = FilterType.REGEX;
                        ZipSnap.filterFullPathname = false;
                        continue;
                    }
                    if (sw.startsWith("-E:") || sw.startsWith("--FILTERREGEX:")) {
                        a = sw.substring(sw.indexOf(58) + 1);
                        if (a.isEmpty()) {
                            err = "Empty --FILTERREGEX parameter specified:\nRegex filter string must be nonempty.";
                            break block67;
                        }
                        ZipSnap.filterString = a;
                        ZipSnap.filterType = FilterType.REGEX;
                        ZipSnap.filterFullPathname = true;
                        continue;
                    }
                }
                if (ZipSnap.command == Command.ADD || ZipSnap.command == Command.RESTORE) {
                    if ("-s".equals(sw) || "--simulate".equals(sw)) {
                        ZipSnap.simulateOnly = true;
                        ErrorWarningHandler.setPauseOnWarning(false);
                        continue;
                    }
                    if ("--all".equals(sw)) {
                        ZipSnap.all = true;
                        continue;
                    }
                    if ("-c".equals(sw) || "--crc".equals(sw)) {
                        ZipSnap.useCrc = true;
                        continue;
                    }
                    if (sw.startsWith("-t:") || sw.startsWith("--time:")) {
                        a = sw.substring(sw.indexOf(58) + 1);
                        if (a.isEmpty()) {
                            err = "Empty --time parameter specified:\nTime-tolerance (in milliseconds) must be a nonnegative integer.";
                            break block67;
                        }
                        try {
                            ZipSnap.timeTolerance = Long.parseLong(a);
                        }
                        catch (Exception e) {
                            ZipSnap.timeTolerance = -1L;
                        }
                        if (ZipSnap.timeTolerance >= 0L) continue;
                        err = "Invalid --time parameter \"" + a + "\" specified:\nTime-tolerance (in milliseconds) must be a nonnegative integer.";
                        break block67;
                    }
                    if ("-l".equals(sw) || "--list".equals(sw)) {
                        swList = 1;
                        continue;
                    }
                }
                if (ZipSnap.command == Command.ADD) {
                    if ("--forceadd".equals(sw)) {
                        ZipSnap.forceAdd = true;
                        continue;
                    }
                    if ("-z".equals(sw) || "--zip".equals(sw)) {
                        swZip = 1;
                        continue;
                    }
                    if (sw.startsWith("-z:") || sw.startsWith("--zip:")) {
                        a = sw.substring(sw.indexOf(58) + 1);
                        if (a.isEmpty()) {
                            err = "Empty --zip parameter specified:\nCompression level must be an integer 0-9.";
                            break block67;
                        }
                        try {
                            ZipSnap.compressionLevel = Integer.parseInt(a);
                        }
                        catch (Exception e) {
                            ZipSnap.compressionLevel = -1;
                        }
                        if (ZipSnap.compressionLevel < 0 || ZipSnap.compressionLevel > 9) {
                            err = "Invalid --zip parameter \"" + a + "\" specified.\nCompression level must be an integer 0-9.";
                            break block67;
                        }
                        swZip = 1;
                        continue;
                    }
                    if ("-j".equals(sw) || "--jar".equals(sw)) {
                        swJar = 1;
                        continue;
                    }
                    if (sw.startsWith("-j:") || sw.startsWith("--jar:")) {
                        a = sw.substring(sw.indexOf(58) + 1);
                        if (a.isEmpty()) {
                            err = "Empty --jar parameter specified:\nCompression level must be an integer 0-9.";
                            break block67;
                        }
                        try {
                            ZipSnap.compressionLevel = Integer.parseInt(a);
                        }
                        catch (Exception e) {
                            ZipSnap.compressionLevel = -1;
                        }
                        if (ZipSnap.compressionLevel < 0 || ZipSnap.compressionLevel > 9) {
                            err = "Invalid --jar parameter \"" + a + "\" specified.\nCompression level must be an integer 0-9.";
                            break block67;
                        }
                        swJar = 1;
                        continue;
                    }
                }
                if (ZipSnap.command != Command.RESTORE) ** GOTO lbl199
                if (sw.startsWith("--snapshot:")) {
                    a = sw.substring(sw.indexOf(58) + 1);
                    if (a.isEmpty()) {
                        err = "Empty --snapshot parameter specified:\nSnapshot number must be a positive integer.";
                        break block67;
                    }
                    try {
                        ZipSnap.snapshotIndex = Integer.parseInt(a) - 1;
                    }
                    catch (Exception e) {
                        ZipSnap.snapshotIndex = -1;
                    }
                    if (ZipSnap.snapshotIndex >= 0) continue;
                    err = "Invalid --snapshot parameter \"" + a + "\" specified:\nSnapshot number must be a positive integer.";
                    break block67;
                }
                if (sw.startsWith("-o:") || sw.startsWith("--overwrite:")) {
                    a = sw.substring(sw.indexOf(58) + 1);
                    if (a.isEmpty()) {
                        err = "Empty --overwrite parameter specified:\nOverwrite parameter must be \"y\" or \"n\".";
                    } else {
                        if ("y".equals(a)) {
                            ZipSnap.defaultActionOnOverwrite = (char)89;
                            continue;
                        }
                        if ("n".equals(a)) {
                            ZipSnap.defaultActionOnOverwrite = (char)78;
                            continue;
                        }
                        err = "Invalid --overwrite parameter \"" + a + "\" specified:\nOverwrite parameter must be \"y\" or \"n\".";
                    }
                    break block67;
                }
                if (sw.startsWith("-d:") || sw.startsWith("--delete:")) {
                    a = sw.substring(sw.indexOf(58) + 1);
                    if (a.isEmpty()) {
                        err = "Empty --delete parameter specified:\nDelete parameter must be \"y\" or \"n\".";
                    } else {
                        if ("y".equals(a)) {
                            ZipSnap.defaultActionOnDelete = (char)89;
                            continue;
                        }
                        if ("n".equals(a)) {
                            ZipSnap.defaultActionOnDelete = (char)78;
                            continue;
                        }
                        err = "Invalid --delete parameter \"" + a + "\" specified:\nDelete parameter must be \"y\" or \"n\".";
                    }
                    break block67;
                }
                if (!sw.startsWith("-p:") && !sw.startsWith("--path:")) ** GOTO lbl199
                a = sw.substring(sw.indexOf(58) + 1);
                if (a.isEmpty()) {
                    err = "Empty --path parameter specified:\nPath parameter must be an existing directory.";
                    break block67;
                }
                try {
                    dir = new File(a).getCanonicalFile();
                }
                catch (Exception e) {
                    err = "Invalid --path parameter specified:\nCannot get absolute path of directory \"" + a + "\":\n" + ErrorWarningHandler.getExceptionMessage(e);
                    break block67;
                }
                if (!dir.exists()) {
                    err = "Invalid --path parameter specified:\nDirectory \"" + a + "\" does not exist.";
                } else if (!dir.isDirectory()) {
                    err = "Invalid --path parameter specified:\n\"" + a + "\" is not a directory; could it be a file?";
                } else {
                    ZipSnap.searchPaths.add(dir);
                    continue;
lbl199:
                    // 2 sources

                    err = "\"" + sw + "\" is not a valid switch for command \"" + command + "\".";
                }
                break block67;
            }
            if (ZipSnap.all && ZipSnap.timeTolerance > 0L) {
                err = "Switches --all and --time cannot be used together.";
            } else if (ZipSnap.all && ZipSnap.useCrc) {
                err = "Switches --all and --crc cannot be used together.";
            } else if (ZipSnap.all && ZipSnap.forceAdd) {
                err = "Switches --all and --forceadd cannot be used together.";
            } else if (swZip + swJar + swList > 1) {
                err = "Only one of the three switches --zip, --jar, and --list can be used.";
            } else {
                if (swZip > 0) {
                    ZipSnap.volumeType = VolumeType.ZIP;
                }
                if (swJar > 0) {
                    ZipSnap.volumeType = VolumeType.JAR;
                }
                if (swList > 0) {
                    ZipSnap.volumeType = VolumeType.LIST;
                }
            }
        }
        if (err != null) {
            ErrorWarningHandler.reportErrorAndExit(err + "\nTo display help, run ZipSnap without any command-line arguments.\n");
        }
    }

    private static void addSnapshotToArchive() {
        List<FileUnit> currentDirContents;
        System.out.print("\nADD SNAPSHOT TO ARCHIVE" + (simulateOnly ? " (SIMULATION MODE)" : "") + "\n");
        String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.ENGLISH).format(currentTime);
        try {
            currentDir = new File("").getCanonicalFile();
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("Unable to get absolute pathname of the current directory:\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        currentDirName = FileIO.trimTrailingSeparator(currentDir.getPath()) + File.separatorChar;
        System.out.print("\nCurrent directory  : \"" + currentDirName + "\"");
        if (!currentDir.exists()) {
            ErrorWarningHandler.reportErrorAndExit("The current directory \"" + currentDirName + "\" does not exist.");
        }
        if (!currentDir.isDirectory()) {
            ErrorWarningHandler.reportErrorAndExit("The current directory \"" + currentDirName + "\" is not a directory; could it be a file?");
        }
        if (!currentDir.canRead()) {
            ErrorWarningHandler.reportErrorAndExit("The current directory \"" + currentDirName + "\" cannot be read.");
        }
        try {
            archiveDir = new File(archive).getCanonicalFile();
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("Unable to get absolute pathname of ZipSnap archive directory \"" + archive + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        archiveDirName = FileIO.trimTrailingSeparator(archiveDir.getPath()) + File.separatorChar;
        System.out.print("\nZipSnap archive    : \"" + archiveDirName + "\"");
        if (archiveDirName.startsWith(currentDirName)) {
            ErrorWarningHandler.reportWarning("The ZipSnap archive directory \"" + archiveDirName + "\" should not be a subdirectory of the current directory \"" + currentDirName + "\".");
        }
        File catalogFile = null;
        if (archiveDir.exists()) {
            if (!archiveDir.isDirectory()) {
                ErrorWarningHandler.reportErrorAndExit("The specified ZipSnap archive directory \"" + archiveDirName + "\" is not a directory; could it be a file?");
            }
            if (!archiveDir.canRead()) {
                ErrorWarningHandler.reportErrorAndExit("The specified ZipSnap archive directory \"" + archiveDirName + "\" cannot be read.");
            }
            catalogFile = ZipSnap.getLatestCatalog();
        }
        Catalog catalog = null;
        if (catalogFile == null) {
            System.out.print("\n - Latest catalog  : (none found)");
            System.out.flush();
            catalog = new Catalog();
        } else {
            System.out.print("\n - Latest catalog  : \"" + catalogFile.getName() + "\"");
            System.out.flush();
            catalog = new Catalog(catalogFile);
        }
        snapshotIndex = catalog.snapshots.size();
        System.out.print("\n - This snapshot   : " + timestamp + "." + (snapshotIndex + 1));
        System.out.flush();
        if (filterPattern != null) {
            if (filterType == FilterType.GLOB) {
                System.out.print("\nGlob filter        : \"" + filterString + "\"");
            } else if (filterType == FilterType.REGEX) {
                System.out.print("\nRegex filter       : \"" + filterString + "\"");
            }
            if (filterFullPathname) {
                System.out.print(" (match full relative pathname)");
            } else {
                System.out.print(" (match name only)");
            }
            System.out.flush();
        }
        if ((currentDirContents = ZipSnap.getCurrentDirContents()).isEmpty()) {
            ErrorWarningHandler.reportWarning("The current directory is empty.");
        }
        ArrayList<FileUnit> addFiles = new ArrayList<FileUnit>();
        if (all || catalogFile == null) {
            System.out.print("\n\nAdding all " + currentDirContents.size() + " files/directories in this snapshot.");
            System.out.flush();
            addFiles.addAll(currentDirContents);
        } else {
            System.out.print("\n\nMatching current directory contents against the catalog..." + (useCrc ? "\n(file checksum computations can be time-intensive)" : ""));
            System.out.flush();
            int numLastSnapshotFilesMatched = 0;
            for (FileUnit u : currentDirContents) {
                int latestSnapshot;
                FileUnit c;
                int j;
                int i = Collections.binarySearch(catalog.files, u);
                if (i < 0) {
                    addFiles.add(u);
                    continue;
                }
                int bestMatch = -1;
                int bestMatchLatestSnapshot = -1;
                for (j = i - 1; j >= 0; --j) {
                    c = catalog.files.get(j);
                    if (!u.name.equals(c.name)) break;
                    if (u.size != c.size || Math.abs(u.time - c.time) > timeTolerance || useCrc && u.getCrc() != c.getCrc()) continue;
                    latestSnapshot = Collections.max(c.snapshots);
                    if (bestMatch >= 0 && latestSnapshot <= bestMatchLatestSnapshot) continue;
                    bestMatch = j;
                    bestMatchLatestSnapshot = latestSnapshot;
                }
                for (j = i; j < catalog.files.size(); ++j) {
                    c = catalog.files.get(j);
                    if (!u.name.equals(c.name)) break;
                    if (u.size != c.size || Math.abs(u.time - c.time) > timeTolerance || useCrc && u.getCrc() != c.getCrc()) continue;
                    latestSnapshot = Collections.max(c.snapshots);
                    if (bestMatch >= 0 && latestSnapshot < bestMatchLatestSnapshot) continue;
                    bestMatch = j;
                    bestMatchLatestSnapshot = latestSnapshot;
                }
                if (bestMatch >= 0) {
                    List<Integer> snapshots = catalog.files.get((int)bestMatch).snapshots;
                    snapshots.add(snapshotIndex);
                    if (!snapshots.contains(snapshotIndex - 1)) continue;
                    ++numLastSnapshotFilesMatched;
                    continue;
                }
                addFiles.add(u);
            }
            System.out.print("\n\nThis snapshot contains " + (currentDirContents.size() - addFiles.size()) + " previously archived files/directories,\nand " + addFiles.size() + " new/modified files/directories.");
            System.out.flush();
            if (addFiles.isEmpty()) {
                int numLastSnapshotFiles = 0;
                for (FileUnit u : catalog.files) {
                    if (!u.snapshots.contains(snapshotIndex - 1)) continue;
                    ++numLastSnapshotFiles;
                }
                if (numLastSnapshotFilesMatched == numLastSnapshotFiles) {
                    if (forceAdd) {
                        System.out.print("\n\nThis snapshot is identical to the last snapshot, but will still be added.");
                    } else {
                        System.out.print("\n\nThis snapshot is identical to the last snapshot, and will not be added.");
                        return;
                    }
                }
            }
        }
        ArrayList<FileUnit> addedFiles = new ArrayList<FileUnit>();
        String volumeName = archiveDir.getName() + "." + timestamp + "." + (snapshotIndex + 1);
        if (volumeType == VolumeType.ZIP) {
            CompressionIO.zipFiles(new File(archiveDir, volumeName + ".zip"), addFiles, addedFiles);
        } else if (volumeType == VolumeType.JAR) {
            CompressionIO.jarFiles(new File(archiveDir, volumeName + ".jar"), addFiles, addedFiles);
        } else if (volumeType == VolumeType.LIST) {
            ZipSnap.listFiles(new File(archiveDir, volumeName + ".list"), addFiles, addedFiles);
        }
        SnapshotUnit s = new SnapshotUnit(timestamp);
        catalog.snapshots.add(snapshotIndex, s);
        for (FileUnit u : addedFiles) {
            u.snapshots.add(snapshotIndex);
            catalog.files.add(u);
        }
        catalog.sort();
        String newCatalogName = archiveDir.getName() + "." + timestamp + "." + (snapshotIndex + 1);
        if (volumeType == VolumeType.ZIP) {
            catalog.writeToFile(new File(archiveDir, newCatalogName + ".txt.zip"));
        } else if (volumeType == VolumeType.JAR) {
            catalog.writeToFile(new File(archiveDir, newCatalogName + ".txt.jar"));
        } else if (volumeType == VolumeType.LIST) {
            catalog.writeToFile(new File(archiveDir, newCatalogName + ".txt"));
        }
    }

    private static void restoreSnapshotFromArchive() {
        System.out.print("\nRESTORE SNAPSHOT FROM ARCHIVE" + (simulateOnly ? " (SIMULATION MODE)" : "") + "\n");
        try {
            currentDir = new File("").getCanonicalFile();
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("Unable to get absolute pathname of the current directory:\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        currentDirName = FileIO.trimTrailingSeparator(currentDir.getPath()) + File.separatorChar;
        System.out.print("\nCurrent directory  : \"" + currentDirName + "\"");
        if (!currentDir.exists()) {
            ErrorWarningHandler.reportErrorAndExit("The current directory \"" + currentDirName + "\" does not exist.");
        }
        if (!currentDir.isDirectory()) {
            ErrorWarningHandler.reportErrorAndExit("The current directory \"" + currentDirName + "\" is not a directory; could it be a file?");
        }
        if (!currentDir.canRead()) {
            ErrorWarningHandler.reportErrorAndExit("The current directory \"" + currentDirName + "\" cannot be read.");
        }
        try {
            archiveDir = new File(archive).getCanonicalFile();
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("Unable to get absolute pathname of ZipSnap archive directory \"" + archive + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        archiveDirName = FileIO.trimTrailingSeparator(archiveDir.getPath()) + File.separatorChar;
        System.out.print("\nZipSnap archive    : \"" + archiveDirName + "\"");
        if (!archiveDir.exists()) {
            ErrorWarningHandler.reportErrorAndExit("The specified ZipSnap archive directory \"" + archiveDirName + "\" does not exist.");
        }
        if (!archiveDir.isDirectory()) {
            ErrorWarningHandler.reportErrorAndExit("The specified ZipSnap archive directory \"" + archiveDirName + "\" is not a directory; could it be a file?");
        }
        if (!archiveDir.canRead()) {
            ErrorWarningHandler.reportErrorAndExit("The specified ZipSnap archive directory \"" + archiveDirName + "\" cannot be read.");
        }
        if (archiveDirName.startsWith(currentDirName)) {
            ErrorWarningHandler.reportWarning("The ZipSnap archive directory \"" + archiveDirName + "\" should not be a subdirectory of the current directory \"" + currentDirName + "\".");
        }
        if (!searchPaths.isEmpty()) {
            System.out.print("\n - Additional search paths for volume files:");
            int i = 0;
            for (File dir : searchPaths) {
                System.out.print("\n   [" + ++i + "] \"" + dir.getPath() + "\"");
            }
        }
        searchPaths.add(archiveDir);
        File catalogFile = ZipSnap.getLatestCatalog();
        if (catalogFile == null) {
            ErrorWarningHandler.reportErrorAndExit("Unable to find a catalog in the specified ZipSnap archive directory \"" + archiveDirName + "\".");
        }
        System.out.print("\n - Latest catalog  : \"" + catalogFile.getName() + "\"");
        System.out.flush();
        Catalog catalog = new Catalog(catalogFile);
        if (catalog.snapshots.isEmpty()) {
            ErrorWarningHandler.reportErrorAndExit("No snapshots found in the catalog \"" + catalogFile.getName() + "\" for this ZipSnap archive.");
        }
        if (snapshotIndex < 0) {
            snapshotIndex = catalog.snapshots.size() - 1;
        }
        System.out.print("\n - Restore snapshot: " + catalog.snapshots.get((int)ZipSnap.snapshotIndex).time + "." + (snapshotIndex + 1));
        System.out.flush();
        if (filterPattern != null) {
            if (filterType == FilterType.GLOB) {
                System.out.print("\nGlob filter        : \"" + filterString + "\"");
            } else if (filterType == FilterType.REGEX) {
                System.out.print("\nRegex filter       : \"" + filterString + "\"");
            }
            if (filterFullPathname) {
                System.out.print(" (match full relative pathname)");
            } else {
                System.out.print(" (match name only)");
            }
            System.out.flush();
        }
        ArrayList<FileUnit> snapshotFiles = new ArrayList<FileUnit>();
        for (FileUnit u : catalog.files) {
            if (!u.snapshots.contains(snapshotIndex) || !u.matchesFilter()) continue;
            snapshotFiles.add(u);
        }
        System.out.print("\n\nThis snapshot contains " + snapshotFiles.size() + " files/directories.");
        System.out.flush();
        List<FileUnit> currentDirContents = ZipSnap.getCurrentDirContents();
        ArrayList<FileUnit> deleteFiles = new ArrayList<FileUnit>(currentDirContents);
        deleteFiles.removeAll(snapshotFiles);
        Collections.reverse(deleteFiles);
        ArrayList extractFiles = new ArrayList(snapshotIndex + 1);
        int numExtractFiles = 0;
        for (int i = 0; i <= snapshotIndex; ++i) {
            extractFiles.add(i, new ArrayList());
        }
        if (all) {
            for (FileUnit u : snapshotFiles) {
                ((List)extractFiles.get(u.snapshots.get(0))).add(u);
                ++numExtractFiles;
            }
        } else {
            System.out.print("\n\nMatching snapshot files/directories against current directory contents..." + (useCrc ? "\n(file checksum computations can be time-intensive)" : ""));
            System.out.flush();
            for (FileUnit u : snapshotFiles) {
                FileUnit c;
                int i = Collections.binarySearch(currentDirContents, u);
                FileUnit fileUnit = c = i >= 0 ? currentDirContents.get(i) : null;
                if (c != null && u.size == c.size && Math.abs(u.time - c.time) <= timeTolerance && (!useCrc || u.getCrc() == c.getCrc())) continue;
                ((List)extractFiles.get(u.snapshots.get(0))).add(u);
                ++numExtractFiles;
            }
        }
        System.out.print("\n\nZipSnap will extract " + numExtractFiles + " files/directories from the archive,\nand delete " + deleteFiles.size() + " files/directories from the current directory.");
        System.out.flush();
        String[] volumeFileExtensions = new String[]{".zip", ".jar"};
        ArrayList<FileUnit> extractedFiles = new ArrayList<FileUnit>();
        int numExtractedFiles = 0;
        for (int index = 0; index <= snapshotIndex; ++index) {
            List extractFilesVolume = (List)extractFiles.get(index);
            if (extractFilesVolume.isEmpty()) continue;
            String volumeName = archiveDir.getName() + "." + catalog.snapshots.get((int)index).time + "." + (index + 1);
            if (volumeType == VolumeType.LIST) {
                File listFile = new File(currentDir, volumeName + ".list");
                numExtractedFiles += ZipSnap.listFiles(listFile, extractFilesVolume, extractedFiles);
                continue;
            }
            File volumeFile = null;
            for (File dir : searchPaths) {
                for (String ext : volumeFileExtensions) {
                    File f = new File(dir, volumeName + ext);
                    if (!f.exists() || f.isDirectory() || volumeFile != null && f.lastModified() <= volumeFile.lastModified()) continue;
                    volumeFile = f;
                }
            }
            if (volumeFile == null) {
                ErrorWarningHandler.reportWarning("Unable to find volume \"" + volumeName + ".{zip,jar}\";\nthe " + extractFilesVolume.size() + " files/directories from this volume will not be extracted.");
                continue;
            }
            if (volumeFile.getName().endsWith(".zip")) {
                numExtractedFiles += CompressionIO.unZipFiles(volumeFile, extractFilesVolume, extractedFiles);
                continue;
            }
            if (!volumeFile.getName().endsWith(".jar")) continue;
            numExtractedFiles += CompressionIO.unJarFiles(volumeFile, extractFilesVolume, extractedFiles);
        }
        if (numExtractFiles > 0) {
            if (volumeType == VolumeType.LIST) {
                System.out.print("\n\nZipSnap has listed " + numExtractedFiles + " out of " + numExtractFiles + " files/directories from the archive.");
            } else {
                System.out.print("\n\nZipSnap has extracted " + numExtractedFiles + " out of " + numExtractFiles + " files/directories from the archive.");
            }
            System.out.flush();
        }
        ArrayList<FileUnit> deletedFiles = new ArrayList<FileUnit>();
        if (!deleteFiles.isEmpty()) {
            ZipSnap.deleteFiles(deleteFiles, deletedFiles);
        }
        if (simulateOnly) {
            return;
        }
        ArrayList<FileUnit> updatedCurrentDirContents = new ArrayList<FileUnit>(currentDirContents);
        for (FileUnit u : extractedFiles) {
            int i = Collections.binarySearch(currentDirContents, u);
            if (i >= 0) {
                updatedCurrentDirContents.set(i, u);
                continue;
            }
            updatedCurrentDirContents.add(u);
        }
        Collections.sort(updatedCurrentDirContents);
        updatedCurrentDirContents.removeAll(deletedFiles);
        ArrayList<FileUnit> restoreDirs = new ArrayList<FileUnit>();
        for (FileUnit u : updatedCurrentDirContents) {
            if (!u.isDirectory || !u.file.isDirectory() || u.file.lastModified() == u.time) continue;
            String pathname = null;
            try {
                pathname = u.file.getCanonicalPath();
            }
            catch (Exception e) {
                pathname = null;
            }
            if (pathname == null || !pathname.equals(u.file.getPath())) continue;
            restoreDirs.add(u);
        }
        Collections.reverse(restoreDirs);
        ArrayList<FileUnit> restoredDirs = new ArrayList<FileUnit>();
        if (!restoreDirs.isEmpty()) {
            ZipSnap.restoreDirTime(restoreDirs, restoredDirs);
        }
    }

    private static void displayArchiveInfo() {
        File catalogFile;
        System.out.print("\nDISPLAY ARCHIVE INFORMATION\n");
        try {
            archiveDir = new File(archive).getCanonicalFile();
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("Unable to get absolute pathname of ZipSnap archive directory \"" + archive + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        archiveDirName = FileIO.trimTrailingSeparator(archiveDir.getPath()) + File.separatorChar;
        System.out.print("\nZipSnap archive    : \"" + archiveDirName + "\"");
        if (!archiveDir.exists()) {
            ErrorWarningHandler.reportErrorAndExit("The specified ZipSnap archive directory \"" + archiveDirName + "\" does not exist.");
        }
        if (!archiveDir.isDirectory()) {
            ErrorWarningHandler.reportErrorAndExit("The specified ZipSnap archive directory \"" + archiveDirName + "\" is not a directory; could it be a file?");
        }
        if (!archiveDir.canRead()) {
            ErrorWarningHandler.reportErrorAndExit("The specified ZipSnap archive directory \"" + archiveDirName + "\" cannot be read.");
        }
        if ((catalogFile = ZipSnap.getLatestCatalog()) == null) {
            ErrorWarningHandler.reportErrorAndExit("Unable to find a catalog in the specified ZipSnap archive directory \"" + archiveDirName + "\".");
        }
        System.out.print("\n - Latest catalog  : \"" + catalogFile.getName() + "\"");
        System.out.flush();
        Catalog catalog = new Catalog(catalogFile);
        if (catalog.snapshots.isEmpty()) {
            ErrorWarningHandler.reportErrorAndExit("No snapshots found in the catalog \"" + catalogFile.getName() + "\" for this ZipSnap archive.");
        }
        if (filterPattern != null) {
            if (filterType == FilterType.GLOB) {
                System.out.print("\nGlob filter        : \"" + filterString + "\"");
            } else if (filterType == FilterType.REGEX) {
                System.out.print("\nRegex filter       : \"" + filterString + "\"");
            }
            if (filterFullPathname) {
                System.out.print(" (match full relative pathname)");
            } else {
                System.out.print(" (match name only)");
            }
            System.out.flush();
        }
        int[] numSnapshotFiles = new int[catalog.snapshots.size()];
        Arrays.fill(numSnapshotFiles, 0);
        int[] numSnapshotFilesAdded = new int[catalog.snapshots.size()];
        Arrays.fill(numSnapshotFilesAdded, 0);
        for (FileUnit u : catalog.files) {
            if (!u.matchesFilter()) continue;
            int n = u.snapshots.get(0);
            numSnapshotFilesAdded[n] = numSnapshotFilesAdded[n] + 1;
            Iterator<Integer> i$ = u.snapshots.iterator();
            while (i$.hasNext()) {
                int i;
                int n2 = i = i$.next().intValue();
                numSnapshotFiles[n2] = numSnapshotFiles[n2] + 1;
            }
        }
        System.out.print("\n\nThis ZipSnap archive contains " + catalog.snapshots.size() + " snapshots and " + catalog.files.size() + " files/directories:\n" + "\nSnapshot      Snapshot         No. of new/modified      Total no. of" + "\n Number         Time         files/directories added  files/directories" + "\n--------  -----------------  -----------------------  -----------------");
        for (int i = 0; i < catalog.snapshots.size(); ++i) {
            System.out.print("\n" + StringManipulator.centerJustify(i + 1, 8) + "  " + StringManipulator.centerJustify(catalog.snapshots.get((int)i).time, 17) + "  " + StringManipulator.centerJustify(numSnapshotFilesAdded[i], 23) + "  " + StringManipulator.centerJustify(numSnapshotFiles[i], 17));
        }
    }

    private static File getLatestCatalog() {
        File[] dirContents = archiveDir.listFiles();
        if (dirContents == null) {
            ErrorWarningHandler.reportErrorAndExit("Unable to get contents of the specified ZipSnap archive directory \"" + archiveDirName + "\".");
        }
        Pattern catalogNamePattern = Pattern.compile(Pattern.quote(archiveDir.getName()) + "\\.[0-9]{8}\\-[0-9]{6}\\.([1-9][0-9]*)\\.(?:txt|txt\\.zip|txt\\.jar)");
        TreeMap<Integer, File> candidateCatalogs = new TreeMap<Integer, File>();
        for (File f : dirContents) {
            int n;
            File c;
            Matcher m;
            if (!f.isFile() || !(m = catalogNamePattern.matcher(f.getName())).matches() || (c = (File)candidateCatalogs.get(n = Integer.parseInt(m.group(1)))) != null && f.lastModified() <= c.lastModified()) continue;
            candidateCatalogs.put(n, f);
        }
        if (candidateCatalogs.isEmpty()) {
            return null;
        }
        return (File)candidateCatalogs.get(candidateCatalogs.lastKey());
    }

    private static List<FileUnit> getCurrentDirContents() {
        System.out.print("\n\nScanning current directory contents...");
        System.out.flush();
        ArrayList<FileUnit> currentDirContents = new ArrayList<FileUnit>();
        ZipSnap.getDirContents(currentDir, currentDirContents);
        Collections.sort(currentDirContents);
        System.out.print("\nThe current directory contains " + currentDirContents.size() + " files/directories.");
        System.out.flush();
        return currentDirContents;
    }

    private static void getDirContents(File dir, List<FileUnit> dirContents) {
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<File> dirs = new ArrayList<File>();
        FileIO.FileIOResult result = FileIO.getDirContents(dir, files, dirs);
        if (!result.success) {
            ErrorWarningHandler.reportWarning("Unable to get contents of directory \"" + FileIO.trimTrailingSeparator(dir.getPath()) + File.separatorChar + "\":\n" + result.errorMessage + "\nThis directory will be ignored.");
            return;
        }
        int currentDirNameLen = currentDirName.length();
        if (!dir.equals(currentDir)) {
            String absoluteNativeName = FileIO.trimTrailingSeparator(dir.getPath()) + File.separatorChar;
            if (absoluteNativeName.startsWith(currentDirName)) {
                FileUnit u = new FileUnit(absoluteNativeName.substring(currentDirNameLen), dir, true);
                if (u.matchesFilter()) {
                    u.name = FileIO.nativeToNeutral(u.nativeName);
                    u.size = 0L;
                    u.time = dir.lastModified();
                    dirContents.add(u);
                }
            } else {
                ErrorWarningHandler.reportWarning("The absolute pathname of directory \"" + absoluteNativeName + "\" does not begin with the absolute pathname of the current directory \"" + currentDirName + "\".\nThis directory will be ignored.");
            }
        }
        for (File f : files) {
            String absoluteNativeName = f.getPath();
            if (absoluteNativeName.startsWith(currentDirName)) {
                FileUnit u = new FileUnit(absoluteNativeName.substring(currentDirNameLen), f, false);
                if (!u.matchesFilter()) continue;
                u.name = FileIO.nativeToNeutral(u.nativeName);
                u.size = f.length();
                u.time = f.lastModified();
                dirContents.add(u);
                continue;
            }
            ErrorWarningHandler.reportWarning("The absolute pathname of file \"" + absoluteNativeName + "\" does not begin with the absolute pathname of the current directory \"" + currentDirName + "\".\nThis file will be ignored.");
        }
        for (File d : dirs) {
            ZipSnap.getDirContents(d, dirContents);
        }
    }

    private static Pattern getGlobFilterPattern() {
        StringBuilder t = new StringBuilder();
        Stack<String> parserMode = new Stack<String>();
        parserMode.push("--");
        StringBuilder remainingChars = new StringBuilder(filterString);
        while (remainingChars.length() > 0) {
            char c = remainingChars.charAt(0);
            remainingChars.deleteCharAt(0);
            if (c == '\\') {
                if (remainingChars.length() == 0) {
                    t.append(Pattern.quote(c + ""));
                    continue;
                }
                c = remainingChars.charAt(0);
                remainingChars.deleteCharAt(0);
                String s = c + "";
                if ("--".equals(parserMode.peek()) && !"\\[]{}?*".contains(s)) {
                    ErrorWarningHandler.reportErrorAndExit("Invalid escape sequence \"\\" + c + "\" near position " + (filterString.length() - remainingChars.length()) + " of glob filter string.");
                } else if ("[]".equals(parserMode.peek()) && !"\\[]{}?*!-".contains(s)) {
                    ErrorWarningHandler.reportErrorAndExit("Invalid escape sequence \"\\" + c + "\" near position " + (filterString.length() - remainingChars.length()) + " of glob filter string.");
                } else if ("{}".equals(parserMode.peek()) && !"\\[]{}?*,".contains(s)) {
                    ErrorWarningHandler.reportErrorAndExit("Invalid escape sequence \"\\" + c + "\" near position " + (filterString.length() - remainingChars.length()) + " of glob filter string.");
                }
                t.append(Pattern.quote(s));
                continue;
            }
            if (c == '*') {
                t.append(".*");
                continue;
            }
            if (c == '?') {
                t.append('.');
                continue;
            }
            if (c == '[') {
                t.append('[');
                parserMode.push("[]");
                if (remainingChars.length() <= 0 || remainingChars.charAt(0) != '!') continue;
                c = remainingChars.charAt(0);
                remainingChars.deleteCharAt(0);
                t.append('^');
                continue;
            }
            if ("[]".equals(parserMode.peek()) && c == ']') {
                t.append(']');
                parserMode.pop();
                continue;
            }
            if ("[]".equals(parserMode.peek()) && c == '-') {
                t.append('-');
                continue;
            }
            if (c == '{') {
                t.append("(?:(?:");
                parserMode.push("{}");
                continue;
            }
            if ("{}".equals(parserMode.peek()) && c == '}') {
                t.append("))");
                parserMode.pop();
                continue;
            }
            if ("{}".equals(parserMode.peek()) && c == ',') {
                t.append(")|(?:");
                continue;
            }
            t.append(Pattern.quote(c + ""));
        }
        if ("[]".equals(parserMode.peek())) {
            ErrorWarningHandler.reportErrorAndExit("Cannot find matching closing square bracket ']' in glob filter string \"" + filterString + "\".");
        }
        if ("{}".equals(parserMode.peek())) {
            ErrorWarningHandler.reportErrorAndExit("Cannot find matching closing curly brace '}' in glob filter string \"" + filterString + "\".");
        }
        Pattern filterPattern = null;
        try {
            filterPattern = Pattern.compile(t.toString());
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("Unable to compile the specified glob filter string \"" + filterString + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        return filterPattern;
    }

    private static Pattern getRegexFilterPattern() {
        Pattern filterPattern = null;
        try {
            filterPattern = Pattern.compile(filterString);
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("Unable to compile the specified regex filter string \"" + filterString + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
        return filterPattern;
    }

    private static int listFiles(File listFile, List<FileUnit> files, List<FileUnit> listedFiles) {
        String listFileName = listFile.getName();
        if (simulateOnly) {
            return CompressionIO.simulateProcessFiles("\n\nSimulating creation of list \"" + listFileName + "\" of " + files.size() + " files/directories:", "", "No. of files/directories listed:", true, files, listedFiles);
        }
        System.out.print("\n\nCreating list \"" + listFileName + "\" of " + files.size() + " files/directories:");
        File parentDir = listFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
        if (parentDir == null || !parentDir.isDirectory()) {
            ErrorWarningHandler.reportErrorAndExit("Unable to create list \"" + listFile.getPath() + "\":\nThe parent directory of the file does not exist, and cannot be created.");
        }
        if (listFile.exists()) {
            ErrorWarningHandler.reportErrorAndExit("Unable to create list \"" + listFile.getPath() + "\":\nA " + (listFile.isDirectory() ? "directory" : "file") + " of the same name already exists.");
        }
        int numListedFiles = 0;
        if (files.isEmpty()) {
            try {
                FileOutputStream fos = new FileOutputStream(listFile);
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                ErrorWarningHandler.reportErrorAndExit("Unable to create list \"" + listFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
        } else {
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new BufferedWriter(new FileWriter(listFile)));
            }
            catch (Exception e) {
                ErrorWarningHandler.reportErrorAndExit("Unable to create list \"" + listFileName + "\":\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
            int i = 0;
            for (FileUnit u : files) {
                System.out.print("\n  [" + ++i + "] \"" + u.nativeName + "\"");
                System.out.flush();
                pw.println(u.nativeName);
                listedFiles.add(u);
                ++numListedFiles;
            }
            try {
                pw.flush();
                pw.close();
            }
            catch (Exception e) {
                ErrorWarningHandler.reportWarning("Unable to close list \"" + listFileName + "\"\n(list may not be written successfully):\n" + ErrorWarningHandler.getExceptionMessage(e));
            }
        }
        System.out.print("\n  --------------------------------\n  No. of files/directories listed: " + numListedFiles + " out of " + files.size());
        System.out.flush();
        FileIO.FileIOResult result = FileIO.setFileTime(listFile, currentTime.getTime());
        if (!result.success) {
            ErrorWarningHandler.reportWarning("Unable to set last-modified time of list \"" + listFileName + "\".");
        }
        return numListedFiles;
    }

    private static int deleteFiles(List<FileUnit> files, List<FileUnit> deletedFiles) {
        if (simulateOnly) {
            if (defaultActionOnDelete == 'N') {
                return CompressionIO.simulateProcessFiles("\n\nSimulating deletion of " + files.size() + " files/directories from the current directory:", "Skipping ", "No. of files/directories deleted:", false, files, deletedFiles);
            }
            return CompressionIO.simulateProcessFiles("\n\nSimulating deletion of " + files.size() + " files/directories from the current directory:", "", "No. of files/directories deleted:", true, files, deletedFiles);
        }
        System.out.print("\n\nDeleting " + files.size() + " files/directories from the current directory:");
        int numDeletedFiles = 0;
        int i = 0;
        for (FileUnit u : files) {
            ++i;
            if (!u.file.exists() || u.isDirectory != u.file.isDirectory()) {
                System.out.print("\n  [" + i + "] \"" + u.nativeName + "\" does not exist anymore.");
                System.out.flush();
                continue;
            }
            String pathname = null;
            try {
                pathname = u.file.getCanonicalPath();
            }
            catch (Exception e) {
                pathname = null;
            }
            if (pathname == null || !pathname.equals(u.file.getPath())) {
                System.out.print("\n  [" + i + "] \"" + u.nativeName + "\" does not exist anymore.");
                System.out.flush();
                continue;
            }
            boolean deleteFile = false;
            if (defaultActionOnDelete == 'Y') {
                System.out.print("\n  [" + i + "] \"" + u.nativeName + "\"");
                deleteFile = true;
            } else if (defaultActionOnDelete == 'N') {
                System.out.print("\n  [" + i + "] Skipping \"" + u.nativeName + "\"");
            } else if (defaultActionOnDelete == '\u0000') {
                System.out.print("\n  [" + i + "] Delete \"" + u.nativeName + "\"?\n  ");
                char choice = UserIO.userCharPrompt("(Y)es/(N)o/(A)lways/Neve(R): ", "YNAR");
                if (choice == 'Y') {
                    deleteFile = true;
                } else if (choice == 'A') {
                    defaultActionOnDelete = (char)89;
                    deleteFile = true;
                } else if (choice == 'R') {
                    defaultActionOnDelete = (char)78;
                }
            }
            System.out.flush();
            if (!deleteFile) continue;
            FileIO.FileIOResult result = null;
            result = u.isDirectory ? FileIO.deleteDir(u.file) : FileIO.deleteFile(u.file);
            if (result.success) {
                deletedFiles.add(u);
                ++numDeletedFiles;
                continue;
            }
            ErrorWarningHandler.reportWarning("Unable to delete " + (u.isDirectory ? "directory" : "file") + " \"" + u.nativeName + "\":\n" + result.errorMessage);
        }
        System.out.print("\n  ---------------------------------\n  No. of files/directories deleted: " + numDeletedFiles + " out of " + files.size());
        System.out.flush();
        return numDeletedFiles;
    }

    private static int restoreDirTime(List<FileUnit> dirs, List<FileUnit> restoredDirs) {
        System.out.print("\n\nRestoring timestamps of " + dirs.size() + " directories:");
        int numRestoredDirs = 0;
        int i = 0;
        for (FileUnit u : dirs) {
            System.out.print("\n  [" + ++i + "] \"" + u.nativeName + "\"");
            System.out.flush();
            FileIO.FileIOResult result = FileIO.setDirTime(u.file, u.time);
            if (result.success) {
                restoredDirs.add(u);
                ++numRestoredDirs;
                continue;
            }
            ErrorWarningHandler.reportWarning("Unable to restore timestamp of directory \"" + u.nativeName + "\".");
        }
        System.out.print("\n  -------------------------------------\n  No. of directory timestamps restored: " + numRestoredDirs + " out of " + dirs.size());
        System.out.flush();
        return numRestoredDirs;
    }

    private static void printUsage() {
        System.out.print("\nZipSnap is a simple command-line incremental backup tool for directories.\n\nUSAGE:  java -jar ZipSnap.jar  [command]  <switches>  [\"Archive\"]\n\n[Commands]:\n\n a  ADD a snapshot of the current directory to the archive:\n     ZipSnap looks for the latest catalog in directory [\"Archive\"] and performs\n     file matching between the current directory contents and previously\n     archived files and directories as described by the catalog. By default,\n     files and directories are matched by full (relative) pathname, size, and\n     last-modified time (in milliseconds). The new or modified files and\n     directories in the current directory (i.e. the unmatched contents) are\n     then added to a new compressed volume (by default, a ZIP file), and a new\n     catalog (by default, a plain text file compressed as a ZIP file) is\n     written. If the archive does not exist yet, a new archive is created.\n\n r  RESTORE a snapshot from the archive to the current directory:\n     ZipSnap looks for the latest catalog in directory [\"Archive\"] and by\n     default, restores the latest snapshot from the archive. File matching is\n     performed between the current directory contents and the snapshot\n     contents, to determine the unmatched files and directories that need to be\n     extracted from their respective compressed volumes, and to be deleted from\n     the current directory. By default, files and directories are matched by\n     full (relative) pathname, size, and last-modified time (in milliseconds).\n\n i  Display INFORMATION on the archive:\n     ZipSnap looks for the latest catalog in directory [\"Archive\"] and displays\n     the file counts for each snapshot in the archive.\n\n<Switches>:\n\n -s, --simulate        Simulate only; do not actually add/restore snapshot\n -i, --ignorewarnings  Ignore warnings; do not pause\n\n -c, --crc             Use file CRC-32 checksum for file matching, in addition\n                        to full (relative) pathname, size, and last-modified\n                        time (in milliseconds)\n -t, --time:[x]        Use a x-millisecond time-tolerance for file matching\n                        (by default, a 0-millisecond time-tolerance is used)\n     --all             Add/extract ALL files/directories when adding/restoring\n                        a snapshot without performing file matching first\n     --forceadd        Force addition of snapshot, even if it is identical to\n                        the last snapshot (by default, an identical snapshot\n                        is not added)\n\n -l, --list            Create a list of files/directories to be added/extracted\n                        when adding/restoring a snapshot\n -z, --zip:<x>         Add files/directories to a ZIP volume using compression\n                        level x, with 0 and 9 representing minimum and maximum\n                        compression respectively (by default, maximum\n                        compression is used)\n -j, --jar:<x>         Add files/directories to a JAR volume ...\n\n     --snapshot:[x]    Restore snapshot number x (by default, the latest\n                        snapshot is restored)\n -o, --overwrite:[y|n] Always[y]/never[n] overwrite existing files/directories\n                        when restoring a snapshot\n -d, --delete:[y|n]    Always[y]/never[n] delete unmatched existing\n                        files/directories when restoring a snapshot\n -p, --path:[\"x\"]      Include additional search path x for volume files when\n                        restoring a snapshot (can be used repeatedly to specify\n                        multiple search paths)\n\n -f, --filter:[\"x\"]       Apply GLOB filter string x for file/directory names\n -F, --FILTER:[\"x\"]       ... for full (relative) file/directory pathnames\n -e, --filterregex:[\"x\"]  Apply REGEX filter string x for file/directory names\n -E, --FILTERREGEX:[\"x\"]  ... for full (relative) file/directory pathnames\n\n[\"Archive\"]:\n\n ZipSnap archive, i.e. the directory containing the catalogs and compressed\n volumes\n\nNOTES:\n\n 1. ZipSnap creates archives that are collections of point-in-time snapshots.\n     An archive is just a directory of catalogs (plain text files compressed as\n     ZIP files) and compressed volumes (ZIP files).\n\n 2. Catalogs are written cumulatively, i.e. a later catalog contains all the\n     information from previous catalogs. Therefore, only the latest catalog is\n     needed when adding/restoring snapshots.\n\n 3. Catalogs and compressed volumes are automatically timestamped as\n     ArchiveName.yyyyMMdd-HHmmss.n, with extensions .txt.zip and .zip\n     respectively, where n is the snapshot number.\n\n 4. The latest catalog selected by ZipSnap is the catalog with the largest\n     snapshot number in the archive directory. To break ties, the catalog with\n     the latest last-modified time is selected.\n\n 5. When restoring a snapshot, ZipSnap looks for volume files with specific\n     timestamps and snapshot numbers, in the archive directory. Additional\n     search paths, if specified, are also searched. To break ties, the volume\n     with the latest last-modified time is selected.\n\n 6. Because ZipSnap never modifies a catalog or compressed volume after it is\n     created, archives can be stored on write-once-only media.\n\n 7. ZipSnap supports GLOB and REGEX filters for file/directory names, or their\n     full (relative) pathnames. The supported REGEX patterns are given by the\n     Java API documentation.\n\n    GLOB Patterns and Wildcards:\n      *    Matches a string of zero or more characters\n      ?    Matches exactly one character\n     [ ]   Matches exactly one character from within the brackets:\n             [abc]      matches a, b, or c\n             [!abc]     matches any character except a, b, or c (negation)\n             [a-z0-9]   matches any character a through z, or 0 through 9,\n                         inclusive (range)\n     { }   Matches exactly one comma-delimited string from within the braces:\n             {a,bc,def} matches either a, bc, or def\n\nEXAMPLES:\n\n 1. ADD a snapshot to the archive; if the archive does not exist, a new archive\n     is created:\n    java -jar ZipSnap.jar a \"C:\\Backups\\Work\"\n\n 2. RESTORE the latest snapshot from the archive:\n    java -jar ZipSnap.jar r \"C:\\Backups\\Work\"\n\n 3. RESTORE the latest snapshot from the archive, and always overwrite existing\n     files/directories, but never delete unmatched existing files/directories:\n    java -jar ZipSnap.jar r --overwrite:y --delete:n \"C:\\Backups\\Work\"\n\n 4. RESTORE snapshot number 2 from the archive:\n    java -jar ZipSnap.jar r --snapshot:2 \"C:\\Backups\\Work\"\n\n 5. RESTORE only jpg or html files in the latest snapshot from the archive:\n    java -jar ZipSnap.jar r --filter:\"*.{jpg,html}\" \"C:\\Backups\\Work\"\n\n 6. Display INFORMATION on the archive:\n    java -jar ZipSnap.jar i \"C:\\Backups\\Work\"\n\n");
    }

    static {
        useCrc = false;
        timeTolerance = 0L;
        all = false;
        snapshotIndex = -1;
        forceAdd = false;
        defaultActionOnOverwrite = '\u0000';
        defaultActionOnDelete = '\u0000';
        volumeType = VolumeType.ZIP;
        compressionLevel = 9;
        searchPaths = new ArrayList<File>();
        filterString = null;
        filterFullPathname = false;
        filterPattern = null;
    }

    private static enum FilterType {
        GLOB,
        REGEX;

    }

    private static enum VolumeType {
        ZIP,
        JAR,
        LIST;

    }

    private static enum Command {
        ADD,
        RESTORE,
        INFO;

    }
}

