/*
 * Decompiled with CFR 0.152.
 */
package zipsnap;

import java.util.Scanner;

public class ErrorWarningHandler {
    private static int numErrors = 0;
    private static int numWarnings = 0;
    private static boolean pauseOnWarning = true;
    private static final int defaultExitCode = 1;

    public static void setPauseOnWarning(boolean pauseOnWarning) {
        ErrorWarningHandler.pauseOnWarning = pauseOnWarning;
    }

    public static int getNumErrors() {
        return numErrors;
    }

    public static int getNumWarnings() {
        return numWarnings;
    }

    public static void reportWarning(Object warningMessage) {
        ++numWarnings;
        System.err.print("\nWARNING: " + warningMessage + "\n");
        System.err.flush();
        if (!pauseOnWarning) {
            return;
        }
        System.err.print("Press ENTER to continue...");
        System.err.flush();
        try {
            new Scanner(System.in).nextLine();
        }
        catch (Exception e) {
            ErrorWarningHandler.reportErrorAndExit("(FATAL) Cannot read from keyboard.\n" + ErrorWarningHandler.getExceptionMessage(e));
        }
    }

    public static void reportErrorAndExit(Object errorMessage, int exitCode) {
        ++numErrors;
        System.err.print("\nERROR: " + errorMessage + "\nProgram aborted.\n\n");
        System.err.flush();
        System.exit(exitCode);
    }

    public static void reportErrorAndExit(Object errorMessage) {
        ErrorWarningHandler.reportErrorAndExit(errorMessage, 1);
    }

    public static String getExceptionMessage(Exception e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        StringBuilder a = new StringBuilder();
        a.append("\nJava exception information (" + e.getClass() + "):\n\"" + e.getMessage() + "\"");
        for (int i = 0; i < stackTrace.length; ++i) {
            a.append("\n  at ");
            a.append(stackTrace[i]);
        }
        a.append('\n');
        return a.toString();
    }
}

