{***************************************************************}
{ XMLInspector - a component for automatic generation of dialog }
{ forms based on XML                                            }
{                                                               }
{    Copyright (c) 2001-2004 Alexander Sviridenkov              }
{    Contact: asv@devrace.com                                   }
{                                                               }
{    This module is partially based om Qstrings                 }
{ ------------------------------------------------------------- }
{    XMLInspector home page : http://www.xmlinspector.com/      }
{    Support page :  http://www.devrace.com/en/support/         }
{ ------------------------------------------------------------- }
{                                                               }
{  Please see the file License.txt for full license information }
{                                                               }
{***************************************************************}

unit strs; //version 1.13 07.06.2001

{$J+}

interface

uses Classes, SysUtils, IniFiles, TypInfo;

{$I xmlinspector.inc}

Const
  MonthNames: array[1..12] of String[8]=('', '', '', '',
  '', '', '', '', '', '', '', '');

  EMonthNames: array[1..12] of String[3]=('Jan', 'Feb', 'Mar', 'Apr',
  'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');

  DOWNames: array[1..7] of string[3]=('', '', '', '', '', '', '');
  EDOWNames: array[1..7] of string[3]=('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
  RootPath: string='';
  CF_HTML=49279;
  MaxParamCount=20; //Max params in procedures


type
  TStringRec=class
   s: string;
   constructor Create(const s1: string);
  end;

  TString2Rec=class
   s, s1: string;
   constructor Create(const xs, xs1: string);
  end;

  TString3Rec=class
   s, s1, s2: string;
   constructor Create(const xs, xs1: string; const xs2: string='');
  end;

  TStringData=class
   s: string;
   t: integer;
   constructor Create(const s1:string; t1:integer);
  end;
                         
  TFastList = class(TStrings)
  private
    FList: PStringItemList;
    FCount: Integer;
    FCapacity: Integer;
    FSorted: Boolean;
    FDuplicates: TDuplicates;
    FOwnsObjects: boolean;
    procedure ExchangeItems(Index1, Index2: Integer);
    procedure Grow;
    procedure QuickSort(L, R: Integer);
    procedure InsertItem(Index: Integer; const S: string);
    procedure SetSorted(Value: Boolean);
    function  FastGetValue(const Name: string):string;
    procedure FastSetValue(const Name, Value: string);
  protected
    function  Get(Index: Integer): string; override;
    function  GetCapacity: Integer; override;
    function  GetCount: Integer; override;
    function  GetObject(Index: Integer): TObject; override;
    procedure Put(Index: Integer; const S: string); override;
    procedure PutObject(Index: Integer; AObject: TObject); override;
    procedure SetCapacity(NewCapacity: Integer); override;
  public
    SortAsInteger: boolean;
    destructor Destroy; override;
    function  Add(const S: string): Integer; override;
    procedure Clear; override;
    procedure Delete(Index: Integer); override;
    procedure Exchange(Index1, Index2: Integer); override;
    function  Find(const S: string; var Index: Integer): Boolean; virtual;
    function  IndexOf(const S: string): Integer; override;
    procedure Insert(Index: Integer; const S: string); override;
    procedure Sort; virtual;
    procedure FreePointers;
    procedure FreeObjects;
    property  Duplicates: TDuplicates read FDuplicates write FDuplicates;
    property  Sorted: Boolean read FSorted write SetSorted;
    property  Values[const Name: string]: string read FastGetValue write FastSetValue;
    property  OwnsObjects: boolean read FOwnsObjects write FOwnsObjects;
  end;

  PDateItem = ^TDateItem;
  TDateItem = record
    FDate: TDateTime;
    FObject: TObject;
  end;

  TVariantParams=array[0..MaxParamCount-1] of variant;


 const MaxDateListSize=MaxInt div SizeOf(TDateItem);

 type

  TDateList = class;
  PDateItemList = ^TDateItemList;
  TDateItemList = array[0..MaxDateListSize-1] of TDateItem;
  TDateListSortCompare = function(List: TDateList; Index1, Index2: Integer): Integer;

  TDateList=class
  private
    FList: PDateItemList;
    FCount: Integer;
    FCapacity: Integer;
    FSorted: Boolean;
    FDuplicates: TDuplicates;
    FOwnsObjects: Boolean;
    procedure ExchangeItems(Index1, Index2: Integer);
    procedure Grow;
    procedure QuickSort(L, R: Integer);
    procedure InsertItem(Index: Integer; const D: TDateTime);
    procedure SetSorted(Value: Boolean);
  protected
    procedure Error(const Msg: string; Data: Integer);
    function Get(Index: Integer): TDateTime; virtual;
    function GetCapacity: Integer;
    function GetCount: Integer; virtual;
    function GetObject(Index: Integer): TObject; virtual;
    procedure Put(Index: Integer; const D: TDateTime); virtual;
    procedure PutObject(Index: Integer; AObject: TObject); virtual;
    procedure SetCapacity(NewCapacity: Integer); virtual;
  public
    destructor Destroy; override;
    function  Add(const D: TDateTime): Integer; virtual;
    function  AddObject(const D: TDateTime; AObject: TObject): Integer; virtual;
    procedure Clear; virtual;
    procedure Delete(Index: Integer); virtual;
    procedure Exchange(Index1, Index2: Integer); virtual;
    function  Find(const D: TDateTime; var Index: Integer): Boolean; virtual;
    function  IndexOf(const D: TDateTime): Integer; virtual;
    function  IndexOfObject(AObject: TObject): Integer;
    procedure Insert(Index: Integer; const D: TDateTime); virtual;
    procedure InsertObject(Index: Integer; const D: TDateTime; AObject: TObject);
    procedure Sort; virtual;
    procedure FreeObjects;
    property  Capacity: Integer read GetCapacity write SetCapacity;
    property  Count: Integer read GetCount;
    property  Objects[Index: Integer]: TObject read GetObject write PutObject;
    property  Dates[Index: Integer]: TDateTime read Get write Put; default;
    property  Duplicates: TDuplicates read FDuplicates write FDuplicates;
    property  Sorted: Boolean read FSorted write SetSorted;
    property  OwnsObjects: boolean read FOwnsObjects write FOwnsObjects;
  end;

  PIDItem = ^TIDItem;
  TIDItem = record
    FID: cardinal;
    FObject: TObject;
  end;

 const MaxIDListSize=MaxInt div SizeOf(TIDItem);

 type
  TIDList = class;
  PIDItemList = ^TIDItemList;
  TIDItemList = array[0..MaxIDListSize-1] of TIDItem;
  TIDListSortCompare = function(List: TIDList; Index1, Index2: Integer): Integer;

  TIDList=class
  private
    FList: PIDItemList;
    FCount: Integer;
    FCapacity: Integer;
    FSorted: Boolean;
    FDuplicates: TDuplicates;
    FOwnsObjects: Boolean;
    procedure ExchangeItems(Index1, Index2: Integer);
    procedure Grow;
    procedure QuickSort(L, R: Integer);
    procedure InsertItem(Index: Integer; ID: cardinal);
    procedure SetSorted(Value: Boolean);
  protected
    procedure Error(const Msg: string; Data: Integer);
    function Get(Index: Integer): cardinal; virtual;
    function GetCapacity: Integer;
    function GetCount: Integer; virtual;
    function GetObject(Index: Integer): TObject; virtual;
    procedure Put(Index: Integer; ID: cardinal); virtual;
    procedure PutObject(Index: Integer; AObject: TObject); virtual;
    procedure SetCapacity(NewCapacity: Integer); virtual;
  public
    destructor Destroy; override;
    function  Add(ID: cardinal): Integer; virtual;
    function  AddObject(ID: cardinal; AObject: TObject): Integer; virtual;
    procedure Clear; virtual;
    procedure Delete(Index: Integer); virtual;
    procedure Exchange(Index1, Index2: Integer); virtual;
    function  Find(ID: cardinal; var Index: Integer): Boolean; virtual;
    function  IndexOf(ID: cardinal): Integer; virtual;
    function  IndexOfObject(AObject: TObject): Integer;
    procedure Insert(Index: Integer; ID: cardinal); virtual;
    procedure InsertObject(Index: Integer; ID: cardinal; AObject: TObject);
    procedure Sort; virtual;
    procedure FreeObjects;
    property  Capacity: Integer read GetCapacity write SetCapacity;
    property  Count: Integer read GetCount;
    property  Objects[Index: Integer]: TObject read GetObject write PutObject;
    property  Ids[Index: Integer]: cardinal read Get write Put; default;
    property  Duplicates: TDuplicates read FDuplicates write FDuplicates;
    property  Sorted: Boolean read FSorted write SetSorted;
    property  OwnsObjects: boolean read FOwnsObjects write FOwnsObjects;
  end;


  TFastString=class
   private
    Value: pointer;
    VSize, VLength, Delta: cardinal;
    function  GetAsString: string;
    procedure SetAsString(const s: string);
   public
    constructor Create(ADelta: cardinal);
    destructor  Destroy; override;
    procedure   Add(const s: string);
    property    AsString: string read GetAsString write SetAsString;
   end;

{ Q_ReplaceStr     FindString   SourceString
   ReplaceString.      
  (    ).   -.
    FindString    SourceString,  
    SourceString. }

function Q_ReplaceStr(const SourceString, FindString, ReplaceString: string): string;

{ Q_PosStr     FindString   SourceString,
     StartPos.   ,   
    0,   FindString     SourceString.
        (   
  ).   - Peter Morris (UK) ( FastStrings). }

function Q_ReplaceText(const SourceString, FindString, ReplaceString: string): string;

function Q_PosStr(const FindString, SourceString: string;
  StartPos: Integer {= 1}): Integer;

{ Q_CopyMem  L    ,  
  Source,   ,   Dest.  
     !!!  Q_CopyMem  , 
    Move. }

procedure Q_CopyMem(Source, Dest: Pointer; L: Cardinal);

{ Q_TinyCopy    32  ()   ,
    Source   ,   Dest.
        L.   
   .   L > 32    . }

procedure Q_TinyCopy(Source, Dest: Pointer; L: Cardinal);

{ Q_PStrLen     PChar,   P. 
       StrLen.  
   Robert Lee (rhlee@optimalcode.com). }

function Q_PStrLen(P: PChar): Integer;

{ Q_SameStr         True, 
   ,   False.  Q_PSameStr  Q_SameStr
   Pointer(String). }

function Q_SameStr(const S1, S2: string): Boolean;

{ Q_CompText      .  
   ,  S1 < S2;  ,  S1 > S2,   , 
  S1 = S2.    ,    
        0.      
   ,   Q_CompText  Q_CompTextL. 
   Q_PCompText  Q_CompText  PChar  Pointer(String). 
    ,      , 
   Q_CompText  Q_SameText. }

{          True, 
   ,  - False.  Q_PSameText  Q_SameStr 
  Pointer(String). }

function Q_SameText(const S1, S2: string): Boolean;


{ Q_SameStrL     MaxL     .
   True,   ,   False. }

function Q_SameStrL(const S1, S2: string; MaxL: Cardinal): Boolean;


{ Q_SameTextL     MaxL     .
   True,   ,   False. }

function Q_SameTextL(const S1, S2: string; MaxL: Cardinal): Boolean;


function Q_CompText(const S1, S2: string): Integer;

{ Q_CompStr      .  
   ,  S1 < S2;  ,  S1 > S2,   , 
  S1 = S2.    ,    
        0.      
   ,   Q_CompStr  Q_CompStrL. 
   Q_PCompStr  Q_CompStr  PChar  Pointer(String). 
    ,      , 
   Q_CompStr  Q_SameStr. }

function Q_CompStr(const S1, S2: string): Integer;

{ Q_FillChar  L  ,   P,  C.
       FillChar. }

procedure Q_FillChar(P: Pointer; L: Cardinal; Ch: Char);

{ Q_UpperCase   S    (  ). 
      .    ,  Q_StrUpper
   Q_StrUpperMoveL. }

function Q_UpperCase(const S: string): string;

{ Q_LowerCase   S    (  ). 
      .    ,  Q_StrLower
   Q_StrLowerMoveL. }

function Q_LowerCase(const S: string): string;

{ Q_PStrToOemL  L   ,   P,
    Windows   DOS.     .
       . }

function  Q_PStrToOemL(P: PChar; L: Cardinal): PChar;

function  VarStrPos(const Str1, Str2: PChar; SL1:integer): PChar;

function  VarPos(s: pchar; p: pchar; astart, L: integer): integer;

function  VarCopy(p: pchar; astart, alength, plength: integer): string;

procedure Q_KoitoWin(var S: string);
procedure Q_WintoKOI(var S: string);

procedure Q_WintoOEM(var S: string);

function  Q_IntToStr(N: Integer): string;

function  ValuetoTextRUR(V: double): string;
function  ValuetoTextUSD(V: double): string;

procedure StrtoFile(const s, FileName: string);

function  FileToStr(const FileName: string): string;

procedure FastTrim(var s: shortstring); assembler;

{ Q_StrTok     S,    
   . Q_StrTok   S   
      ,       
  -   Delimiters. .. Delimiters -  ,
    ,       S.
       ,   Q_StrTok.
      -,    . 
  Delimiters   ,   , 
           : Q_StrTok,
  Q_StrSpn, Q_StrCSpn, Q_ProperCase, Q_ProperCaseInPlace, Q_WordAtPos,
  Q_GetWordN, Q_SetDelimiters, Q_CountOfWords.   
    ,       . }

function  Q_StrTok(var S: string; const Delimiters: string): string;

{ Q_Delete     S.     .
  Index -    , Count -  ,
   .    ,   Delete. }

procedure Q_Delete(var S: string; Index, Count: Integer);

{ Q_ProperCase   S,   ,  
       (     
   ,    -   ).   Delimiters
   ,        S.
  ,   Q_ProperCase(' ',' ')  
  ' '.  Delimiters   , 
   ,         
   : Q_ProperCaseInPlace, Q_ProperCase, Q_StrTok, Q_StrSpn,
  Q_StrCSpn, Q_WordAtPos, Q_GetWordN, Q_SetDelimiters, Q_CountOfWords. 
      ,     
   . }

function Q_ProperCase(const S, Delimiters: string): string;


procedure Q_CutLeft(var S: string; CharCount: Integer);

{ Q_TestByMask ,    S  Mask, ,
    MaskChar   Mask      S 
   .       .
    S  ,   True,  False.
  , Q_TestMask('ISBN 5-09-007017-2','ISBN ?-??-??????-?','?') 
   True. }

function Q_TestByMask(const S, Mask: string; MaskChar: Char = 'X'): Boolean;


{ Q_TestWildStr ,    S  Mask, ,
    MaskChar   Mask      S 
   ,   WildCard     
   .       . 
  WildCard     #0.   S  ,
    True,  False. ,   
   True: Q_TestWildStr('abc12345_infQ_XL.dat','abc*_???Q_*.d*at'). }

function Q_TestWildStr(const S, Mask: string; MaskChar, WildCard: Char): Boolean;

{ Q_StrScan     Ch   S,   
   StartPos.      ,   Ch
    S  .  Q_PStrScan  Q_StrScan 
  Pointer(String). }

function Q_StrScan(const S: string; Ch: Char; StartPos: Integer = 1): Integer;
function Q_PStrScan(P: Pointer; Ch: Char; ASize: Integer): Integer;

function  Min(x1, x2: Integer): Integer; overload;
function  Max(x1, x2: Integer): Integer; overload;
function  Min(x1, x2: extended): extended; overload;
function  Max(x1, x2: extended): extended; overload;

function  IIF(b: boolean; const s1, s2: string): string; overload;
function  IIF(b: boolean; n1, n2: integer): integer; overload;
function  IIF(b: boolean; r1, r2: extended): extended; overload;
function  Decode(const s: string; const Values: array of string): string;
function  StrIn(const s: string; const Values: array of string): boolean;
function  CopyToPos(const s, substr: string): string;

function  IntParam(const s: string; defvalue: integer): integer;

function  IntToStr2(value: integer):string;
function  StrtoInt2(const s: string): integer;

function  TransliterateRE(const s: string): string;
function  TransliterateER(const s: string): string;

function  LongTimetoStr(t: TDateTime): string;
function  StrtoLongTime(const s: string): TDateTime;

function  ReadIni(const IniFile, Section, Param: string): string;
procedure WriteIni(const IniFile, Section, Param, Value: string);
procedure StrToTokens(s, delims: string; L:TStringList);

procedure DirectorytoStringList(Dir: string; L: TStringList);
procedure SubdirstoStringList(Dir: string; L: TStringList);
function  StartsWith(const s, start: string): boolean;
function  EndsWith(const s, send: string): boolean;
function  iStrtoFloat(const s: string): extended;
function  iStrtoCurr(const s: string): currency;
function  BooltoStr(b: boolean): string;
function  Trans(const s: string): string;
function  ExtractQuotedStr(var s: string): string;
function  Dow(Date: TDateTime): integer;
function  MonthStart(Date: TDateTime): TDateTime;
function  MonthEnd(Date: TDateTime): TDateTime;
function  PrevMonthStart(Date: TDateTime): TDateTime;
function  YearStart(Date: TDateTime):TDateTime;
function  YearEnd(Date: TDateTime):TDateTime;
function  DaysPerMonth(AYear, AMonth: Integer): Integer;
function  LastDayofYear(Date: TDateTime): TDateTime;
function  FirstDayofMonth(Date: TDateTime): TDateTime;
function  LastDayofMonth(Date: TDateTime): TDateTime;
function  CodeWordChange(PresentCode: string; Step:integer): string;
function  ShiftStr(const s: string; shift: integer):string;
function  RemoveTags(s: string): string;
function  RemoveTagsInsideTag(s, tag: string): string;
function  StrtoIP(const s: string): cardinal;
function  IPtoStr(ip: cardinal): string;
function  HTTPDecode(AStr: String): String;
procedure AddStr(var s: string; s1: string; delimiter: string=',');
function  WordPos(word, s: string): integer;
function  MathRound(x: extended): integer;
function  DecodeString(s: string): string;
function  HextoStr(const s:string):string;
procedure InsertStr(const s1: string; var s: string; p:integer);
procedure FileAppend(const FileName, s: string);
procedure FreeListObjects(L: TStringList);
function  iStrtoInt(const s: string): int64;
function  CorrectForm(const root, f0, f1, f2: string; count: integer): string;
function  StrtoDateFmt(const s, format: string): TDateTime;
function  iFormatDateTime(const format: string; DateTime: TDateTime): string;
function  Q_ScanLongWord(N: LongWord; ArrPtr: Pointer; Count: Cardinal): Integer;
function  CaseFind(F: TStringList; const S: string; var Index: Integer): Boolean;
function  CaseIndexof(L: TStringList; const s: string): integer;
function  Ceil(X: Extended): Integer;
function  Floor(X: Extended): Integer;
function  HexToDec(const p_str: string): integer;
function  HexToCardinal(const p_str: string): cardinal;
function  Power(Base, Exponent: Extended): Extended;
function  MonthList: string;
function  LoWord(t: cardinal): word;
function  HiWord(t: cardinal): word;
procedure SetEnabled(const A: array of TObject; E: boolean);
procedure SetVisible(const A: array of TObject; E: boolean);
function  FileUpper(const s: string): string;
{$IFDEF LINUX}
function GetTickCount: cardinal;
{$ENDIF}
function CheckFilesExists(const Path, Files: string): string;
function CompareDate(D1, D2: TDateTime): Integer;
function CompareInteger(I1, I2: Integer): Integer;

implementation

type LongWord=integer;
     PByte = ^Byte;
     PDelimsMap = ^TDelimsMap;
     TDelimsMap = array[#0..#255] of Boolean;
     PDelimsArr = ^TDelimsArr;
     TDelimsArr = array[0..255] of Boolean;

threadvar
  UDelimsMap: TDelimsMap;

const
  ToUpperChars: array[0..255] of Char =
    (#$00,#$01,#$02,#$03,#$04,#$05,#$06,#$07,#$08,#$09,#$0A,#$0B,#$0C,#$0D,#$0E,#$0F,
     #$10,#$11,#$12,#$13,#$14,#$15,#$16,#$17,#$18,#$19,#$1A,#$1B,#$1C,#$1D,#$1E,#$1F,
     #$20,#$21,#$22,#$23,#$24,#$25,#$26,#$27,#$28,#$29,#$2A,#$2B,#$2C,#$2D,#$2E,#$2F,
     #$30,#$31,#$32,#$33,#$34,#$35,#$36,#$37,#$38,#$39,#$3A,#$3B,#$3C,#$3D,#$3E,#$3F,
     #$40,#$41,#$42,#$43,#$44,#$45,#$46,#$47,#$48,#$49,#$4A,#$4B,#$4C,#$4D,#$4E,#$4F,
     #$50,#$51,#$52,#$53,#$54,#$55,#$56,#$57,#$58,#$59,#$5A,#$5B,#$5C,#$5D,#$5E,#$5F,
     #$60,#$41,#$42,#$43,#$44,#$45,#$46,#$47,#$48,#$49,#$4A,#$4B,#$4C,#$4D,#$4E,#$4F,
     #$50,#$51,#$52,#$53,#$54,#$55,#$56,#$57,#$58,#$59,#$5A,#$7B,#$7C,#$7D,#$7E,#$7F,
     #$80,#$81,#$82,#$81,#$84,#$85,#$86,#$87,#$88,#$89,#$8A,#$8B,#$8C,#$8D,#$8E,#$8F,
     #$80,#$91,#$92,#$93,#$94,#$95,#$96,#$97,#$98,#$99,#$8A,#$9B,#$8C,#$8D,#$8E,#$8F,
     #$A0,#$A1,#$A1,#$A3,#$A4,#$A5,#$A6,#$A7,#$A8,#$A9,#$AA,#$AB,#$AC,#$AD,#$AE,#$AF,
     #$B0,#$B1,#$B2,#$B2,#$A5,#$B5,#$B6,#$B7,#$A8,#$B9,#$AA,#$BB,#$A3,#$BD,#$BD,#$AF,
     #$C0,#$C1,#$C2,#$C3,#$C4,#$C5,#$C6,#$C7,#$C8,#$C9,#$CA,#$CB,#$CC,#$CD,#$CE,#$CF,
     #$D0,#$D1,#$D2,#$D3,#$D4,#$D5,#$D6,#$D7,#$D8,#$D9,#$DA,#$DB,#$DC,#$DD,#$DE,#$DF,
     #$C0,#$C1,#$C2,#$C3,#$C4,#$C5,#$C6,#$C7,#$C8,#$C9,#$CA,#$CB,#$CC,#$CD,#$CE,#$CF,
     #$D0,#$D1,#$D2,#$D3,#$D4,#$D5,#$D6,#$D7,#$D8,#$D9,#$DA,#$DB,#$DC,#$DD,#$DE,#$DF);

  ToLowerChars: array[0..255] of Char =
    (#$00,#$01,#$02,#$03,#$04,#$05,#$06,#$07,#$08,#$09,#$0A,#$0B,#$0C,#$0D,#$0E,#$0F,
     #$10,#$11,#$12,#$13,#$14,#$15,#$16,#$17,#$18,#$19,#$1A,#$1B,#$1C,#$1D,#$1E,#$1F,
     #$20,#$21,#$22,#$23,#$24,#$25,#$26,#$27,#$28,#$29,#$2A,#$2B,#$2C,#$2D,#$2E,#$2F,
     #$30,#$31,#$32,#$33,#$34,#$35,#$36,#$37,#$38,#$39,#$3A,#$3B,#$3C,#$3D,#$3E,#$3F,
     #$40,#$61,#$62,#$63,#$64,#$65,#$66,#$67,#$68,#$69,#$6A,#$6B,#$6C,#$6D,#$6E,#$6F,
     #$70,#$71,#$72,#$73,#$74,#$75,#$76,#$77,#$78,#$79,#$7A,#$5B,#$5C,#$5D,#$5E,#$5F,
     #$60,#$61,#$62,#$63,#$64,#$65,#$66,#$67,#$68,#$69,#$6A,#$6B,#$6C,#$6D,#$6E,#$6F,
     #$70,#$71,#$72,#$73,#$74,#$75,#$76,#$77,#$78,#$79,#$7A,#$7B,#$7C,#$7D,#$7E,#$7F,
     #$90,#$83,#$82,#$83,#$84,#$85,#$86,#$87,#$88,#$89,#$9A,#$8B,#$9C,#$9D,#$9E,#$9F,
     #$90,#$91,#$92,#$93,#$94,#$95,#$96,#$97,#$98,#$99,#$9A,#$9B,#$9C,#$9D,#$9E,#$9F,
     #$A0,#$A2,#$A2,#$BC,#$A4,#$B4,#$A6,#$A7,#$B8,#$A9,#$BA,#$AB,#$AC,#$AD,#$AE,#$BF,
     #$B0,#$B1,#$B3,#$B3,#$B4,#$B5,#$B6,#$B7,#$B8,#$B9,#$BA,#$BB,#$BC,#$BE,#$BE,#$BF,
     #$E0,#$E1,#$E2,#$E3,#$E4,#$E5,#$E6,#$E7,#$E8,#$E9,#$EA,#$EB,#$EC,#$ED,#$EE,#$EF,
     #$F0,#$F1,#$F2,#$F3,#$F4,#$F5,#$F6,#$F7,#$F8,#$F9,#$FA,#$FB,#$FC,#$FD,#$FE,#$FF,
     #$E0,#$E1,#$E2,#$E3,#$E4,#$E5,#$E6,#$E7,#$E8,#$E9,#$EA,#$EB,#$EC,#$ED,#$EE,#$EF,
     #$F0,#$F1,#$F2,#$F3,#$F4,#$F5,#$F6,#$F7,#$F8,#$F9,#$FA,#$FB,#$FC,#$FD,#$FE,#$FF);


  ToOemChars: array[0..255] of Char =
    (#$00,#$01,#$02,#$03,#$04,#$05,#$06,#$07,#$08,#$09,#$0A,#$0B,#$0C,#$0D,#$0E,#$0F,
     #$10,#$11,#$12,#$13,#$14,#$15,#$16,#$17,#$18,#$19,#$1A,#$1B,#$1C,#$1D,#$1E,#$1F,
     #$20,#$21,#$22,#$23,#$24,#$25,#$26,#$27,#$28,#$29,#$2A,#$2B,#$2C,#$2D,#$2E,#$2F,
     #$30,#$31,#$32,#$33,#$34,#$35,#$36,#$37,#$38,#$39,#$3A,#$3B,#$3C,#$3D,#$3E,#$3F,
     #$40,#$41,#$42,#$43,#$44,#$45,#$46,#$47,#$48,#$49,#$4A,#$4B,#$4C,#$4D,#$4E,#$4F,
     #$50,#$51,#$52,#$53,#$54,#$55,#$56,#$57,#$58,#$59,#$5A,#$5B,#$5C,#$5D,#$5E,#$5F,
     #$60,#$61,#$62,#$63,#$64,#$65,#$66,#$67,#$68,#$69,#$6A,#$6B,#$6C,#$6D,#$6E,#$6F,
     #$70,#$71,#$72,#$73,#$74,#$75,#$76,#$77,#$78,#$79,#$7A,#$7B,#$7C,#$7D,#$7E,#$7F,
     #$3F,#$3F,#$27,#$3F,#$22,#$3A,#$C5,#$D8,#$3F,#$25,#$3F,#$3C,#$3F,#$3F,#$3F,#$3F,
     #$3F,#$27,#$27,#$22,#$22,#$07,#$2D,#$2D,#$3F,#$54,#$3F,#$3E,#$3F,#$3F,#$3F,#$3F,
     #$FF,#$F6,#$F7,#$3F,#$FD,#$3F,#$B3,#$15,#$F0,#$63,#$F2,#$3C,#$BF,#$2D,#$52,#$F4,
     #$F8,#$2B,#$3F,#$3F,#$3F,#$E7,#$14,#$FA,#$F1,#$FC,#$F3,#$3E,#$3F,#$3F,#$3F,#$F5,
     #$80,#$81,#$82,#$83,#$84,#$85,#$86,#$87,#$88,#$89,#$8A,#$8B,#$8C,#$8D,#$8E,#$8F,
     #$90,#$91,#$92,#$93,#$94,#$95,#$96,#$97,#$98,#$99,#$9A,#$9B,#$9C,#$9D,#$9E,#$9F,
     #$A0,#$A1,#$A2,#$A3,#$A4,#$A5,#$A6,#$A7,#$A8,#$A9,#$AA,#$AB,#$AC,#$AD,#$AE,#$AF,
     #$E0,#$E1,#$E2,#$E3,#$E4,#$E5,#$E6,#$E7,#$E8,#$E9,#$EA,#$EB,#$EC,#$ED,#$EE,#$EF);


    KOI8ToWinTable :  array[0..255] of Char =
    (#$00, #$01, #$02, #$03, #$04, #$05, #$06, #$07, #$08, #$09, #$0A, #$0B, #$0C, #$0D, #$0E, #$0F,
     #$10, #$11, #$12, #$13, #$14, #$15, #$16, #$17, #$18, #$19, #$1A, #$1B, #$1C, #$1D, #$1E, #$1F,
     #$20, #$21, #$22, #$23, #$24, #$25, #$26, #$27, #$28, #$29, #$2A, #$2B, #$2C, #$2D, #$2E, #$2F,
     #$30, #$31, #$32, #$33, #$34, #$35, #$36, #$37, #$38, #$39, #$3A, #$3B, #$3C, #$3D, #$3E, #$3F,
     #$40, #$41, #$42, #$43, #$44, #$45, #$46, #$47, #$48, #$49, #$4A, #$4B, #$4C, #$4D, #$4E, #$4F,
     #$50, #$51, #$52, #$53, #$54, #$55, #$56, #$57, #$58, #$59, #$5A, #$5B, #$5C, #$5D, #$5E, #$5F,
     #$60, #$61, #$62, #$63, #$64, #$65, #$66, #$67, #$68, #$69, #$6A, #$6B, #$6C, #$6D, #$6E, #$6F,
     #$70, #$71, #$72, #$73, #$74, #$75, #$76, #$77, #$78, #$79, #$7A, #$7B, #$7C, #$7D, #$7E, #$7F,
     #$80, #$81, #$82, #$83, #$84, #$85, #$86, #$87, #$88, #$89, #$8A, #$8B, #$8C, #$8D, #$8E, #$8F,
     #$90, #$91, #$92, #$93, #$94, #$95, #$96, #$97, #$98, #$99, #$9A, #$9B, #$9C, #$9D, #$9E, #$9F,
     #$A0, #$A1, #$A2, #$B8{SV}, #$A4, #$A5, #$A6, #$A7, #$A8, #$A9, #$AA, #$AB, #$AC, #$AD, #$AE, #$AF,
     #$B0, #$B1, #$B2, #$B3, #$B4, #$B5, #$B6, #$B7, #$B8, #$B9, #$BA, #$BB, #$BC, #$BD, #$BE, #$BF,
     #$FE, #$E0, #$E1, #$F6, #$E4, #$E5, #$F4, #$E3, #$F5, #$E8, #$E9, #$EA, #$EB, #$EC, #$ED, #$EE,
     #$EF, #$FF, #$F0, #$F1, #$F2, #$F3, #$E6, #$E2, #$FC, #$FB, #$E7, #$F8, #$FD, #$F9, #$F7, #$FA,
     #$DE, #$C0, #$C1, #$D6, #$C4, #$C5, #$D4, #$C3, #$D5, #$C8, #$C9, #$CA, #$CB, #$CC, #$CD, #$CE,
     #$CF, #$DF, #$D0, #$D1, #$D2, #$D3, #$C6, #$C2, #$DC, #$DB, #$C7, #$D8, #$DD, #$D9, #$D7, #$DA);

    WintoKOI8Table :  array[0..255] of Char =
    (#$00, #$01, #$02, #$03, #$04, #$05, #$06, #$07, #$08, #$09, #$0A, #$0B, #$0C, #$0D, #$0E, #$0F,
     #$10, #$11, #$12, #$13, #$14, #$15, #$16, #$17, #$18, #$19, #$1A, #$1B, #$1C, #$1D, #$1E, #$1F,
     #$20, #$21, #$22, #$23, #$24, #$25, #$26, #$27, #$28, #$29, #$2A, #$2B, #$2C, #$2D, #$2E, #$2F,
     #$30, #$31, #$32, #$33, #$34, #$35, #$36, #$37, #$38, #$39, #$3A, #$3B, #$3C, #$3D, #$3E, #$3F,
     #$40, #$41, #$42, #$43, #$44, #$45, #$46, #$47, #$48, #$49, #$4A, #$4B, #$4C, #$4D, #$4E, #$4F,
     #$50, #$51, #$52, #$53, #$54, #$55, #$56, #$57, #$58, #$59, #$5A, #$5B, #$5C, #$5D, #$5E, #$5F,
     #$60, #$61, #$62, #$63, #$64, #$65, #$66, #$67, #$68, #$69, #$6A, #$6B, #$6C, #$6D, #$6E, #$6F,
     #$70, #$71, #$72, #$73, #$74, #$75, #$76, #$77, #$78, #$79, #$7A, #$7B, #$7C, #$7D, #$7E, #$7F,
     #$80, #$81, #$82, #$83, #$84, #$85, #$86, #$87, #$88, #$89, #$8A, #$8B, #$8C, #$8D, #$8E, #$8F,
     #$90, #$91, #$92, #$93, #$94, #$95, #$96, #$97, #$98, #$99, #$9A, #$9B, #$9C, #$9D, #$9E, #$9F,
     #$A0, #$A1, #$A2, #$A3, #$A4, #$A5, #$A6, #$A7, #$A8, #$A9, #$AA, #$AB, #$AC, #$AD, #$AE, #$AF,
     #$B0, #$B1, #$B2, #$B3, #$B4, #$B5, #$B6, #$B7, #$B8, #$B9, #$BA, #$BB, #$BC, #$BD, #$BE, #$BF,
     #$E1, #$E2, #$F7, #$E7, #$E4, #$E5, #$F6, #$FA, #$E9, #$EA, #$EB, #$EC, #$ED, #$EE, #$EF, #$F0,
     #$F2, #$F3, #$F4, #$F5, #$E6, #$E8, #$E3, #$FE, #$FB, #$FD, #$FF, #$F9, #$F8, #$FC, #$E0, #$F1,
     #$C1, #$C2, #$D7, #$C7, #$C4, #$C5, #$D6, #$DA, #$C9, #$CA, #$CB, #$CC, #$CD, #$CE, #$CF, #$D0,
     #$D2, #$D3, #$D4, #$D5, #$C6, #$C8, #$C3, #$DE, #$DB, #$DD, #$DF, #$D9, #$D8, #$DC, #$C0, #$D1);


    TransRE_Rus:string='';
    TransRE_Eng:array[1..33] of string=('a','b','v','g','d','e','yo','zh','z','i','y','k','l','m','n','o','p','r','s','t',
      'u','f','h','ts','ch','sh','sch','''','''','y','e','yu','ya');


constructor TStringRec.Create(const s1:string);
begin
 s:=s1;
end;

constructor TStringData.Create(const s1:string; t1: integer);
begin
 s:=s1;
 t:=t1
end;

function Q_ReplaceStr(const SourceString, FindString, ReplaceString: string): string;
var
  P,PS: PChar;
  L,L1,L2,Cnt: Integer;
  I,J,K,M: Integer;
begin
//{SV}  if (ReplaceString='') and (FindString=SourceString) then begin Result:=''; exit end;
  L1 := Length(FindString);
  Cnt := 0;
  I := Q_PosStr(FindString,SourceString,1);
  while I <> 0 do
  begin
    Inc(I,L1);
    asm
      PUSH    I
    end;
    Inc(Cnt);
    I := Q_PosStr(FindString,SourceString,I);
  end;
  if Cnt <> 0 then
  begin
    L := Length(SourceString);
    L2 := Length(ReplaceString);
    J := L+1;
    Inc(L,(L2-L1)*Cnt);
    if L <> 0 then
    begin
      SetString(Result,nil,L);
      P := Pointer(Result);
      Inc(P, L);
      PS := Pointer(LongWord(SourceString)-1);
      if L2 <= 32 then
        for I := 0 to Cnt-1 do
        begin
          asm
            POP     K
          end;
          M := J-K;
          if M > 0 then
          begin
            Dec(P,M);
            Q_CopyMem(@PS[K],P,M);
          end;
          Dec(P,L2);
          Q_TinyCopy(Pointer(ReplaceString),P,L2);
          J := K-L1;
        end
      else
        for I := 0 to Cnt-1 do
        begin
          asm
            POP     K
          end;
          M := J-K;
          if M > 0 then
          begin
            Dec(P,M);
            Q_CopyMem(@PS[K],P,M);
          end;
          Dec(P,L2);
          Q_CopyMem(Pointer(ReplaceString),P,L2);
          J := K-L1;
        end;
      Dec(J);
      if J > 0 then
        Q_CopyMem(Pointer(SourceString),Pointer(Result),J);
    end else begin
      Result := '';
      for i:=1 to Cnt do asm pop K end;
    end
  end else
    Result := SourceString;
end;

function Q_PosText(const FindString, SourceString: string; StartPos: Integer): Integer;
asm
        PUSH    ESI
        PUSH    EDI
        PUSH    EBX
        TEST    EAX,EAX
        JE      @@qt
        TEST    EDX,EDX
        JE      @@qt0
        MOV     ESI,EAX
        MOV     EDI,EDX
        PUSH    EDX
        MOV     EAX,[EAX-4]
        MOV     EDX,[EDX-4]
        DEC     EAX
        SUB     EDX,EAX
        DEC     ECX
        PUSH    EAX
        SUB     EDX,ECX
        JNG     @@qtx
        ADD     EDI,ECX
        MOV     ECX,EDX
        MOV     EDX,EAX
        MOVZX   EBX,BYTE PTR [ESI]
        MOV     AL,BYTE PTR [EBX+ToUpperChars]
@@lp1:  MOVZX   EBX,BYTE PTR [EDI]
        CMP     AL,BYTE PTR [EBX+ToUpperChars]
        JE      @@uu
@@fr:   INC     EDI
        DEC     ECX
        JE      @@qtx
        MOVZX   EBX,BYTE PTR [EDI]
        CMP     AL,BYTE PTR [EBX+ToUpperChars]
        JE      @@uu
        INC     EDI
        DEC     ECX
        JE      @@qtx
        MOVZX   EBX,BYTE PTR [EDI]
        CMP     AL,BYTE PTR [EBX+ToUpperChars]
        JE      @@uu
        INC     EDI
        DEC     ECX
        JE      @@qtx
        MOVZX   EBX,BYTE PTR [EDI]
        CMP     AL,BYTE PTR [EBX+ToUpperChars]
        JE      @@uu
        INC     EDI
        DEC     ECX
        JNE     @@lp1
@@qtx:  ADD     ESP,$08
@@qt0:  XOR     EAX,EAX
@@qt:   POP     EBX
        POP     EDI
        POP     ESI
        RET
@@ms:   MOVZX   EBX,BYTE PTR [ESI]
        MOV     AL,BYTE PTR [EBX+ToUpperChars]
        MOV     EDX,[ESP]
        JMP     @@fr
@@uu:   TEST    EDX,EDX
        JE      @@fd
@@lp2:  MOV     BL,BYTE PTR [ESI+EDX]
        MOV     AH,BYTE PTR [EDI+EDX]
        CMP     BL,AH
        JE      @@eq
        MOV     AL,BYTE PTR [EBX+ToUpperChars]
        MOVZX   EBX,AH
        CMP     AL,BYTE PTR [EBX+ToUpperChars]
        JNE     @@ms
@@eq:   DEC     EDX
        JNZ     @@lp2
@@fd:   LEA     EAX,[EDI+1]
        POP     ECX
        SUB     EAX,[ESP]
        POP     ECX
        POP     EBX
        POP     EDI
        POP     ESI
end;


function Q_ReplaceText(const SourceString, FindString, ReplaceString: string): string;
var
  P,PS: PChar;
  L,L1,L2,Cnt: Integer;
  I,J,K,M: Integer;
begin
  L1 := Length(FindString);
  Cnt := 0;
  I := Q_PosText(FindString,SourceString,1);
  while I <> 0 do
  begin
    Inc(I,L1);
    asm
      PUSH    I
    end;
    Inc(Cnt);
    I := Q_PosText(FindString,SourceString,I);
  end;
  if Cnt <> 0 then
  begin
    L := Length(SourceString);
    L2 := Length(ReplaceString);
    J := L+1;
    Inc(L,(L2-L1)*Cnt);
    if L <> 0 then
    begin
      SetString(Result,nil,L);
      P := Pointer(Result);
      Inc(P, L);
      PS := Pointer(LongWord(SourceString)-1);
      if L2 <= 32 then
        for I := 0 to Cnt-1 do
        begin
          asm
            POP     K
          end;
          M := J-K;
          if M > 0 then
          begin
            Dec(P,M);
            Q_CopyMem(@PS[K],P,M);
          end;
          Dec(P,L2);
          Q_TinyCopy(Pointer(ReplaceString),P,L2);
          J := K-L1;
        end
      else
        for I := 0 to Cnt-1 do
        begin
          asm
            POP     K
          end;
          M := J-K;
          if M > 0 then
          begin
            Dec(P,M);
            Q_CopyMem(@PS[K],P,M);
          end;
          Dec(P,L2);
          Q_CopyMem(Pointer(ReplaceString),P,L2);
          J := K-L1;
        end;
      Dec(J);
      if J > 0 then
        Q_CopyMem(Pointer(SourceString),Pointer(Result),J);
    end else begin
      Result := '';
      for i:=1 to Cnt do asm pop K end;
    end
  end else
    Result := SourceString;
end;


function Q_PosStr(const FindString, SourceString: string; StartPos: Integer): Integer;
asm
        PUSH    ESI
        PUSH    EDI
        PUSH    EBX
        PUSH    EDX
        TEST    EAX,EAX
        JE      @@qt
        TEST    EDX,EDX
        JE      @@qt0
        MOV     ESI,EAX
        MOV     EDI,EDX
        MOV     EAX,[EAX-4]
        MOV     EDX,[EDX-4]
        DEC     EAX
        SUB     EDX,EAX
        DEC     ECX
        SUB     EDX,ECX
        JNG     @@qt0
        XCHG    EAX,EDX
        ADD     EDI,ECX
        MOV     ECX,EAX
        JMP     @@nx
@@fr:   INC     EDI
        DEC     ECX
        JE      @@qt0
@@nx:   MOV     EBX,EDX
        MOV     AL,BYTE PTR [ESI]
@@lp1:  CMP     AL,BYTE PTR [EDI]
        JE      @@uu
        INC     EDI
        DEC     ECX
        JE      @@qt0
        CMP     AL,BYTE PTR [EDI]
        JE      @@uu
        INC     EDI
        DEC     ECX
        JE      @@qt0
        CMP     AL,BYTE PTR [EDI]
        JE      @@uu
        INC     EDI
        DEC     ECX
        JE      @@qt0
        CMP     AL,BYTE PTR [EDI]
        JE      @@uu
        INC     EDI
        DEC     ECX
        JNE     @@lp1
@@qt0:  XOR     EAX,EAX
@@qt:   POP     ECX
        POP     EBX
        POP     EDI
        POP     ESI
        RET
@@uu:   TEST    EDX,EDX
        JE      @@fd
@@lp2:  MOV     AL,BYTE PTR [ESI+EBX]
        CMP     AL,BYTE PTR [EDI+EBX]
        JNE     @@fr
        DEC     EBX
        JE      @@fd
        MOV     AL,BYTE PTR [ESI+EBX]
        CMP     AL,BYTE PTR [EDI+EBX]
        JNE     @@fr
        DEC     EBX
        JE      @@fd
        MOV     AL,BYTE PTR [ESI+EBX]
        CMP     AL,BYTE PTR [EDI+EBX]
        JNE     @@fr
        DEC     EBX
        JE      @@fd
        MOV     AL,BYTE PTR [ESI+EBX]
        CMP     AL,BYTE PTR [EDI+EBX]
        JNE     @@fr
        DEC     EBX
        JNE     @@lp2
@@fd:   LEA     EAX,[EDI+1]
        SUB     EAX,[ESP]
        POP     ECX
        POP     EBX
        POP     EDI
        POP     ESI
end;

procedure IntCopy16;
asm
        MOV     EAX,[ESI]
        MOV     [EDI],EAX
        MOV     EAX,[ESI+4]
        MOV     [EDI+4],EAX
        MOV     EAX,[ESI+8]
        MOV     [EDI+8],EAX
        MOV     EAX,[ESI+12]
        MOV     [EDI+12],EAX
        MOV     EAX,[ESI+16]
        MOV     [EDI+16],EAX
        MOV     EAX,[ESI+20]
        MOV     [EDI+20],EAX
        MOV     EAX,[ESI+24]
        MOV     [EDI+24],EAX
        MOV     EAX,[ESI+28]
        MOV     [EDI+28],EAX
        MOV     EAX,[ESI+32]
        MOV     [EDI+32],EAX
        MOV     EAX,[ESI+36]
        MOV     [EDI+36],EAX
        MOV     EAX,[ESI+40]
        MOV     [EDI+40],EAX
        MOV     EAX,[ESI+44]
        MOV     [EDI+44],EAX
        MOV     EAX,[ESI+48]
        MOV     [EDI+48],EAX
        MOV     EAX,[ESI+52]
        MOV     [EDI+52],EAX
        MOV     EAX,[ESI+56]
        MOV     [EDI+56],EAX
        MOV     EAX,[ESI+60]
        MOV     [EDI+60],EAX
end;


procedure Q_CopyMem(Source, Dest: Pointer; L: Cardinal);
asm
        PUSH    EDI
        PUSH    ESI
        MOV     EDI,EDX
        MOV     EDX,ECX
        MOV     ESI,EAX
        TEST    EDI,3
        JNE     @@cl
        SHR     ECX,2
        AND     EDX,3
        CMP     ECX,16
        JBE     @@cw0
@@lp0:  CALL    IntCopy16
        ADD     ESI,64
        SUB     ECX,16
        ADD     EDI,64
        CMP     ECX,16
        JA      @@lp0
@@cw0:  JMP     DWORD PTR @@wV[ECX*4]
@@cl:   MOV     EAX,EDI
        MOV     EDX,3
        SUB     ECX,4
        JB      @@bc
        AND     EAX,3
        ADD     ECX,EAX
        JMP     DWORD PTR @@lV[EAX*4-4]
@@bc:   JMP     DWORD PTR @@tV[ECX*4+16]
@@lV:   DD      @@l1, @@l2, @@l3
@@l1:   AND     EDX,ECX
        MOV     AL,[ESI]
        MOV     [EDI],AL
        MOV     AL,[ESI+1]
        MOV     [EDI+1],AL
        MOV     AL,[ESI+2]
        SHR     ECX,2
        MOV     [EDI+2],AL
        ADD     ESI,3
        ADD     EDI,3
        CMP     ECX,16
        JBE     @@cw1
@@lp1:  CALL    IntCopy16
        ADD     ESI,64
        SUB     ECX,16
        ADD     EDI,64
        CMP     ECX,16
        JA      @@lp1
@@cw1:  JMP     DWORD PTR @@wV[ECX*4]
@@l2:   AND     EDX,ECX
        MOV     AL,[ESI]
        MOV     [EDI],AL
        MOV     AL,[ESI+1]
        SHR     ECX,2
        MOV     [EDI+1],AL
        ADD     ESI,2
        ADD     EDI,2
        CMP     ECX,16
        JBE     @@cw2
@@lp2:  CALL    IntCopy16
        ADD     ESI,64
        SUB     ECX,16
        ADD     EDI,64
        CMP     ECX,16
        JA      @@lp2
@@cw2:  JMP     DWORD PTR @@wV[ECX*4]
@@l3:   AND     EDX,ECX
        MOV     AL,[ESI]
        MOV     [EDI],AL
        INC     ESI
        SHR     ECX,2
        INC     EDI
        CMP     ECX,16
        JBE     @@cw3
@@lp3:  CALL    IntCopy16
        ADD     ESI,64
        SUB     ECX,16
        ADD     EDI,64
        CMP     ECX,16
        JA      @@lp3
@@cw3:  JMP     DWORD PTR @@wV[ECX*4]
@@wV:   DD      @@w0, @@w1, @@w2, @@w3
        DD      @@w4, @@w5, @@w6, @@w7
        DD      @@w8, @@w9, @@w10, @@w11
        DD      @@w12, @@w13, @@w14, @@w15
        DD      @@w16
@@w16:  MOV     EAX,[ESI+ECX*4-64]
        MOV     [EDI+ECX*4-64],EAX
@@w15:  MOV     EAX,[ESI+ECX*4-60]
        MOV     [EDI+ECX*4-60],EAX
@@w14:  MOV     EAX,[ESI+ECX*4-56]
        MOV     [EDI+ECX*4-56],EAX
@@w13:  MOV     EAX,[ESI+ECX*4-52]
        MOV     [EDI+ECX*4-52],EAX
@@w12:  MOV     EAX,[ESI+ECX*4-48]
        MOV     [EDI+ECX*4-48],EAX
@@w11:  MOV     EAX,[ESI+ECX*4-44]
        MOV     [EDI+ECX*4-44],EAX
@@w10:  MOV     EAX,[ESI+ECX*4-40]
        MOV     [EDI+ECX*4-40],EAX
@@w9:   MOV     EAX,[ESI+ECX*4-36]
        MOV     [EDI+ECX*4-36],EAX
@@w8:   MOV     EAX,[ESI+ECX*4-32]
        MOV     [EDI+ECX*4-32],EAX
@@w7:   MOV     EAX,[ESI+ECX*4-28]
        MOV     [EDI+ECX*4-28],EAX
@@w6:   MOV     EAX,[ESI+ECX*4-24]
        MOV     [EDI+ECX*4-24],EAX
@@w5:   MOV     EAX,[ESI+ECX*4-20]
        MOV     [EDI+ECX*4-20],EAX
@@w4:   MOV     EAX,[ESI+ECX*4-16]
        MOV     [EDI+ECX*4-16],EAX
@@w3:   MOV     EAX,[ESI+ECX*4-12]
        MOV     [EDI+ECX*4-12],EAX
@@w2:   MOV     EAX,[ESI+ECX*4-8]
        MOV     [EDI+ECX*4-8],EAX
@@w1:   MOV     EAX,[ESI+ECX*4-4]
        MOV     [EDI+ECX*4-4],EAX
        SHL     ECX,2
        ADD     ESI,ECX
        ADD     EDI,ECX
@@w0:   JMP     DWORD PTR @@tV[EDX*4]
@@tV:   DD      @@t0, @@t1, @@t2, @@t3
@@t3:   MOV     AL,[ESI+2]
        MOV     [EDI+2],AL
@@t2:   MOV     AL,[ESI+1]
        MOV     [EDI+1],AL
@@t1:   MOV     AL,[ESI]
        MOV     [EDI],AL
@@t0:   POP     ESI
        POP     EDI
end;


procedure Q_TinyCopy(Source, Dest: Pointer; L: Cardinal);
asm
        JMP     DWORD PTR @@tV[ECX*4]
@@tV:   DD      @@tu00, @@tu01, @@tu02, @@tu03
        DD      @@tu04, @@tu05, @@tu06, @@tu07
        DD      @@tu08, @@tu09, @@tu10, @@tu11
        DD      @@tu12, @@tu13, @@tu14, @@tu15
        DD      @@tu16, @@tu17, @@tu18, @@tu19
        DD      @@tu20, @@tu21, @@tu22, @@tu23
        DD      @@tu24, @@tu25, @@tu26, @@tu27
        DD      @@tu28, @@tu29, @@tu30, @@tu31
        DD      @@tu32
@@tu00: RET
@@tu01: MOV     CL,BYTE PTR [EAX]
        MOV     BYTE PTR [EDX],CL
        RET
@@tu02: MOV     CX,WORD PTR [EAX]
        MOV     WORD PTR [EDX],CX
        RET
@@tu03: MOV     CX,WORD PTR [EAX]
        MOV     WORD PTR [EDX],CX
        MOV     CL,BYTE PTR [EAX+2]
        MOV     BYTE PTR [EDX+2],CL
        RET
@@tu04: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        RET
@@tu05: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     CL,BYTE PTR [EAX+4]
        MOV     BYTE PTR [EDX+4],CL
        RET
@@tu06: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     CX,WORD PTR [EAX+4]
        MOV     WORD PTR [EDX+4],CX
        RET
@@tu07: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     CX,WORD PTR [EAX+4]
        MOV     WORD PTR [EDX+4],CX
        MOV     CL,BYTE PTR [EAX+6]
        MOV     BYTE PTR [EDX+6],CL
        RET
@@tu08: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        RET
@@tu09: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     CL,BYTE PTR [EAX+8]
        MOV     BYTE PTR [EDX+8],CL
        RET
@@tu10: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     CX,WORD PTR [EAX+8]
        MOV     WORD PTR [EDX+8],CX
        RET
@@tu11: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     CX,WORD PTR [EAX+8]
        MOV     WORD PTR [EDX+8],CX
        MOV     CL,BYTE PTR [EAX+10]
        MOV     BYTE PTR [EDX+10],CL
        RET
@@tu12: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        RET
@@tu13: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     CL,BYTE PTR [EAX+12]
        MOV     BYTE PTR [EDX+12],CL
        RET
@@tu14: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     CX,WORD PTR [EAX+12]
        MOV     WORD PTR [EDX+12],CX
        RET
@@tu15: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     CX,WORD PTR [EAX+12]
        MOV     WORD PTR [EDX+12],CX
        MOV     CL,BYTE PTR [EAX+14]
        MOV     BYTE PTR [EDX+14],CL
        RET
@@tu16: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        RET
@@tu17: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     CL,BYTE PTR [EAX+16]
        MOV     BYTE PTR [EDX+16],CL
        RET
@@tu18: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     CX,WORD PTR [EAX+16]
        MOV     WORD PTR [EDX+16],CX
        RET
@@tu19: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     CX,WORD PTR [EAX+16]
        MOV     WORD PTR [EDX+16],CX
        MOV     CL,BYTE PTR [EAX+18]
        MOV     BYTE PTR [EDX+18],CL
        RET
@@tu20: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        RET
@@tu21: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     CL,BYTE PTR [EAX+20]
        MOV     BYTE PTR [EDX+20],CL
        RET
@@tu22: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     CX,WORD PTR [EAX+20]
        MOV     WORD PTR [EDX+20],CX
        RET
@@tu23: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     CX,WORD PTR [EAX+20]
        MOV     WORD PTR [EDX+20],CX
        MOV     CL,BYTE PTR [EAX+22]
        MOV     BYTE PTR [EDX+22],CL
        RET
@@tu24: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     ECX,DWORD PTR [EAX+20]
        MOV     DWORD PTR [EDX+20],ECX
        RET
@@tu25: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     ECX,DWORD PTR [EAX+20]
        MOV     DWORD PTR [EDX+20],ECX
        MOV     CL,BYTE PTR [EAX+24]
        MOV     BYTE PTR [EDX+24],CL
        RET
@@tu26: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     ECX,DWORD PTR [EAX+20]
        MOV     DWORD PTR [EDX+20],ECX
        MOV     CX,WORD PTR [EAX+24]
        MOV     WORD PTR [EDX+24],CX
        RET
@@tu27: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     ECX,DWORD PTR [EAX+20]
        MOV     DWORD PTR [EDX+20],ECX
        MOV     CX,WORD PTR [EAX+24]
        MOV     WORD PTR [EDX+24],CX
        MOV     CL,BYTE PTR [EAX+26]
        MOV     BYTE PTR [EDX+26],CL
        RET
@@tu28: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     ECX,DWORD PTR [EAX+20]
        MOV     DWORD PTR [EDX+20],ECX
        MOV     ECX,DWORD PTR [EAX+24]
        MOV     DWORD PTR [EDX+24],ECX
        RET
@@tu29: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     ECX,DWORD PTR [EAX+20]
        MOV     DWORD PTR [EDX+20],ECX
        MOV     ECX,DWORD PTR [EAX+24]
        MOV     DWORD PTR [EDX+24],ECX
        MOV     CL,BYTE PTR [EAX+28]
        MOV     BYTE PTR [EDX+28],CL
        RET
@@tu30: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     ECX,DWORD PTR [EAX+20]
        MOV     DWORD PTR [EDX+20],ECX
        MOV     ECX,DWORD PTR [EAX+24]
        MOV     DWORD PTR [EDX+24],ECX
        MOV     CX,WORD PTR [EAX+28]
        MOV     WORD PTR [EDX+28],CX
        RET
@@tu31: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     ECX,DWORD PTR [EAX+20]
        MOV     DWORD PTR [EDX+20],ECX
        MOV     ECX,DWORD PTR [EAX+24]
        MOV     DWORD PTR [EDX+24],ECX
        MOV     CX,WORD PTR [EAX+28]
        MOV     WORD PTR [EDX+28],CX
        MOV     CL,BYTE PTR [EAX+30]
        MOV     BYTE PTR [EDX+30],CL
        RET
@@tu32: MOV     ECX,DWORD PTR [EAX]
        MOV     DWORD PTR [EDX],ECX
        MOV     ECX,DWORD PTR [EAX+4]
        MOV     DWORD PTR [EDX+4],ECX
        MOV     ECX,DWORD PTR [EAX+8]
        MOV     DWORD PTR [EDX+8],ECX
        MOV     ECX,DWORD PTR [EAX+12]
        MOV     DWORD PTR [EDX+12],ECX
        MOV     ECX,DWORD PTR [EAX+16]
        MOV     DWORD PTR [EDX+16],ECX
        MOV     ECX,DWORD PTR [EAX+20]
        MOV     DWORD PTR [EDX+20],ECX
        MOV     ECX,DWORD PTR [EAX+24]
        MOV     DWORD PTR [EDX+24],ECX
        MOV     ECX,DWORD PTR [EAX+28]
        MOV     DWORD PTR [EDX+28],ECX
end;


function Q_PStrLen(P: PChar): Integer;
asm
        TEST    EAX,EAX
        JE      @@qt
        PUSH    EBX
        LEA     EDX,[EAX+1]
@L1:    MOV     EBX,[EAX]
        ADD     EAX,4
        LEA     ECX,[EBX-$01010101]
        NOT     EBX
        AND     ECX,EBX
        AND     ECX,$80808080
        JZ      @L1
        TEST    ECX,$00008080
        JZ      @L2
        SHL     ECX,16
        SUB     EAX,2
@L2:    SHL     ECX,9
        SBB     EAX,EDX
        POP     EBX
@@qt:
end;


function Q_SameStr(const S1, S2: string): Boolean;
asm
        CMP     EAX,EDX
        JE      @@08
        TEST    EAX,EAX
        JE      @@qt2
        TEST    EDX,EDX
        JE      @@qt1
        MOV     ECX,[EAX-4]
        CMP     ECX,[EDX-4]
        JE      @@01
@@qt1:  XOR     EAX,EAX
@@qt2:  RET
@@01:   PUSH    EBX
        SUB     ECX,8
        JS      @@nx
@@lp:   MOV     EBX,DWORD PTR [EAX+ECX]
        CMP     EBX,DWORD PTR [EDX+ECX]
        JNE     @@zq
        MOV     EBX,DWORD PTR [EAX+ECX+4]
        CMP     EBX,DWORD PTR [EDX+ECX+4]
        JNE     @@zq
        SUB     ECX,8
        JNS     @@lp
@@nx:   JMP     DWORD PTR @@tV[ECX*4+32]
@@tV:   DD      @@eq,@@t1,@@t2,@@t3
        DD      @@t4,@@t5,@@t6,@@t7
@@t7:   MOV     BL,BYTE PTR [EAX+6]
        XOR     BL,BYTE PTR [EDX+6]
        JNE     @@zq
@@t6:   MOV     BL,BYTE PTR [EAX+5]
        XOR     BL,BYTE PTR [EDX+5]
        JNE     @@zq
@@t5:   MOV     BL,BYTE PTR [EAX+4]
        XOR     BL,BYTE PTR [EDX+4]
        JNE     @@zq
@@t4:   MOV     EBX,DWORD PTR [EAX]
        CMP     EBX,DWORD PTR [EDX]
        JNE     @@zq
@@eq:   POP     EBX
@@08:   MOV     EAX,1
        RET
@@t3:   MOV     BL,BYTE PTR [EAX+2]
        XOR     BL,BYTE PTR [EDX+2]
        JNE     @@zq
@@t2:   MOV     BL,BYTE PTR [EAX+1]
        XOR     BL,BYTE PTR [EDX+1]
        JNE     @@zq
@@t1:   MOV     BL,BYTE PTR [EAX]
        XOR     BL,BYTE PTR [EDX]
        JNE     @@zq
        POP     EBX
        MOV     EAX,1
        RET
@@zq:   POP     EBX
@@07:   XOR     EAX,EAX
end;



function Q_SameText(const S1, S2: string): Boolean;
asm
        CMP     EAX,EDX
        JE      @@08
        TEST    EAX,EAX
        JE      @@09
        TEST    EDX,EDX
        JE      @@07
        MOV     ECX,[EAX-4]
        CMP     ECX,[EDX-4]
        JE      @@im
        XOR     EAX,EAX
        RET
@@im:   TEST    ECX,ECX
        JE      @@07
        PUSH    ESI
        PUSH    EDI
        MOV     ESI,EAX
        MOV     EDI,EDX
@@00:   DEC     ECX
        JS      @@qt
@@01:   MOVZX   EAX,BYTE PTR [ESI+ECX]
        MOVZX   EDX,BYTE PTR [EDI+ECX]
        CMP     AL,DL
        JE      @@00
        MOV     AL,BYTE PTR [EAX+ToUpperChars]
        XOR     AL,BYTE PTR [EDX+ToUpperChars]
        JE      @@00
        POP     EDI
        POP     ESI
@@07:   XOR     EAX,EAX
@@09:   RET
@@qt:   POP     EDI
        POP     ESI
@@08:   MOV     EAX,1
end;

function Q_SameStrL(const S1, S2: string; MaxL: Cardinal): Boolean;
asm
        CMP     EAX,EDX
        JE      @@08
        TEST    EAX,EAX
        JE      @@09
        TEST    EDX,EDX
        JE      @@07
        PUSH    EBX
        PUSH    ESI
        MOV     EBX,[EAX-4]
        MOV     ESI,[EDX-4]
        SUB     EBX,ESI
        JG      @@w1
        ADD     ESI,EBX
@@w1:   CMP     ECX,ESI
        JA      @@fc
@@dn:   SUB     ECX,4
        JS      @@nx
@@lp:   MOV     EBX,DWORD PTR [EAX+ECX]
        CMP     EBX,DWORD PTR [EDX+ECX]
        JNE     @@zq
        SUB     ECX,4
        JNS     @@lp
@@nx:   JMP     DWORD PTR @@tV[ECX*4+16]
@@tV:   DD      @@eq,@@t1,@@t2,@@t3
@@t3:   MOV     BL,BYTE PTR [EAX+2]
        XOR     BL,BYTE PTR [EDX+2]
        JNE     @@zq
@@t2:   MOV     BL,BYTE PTR [EAX+1]
        XOR     BL,BYTE PTR [EDX+1]
        JNE     @@zq
@@t1:   MOV     BL,BYTE PTR [EAX]
        XOR     BL,BYTE PTR [EDX]
        JNE     @@zq
@@eq:   POP     ESI
        POP     EBX
@@08:   MOV     EAX,1
        RET
@@fc:   MOV     ECX,ESI
        TEST    EBX,EBX
        JE      @@dn
@@zq:   POP     ESI
        POP     EBX
@@07:   XOR     EAX,EAX
@@09:
end;


function Q_SameTextL(const S1, S2: string; MaxL: Cardinal): Boolean;
asm
        CMP     EAX,EDX
        JE      @@08
        TEST    EAX,EAX
        JE      @@xx
        TEST    EDX,EDX
        JE      @@07
        PUSH    ESI
        PUSH    EDI
        MOV     ESI,[EAX-4]
        MOV     EDI,[EDX-4]
        SUB     ESI,EDI
        JG      @@w1
        ADD     EDI,ESI
@@w1:   CMP     ECX,EDI
        JA      @@fc
@@dn:   TEST    ECX,ECX
        JE      @@zq
        MOV     ESI,EAX
        MOV     EDI,EDX
@@0:    DEC     ECX
        JS      @@eq
@@1:    MOVZX   EAX,BYTE PTR [ESI+ECX]
        MOVZX   EDX,BYTE PTR [EDI+ECX]
        CMP     AL,DL
        JE      @@0
        MOV     AL,BYTE PTR [EAX+ToUpperChars]
        XOR     AL,BYTE PTR [EDX+ToUpperChars]
        JE      @@0
@@zq:   POP     EDI
        POP     ESI
@@07:   XOR     EAX,EAX
@@xx:   RET
@@fc:   MOV     ECX,EDI
        TEST    ESI,ESI
        JE      @@dn
        JMP     @@zq
@@eq:   POP     EDI
        POP     ESI
@@08:   MOV     EAX,1
end;


function Q_CompText(const S1, S2: string): Integer;
asm
        TEST    EAX,EAX
        JE      @@2
        TEST    EDX,EDX
        JE      @@3
        PUSH    ESI
        PUSH    EDI
        MOV     ESI,EAX
        MOV     EDI,EDX
        JMP     @@1
@@0:    TEST    AL,AL
        JE      @@4
        INC     ESI
        INC     EDI
@@1:    MOVZX   EAX,BYTE PTR [ESI]
        MOVZX   EDX,BYTE PTR [EDI]
        CMP     AL,DL
        JE      @@0
        MOV     AL,BYTE PTR [EAX+ToUpperChars]
        MOV     DL,BYTE PTR [EDX+ToUpperChars]
        CMP     AL,DL
        JE      @@0
        MOVZX   EAX,AL
        MOVZX   EDX,DL
        SUB     EAX,EDX
        POP     EDI
        POP     ESI
        RET
@@2:    TEST    EDX,EDX
        JE      @@7
        MOV     CH,BYTE PTR [EDX]
        TEST    CH,CH
        JE      @@7
        NOT     EAX
        RET
@@3:    MOV     CL,BYTE PTR [EAX]
        TEST    CL,CL
        JE      @@5
        MOV     EAX,1
        RET
@@4:    POP     EDI
        POP     ESI
@@5:    XOR     EAX,EAX
@@7:
end;

function Q_CompStr(const S1, S2: string): Integer;
asm
        TEST    EAX,EAX
        JE      @@2
        TEST    EDX,EDX
        JE      @@3
        PUSH    EAX
        MOVZX   EAX,BYTE PTR [EAX]
        MOVZX   ECX,BYTE PTR [EDX]
        SUB     EAX,ECX
        JE      @@m
        POP     ECX
        RET
@@m:    POP     EAX
        INC     EAX
        INC     EDX
@@0:    TEST    CL,CL
        JE      @@5
        MOV     CL,BYTE PTR [EAX]
        MOV     CH,BYTE PTR [EDX]
        CMP     CL,CH
        JNE     @@ne
        TEST    CL,CL
        JE      @@5
        MOV     CL,BYTE PTR [EAX+1]
        MOV     CH,BYTE PTR [EDX+1]
        CMP     CL,CH
        JNE     @@ne
        TEST    CL,CL
        JE      @@5
        MOV     CL,BYTE PTR [EAX+2]
        MOV     CH,BYTE PTR [EDX+2]
        CMP     CL,CH
        JNE     @@ne
        TEST    CL,CL
        JE      @@5
        MOV     CL,BYTE PTR [EAX+3]
        MOV     CH,BYTE PTR [EDX+3]
        ADD     EAX,4
        ADD     EDX,4
        CMP     CL,CH
        JE      @@0
@@ne:   MOVZX   EAX,CL
        MOVZX   EDX,CH
        SUB     EAX,EDX
        RET
@@2:    TEST    EDX,EDX
        JE      @@7
        MOV     CH,BYTE PTR [EDX]
        TEST    CH,CH
        JE      @@7
        NOT     EAX
        RET
@@3:    MOV     CL,BYTE PTR [EAX]
        TEST    CL,CL
        JE      @@5
        MOV     EAX,1
        RET
@@5:    XOR     EAX,EAX
@@7:
end;


procedure Q_FillChar(P: Pointer; L: Cardinal; Ch: Char);
asm
        PUSH    EDI
        MOV     EDI,EAX
        MOVZX   EAX,CL
        CMP     EDX,16
        JB      @@tl
        MOV     ECX,EDI
        NEG     ECX
        AND     ECX,7
        SUB     EDX,ECX
        JMP     DWORD PTR @@bV[ECX*4]
@@bV:   DD      @@bu00, @@bu01, @@bu02, @@bu03
        DD      @@bu04, @@bu05, @@bu06, @@bu07
@@bu07: MOV     [EDI+06],AL
@@bu06: MOV     [EDI+05],AL
@@bu05: MOV     [EDI+04],AL
@@bu04: MOV     [EDI+03],AL
@@bu03: MOV     [EDI+02],AL
@@bu02: MOV     [EDI+01],AL
@@bu01: MOV     [EDI],AL
        ADD     EDI,ECX
@@bu00: MOV     ECX,EAX
        SHL     EAX,8
        ADD     EAX,ECX
        MOV     ECX,EAX
        SHL     EAX,16
        ADD     EAX,ECX
        MOV     ECX,EDX
        AND     EDX,3
        SHR     ECX,2
        REP     STOSD
@@tl:   JMP     DWORD PTR @@tV[EDX*4]
@@tV:   DD      @@tu00, @@tu01, @@tu02, @@tu03
        DD      @@tu04, @@tu05, @@tu06, @@tu07
        DD      @@tu08, @@tu09, @@tu10, @@tu11
        DD      @@tu12, @@tu13, @@tu14, @@tu15
@@tu15: MOV     [EDI+14],AL
@@tu14: MOV     [EDI+13],AL
@@tu13: MOV     [EDI+12],AL
@@tu12: MOV     [EDI+11],AL
@@tu11: MOV     [EDI+10],AL
@@tu10: MOV     [EDI+09],AL
@@tu09: MOV     [EDI+08],AL
@@tu08: MOV     [EDI+07],AL
@@tu07: MOV     [EDI+06],AL
@@tu06: MOV     [EDI+05],AL
@@tu05: MOV     [EDI+04],AL
@@tu04: MOV     [EDI+03],AL
@@tu03: MOV     [EDI+02],AL
@@tu02: MOV     [EDI+01],AL
@@tu01: MOV     [EDI],AL
@@tu00: POP     EDI
end;

function Q_PStrToOemL(P: PChar; L: Cardinal): PChar;
asm
        DEC     EDX
        JS      @@2
        PUSH    EBX
@@0:    MOVZX   EBX,BYTE PTR [EAX+EDX]
        MOV     CL,BYTE PTR [EBX+ToOemChars]
        MOV     BYTE PTR [EAX+EDX],CL
        DEC     EDX
        JNS     @@0
        POP     EBX
@@2:
end;


procedure Q_KoitoWin(var S: string);
asm
        CALL    UniqueString
        TEST    EAX,EAX
        JE      @@2
        MOV     ECX,[EAX-4]
        DEC     ECX
        JS      @@2
@@1:    MOVZX   EDX,BYTE PTR [EAX+ECX]
        MOV     DL,BYTE PTR [EDX+Koi8toWinTable]
        MOV     BYTE PTR [EAX+ECX],DL
        DEC     ECX
        JNS     @@1
@@2:
end;

procedure Q_WintoKOI(var S: string);
asm
        CALL    UniqueString
        TEST    EAX,EAX
        JE      @@2
        MOV     ECX,[EAX-4]
        DEC     ECX
        JS      @@2
@@1:    MOVZX   EDX,BYTE PTR [EAX+ECX]
        MOV     DL,BYTE PTR [EDX+WintoKOI8Table]
        MOV     BYTE PTR [EAX+ECX],DL
        DEC     ECX
        JNS     @@1
@@2:
end;

procedure Q_WintoOEM(var S: string);
asm
        CALL    UniqueString
        TEST    EAX,EAX
        JE      @@2
        MOV     ECX,[EAX-4]
        DEC     ECX
        JS      @@2
@@1:    MOVZX   EDX,BYTE PTR [EAX+ECX]
        MOV     DL,BYTE PTR [EDX+ToOEMChars]
        MOV     BYTE PTR [EAX+ECX],DL
        DEC     ECX
        JNS     @@1
@@2:
end;


 function VarStrPos(const Str1, Str2: PChar; SL1:integer): PChar; assembler;
 asm
         PUSH    EDI
         PUSH    ESI
         PUSH    EBX
         OR      EAX,EAX
         JE      @@2
         OR      EDX,EDX
         JE      @@2
         MOV     EBX,EAX
         MOV     EDI,EDX
        push ECX
         XOR     AL,AL
         MOV     ECX,0FFFFFFFFH
         REPNE   SCASB
         NOT     ECX
         DEC     ECX
         JE      @@2
         MOV     ESI,ECX
         MOV     EDI,EBX
        pop ECX
        Inc ECX
         SUB     ECX,ESI
         JBE     @@2
         MOV     EDI,EBX
         LEA     EBX,[ESI-1]
 @@1:    MOV     ESI,EDX
         LODSB
         REPNE   SCASB
         JNE     @@2
         MOV     EAX,ECX
         PUSH    EDI
         MOV     ECX,EBX
         REPE    CMPSB
         POP     EDI
         MOV     ECX,EAX
         JNE     @@1
         LEA     EAX,[EDI-1]
         JMP     @@3
 @@2:    XOR     EAX,EAX
 @@3:    POP     EBX
         POP     ESI
         POP     EDI
 end;

 function VarPos(s: pchar; p: pchar; astart, L: integer): integer;
 var p1:pchar;
 begin
  if astart>=L then begin Result:=0; exit end;
  inc(p, astart);
  p1:=VarStrPos(p, s, L-astart);
  if p1<>nil then Result:=integer(p1-p)+1 else Result:=0;
 end;

 function VarCopy(p:pchar; astart,alength,plength:integer):string;
 begin
  if alength>plength-astart then alength:=plength-astart;
  if alength<0 then alength:=0;
  SetLength(Result,alength);
  if alength>0 then move(p[astart],Result[1],alength);
 end;

function Q_IntToStr(N: Integer): string;
asm
        PUSH    ESI
        PUSH    EDI
        MOV     ESI,EAX
        MOV     EDI,EDX
        MOV     EAX,EDX
        XOR     EDX,EDX
        CMP     ESI,1000
        JNL     @@x1
        CMP     ESI,$FFFFFF9C
        JNG     @@x1
        MOV     ECX,3
        JMP     @@do
@@x1:   CMP     ESI,10000000
        JNL     @@x2
        CMP     ESI,$FFF0BDC0
        JNG     @@x2
        MOV     ECX,7
        JMP     @@do
@@x2:   MOV     ECX,$0B
@@do:   CALL    System.@LStrFromPCharLen
        MOV     EAX,ESI
        MOV     ESI,[EDI]
        MOV     EDI,ESI
        TEST    EAX,EAX
        JE      @@eq
        JNS     @@ns
        CMP     EAX,$80000000
        JE      @@mm
        MOV     BYTE PTR [ESI],$2D
        INC     ESI
        NEG     EAX
@@ns:   MOV     ECX,$0A
@@lp1:  XOR     EDX,EDX
        DIV     ECX
        ADD     DL,$30
        MOV     BYTE PTR [ESI],DL
        INC     ESI
        TEST    EAX,EAX
        JNE     @@lp1
        MOV     BYTE PTR [ESI],0
        LEA     ECX,[ESI-1]
        SUB     ESI,EDI
        MOV     DWORD PTR [EDI-4],ESI
        CMP     BYTE PTR [EDI],$2D
        JE      @@ws
@@lp2:  CMP     EDI,ECX
        JAE     @@qt
        MOV     AH,BYTE PTR [EDI]
        MOV     AL,BYTE PTR [ECX]
        MOV     BYTE PTR [ECX],AH
        MOV     BYTE PTR [EDI],AL
        DEC     ECX
@@ws:   INC     EDI
        JMP     @@lp2
@@qt:   POP     EDI
        POP     ESI
        RET
@@eq:   MOV     WORD PTR [ESI],$0030
        MOV     DWORD PTR [ESI-4],1
        POP     EDI
        POP     ESI
        RET
@@mm:   MOV     DWORD PTR [ESI],$3431322D
        MOV     DWORD PTR [ESI+4],$33383437
        MOV     DWORD PTR [ESI+8],$00383436
        MOV     DWORD PTR [ESI-4],11
        POP     EDI
        POP     ESI
end;

procedure Q_StrUpperMoveL(const Source: string; var Dest: string; MaxL: Cardinal);
asm
        MOV     EDX,[EDX]
        TEST    EAX,EAX
        JE      @@x2
        PUSH    EDI
        MOV     EDI,[EAX-4]
        TEST    EDI,EDI
        JE      @@x4
        CMP     ECX,EDI
        JB      @@x0
        MOV     ECX,EDI
@@x0:   MOV     [EDX-4],ECX
        MOV     BYTE PTR [ECX+EDX],$00
        DEC     ECX
        JS      @@qt
        MOV     EDI,EDX
@@1:    MOVZX   EDX,BYTE PTR [EAX+ECX]
        MOV     DL,BYTE PTR [EDX+ToUpperChars]
        MOV     BYTE PTR [EDI+ECX],DL
        DEC     ECX
        JNS     @@1
@@qt:   POP     EDI
        RET
@@x4:   POP     EDI
        XOR     EAX,EAX
@@x2:   TEST    EDX,EDX
        JE      @@x3
        MOV     [EDX-4],EAX
        MOV     BYTE PTR [EDX],AL
@@x3:
end;

procedure Q_StrLowerMoveL(const Source: string; var Dest: string; MaxL: Cardinal);
asm
        MOV     EDX,[EDX]
        TEST    EAX,EAX
        JE      @@x2
        PUSH    EDI
        MOV     EDI,[EAX-4]
        TEST    EDI,EDI
        JE      @@x4
        CMP     ECX,EDI
        JB      @@x0
        MOV     ECX,EDI
@@x0:   MOV     [EDX-4],ECX
        MOV     BYTE PTR [ECX+EDX],$00
        DEC     ECX
        JS      @@qt
        MOV     EDI,EDX
@@1:    MOVZX   EDX,BYTE PTR [EAX+ECX]
        MOV     DL,BYTE PTR [EDX+ToLowerChars]
        MOV     BYTE PTR [EDI+ECX],DL
        DEC     ECX
        JNS     @@1
@@qt:   POP     EDI
        RET
@@x4:   POP     EDI
        XOR     EAX,EAX
@@x2:   TEST    EDX,EDX
        JE      @@x3
        MOV     [EDX-4],EAX
        MOV     BYTE PTR [EDX],AL
@@x3:
end;

function Q_UpperCase(const S: string): string;
var
  L: Integer;
begin
  L := Length(S);
  SetString(Result, nil, L);
  Q_StrUpperMoveL(S, Result, L);
end;

function Q_LowerCase(const S: string): string;
var
  L: Integer;
begin
  L := Length(S);
  SetString(Result, nil, L);
  Q_StrLowerMoveL(S, Result, L);
end;



{ TFastList }

destructor TFastList.Destroy;
begin
  if OwnsObjects then FreeObjects;
  if FCount <> 0 then Finalize(FList^[0], FCount);
  FCount := 0;
  SetCapacity(0);
  inherited Destroy;
end;

function TFastList.Add(const S: string): Integer;
begin
 if not Sorted then Result := FCount
 else
  case Duplicates of
   dupAccept: Find(s, Result);
   dupIgnore: if Find(S, Result) then Exit;
   dupError: if Find(S, Result) then Error('SDuplicateString', 0);
  end;
 InsertItem(Result, S);
end;

procedure TFastList.Clear;
begin
  if FCount <> 0 then
  begin
    Finalize(FList^[0], FCount);
    FCount := 0;
    SetCapacity(0);
  end;
end;

procedure TFastList.Delete(Index: Integer);
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  Finalize(FList^[Index]);
  Dec(FCount);
  if Index < FCount then
    System.Move(FList^[Index + 1], FList^[Index],
      (FCount - Index) * SizeOf(TStringItem));
end;

procedure TFastList.Exchange(Index1, Index2: Integer);
begin
  if (Index1 < 0) or (Index1 >= FCount) then Error('SListIndexError', Index1);
  if (Index2 < 0) or (Index2 >= FCount) then Error('SListIndexError', Index2);
  ExchangeItems(Index1, Index2);
end;

procedure TFastList.ExchangeItems(Index1, Index2: Integer);
var
  Temp: Integer;
  Item1, Item2: PStringItem;
begin
  Item1 := @FList^[Index1];
  Item2 := @FList^[Index2];
  Temp := Integer(Item1^.FString);
  Integer(Item1^.FString) := Integer(Item2^.FString);
  Integer(Item2^.FString) := Temp;
  Temp := Integer(Item1^.FObject);
  Integer(Item1^.FObject) := Integer(Item2^.FObject);
  Integer(Item2^.FObject) := Temp;
end;

function CompCardinal(C1, C2: cardinal): integer;
begin
 if C1=C2 then Result:=0 else if C1>C2 then Result:=1 else Result:=-1
end;

function TFastList.Find(const S: string; var Index: Integer): Boolean;
var
  L, H, I, C: Integer;  SI: cardinal;
begin
  Result := False;
  L := 0;
  H := FCount - 1;
  SI:=0;
  if SortAsInteger then SI:=StrtoInt64(S);
  while L <= H do
  begin
    I := (L + H) shr 1;
    if not SortAsInteger then C := Q_CompStr(FList^[I].FString, S)
     else C:=CompCardinal(StrtoInt64(FList^[I].FString), SI); 
    if C < 0 then L := I + 1 else
    begin
      H := I - 1;
      if C = 0 then
      begin
        Result := True;
        if Duplicates <> dupAccept then L := I;
      end;
    end;
  end;
  Index := L;
end;

function TFastList.Get(Index: Integer): string;
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  Result := FList^[Index].FString;
end;

function TFastList.GetCapacity: Integer;
begin
  Result := FCapacity;
end;

function TFastList.GetCount: Integer;
begin
  Result := FCount;
end;

function TFastList.GetObject(Index: Integer): TObject;
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  Result := FList^[Index].FObject;
end;

procedure TFastList.Grow;
var Delta: Integer;
begin
  if FCapacity > 64 then Delta := FCapacity div 4 else
    if FCapacity > 8 then Delta := 16 else
      Delta := 4;
  SetCapacity(FCapacity + Delta);
end;

function TFastList.IndexOf(const S: string): Integer;
begin
 if not Sorted then begin
  for Result := 0 to FCount - 1 do
   if Q_SameText(FList^[Result].FString, S) then Exit;
  Result := -1;
 end else if not Find(S, Result) then Result := -1;
end;

procedure TFastList.Insert(Index: Integer; const S: string);
begin
  if Sorted then Error('SSortedListError', 0);
  if (Index < 0) or (Index > FCount) then Error('SListIndexError', Index);
  InsertItem(Index, S);
end;

procedure TFastList.InsertItem(Index: Integer; const S: string);
begin
  if FCount = FCapacity then Grow;
  if Index < FCount then
    System.Move(FList^[Index], FList^[Index + 1],
      (FCount - Index) * SizeOf(TStringItem));
  with FList^[Index] do
  begin
    Pointer(FString) := nil;
    FObject := nil;
    FString := S;
  end;
  Inc(FCount);
end;

procedure TFastList.Put(Index: Integer; const S: string);
var n:integer;
begin
//  if Sorted then Error('SSortedListError', 0);
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  n:=IndexOf(s);
  case Duplicates of
   dupIgnore: if (n<>-1) and (n<>Index) then Exit;
   dupError: if (n<>-1) and (n<>Index) then Error('SDuplicateString', 0);
  end;
  FList^[Index].FString := S;
  if Sorted then QuickSort(0,FCount-1);
end;

procedure TFastList.PutObject(Index: Integer; AObject: TObject);
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  FList^[Index].FObject := AObject;
end;

procedure TFastList.QuickSort(L, R: Integer);
var
  I, J: Integer;
  P: string;
begin
  repeat
    I := L;
    J := R;
    P := FList^[(L + R) shr 1].FString;
    repeat
      if SortAsInteger then begin
       while StrtoInt(FList^[I].FString)<StrtoInt(P) do Inc(I);
       while StrtoInt(FList^[J].FString)>StrtoInt(P) do Dec(J);
      end else begin
       while Q_CompStr(FList^[I].FString, P) < 0 do Inc(I);
       while Q_CompStr(FList^[J].FString, P) > 0 do Dec(J);
      end;
      if I <= J then
      begin
        ExchangeItems(I, J);
        Inc(I);
        Dec(J);
      end;
    until I > J;
    if L < J then QuickSort(L, J);
    L := I;
  until I >= R;
end;

procedure TFastList.SetCapacity(NewCapacity: Integer);
begin
  ReallocMem(FList, NewCapacity * SizeOf(TStringItem));
  FCapacity := NewCapacity;
end;

procedure TFastList.SetSorted(Value: Boolean);
begin
  if FSorted <> Value then
  begin
    if Value then Sort;
    FSorted := Value;
  end;
end;

procedure TFastList.Sort;
begin
 if not Sorted and (FCount > 1) then QuickSort(0, FCount - 1);
end;

procedure TFastList.FreePointers;
var i:integer;
begin
 for i:=0 to Count-1 do FreeMem(Pointer(Objects[i]))
end;

procedure TFastList.FreeObjects;
var i:integer;
begin
 for i:=0 to Count-1 do
  if Assigned(Objects[i]) then
   Objects[i].Free
end;

function TFastList.FastGetValue(const Name:string):string;
var s:string; i,n:integer;
begin
 s:=name+'='; n:=Length(s);
 for i:=0 to fCount-1 do
  if Q_SameTextL(s,FList^[i].FString,n) then begin
   Result:=copy(FList^[i].FString,n+1,maxint);
   exit
  end;
 Result:='';
end;

procedure TFastList.FastSetValue(const Name,Value:string);
var i,n,k: Integer; s:string;
begin
 s:=name+'='; n:=Length(s); k:=-1;
 for i:=0 to fCount-1 do
  if Q_SameTextL(s,FList^[i].FString,n) then begin
   k:=i;
   break
  end;
  if Value <> '' then
  begin
    if k < 0 then k := Add('');
    Put(k, Name + '=' + Value);
  end else
  begin
    if k >= 0 then Delete(k);
  end;
end;



{--------------------TFastString--------------------------------------}

constructor TFastString.Create(ADelta: cardinal);
begin
 Delta:=ADelta;
end;

destructor TFastString.Destroy;
begin
 if Assigned(Value) then FreeMem(Value);
 inherited;
end;

function TFastString.GetAsString: string;
begin
 SetLength(Result, VLength);
 Move(Value^, pointer(Result)^, VLength);
end;

procedure TFastString.SetAsString(const s:string);
begin
 if Value<>nil then begin FreeMem(Value); Value:=nil end;
 VLength:=length(s);
 VSize:=VLength;
 GetMem(Value, VSize);
 if VLength>0 then move(s[1], Value^, VLength);
end;

procedure TFastString.Add(const s: string);
var L, n: cardinal;
begin
 L:=length(s);
 if L>0 then begin
  if VLength+L>VSize then begin
   n:=VLength+L-VSize;
   if n<delta then n:=delta;
   ReallocMem(Value, VSize+n);
   inc(VSize, n);
  end;
  move(Pointer(s)^, pointer(cardinal(Value)+VLength)^, L);
  inc(VLength, L);
 end;
end;

{----------------------common-------------------------}

function ValuetoTextRUR(V: double): string;
var V1,k3,k2,k1,VL:integer; s:string; minus:boolean;
const A1:array[0..19] of string=('',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
  ' ',' ',' ',' ',' ',' ',
  ' ',' ',' ');
  A10:array[0..9] of string=('',' ',' ',' ',' ',' ',' ',' ',' ',' ');
  A100:array[0..9] of string=('',' ',' ',' ',' ',' ',' ',' ',' ',' ');

 function Add(const s1, s2, s3, sone, stwo: string): string;
 begin
  Result:='';
  VL:=VL div 1000;
  if VL=0 then exit;
  V1:=VL-(VL div 1000)*1000;
  if V1<>0 then begin
   k3:=v1 div 100; k2:=(v1-k3*100) div 10; k1:=(v1-k3*100-k2*10);
   if k2=1 then begin k2:=0; k1:=k1+10 end;
   if k1=1 then s:=s1 else if (k1<5) and (k1>1) then s:=s2 else s:=s3;
   A1[1]:=sone; A1[2]:=stwo;
   Result:=A100[k3]+A10[k2]+A1[k1]+s;
  end;
 end;

begin

 Result:='';

 if V<0 then begin V:=abs(V); minus:=true end else minus:=false;
 V:=round(v*100)/100;
 VL:=Round(Frac(V)*100);
 if VL<>0 then begin
   A1[1]:=' '; A1[2]:=' ';
   V1:=VL;
   k2:=v1 div 10; k1:=(v1-k2*10);
   if k2=1 then begin k2:=0; k1:=k1+10 end;
   Result:=Result+A10[k2]+A1[k1];
   if k1=1 then Result:=Result+'' else
   if (k1<5) and (k1>1) then Result:=Result+'' else
   Result:=Result+'';
 end;

 A1[1]:=' '; A1[2]:=' ';
 VL:=Trunc(V);
 V1:=(VL-(VL div 1000)*1000);
 k3:=v1 div 100; k2:=(v1-k3*100) div 10; k1:=(v1-k3*100-k2*10);
 if k2=1 then begin k2:=0; k1:=k1+10 end;
 s:=A100[k3]+A10[k2]+A1[k1]; if (s='') and (VL div 1000=0) then s:=' ';
 if k1=1 then Result:=s+' '+Result else
 if (k1<5) and (k1>1) then Result:=s+' '+Result else
 Result:=s+' '+Result;
 Result:=Add(' ',' ',' ',' ',' ')+Result;
 if VL<>0 then Result:=Add(' ',' ',' ',' ',' ')+Result;
 if VL<>0 then Result:=Add(' ',' ',' ',' ',' ')+Result;
 if minus then Result:=' '+Result;
end;

function ValuetoTextUSD(V:double):string;
var V1,k3,k2,k1,VL:integer; s:string; minus:boolean;
const A1:array[0..19] of string=('',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
  ' ',' ',' ',' ',' ',' ',
  ' ',' ',' ');
  A10:array[0..9] of string=('',' ',' ',' ',' ',' ',' ',' ',' ',' ');
  A100:array[0..9] of string=('',' ',' ',' ',' ',' ',' ',' ',' ',' ');

 function Add(s1,s2,s3,sone,stwo:string):string;
 begin
  Result:='';
  VL:=VL div 1000;
  if VL=0 then exit;
  V1:=VL-(VL div 1000)*1000;
  if V1<>0 then begin
   k3:=v1 div 100; k2:=(v1-k3*100) div 10; k1:=(v1-k3*100-k2*10);
   if k2=1 then begin k2:=0; k1:=k1+10 end;
   if k1=1 then s:=s1 else if (k1<5) and (k1>1) then s:=s2 else s:=s3;
   A1[1]:=sone; A1[2]:=stwo;
   Result:=A100[k3]+A10[k2]+A1[k1]+s;
  end;
 end;

begin

 Result:='';
 if V<0 then begin V:=abs(V); minus:=true end else minus:=false;
 VL:=Round(Frac(V)*100);
 if VL=100 then begin V:=V+1; VL:=0 end;
 if VL<>0 then begin
   A1[1]:=' '; A1[2]:=' ';
   V1:=VL;
   k2:=v1 div 10; k1:=(v1-k2*10);
   if k2=1 then begin k2:=0; k1:=k1+10 end;
   Result:=Result+A10[k2]+A1[k1];
   if k1=1 then Result:=Result+'' else
   if (k1<5) and (k1>1) then Result:=Result+'' else
   Result:=Result+'';
 end;

 A1[1]:=' '; A1[2]:=' ';
 VL:=Trunc(V);
 V1:=(VL-(VL div 1000)*1000);
 k3:=v1 div 100; k2:=(v1-k3*100) div 10; k1:=(v1-k3*100-k2*10);
 if k2=1 then begin k2:=0; k1:=k1+10 end;
 s:=A100[k3]+A10[k2]+A1[k1]; if (s='') and (VL div 1000=0) then s:=' ';
 if k1=1 then Result:=s+' '+Result else
 if (k1<5) and (k1>1) then Result:=s+' '+Result else
 Result:=s+' '+Result;
 Result:=Add(' ',' ',' ',' ',' ')+Result;
 if VL<>0 then Result:=Add(' ',' ',' ',' ',' ')+Result;
 if VL<>0 then Result:=Add(' ',' ',' ',' ',' ')+Result;
 if minus then Result:=' '+Result;
end;

function CorrectForm(const root, f0, f1, f2: string; count: integer): string;
begin
 count:=count mod 100;
 if (count>10) and (count<19) then count:=0 else count:=count mod 10;
 case count of
  0,5..9: Result:=root+f0;
  1: Result:=root+f1;
  2..4: Result:=root+f2;
 end;
end;

procedure StrtoFile(const s, FileName: string);
var Stream: TStream;
begin
 Stream := TFileStream.Create(FileName, fmCreate);
 try
  Stream.WriteBuffer(Pointer(s)^, Length(S));
 finally Stream.Free end;
end;

function FileToStr(const FileName:string):string;
var Stream: TStream;
begin
 try
  Stream := TFileStream.Create(FileName, fmOpenRead or fmShareDenyNone);
  try
    SetLength(Result, Stream.Size);
    Stream.Read(Pointer(Result)^, Stream.Size);
  finally
    Stream.Free;
  end;
 except on E: Exception do begin
  E.Message:=E.Message+' '+FileName;
  raise
 end end;
end;

procedure Q_FillLong(Value: LongWord; P: Pointer; Count: Cardinal);
asm
        CMP     ECX,32
        JBE     @@xx
        XCHG    EDI,EDX
        REP     STOSD
        MOV     EDI,EDX
        RET
@@xx:   JMP     DWORD PTR @@wV[ECX*4]
@@wV:   DD      @@w00, @@w01, @@w02, @@w03
        DD      @@w04, @@w05, @@w06, @@w07
        DD      @@w08, @@w09, @@w10, @@w11
        DD      @@w12, @@w13, @@w14, @@w15
        DD      @@w16, @@w17, @@w18, @@w19
        DD      @@w20, @@w21, @@w22, @@w23
        DD      @@w24, @@w25, @@w26, @@w27
        DD      @@w28, @@w29, @@w30, @@w31
        DD      @@w32
@@w32:  MOV     [EDX+124],EAX
@@w31:  MOV     [EDX+120],EAX
@@w30:  MOV     [EDX+116],EAX
@@w29:  MOV     [EDX+112],EAX
@@w28:  MOV     [EDX+108],EAX
@@w27:  MOV     [EDX+104],EAX
@@w26:  MOV     [EDX+100],EAX
@@w25:  MOV     [EDX+96],EAX
@@w24:  MOV     [EDX+92],EAX
@@w23:  MOV     [EDX+88],EAX
@@w22:  MOV     [EDX+84],EAX
@@w21:  MOV     [EDX+80],EAX
@@w20:  MOV     [EDX+76],EAX
@@w19:  MOV     [EDX+72],EAX
@@w18:  MOV     [EDX+68],EAX
@@w17:  MOV     [EDX+64],EAX
@@w16:  MOV     [EDX+60],EAX
@@w15:  MOV     [EDX+56],EAX
@@w14:  MOV     [EDX+52],EAX
@@w13:  MOV     [EDX+48],EAX
@@w12:  MOV     [EDX+44],EAX
@@w11:  MOV     [EDX+40],EAX
@@w10:  MOV     [EDX+36],EAX
@@w09:  MOV     [EDX+32],EAX
@@w08:  MOV     [EDX+28],EAX
@@w07:  MOV     [EDX+24],EAX
@@w06:  MOV     [EDX+20],EAX
@@w05:  MOV     [EDX+16],EAX
@@w04:  MOV     [EDX+12],EAX
@@w03:  MOV     [EDX+8],EAX
@@w02:  MOV     [EDX+4],EAX
@@w01:  MOV     [EDX],EAX
@@w00:
end;

procedure Q_MoveMem(Source, Dest: Pointer; L: Cardinal);
asm
        PUSH    EDI
        PUSH    ESI
        MOV     EDI,EDX
        MOV     ESI,EAX
        MOV     EAX,ECX
        MOV     EDX,ECX
        ADD     EAX,ESI
        CMP     EDI,ESI
        JBE     @@cpu
        CMP     EDI,EAX
        JB      @@cpd
@@cpu:  TEST    EDI,3
        JNZ     @@clu
        SHR     ECX,2
        AND     EDX,3
        CMP     ECX,16
        JBE     @@cwu
        REP     MOVSD
        JMP     DWORD PTR @@tuV[EDX*4]
@@clu:  MOV     EAX,EDI
        MOV     EDX,3
        SUB     ECX,4
        JB      @@bcu
        AND     EAX,3
        ADD     ECX,EAX
        JMP     DWORD PTR @@luV[EAX*4-4]
@@bcu:  JMP     DWORD PTR @@tuV[ECX*4+16]
@@cwu:  JMP     DWORD PTR @@wuV[ECX*4]
@@luV:  DD      @@lu1, @@lu2, @@lu3
@@lu1:  AND     EDX,ECX
        MOV     AL,[ESI]
        MOV     [EDI],AL
        MOV     AL,[ESI+1]
        MOV     [EDI+1],AL
        MOV     AL,[ESI+2]
        SHR     ECX,2
        MOV     [EDI+2],AL
        ADD     ESI,3
        ADD     EDI,3
        CMP     ECX,16
        JBE     @@cwu
        REP     MOVSD
        JMP     DWORD PTR @@tuV[EDX*4]
@@lu2:  AND     EDX,ECX
        MOV     AL,[ESI]
        MOV     [EDI],AL
        MOV     AL,[ESI+1]
        SHR     ECX,2
        MOV     [EDI+1],AL
        ADD     ESI,2
        ADD     EDI,2
        CMP     ECX,16
        JBE     @@cwu
        REP     MOVSD
        JMP     DWORD PTR @@tuV[EDX*4]
@@lu3:  AND     EDX,ECX
        MOV     AL,[ESI]
        MOV     [EDI],AL
        INC     ESI
        SHR     ECX,2
        INC     EDI
        CMP     ECX,16
        JBE     @@cwu
        REP     MOVSD
        JMP     DWORD PTR @@tuV[EDX*4]
@@wuV:  DD      @@wu0, @@wu1, @@wu2, @@wu3
        DD      @@wu4, @@wu5, @@wu6, @@wu7
        DD      @@wu8, @@wu9, @@wu10, @@wu11
        DD      @@wu12, @@wu13, @@wu14, @@wu15
        DD      @@wu16
@@wu16: MOV     EAX,[ESI+ECX*4-64]
        MOV     [EDI+ECX*4-64],EAX
@@wu15: MOV     EAX,[ESI+ECX*4-60]
        MOV     [EDI+ECX*4-60],EAX
@@wu14: MOV     EAX,[ESI+ECX*4-56]
        MOV     [EDI+ECX*4-56],EAX
@@wu13: MOV     EAX,[ESI+ECX*4-52]
        MOV     [EDI+ECX*4-52],EAX
@@wu12: MOV     EAX,[ESI+ECX*4-48]
        MOV     [EDI+ECX*4-48],EAX
@@wu11: MOV     EAX,[ESI+ECX*4-44]
        MOV     [EDI+ECX*4-44],EAX
@@wu10: MOV     EAX,[ESI+ECX*4-40]
        MOV     [EDI+ECX*4-40],EAX
@@wu9:  MOV     EAX,[ESI+ECX*4-36]
        MOV     [EDI+ECX*4-36],EAX
@@wu8:  MOV     EAX,[ESI+ECX*4-32]
        MOV     [EDI+ECX*4-32],EAX
@@wu7:  MOV     EAX,[ESI+ECX*4-28]
        MOV     [EDI+ECX*4-28],EAX
@@wu6:  MOV     EAX,[ESI+ECX*4-24]
        MOV     [EDI+ECX*4-24],EAX
@@wu5:  MOV     EAX,[ESI+ECX*4-20]
        MOV     [EDI+ECX*4-20],EAX
@@wu4:  MOV     EAX,[ESI+ECX*4-16]
        MOV     [EDI+ECX*4-16],EAX
@@wu3:  MOV     EAX,[ESI+ECX*4-12]
        MOV     [EDI+ECX*4-12],EAX
@@wu2:  MOV     EAX,[ESI+ECX*4-8]
        MOV     [EDI+ECX*4-8],EAX
@@wu1:  MOV     EAX,[ESI+ECX*4-4]
        MOV     [EDI+ECX*4-4],EAX
        LEA     EAX,[ECX*4]
        ADD     ESI,EAX
        ADD     EDI,EAX
@@wu0:  JMP     DWORD PTR @@tuV[EDX*4]
@@tuV:  DD      @@tu0, @@tu1, @@tu2, @@tu3
@@tu0:  POP     ESI
        POP     EDI
        RET
@@tu1:  MOV     AL,[ESI]
        MOV     [EDI],AL
        POP     ESI
        POP     EDI
        RET
@@tu2:  MOV     AL,[ESI]
        MOV     [EDI],AL
        MOV     AL,[ESI+1]
        MOV     [EDI+1],AL
        POP     ESI
        POP     EDI
        RET
@@tu3:  MOV     AL,[ESI]
        MOV     [EDI],AL
        MOV     AL,[ESI+1]
        MOV     [EDI+1],AL
        MOV     AL,[ESI+2]
        MOV     [EDI+2],AL
        POP     ESI
        POP     EDI
        RET
@@cpd:  LEA     ESI,[ESI+ECX-4]
        LEA     EDI,[EDI+ECX-4]
        TEST    EDI,3
        JNZ     @@cld
        SHR     ECX,2
        AND     EDX,3
        CMP     ECX,16
        JBE     @@cwd
        STD
        REP     MOVSD
        CLD
        JMP     DWORD PTR @@tdV[EDX*4]
@@cwd:  NEG     ECX
        JMP     DWORD PTR @@wdV[ECX*4+64]
@@cld:  MOV     EAX,EDI
        MOV     EDX,3
        CMP     ECX,4
        JB      @@bcd
        AND     EAX,3
        SUB     ECX,EAX
        JMP     DWORD PTR @@ldV[EAX*4-4]
@@bcd:  JMP     DWORD PTR @@tdV[ECX*4]
@@ldV:  DD      @@ld1, @@ld2, @@ld3
@@ld1:  MOV     AL,[ESI+3]
        AND     EDX,ECX
        MOV     [EDI+3],AL
        DEC     ESI
        SHR     ECX,2
        DEC     EDI
        CMP     ECX,16
        JBE     @@cwd
        STD
        REP     MOVSD
        CLD
        JMP     DWORD PTR @@tdV[EDX*4]
@@ld2:  MOV     AL,[ESI+3]
        AND     EDX,ECX
        MOV     [EDI+3],AL
        MOV     AL,[ESI+2]
        SHR     ECX,2
        MOV     [EDI+2],AL
        SUB     ESI,2
        SUB     EDI,2
        CMP     ECX,16
        JBE     @@cwd
        STD
        REP     MOVSD
        CLD
        JMP     DWORD PTR @@tdV[EDX*4]
@@ld3:  MOV     AL,[ESI+3]
        AND     EDX,ECX
        MOV     [EDI+3],AL
        MOV     AL,[ESI+2]
        MOV     [EDI+2],AL
        MOV     AL,[ESI+1]
        SHR     ECX,2
        MOV     [EDI+1],AL
        SUB     ESI,3
        SUB     EDI,3
        CMP     ECX,16
        JBE     @@cwd
        STD
        REP     MOVSD
        CLD
        JMP     DWORD PTR @@tdV[EDX*4]
@@wdV:  DD      @@wd16
        DD      @@wd15, @@wd14, @@wd13, @@wd12
        DD      @@wd11, @@wd10, @@wd9, @@wd8
        DD      @@wd7, @@wd6, @@wd5, @@wd4
        DD      @@wd3, @@wd2, @@wd1, @@wd0
@@wd16: MOV     EAX,[ESI+ECX*4+64]
        MOV     [EDI+ECX*4+64],EAX
@@wd15: MOV     EAX,[ESI+ECX*4+60]
        MOV     [EDI+ECX*4+60],EAX
@@wd14: MOV     EAX,[ESI+ECX*4+56]
        MOV     [EDI+ECX*4+56],EAX
@@wd13: MOV     EAX,[ESI+ECX*4+52]
        MOV     [EDI+ECX*4+52],EAX
@@wd12: MOV     EAX,[ESI+ECX*4+48]
        MOV     [EDI+ECX*4+48],EAX
@@wd11: MOV     EAX,[ESI+ECX*4+44]
        MOV     [EDI+ECX*4+44],EAX
@@wd10: MOV     EAX,[ESI+ECX*4+40]
        MOV     [EDI+ECX*4+40],EAX
@@wd9:  MOV     EAX,[ESI+ECX*4+36]
        MOV     [EDI+ECX*4+36],EAX
@@wd8:  MOV     EAX,[ESI+ECX*4+32]
        MOV     [EDI+ECX*4+32],EAX
@@wd7:  MOV     EAX,[ESI+ECX*4+28]
        MOV     [EDI+ECX*4+28],EAX
@@wd6:  MOV     EAX,[ESI+ECX*4+24]
        MOV     [EDI+ECX*4+24],EAX
@@wd5:  MOV     EAX,[ESI+ECX*4+20]
        MOV     [EDI+ECX*4+20],EAX
@@wd4:  MOV     EAX,[ESI+ECX*4+16]
        MOV     [EDI+ECX*4+16],EAX
@@wd3:  MOV     EAX,[ESI+ECX*4+12]
        MOV     [EDI+ECX*4+12],EAX
@@wd2:  MOV     EAX,[ESI+ECX*4+8]
        MOV     [EDI+ECX*4+8],EAX
@@wd1:  MOV     EAX,[ESI+ECX*4+4]
        MOV     [EDI+ECX*4+4],EAX
        LEA     EAX,[ECX*4]
        ADD     ESI,EAX
        ADD     EDI,EAX
@@wd0:  JMP     DWORD PTR @@tdV[EDX*4]
@@tdV:  DD      @@td0, @@td1, @@td2, @@td3
@@td0:  POP     ESI
        POP     EDI
        RET
@@td1:  MOV     AL,[ESI+3]
        MOV     [EDI+3],AL
        POP     ESI
        POP     EDI
        RET
@@td2:  MOV     AL,[ESI+3]
        MOV     [EDI+3],AL
        MOV     AL,[ESI+2]
        MOV     [EDI+2],AL
        POP     ESI
        POP     EDI
        RET
@@td3:  MOV     AL,[ESI+3]
        MOV     [EDI+3],AL
        MOV     AL,[ESI+2]
        MOV     [EDI+2],AL
        MOV     AL,[ESI+1]
        MOV     [EDI+1],AL
        POP     ESI
        POP     EDI
end;

procedure Q_MoveBytes(Source, Dest: Pointer; L: Cardinal);
asm
        CMP     EDX,EAX
        JA      @@bm
        JE      @@qt
        XCHG    ESI,EAX
        XCHG    EDI,EDX
        REP     MOVSB
        MOV     ESI,EAX
        MOV     EDI,EDX
        RET
@@bm:   PUSH    ESI
        PUSH    EDI
        STD
        LEA     ESI,[EAX+ECX-1]
        LEA     EDI,[EDX+ECX-1]
        REP     MOVSB
        CLD
        POP     EDI
        POP     ESI
@@qt:
end;

procedure Q_CutRight(var S: string; CharCount: Integer);
var
  L: Integer;
  P: ^Integer;
begin
  if CharCount > 0 then
  begin
    L := Length(S)-CharCount;
    if L > 0 then
    begin
      UniqueString(S);
      P := Pointer(S);
      Dec(P);
      P^ := L;
      Inc(LongWord(P),L+4);
      PByte(P)^ := 0;
    end else
      S := '';
  end
  else if CharCount < 0 then
    Q_CutLeft(S,-CharCount);
end;

procedure Q_CutLeft(var S: string; CharCount: Integer);
var
  L: Integer;
  P: ^Integer;
begin
  if CharCount > 0 then
  begin
    L := Length(S)-CharCount;
    if L > 0 then
    begin
      UniqueString(S);
      P := Pointer(S);
      Dec(P);
      P^ := L;
      Inc(LongWord(P),CharCount+4);
      if CharCount > 3 then
        Q_MoveMem(P,Pointer(S),L)
      else
        Q_MoveBytes(P,Pointer(S),L);
      P := Pointer(S);
      Inc(LongWord(P),L);
      PByte(P)^ := 0;
    end else
      S := '';
  end
  else if CharCount < 0 then
    Q_CutRight(S,-CharCount);
end;


function Q_StrTok(var S: string; const Delimiters: string): string; 
var
  DelimsMap: PDelimsMap;
  I: Integer;
  P1,P2: PChar;
  L: LongWord;
begin
  asm
        CALL    SysInit.@GetTls
        LEA     EAX,[EAX+UDelimsMap]
        MOV     DelimsMap,EAX
  end;
  L := Length(Delimiters);
  if L <> 0 then
  begin
    Q_FillLong(0,DelimsMap,64);
    for I := 1 to L do
      DelimsMap^[Delimiters[I]] := True;
  end;
  L := Length(S);
  if L <> 0 then
  begin
    P2 := Pointer(S);
    Inc(L,LongWord(P2));
    while (LongWord(P2)<L) and DelimsMap^[P2^] do Inc(P2);
    if LongWord(P2) >= L then
    begin
      S := '';
      Result := '';
      Exit;
    end;
    P1 := P2;
    while (LongWord(P2)<L) and not DelimsMap^[P2^] do Inc(P2);
    I := LongWord(P2)-LongWord(P1);
    SetString(Result,nil,I);
    Q_CopyMem(P1,Pointer(Result),I);
    P1 := Pointer(S);
    Q_CutLeft(S,LongWord(P2)-LongWord(P1));
  end else
    Result := '';
end;


procedure Q_Delete(var S: string; Index, Count: Integer);
asm
        PUSH    EBX
        PUSH    ESI
        XOR     EBX,EBX
        CMP     ECX,EBX
        JLE     @@qt
        MOV     EBX,[EAX]
        TEST    EBX,EBX
        JE      @@qt
        MOV     ESI,[EBX-4]
        DEC     EDX
        JS      @@qt
        SUB     ESI,EDX
        JNG     @@qt
        SUB     ESI,ECX
        JLE     @@ct
        PUSH    ECX
        MOV     EBX,EDX
        CALL    UniqueString
        POP     ECX
        PUSH    EAX
        MOV     EDX,ESI
        ADD     EAX,EBX
        SHR     ESI,2
        JE      @@nx
@@lp:   MOV     BL,[EAX+ECX]
        MOV     [EAX],BL
        MOV     BL,[EAX+ECX+1]
        MOV     [EAX+1],BL
        MOV     BL,[EAX+ECX+2]
        MOV     [EAX+2],BL
        MOV     BL,[EAX+ECX+3]
        MOV     [EAX+3],BL
        ADD     EAX,4
        DEC     ESI
        JNE     @@lp
@@nx:   AND     EDX,3
        JMP     DWORD PTR @@tV[EDX*4]
@@ct:   TEST    EDX,EDX
        JE      @@zq
        MOV     EBX,EDX
        CALL    UniqueString
        MOV     [EAX-4],EBX
        XOR     EDX,EDX
        MOV     [EAX+EBX],DL
@@qt:   POP     ESI
        POP     EBX
        RET
@@zq:   CALL    System.@LStrClr
        POP     ESI
        POP     EBX
        RET
@@tV:   DD      @@t0,@@t1,@@t2,@@t3
@@t1:   MOV     BL,[EAX+ECX]
        MOV     [EAX],BL
        INC     EAX
        JMP     @@t0
@@t2:   MOV     BL,[EAX+ECX]
        MOV     [EAX],BL
        MOV     BL,[EAX+ECX+1]
        MOV     [EAX+1],BL
        ADD     EAX,2
        JMP     @@t0
@@t3:   MOV     BL,[EAX+ECX]
        MOV     [EAX],BL
        MOV     BL,[EAX+ECX+1]
        MOV     [EAX+1],BL
        MOV     BL,[EAX+ECX+2]
        MOV     [EAX+2],BL
        ADD     EAX,3
@@t0:   POP     EDX
        MOV     BYTE PTR [EAX],0
        SUB     EAX,EDX
        MOV     [EDX-4],EAX
        POP     ESI
        POP     EBX
end;


function Min(x1, x2: Integer): Integer; assembler;
asm
 cmp eax,edx
 jle @end
 mov eax,edx
 @end:
end;

function Max(x1, x2: Integer): Integer; assembler;
asm
 cmp edx,eax
 jle @end
 mov eax,edx
 @end:
end;

function Min(x1, x2: Extended): Extended;
begin
 if x1>x2 then Result:=x2 else Result:=x1;
end;

function Max(x1, x2: Extended): Extended;
begin
 if x1>x2 then Result:=x1 else Result:=x2;
end;

function IntParam(const s: string; defvalue: integer): integer;
begin
 if s='' then Result:=defvalue else Result:=strtoint(s)
end;

procedure FastTrim(var s:shortstring); assembler;
asm
  push esi
  push edi
  mov edi,s
  xor ecx,ecx
  mov cl,[edi]
  cmp cl,0
  jz @end2
  mov esi,edi
  inc esi
 @1:
  cmp byte ptr [edi][ecx],' '
  ja  @l1
  loop @1
 @l1:
  cmp cl,0
  jz @end2
  cmp byte ptr [esi],' '
  ja @end2
  inc esi
  loop @l1
 @end2:
  mov byte ptr [edi],cl
  inc edi
  rep movsb
  pop edi
  pop esi
end;

function TransliterateRE(const s: string): string;
var i, n: integer;
begin
 Result:='';
 for i:=1 to Length(s) do begin
  n:=Pos(s[i],TransRE_Rus);
  if n>0 then begin Result:=Result+TransRE_Eng[n]; continue end;
  n:=Pos(Q_LowerCase(s[i]),TransRE_Rus);
  if n>0 then begin Result:=Result+Q_UpperCase(TransRE_Eng[n]); continue end;
  Result:=Result+s[i];
 end;
end;

function TransliterateER(const s: string): string;
var i,n,k:integer; s1:string; yes:boolean;
begin
 Result:='';
 i:=1;
 while i<=Length(s) do begin
  if copy(s,i,3)='sch' then begin Result:=Result+''; Inc(i,3); continue end;
  yes:=false;
  for n:=2 downto 1 do begin
   s1:=copy(s,i,n);
   if Length(s1)<n then continue;
   for k:=1 to 33 do if TransRE_Eng[k]=s1 then begin Result:=Result+TransRE_Rus[k]; Inc(i,n); yes:=true; break end;
   if yes then break;
   for k:=1 to 33 do if TransRE_Eng[k]=Q_LowerCase(s1) then begin
    Result:=Result+Q_UpperCase(TransRE_Rus[k]);
    Inc(i,n);
    yes:=true;
    break
   end;
   if (n=1) and (not yes) then begin Result:=Result+s[i]; Inc(i) end;
  end;
 end;
end;

function Q_ProperCase(const S, Delimiters: string): string; overload;
var
  DelimsMap: PDelimsMap;
  I: Integer;
  L: LongWord;
  P: PChar;
  A: Boolean;
begin
  asm
        CALL    SysInit.@GetTls
        LEA     EAX,[EAX+UDelimsMap]
        MOV     DelimsMap,EAX
  end;
  L := Length(Delimiters);
  if L <> 0 then
  begin
    Q_FillLong(0,DelimsMap,64);
    for I := 1 to L do
      DelimsMap^[Delimiters[I]] := True;
  end;
  L := Length(S);
  if L <> 0 then
  begin
    SetString(Result, nil, L);
    Q_StrLowerMoveL(S, Result, L);
    P := Pointer(Result);
    A := False;
    for I := 1 to L do
    begin
      if not DelimsMap^[P^] then
      begin
        if not A then
        begin
          A := True;
          P^ := ToUpperChars[Byte(P^)];
        end;
      end else
        A := False;
      Inc(P);
    end;
  end else
    Result := '';
end;



{---------------TDateList----------------------------------}

destructor TDateList.Destroy;
begin
  inherited Destroy;
  if OwnsObjects then FreeObjects;
  FCount := 0;
  SetCapacity(0);
end;

function TDateList.Add(const D: TDateTime): Integer;
begin
 if not Sorted then Result := FCount
 else
  case Duplicates of
   dupIgnore: Find(D, Result);
   dupError: if Find(D, Result) then Error('SDuplicateString', 0);
  end;
 inc(Result);
 InsertItem(Result, D);
end;

function TDateList.AddObject(const D: TDateTime; AObject: TObject): Integer;
begin
  Result := Add(D);
  PutObject(Result, AObject);
end;

procedure TDateList.Error(const Msg: string; Data: Integer);

  function ReturnAddr: Pointer;
  asm
          MOV     EAX,[EBP+4]
  end;

begin
  raise EStringListError.CreateFmt(Msg, [Data]) at ReturnAddr;
end;

procedure TDateList.Exchange(Index1, Index2: Integer);
var
  TempObject: TObject;
  TempDate: TDateTime;
begin
    TempDate := Dates[Index1];
    TempObject := Objects[Index1];
    Dates[Index1] := Dates[Index2];
    Objects[Index1] := Objects[Index2];
    Dates[Index2] := TempDate;
    Objects[Index2] := TempObject;
end;

function TDateList.GetCapacity: Integer;
begin
  Result := FCapacity;
end;

function TDateList.IndexOfObject(AObject: TObject): Integer;
begin
  for Result := 0 to GetCount - 1 do
    if GetObject(Result) = AObject then Exit;
  Result := -1;
end;

procedure TDateList.InsertObject(Index: Integer; const D: TDateTime; AObject: TObject);
begin
  Insert(Index, D);
  PutObject(Index, AObject);
end;

procedure TDateList.Put(Index: Integer; const D: TDateTime);
begin
  if Sorted then Error('SSortedListError', 0);
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  FList^[Index].FDate := D;
end;

function TDateList.GetObject(Index: Integer): TObject;
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  Result := FList^[Index].FObject;
end;

procedure TDateList.ExchangeItems(Index1, Index2: Integer);
var
  Temp: Integer; TempD: TDateTime;
  Item1, Item2: PDateItem;
begin
  Item1 := @FList^[Index1];
  Item2 := @FList^[Index2];
  TempD := Item1^.FDate;
  Item1^.FDate := Item2^.FDate;
  Item2^.FDate := TempD;
  Temp := Integer(Item1^.FObject);
  Integer(Item1^.FObject) := Integer(Item2^.FObject);
  Integer(Item2^.FObject) := Temp;
end;

procedure TDateList.Grow;
var Delta: Integer;
begin
  if FCapacity > 64 then Delta := FCapacity div 4 else
    if FCapacity > 8 then Delta := 16 else
      Delta := 4;
  SetCapacity(FCapacity + Delta);
end;

function CompDateTime(d1,d2:TDateTime):integer;
begin
 if d1>d2 then Result:=1 else if d1<d2 then Result:=-1 else Result:=0
end;

procedure TDateList.QuickSort(L, R: Integer);
var
  I, J: Integer;
  P: TDateTime;
begin
  repeat
    I := L;
    J := R;
    P := FList^[(L + R) shr 1].FDate;
    repeat
      while CompDateTime(FList^[I].FDate, P) < 0 do Inc(I);
      while CompDateTime(FList^[J].FDate, P) > 0 do Dec(J);
      if I <= J then
      begin
        ExchangeItems(I, J);
        Inc(I);
        Dec(J);
      end;
    until I > J;
    if L < J then QuickSort(L, J);
    L := I;
  until I >= R;
end;

procedure TDateList.InsertItem(Index: Integer; const D: TDateTime);
begin
  if FCount = FCapacity then Grow;
  if Index < FCount then
    System.Move(FList^[Index], FList^[Index + 1],
      (FCount - Index) * SizeOf(TDateItem));
  with FList^[Index] do
  begin
    FObject := nil;
    FDate := D;
  end;
  Inc(FCount);
end;

procedure TDateList.SetSorted(Value: Boolean);
begin
  if FSorted <> Value then
  begin
    if Value then Sort;
    FSorted := Value;
  end;
end;

function TDateList.Get(Index: Integer): TDateTime;
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  Result := FList^[Index].FDate;
end;

function TDateList.GetCount: Integer;
begin
  Result := FCount;
end;

procedure TDateList.PutObject(Index: Integer; AObject: TObject);
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  FList^[Index].FObject := AObject;
end;

procedure TDateList.SetCapacity(NewCapacity: Integer);
begin
  ReallocMem(FList, NewCapacity * SizeOf(TDateItem));
  FCapacity := NewCapacity;
end;

procedure TDateList.Clear;
begin
  if FCount <> 0 then
  begin
    FCount := 0;
    SetCapacity(0);
  end;
end;

procedure TDateList.Delete(Index: Integer);
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  Dec(FCount);
  if Index < FCount then
    System.Move(FList^[Index + 1], FList^[Index],
      (FCount - Index) * SizeOf(TDateItem));
end;

function TDateList.Find(const D: TDateTime; var Index: Integer): Boolean;
var
  L, H, I, C: Integer;
begin
  Result := False;
  if FCount=0 then begin Index:=-1; exit end;
  L := 0;
  H := FCount - 1;
  if D<FList^[L].FDate then begin Index:=-1; exit end else
   if D>=FList^[H].FDate then begin Result:=true; Index:=H; exit end;
  while H-L>1 do begin
    I := (L + H) shr 1;
    C := CompDateTime(FList^[I].Fdate, D);
    if C < 0 then L := I else
    begin
      H := I;
      if C = 0 then if Duplicates <> dupAccept then L := I;
    end;
  end;
  Index := L;
  Result:=true;
end;

procedure TDateList.Insert(Index: Integer; const D: TDateTime);
begin
  if Sorted then Error('SSortedListError', 0);
  if (Index < 0) or (Index > FCount) then Error('SListIndexError', Index);
  InsertItem(Index, D);
end;

function TDateList.IndexOf(const D: TDateTime): Integer;
begin
 if not Find(D, Result) then Result := -1;
end;

procedure TDateList.Sort;
begin
 if not Sorted and (FCount > 1) then QuickSort(0, FCount - 1);
end;

procedure TDateList.FreeObjects;
var i:integer;
begin
 for i:=0 to Count-1 do if Assigned(Objects[i]) then Objects[i].Free
end;

{---------------TDateList----------------------------------}

destructor TIDList.Destroy;
begin
  inherited Destroy;
  if OwnsObjects then FreeObjects;
  FCount := 0;
  SetCapacity(0);
end;

function TIDList.Add(ID: cardinal): Integer;
begin
 if not Sorted then Result := FCount
 else
  case Duplicates of
   dupIgnore: Find(ID, Result);
   dupError: if Find(ID, Result) then Error('SDuplicateString', 0);
  end;
 InsertItem(Result, ID);
end;

function TIDList.AddObject(ID: cardinal; AObject: TObject): Integer;
begin
  Result := Add(ID);
  PutObject(Result, AObject);
end;

procedure TIDList.Error(const Msg: string; Data: Integer);

  function ReturnAddr: Pointer;
  asm
          MOV     EAX,[EBP+4]
  end;

begin
  raise EStringListError.CreateFmt(Msg, [Data]) at ReturnAddr;
end;

procedure TIDList.Exchange(Index1, Index2: Integer);
var
  TempObject: TObject;
  Temp: cardinal;
begin
    Temp := Ids[Index1];
    TempObject := Objects[Index1];
    Ids[Index1] := Ids[Index2];
    Objects[Index1] := Objects[Index2];
    Ids[Index2] := Temp;
    Objects[Index2] := TempObject;
end;

function TIDList.GetCapacity: Integer;
begin
  Result := FCapacity;
end;

function TIDList.IndexOfObject(AObject: TObject): Integer;
begin
  for Result := 0 to GetCount - 1 do
    if GetObject(Result) = AObject then Exit;
  Result := -1;
end;

procedure TIDList.InsertObject(Index: Integer; ID: cardinal; AObject: TObject);
begin
  Insert(Index, ID);
  PutObject(Index, AObject);
end;

procedure TIDList.Put(Index: Integer; ID: cardinal);
begin
  if Sorted then Error('SSortedListError', 0);
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  FList^[Index].FID := ID;
end;

function TIDList.GetObject(Index: Integer): TObject;
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  Result := FList^[Index].FObject;
end;

procedure TIDList.ExchangeItems(Index1, Index2: Integer);
var
  Temp: Integer; TempD: cardinal;
  Item1, Item2: PIDItem;
begin
  Item1 := @FList^[Index1];
  Item2 := @FList^[Index2];
  TempD := Item1^.FID;
  Item1^.FID := Item2^.FID;
  Item2^.FID := TempD;
  Temp := Integer(Item1^.FObject);
  Integer(Item1^.FObject) := Integer(Item2^.FObject);
  Integer(Item2^.FObject) := Temp;
end;

procedure TIDList.Grow;
var Delta: Integer;
begin
  if FCapacity > 64 then Delta := FCapacity div 4 else
    if FCapacity > 8 then Delta := 16 else
      Delta := 4;
  SetCapacity(FCapacity + Delta);
end;

function CompID(d1, d2: cardinal): integer;
begin
 if d1>d2 then Result:=1 else if d1<d2 then Result:=-1 else Result:=0
end;

procedure TIDList.QuickSort(L, R: Integer);
var
  I, J: Integer;
  P: cardinal;
begin
  repeat
    I := L;
    J := R;
    P := FList^[(L + R) shr 1].FID;
    repeat
      while CompDateTime(FList^[I].FID, P) < 0 do Inc(I);
      while CompDateTime(FList^[J].FID, P) > 0 do Dec(J);
      if I <= J then
      begin
        ExchangeItems(I, J);
        Inc(I);
        Dec(J);
      end;
    until I > J;
    if L < J then QuickSort(L, J);
    L := I;
  until I >= R;
end;

procedure TIDList.InsertItem(Index: Integer; ID: cardinal);
begin
  if FCount = FCapacity then Grow;
  if Index < FCount then
    System.Move(FList^[Index], FList^[Index + 1],
      (FCount - Index) * SizeOf(TIDItem));
  with FList^[Index] do
  begin
    FObject := nil;
    FID := ID;
  end;
  Inc(FCount);
end;

procedure TIDList.SetSorted(Value: Boolean);
begin
  if FSorted <> Value then
  begin
    if Value then Sort;
    FSorted := Value;
  end;
end;

function TIDList.Get(Index: Integer): cardinal;
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  Result := FList^[Index].FID;
end;

function TIDList.GetCount: Integer;
begin
  Result := FCount;
end;

procedure TIDList.PutObject(Index: Integer; AObject: TObject);
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  FList^[Index].FObject := AObject;
end;

procedure TIDList.SetCapacity(NewCapacity: Integer);
begin
  ReallocMem(FList, NewCapacity * SizeOf(TIDItem));
  FCapacity := NewCapacity;
end;

procedure TIDList.Clear;
begin
  if FCount <> 0 then
  begin
    FCount := 0;
    SetCapacity(0);
  end;
end;

procedure TIDList.Delete(Index: Integer);
begin
  if (Index < 0) or (Index >= FCount) then Error('SListIndexError', Index);
  Dec(FCount);
  if Index < FCount then
    System.Move(FList^[Index + 1], FList^[Index],
      (FCount - Index) * SizeOf(TIDItem));
end;

function TIDList.Find(ID: cardinal; var Index: Integer): Boolean;
var
  L, H, I: Integer; C: Cardinal;
begin
  Result := False;
  L := 0;
  H := FCount - 1;
  while L<=H do begin
    I := (L + H) shr 1;
    C:=FList^[I].FId;
    if C < ID then L := I +1 else
    begin
      H := I - 1;
      if C = ID then begin
       Result := True;
       L := I;
      end;
    end;
  end;
  Index := L;
end;

procedure TIDList.Insert(Index: Integer; ID: cardinal);
begin
  if Sorted then Error('SSortedListError', 0);
  if (Index < 0) or (Index > FCount) then Error('SListIndexError', Index);
  InsertItem(Index, ID);
end;

function TIDList.IndexOf(ID: cardinal): Integer;
begin
 if not Find(ID, Result) then Result := -1;
end;

procedure TIDList.Sort;
begin
 if not Sorted and (FCount > 1) then QuickSort(0, FCount - 1);
end;

procedure TIDList.FreeObjects;
var i: integer;
begin
 for i:=0 to Count-1 do if Assigned(Objects[i]) then Objects[i].Free
end;


function IntToStr2(value: integer): string;
begin
 Result:=inttostr(value);
 if length(Result)=1 then Result:='0'+Result;
end;

function StrtoInt2(const s: string): integer;
begin
 Result:=1;
 while (Result<=Length(s)) and (s[Result]='0') do inc(Result);
 if Result>length(s) then Result:=0
  else Result:=StrtoInt(copy(s, Result, MaxInt));
end;

function LongTimetoStr(t: TDateTime): string;
begin
 Result:=FormatDateTime('hh:mm:ss', t);
 if t>=1 then Result:=IntToStr(trunc(t*24))+copy(Result, 3, maxint);
end;

function StrtoLongTime(const s: string): TDateTime;
var n: integer; s1: string;
begin
 s1:=copy(s, 1, pos(':', s)-1);
 n:=strtoint2(s1);
 Result:=StrtoTime('00'+copy(s, pos(':', s), maxint))+n/24;
end;

function ReadIni(const IniFile, Section, Param: string): string;
var II: TIniFile;
begin
 II:=TIniFile.Create(IniFile);
 try
   Result:=II.ReadString(Section,Param,'');
 finally II.Free end;
end;

procedure WriteIni(const IniFile, Section, Param, Value: string);
var II: TIniFile;
begin
 II:=TIniFile.Create(IniFile);
 try
   II.WriteString(Section,Param,Value);
 finally II.Free end;
end;

procedure StrToTokens(s, delims: string; L:TStringList);
begin
 while length(s)>0 do L.Add(Q_StrTok(s, delims));
end;

function IIF(b:boolean; const s1, s2: string): string;
begin
 if b then Result:=s1 else Result:=s2
end;

function IIF(b:boolean; n1,n2:integer):integer;
begin
 if b then Result:=n1 else Result:=n2
end;

function IIF(b:boolean; r1,r2:extended):Extended;
begin
 if b then Result:=r1 else Result:=r2
end;

function Decode(const s: string; const Values: array of string): string;
var i:integer;
begin
 for i:=0 to High(Values) div 2 do
  if Values[i*2]=s then begin
   Result:=Values[i*2+1];
   exit
  end;
 Result:=Values[High(Values)]
end;

function StrIn(const s: string; const Values: array of string): boolean;
var i:integer;
begin
 for i:=0 to High(Values) do
  if Values[i]=s then begin Result:=true; exit end;
 Result:=false;
end;

function CopyToPos(const s, substr: string): string;
begin
 Result:=copy(s, 1, pos(substr, s)-1)
end;

function StartsWith(const s, start: string): boolean;
begin
 Result:=Q_SameStrL(s, start, length(start))
end;

function EndsWith(const s, send: string): boolean;
begin
 Result:=copy(s, length(s)-length(send)+1, MaxInt)=send
end;

procedure DirectorytoStringList(Dir: string; L: TStringList);
var F: TSearchRec; Found:integer;
begin
 L.Clear;
 if EndsWith(Dir, '\') then Dir:=Dir+'*.*';
 Found:=FindFirst(Dir, faAnyFile, F);
 while Found=0 do begin
  if (copy(F.Name,1,1)<>'.') and ((F.Attr and faDirectory)=0) then L.Add(F.Name);
  Found:=FindNext(F);
 end;
 SysUtils.FindClose(F);
end;

procedure SubdirstoStringList(Dir: string; L: TStringList);
var F: TSearchRec; Found: integer;
begin
 L.Clear;
 if EndsWith(Dir, '\') then Dir:=Dir+'*.*';
 Found:=FindFirst(Dir, faAnyFile, F);
 while Found=0 do begin
  if (copy(F.Name,1,1)<>'.') and ((F.Attr and faDirectory)<>0) then L.Add(F.Name);
  Found:=FindNext(F);
 end;
 SysUtils.FindClose(F);
end;


function iStrtoFloat(const s: string): extended;
begin
 if s='' then Result:=0 else Result:=StrtoFloat(Q_ReplaceStr(Q_ReplaceStr(s,',',DecimalSeparator),'.',DecimalSeparator));
end;

function iStrtoCurr(const s:string): currency;
begin
 if s='' then Result:=0 else Result:=StrtoCurr(Q_ReplaceStr(Q_ReplaceStr(s,',',DecimalSeparator),'.',DecimalSeparator));
end;

function Trans(const s: string): string; begin Result:=s end;

function BooltoStr(b:boolean):string; begin if b then Result:='1' else Result:='0' end;

function ExtractQuotedStr(var s:string):string;
var p:integer;
begin
 p:=2; 
 while p<length(s) do begin
  if s[p]='''' then begin
   if (p<length(s)) and (s[p+1]<>'''') then break else inc(p);
  end else inc(p)
 end;
 Result:=Q_ReplaceStr(copy(s,2,p-2),'''''','''');
 delete(s,1,p);
end;

function Dow(Date: TDateTime):integer;
begin
 Result:=DayofWeek(Date)-1;
 if Result=-1 then Result:=7
end;

function MonthStart(Date: TDateTime):TDateTime;
var Year, Month, Day: Word;
begin
 DecodeDate(Date, Year, Month, Day);
 Result := EncodeDate(Year, Month, 1);
end;

function PrevMonthStart(Date: TDateTime):TDateTime;
var Year, Month, Day: Word;
begin
 DecodeDate(Date, Year, Month, Day);
 Day := 1;
 if Month > 1 then Dec(Month)
 else begin
   Dec(Year);
   Month := 12;
 end;
 Result := EncodeDate(Year, Month, 1);
end;


function MonthEnd(Date: TDateTime):TDateTime;
var Year, Month, Day: Word;
begin
 DecodeDate(Date, Year, Month, Day);
 if Month=12 then begin Month:=1; inc(Year) end else inc(Month);
 Result := EncodeDate(Year, Month, 1)-1;
end;

function YearStart(Date: TDateTime):TDateTime;
var Year, Month, Day: Word;
begin
 DecodeDate(Date, Year, Month, Day);
 Result := EncodeDate(Year, 1, 1);
end;

function YearEnd(Date: TDateTime):TDateTime;
var Year, Month, Day: Word;
begin
 DecodeDate(Date, Year, Month, Day);
 Result := EncodeDate(Year+1, 1, 1)-1;
end;

function DaysPerMonth(AYear, AMonth: Integer): Integer;
const
  DaysInMonth: array[1..12] of Integer =
    (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
begin
  Result := DaysInMonth[AMonth];
  if (AMonth = 2) and IsLeapYear(AYear) then Inc(Result); { leap-year Feb is special }
end;

function LastDayofYear(Date: TDateTime): TDateTime;
var dd, mm, yy: word;
begin
 DecodeDate(Date, yy, mm, dd);
 Result:=EncodeDate(yy, 12, 31);
end;

function LastDayofMonth(Date: TDateTime): TDateTime;
var dd, mm, yy: word;
begin
 DecodeDate(Date, yy, mm, dd);
 Result:=EncodeDate(yy, mm, DaysperMonth(yy, mm));
end;

function FirstDayofMonth(Date: TDateTime): TDateTime;
var dd, mm, yy: word;
begin
 DecodeDate(Date, yy, mm, dd);
 Result:=EncodeDate(yy, mm, 1);
end;


const CodeChars:string='0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';

function CodeWordChange(PresentCode:string; Step:integer):string;
var t1,t2,n1,n2:integer;
begin
 if PresentCode='' then PresentCode:='00' else
 if length(PresentCode)=1 then PresentCode:='0'+PresentCode;
 t1:=abs(Step) div length(CodeChars);
 t2:=abs(Step) mod length(CodeChars);
 n2:=pos(PresentCode[2],CodeChars);
 n1:=pos(PresentCode[1],CodeChars);
 if Step>=0 then begin
  if n2+t2>length(CodeChars) then begin
   inc(t1);
   dec(t2,length(CodeChars));
  end;
 Result:=CodeChars[n1+t1]+CodeChars[n2+t2]
 end else begin
  if n2-t2<1 then begin
   inc(t1);
   dec(t2,length(CodeChars));
  end;
  if n1-t1<=0 then Result:='00' else
   Result:=CodeChars[max(n1-t1,1)]+CodeChars[n2-t2]
 end;
end;

function ShiftStr(const s: string; shift:integer):string;
var i:integer;
begin
 Result:=s;
 for i:=1 to length(Result) do Result[i]:=char(ord(Result[i])+shift);
end;

function RemoveTags(s:string):string;
begin
 while pos('<',s)>0 do
  if pos('>',s)>pos('<',s) then s:=copy(s,1,pos('<',s)-1)+copy(s,pos('>',s)+1,maxInt)
   else s:=copy(s,1,pos('<',s)-1);
 Result:=s;
end;                     

function RemoveTagsInsideTag(s,tag:string):string;
var n2:integer;
begin
 Result:='';
 while pos('<'+tag,s)>0 do begin
  Result:=Result+copy(s,1,pos('<'+tag,s));
  delete(s,1,pos('<'+tag,s));
  Result:=Result+copy(s,1,pos('>',s));
  delete(s,1,pos('>',s));
  n2:=pos('</'+tag+'>',s);
  Result:=Result+RemoveTags(copy(s,1,n2-1));
  delete(s,1,n2-1);
  Result:=Result+copy(s,1,pos('>',s));
  delete(s,1,pos('>',s));
 end; 
end;

function StrtoIP(const s: string): cardinal;
var i, n1, n2: integer; t: byte;
begin
 Result:=0; n2:=length(s)+1;
 for i:=0 to 3 do begin
  n1:=n2-1;
  while (n1>0) and (s[n1]<>'.') do dec(n1);
  t:=StrtoInt(copy(s, n1+1, n2-n1-1));
  Result:=Result+(t shl (8*i));
  n2:=n1;
 end;
end;

function IPtoStr(ip: cardinal): string;
var i: integer; t: byte;
begin
 Result:='';
 for i:=0 to 3 do begin
  t:=IP and $FF;
  Result:=IntToStr(t)+'.'+Result;
  ip:=ip shr 8;
 end;
 SetLength(Result, Length(Result)-1);
end;

function Q_TestByMask(const S, Mask: string; MaskChar: Char): Boolean;
asm
        TEST    EAX,EAX
        JE      @@qt2
        PUSH    EBX
        TEST    EDX,EDX
        JE      @@qt1
        MOV     EBX,[EAX-4]
        CMP     EBX,[EDX-4]
        JE      @@01
@@qt1:  XOR     EAX,EAX
        POP     EBX
@@qt2:  RET
@@01:   DEC     EBX
        JS      @@07
@@lp:   MOV     CH,BYTE PTR [EDX+EBX]
        CMP     CL,CH
        JNE     @@cm
        DEC     EBX
        JS      @@eq
        MOV     CH,BYTE PTR [EDX+EBX]
        CMP     CL,CH
        JNE     @@cm
        DEC     EBX
        JS      @@eq
        MOV     CH,BYTE PTR [EDX+EBX]
        CMP     CL,CH
        JNE     @@cm
        DEC     EBX
        JS      @@eq
        MOV     CH,BYTE PTR [EDX+EBX]
        CMP     CL,CH
        JNE     @@cm
        DEC     EBX
        JNS     @@lp
@@eq:   MOV     EAX,1
        POP     EBX
        RET
@@cm:   CMP     CH,BYTE PTR [EAX+EBX]
        JNE     @@07
        DEC     EBX
        JNS     @@lp
        MOV     EAX,1
        POP     EBX
        RET
@@07:   XOR     EAX,EAX
        POP     EBX
end;


function Q_TestWildStr(const S, Mask: string; MaskChar, WildCard: Char): Boolean;
label 99;
var
  L, X, X0, Q, ML: Integer;
  P, P1, B: PChar;
  C: Char;
begin
  X:= Q_StrScan(Mask, WildCard);
  Q:= Q_StrScan(Mask, MaskChar);
  if X = 0 then begin
    if Q=0 then Result:=Q_SameStr(s, Mask) else Result:=Q_TestByMask(S, Mask, MaskChar);
    Exit;
  end;
  ML:=length(Mask);
  if (X=1) and (ML=1) then begin Result:=true; exit end;
  if X=ML then begin
    if Q=0 then Result:=Q_SameStrL(s, Mask, ML-1)
     else Result:=Q_TestByMask(copy(s, 1, ML-1), copy(Mask, 1, ML-1), MaskChar);
    exit
  end;
  L := Length(S);
  P := Pointer(S);
  Result := False;
  B := Pointer(Mask);
  Q := X-1;
  if L < Q then Exit;
  while Q > 0 do begin
    C := B^;
    if (C<>MaskChar) and (C<>P^) then Exit;
    Dec(Q);
    Inc(B);
    Inc(P);
  end;
  Dec(L,X-1);
  repeat
    X0 := X;
    P1 := P;
    while (X0<=ML) and (Mask[X0] = WildCard) do Inc(X0);
    X := Q_StrScan(Mask,WildCard,X0);
    if X = 0 then Break;
  99:
    P := P1;
    B := @Mask[X0];
    Q := X-X0;
    if L < Q then Exit;
    while Q > 0 do begin
      C := B^;
      if (C<>MaskChar) and (C<>P^) then
      begin
        Inc(P1);
        Dec(L);
        goto 99;
      end;
      Dec(Q);
      Inc(B);
      Inc(P);
    end;
    Dec(L,X-X0);
  until False;
  X := ML;
  if L >= X-X0+1 then
  begin
    P := Pointer(S);
    Inc(P,Length(S)-1);
    while X >= X0 do
    begin
      C := Mask[X];
      if (C<>MaskChar) and (C<>P^) then
        Exit;
      Dec(X);
      Dec(P);
    end;
    Result := True;
  end;
end;

function Q_StrScan(const S: string; Ch: Char; StartPos: Integer): Integer;
asm
        TEST    EAX,EAX
        JE      @@qt
        PUSH    EDI
        MOV     EDI,EAX
        LEA     EAX,[ECX-1]
        MOV     ECX,[EDI-4]
        SUB     ECX,EAX
        JLE     @@m1
        PUSH    EDI
        ADD     EDI,EAX
        MOV     EAX,EDX
        POP     EDX
        REPNE   SCASB
        JNE     @@m1
        MOV     EAX,EDI
        SUB     EAX,EDX
        POP     EDI
        RET
@@m1:   POP     EDI
        XOR     EAX,EAX
@@qt:
end;

{IFDEF LINUX}
{function Q_PStrScan(P: Pointer; Ch: Char; ASize: Integer): Integer;
begin
 Result:=pos(ch, copy(pchar(p), 1, ASize));
end;}

{ELSE}
function Q_PStrScan(P: Pointer; Ch: Char; ASize: Integer): Integer;
asm
        TEST    EAX,EAX
        JE      @@qt
        TEST    ECX,ECX
        JE      @@qt
        PUSH    EDI
        MOV     EDI,EAX
        {LEA     EAX,[ECX-1]
        MOV     ECX,[EDI-4]
        SUB     ECX,EAX
        JLE     @@m1}
        PUSH    EDI
//        ADD     EDI,EAX
        MOV     EAX,EDX
        POP     EDX
        REPNE   SCASB
        JNE     @@m1
        MOV     EAX,EDI
        SUB     EAX,EDX
        POP     EDI
        RET
@@m1:   POP     EDI
        XOR     EAX,EAX
@@qt:
end;
{ENDIF}

function Q_ScanLongWord(N: cardinal; ArrPtr: Pointer; Count: Cardinal): Integer;
asm
        TEST    ECX,ECX
        JE      @@m1
        PUSH    EDI
        MOV     EDI,EDX
        REPNE   SCASD
        JNE     @@m2
        MOV     EAX,EDI
        SUB     EAX,EDX
        POP     EDI
        SHR     EAX,2
        DEC     EAX
        RET
@@m2:   POP     EDI
@@m1:   MOV     EAX,$FFFFFFFF
end;


function HTTPDecode(AStr: String): String;
var Sp, Rp, Cp: PChar;
begin
 SetLength(Result, Length(AStr));
 Astr:=Astr+#0;
 Sp := PChar(AStr);
 Rp := PChar(Result);
 while Sp^ <> #0 do
 begin
   if not (Sp^ in ['+','%']) then Rp^ := Sp^
   else
     if Sp^ = '+' then Rp^ := ' '
     else begin
       inc(Sp);
       if Sp^ = '%' then Rp^ := '%'
       else if Sp^ in ['0'..'9','A'..'F']  then begin
        Cp := Sp;
        Inc(Sp);
        if Sp^ in ['0'..'9','A'..'F'] then Rp^ := Chr(StrToInt('$'+Cp^+Sp^));
       end;
     end;
   Inc(Rp);
   Inc(Sp);
 end;
 SetLength(Result, Rp - PChar(Result));
end;

procedure AddStr(var s:string; s1:string; delimiter:string=',');
begin
 if s='' then s:=s1 else s:=s+delimiter+s1;
end;

function WordPos(word,s:string):integer;
var n,start:integer;
const delims=#13#10+' .,{}()/<>+-~@#$%^&*?";:''';
begin
 word:=Q_UpperCase(word);
 s:=Q_UpperCase(s);
 Result:=0;
 start:=1;
 n:=Q_PosStr(word,s,start);
 while n>0 do begin
  if ((n=1) or (pos(s[n-1],delims)>0)) and ( (n+length(word)-1=length(s)) or (pos(s[n+length(word)],delims)>0) )
   then begin
   Result:=n;
   exit
  end;
  start:=n+1;
  n:=Q_PosStr(word,s,start);
 end;
end;

function MathRound(x:extended): integer;
begin
 Result:=round(x);
 if (frac(x)=0.5) and not odd(trunc(x)) then inc(Result);
end;

function DecodeString(s: string): string;
var s1: string;
begin
 if StartsWith(s, '^') then begin
  Result:='';
  while Pos('^', s)>0 do begin
   Delete(s, 1, Pos('^', s));
   if Pos('^', s)=0 then s1:=s else s1:=copy(s, 1, Pos('^', s)-1);
   Delete(s, 1, Length(s1));
   Result:=Result+char(strtoint(trim(s1)));
  end
 end else Result:=s
end;

function HextoStr(const s: string): string;
var i:integer;
begin
 Result:='';
 for i:=1 to length(s) do Result:=Result+inttohex(integer(s[i]),2);
end;

procedure InsertStr(const s1: string; var s: string; p: integer);
begin
 delete(s,p+1,length(s1));
 insert(s1,s,p+1);
end;

procedure FileAppend(const FileName, s: string);
var f:integer;
begin
 f:=FileOpen(FileName,FMOpenReadWrite+FMShareDenyNone);
 try
  FileSeek(f, 0, 2);
  FileWrite(f, s[1], length(s));
 finally FileClose(f) end;
end;

procedure FreeListObjects(L: TStringList);
var i:integer;
begin
 for i:=0 to L.Count-1 do L.Objects[i].Free;
end;

function iStrtoInt(const s: string): int64;
begin
 if s='' then Result:=0 else Result:=StrtoInt64(s)
end;

function StrtoDateFmt(const s, format:string): TDateTime;
var si, sn: integer; yy, dd, mm, hh, nn, ss: word; fi, fn: pchar; PMTime, HasTime: boolean; sx: string;
begin
 if Format='cisco' then begin
  sx:=s;
  si:=Q_StrScan(sx, '=');
  if si>0 then Delete(sx, 1, si);
  if StartsWith(sx, '*') then Delete(sx, 1, 1);
  sx:=Copy(sx, 1, 8)+' '+trim(Copy(sx, Length(sx)-10, MaxInt));
  Result:=StrtoDateFmt(sx, 'hh:nn:ss mmm d yyyy');
  exit
 end;
 HasTime:=False; PMTime:=False;
 yy:=0; dd:=0; mm:=0; hh:=0; nn:=0; ss:=0;
 fi:=@format[1]; si:=1; fn:=@format[length(format)]; sn:=length(s);
 while (fi<=fn) and (si<=sn) do begin
  case fi^ of

   'd': if (fn-fi>0) and (pchar(fi+1)^<>'d') and (si<sn) and not (s[si+1] in ['0'..'9']) then begin
         dd:=StrtoInt(s[si]);
         inc(si);
         inc(fi);
        end else begin
         dd:=StrtoInt(trim(copy(s, si, 2)));
         inc(si, 2);
         if (fn-fi>0) and (pchar(fi+1)^='d') then inc(fi, 2) else Inc(fi);
        end;

   'h': begin hh:=StrtoInt(trim(copy(s,si,2))); inc(si,2); inc(fi,2); HasTime:=true end;
   'm': if (fn-fi>1) and (pchar(fi+2)^='m') then begin
         if sn-si>1 then
          case s[si] of
           'a': if s[si+1]='p' then mm:=4 else if s[si+1]='u' then mm:=8;
           'd': if s[si+1]='e' then mm:=12;
           'f': if s[si+1]='e' then mm:=2;
           'j': if s[si+1]='a' then mm:=1 else if s[si+2]='n' then mm:=6 else if s[si+2]='l' then mm:=7;
           'm': if s[si+2]='r' then mm:=3 else if s[si+2]='y' then mm:=5;
           'n': if s[si+1]='o' then mm:=11;
           'o': if s[si+1]='c' then mm:=10;
           's': if s[si+1]='e' then mm:=9;
          end;
         inc(si,3); inc(fi,3);
        end else begin mm:=StrtoInt(trim(copy(s,si,2))); inc(si,2); inc(fi,2) end;
   'n': begin nn:=StrtoInt(trim(copy(s,si,2))); inc(si,2); inc(fi,2); HasTime:=true end;
   'p': begin if s[si]='a' then PMTime:=True; Inc(fi,2); Inc(si,2) end;
   's': begin ss:=StrtoInt(trim(copy(s,si,2))); inc(si,2); inc(fi,2); HasTime:=true end;
   'y': if (fn-fi>2) and (pchar(fi+2)^='y') then begin
         if (sn-si>2) then yy:=StrtoInt(trim(copy(s,si,4))) else raise Exception.Create('Invalid date/time');
         inc(si,4); inc(fi,4)
        end else begin
         yy:=StrtoInt(trim(copy(s,si,2)));
         if yy<50 then inc(yy,2000) else inc(yy,1900);
         inc(si,2); inc(fi,2)
        end;
   else begin inc(fi); inc(si) end;
  end;
 end;
 if (mm<1) or (mm>12) or (dd<1) or (dd>31) or (yy>9999) then raise Exception.Create('Invalid date/time')
  else begin
   Result:=EncodeDate(yy, mm, dd);
   if HasTime then begin
    if PMTime and (hh<12) then Inc(hh,12);
    if (hh>23) or (nn>59) or (ss>59) then raise Exception.Create('Invalid date/time')
     else Result:=Result+(hh*60*60+nn*60+ss)/(24*60*60);
   end;
  end;
end;


{ TStringRec2 }

constructor TString2Rec.Create(const xs, xs1: string);
begin
 s:=xs; s1:=xs1
end;

constructor TString3Rec.Create(const xs, xs1: string; const xs2: string='');
begin
 s:=xs; s1:=xs1; s2:=xs2
end;

function CaseFind(F: TStringList; const S: string; var Index: Integer): Boolean;
var L, H, I, C: Integer;
begin
  Result := False;
  L := 0;
  H := F.Count - 1;
  while L <= H do
  begin
    I := (L + H) shr 1;
    C := Q_CompStr(F[I], S);
    if C < 0 then L := I + 1 else
    begin
      H := I - 1;
      if C = 0 then
      begin
        Result := True;
        L := I;
      end;
    end;
  end;
  Index := L;
end;

function CaseIndexof(L: TStringList; const s: string): integer;
begin
 if not L.Sorted then begin
  for Result := 0 to L.Count - 1 do
    if Q_CompStr(L[Result], S) = 0 then Exit;
  Result := -1;
 end else if not CaseFind(L, s, Result) then Result:=-1;
end;

function Ceil(X: Extended): Integer;
begin
  Result := Integer(Trunc(X));
  if Frac(X) > 0 then
    Inc(Result);
end;

function Floor(X: Extended): Integer;
begin
  Result := Integer(Trunc(X));
  if Frac(X) < 0 then
    Dec(Result);
end;

function IntPower(Base: Extended; Exponent: Integer): Extended;
asm
        mov     ecx, eax
        cdq
        fld1                      { Result := 1 }
        xor     eax, edx
        sub     eax, edx          { eax := Abs(Exponent) }
        jz      @@3
        fld     Base
        jmp     @@2
@@1:    fmul    ST, ST            { X := Base * Base }
@@2:    shr     eax,1
        jnc     @@1
        fmul    ST(1),ST          { Result := Result * X }
        jnz     @@1
        fstp    st                { pop X from FPU stack }
        cmp     ecx, 0
        jge     @@3
        fld1
        fdivrp                    { Result := 1 / Result }
@@3:
        fwait
end;

function Power(Base, Exponent: Extended): Extended;
begin
  if Exponent = 0.0 then
    Result := 1.0               { n**0 = 1 }
  else if (Base = 0.0) and (Exponent > 0.0) then
    Result := 0.0               { 0**n = 0, n > 0 }
  else if (Frac(Exponent) = 0.0) and (Abs(Exponent) <= MaxInt) then
    Result := IntPower(Base, Integer(Trunc(Exponent)))
  else
    Result := Exp(Exponent * Ln(Base))
end;

function HexToDec(const p_str: string): integer;
const digits='0123456789abcdefghijklmnopqrstuvwxyz';
var str:string; i,c,digit:integer;
begin
 str :=Q_LowerCase(p_str);
 if (StartsWith(str, '0x')) then str := Copy(str, 3, length(str)-2);
 if (Copy(str, length(str), 1) = 'h') then str := Copy(str, 1, length(str)-1);
 c := 0;
 i := length(str);
 result := 0;
 while(i >= 1) do begin
   digit:= Pos(Copy(str, i, 1), digits)-1;
   result := digit * round(Power(16, c)) + result;
   Inc(c);
   Dec(i);
 end;
end;

function HexToCardinal(const p_str: string): cardinal;
const digits='0123456789abcdefghijklmnopqrstuvwxyz';
var str: string; i,c,digit:integer;
begin
 str :=Q_LowerCase(p_str);
 if (StartsWith(str, '0x')) then str := Copy(str, 3, length(str)-2);
 if (Copy(str, length(str), 1) = 'h') then str := Copy(str, 1, length(str)-1);
 c := 0;
 i := length(str);
 result := 0;
 while(i >= 1) do begin
   digit:= Pos(Copy(str, i, 1), digits)-1;
   result := digit * round(Power(16, c)) + result;
   Inc(c);
   Dec(i);
 end;
end;

function iFormatDateTime(const format: string; DateTime: TDateTime): string;
var yy, mm, dd: word;
begin
 if pos('mmm', format)>0 then begin
  Result:=FormatDateTime(Q_ReplaceStr(Q_ReplaceStr(format, 'ddd', '$#$'), 'mmm', '$@$'), DateTime);
  DecodeDate(DateTime, yy, mm, dd);
  Result:=Q_ReplaceStr(Result, '$@$', EMonthNames[mm]);
  Result:=Q_ReplaceStr(Result, '$#$', EDowNames[DayofWeek(DateTime)]);
 end else Result:=FormatDateTime(format, DateTime);
end;

function MonthList: string;
var i: Integer;
begin
 Result:=MonthNames[1];
 for i:=2 to 12 do Result:=Result+#13+MonthNames[i];
end;

procedure SetEnabled(const A:array of TObject; E: boolean);
var i: integer;
begin
 for i:=0 to High(A) do {if (A[i] is TControl) then (A[i] as TControl).Enabled:=E
  else if (A[i] is TMenuItem) then (A[i] as TMenuItem).Enabled:=E
 else} if E then SetPropValue(A[i], 'Enabled', 1) else SetPropValue(A[i], 'Enabled', 0);
end;

procedure SetVisible(const A:array of TObject; E: boolean);
var i: integer;
begin
 for i:=0 to High(A) do {if (A[i] is TControl) then (A[i] as TControl).Visible:=E
  else if (A[i] is TMenuItem) then (A[i] as TMenuItem).Visible:=E else}
 if E then SetPropValue(A[i], 'Visible', 1) else SetPropValue(A[i], 'Visible', 0);
end;

function  LoWord(t: cardinal): word;
begin
 Result:=word(t and $FFFF);
end;

function  HiWord(t: cardinal): word;
begin
 Result:=word((t shr 16) and $FFFF);
end;

{$IFDEF LINUX}
function GetTickCount: cardinal;
begin
 Result:=trunc((Now-round(Now-10))*24*60*60*1000);
end;
{$ENDIF}

function FileUpper(const s: string): string;
begin
 {$IFDEF LINUX}
 Result:=s
 {$ELSE}
 Result:=AnsiUpperCase(s)
 {$ENDIF}
end;

function CheckFilesExists(const Path, Files: string): string;
var s, s1: string;
begin
 Result:='';
 s:=Files;
 while s<>'' do begin
  s1:=trim(Q_StrTok(s, #13));
  if (s1<>'') and not FileExists(Path+s1) then AddStr(Result, s1, #13);
 end;
end;

function CompareDate(D1, D2: TDateTime): Integer;
begin
 if D1>D2 then Result:=1 else if D1<D2 then Result:=-1 else Result:=0
end; 

function CompareInteger(I1, I2: Integer): Integer;
begin
 if I1>I2 then Result:=1 else if I1<I2 then Result:=-1 else Result:=0
end;


initialization

 RootPath:=ExtractFilePath(Paramstr(0))

end.
