
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, DB, DBTables, Grids, DBGrids, ExtCtrls, xsdedit, strs,
  xmls, contnrs, xsdins;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Table1: TTable;
    Panel2: TPanel;
    Button1: TButton;
    Button2: TButton;
    DTable: TTable;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    Dictionaries: TStringList;
    procedure GetDictionary(Sender: TXMLInspector; const Name: string; var Dictionary: TXMLDictionary);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
var XE: TXSDEditor; SN: TXMLNode;
begin
 // Create an editor with XMLInspector
 SN := nil;
 XE := TXSDEditor.Create(Self);
 try
  // Generate XSD scheme for editing a table record
  SN := TXMLNode.Create(FileToStr(ExtractFilePath(ParamStr(0)) + 'scheme1.xsd'));

  // Add a new record to a table or edit the current record
  if Sender = Button2 then begin
    Table1.Append;
    XE.Caption := 'New Employee';
  end
  else begin
    Table1.Edit;
    XE.Caption := 'Edit Employee';
  end;
  XE.XP.OnGetDictionary:=GetDictionary;

  // Run a dialog form with XMLInspector and store (or cancel) changes
  try
    XE.Run(SN[0], CreateXMLTemplate(SN[0], True), Table1);
    if XE.ModalResult = mrOk then Table1.Post else Table1.Cancel;
  except
    Table1.Cancel;
    raise;
  end;
 finally
  XE.Free;
  SN.Free;
 end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Dictionaries:=TStringList.Create;
 Dictionaries.Sorted:=true;
end;

procedure TForm1.GetDictionary(Sender: TXMLInspector; const Name: string;
  var Dictionary: TXMLDictionary);
var n: integer; D, XN: TXMLNode;
begin
 if Dictionaries.Find(Name, n) then Dictionary:=TXMLDictionary(Dictionaries.Objects[n])
 else begin
  D:=TXMLNode.CreateFromFile(ExtractFilePath(Paramstr(0))+'dictionaries.xml');
  XN:=D.NodebyAttr('id', Name);
  if Assigned(XN) then begin
   Dictionary:=TXMLDictionary.Create;
   DTable.Close;
   DTable.TableName:=XN.Attr['table'];
   DTable.Open;
   while not DTable.Eof do begin
    Dictionary.AddItem(DTable.FieldbyName(XN.Attr['id_field']).AsString,
     TXMLNode.Create(Format('<item id="%s" name="%s"/>', [DTable.FieldbyName(XN.Attr['id_field']).AsString,
     DTable.FieldbyName(XN.Attr['name_field']).AsString])));
    DTable.Next;
   end;
   Dictionaries.AddObject(Name, Dictionary);
  end;
 end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
var i: integer;
begin
 for i:=0 to Dictionaries.Count-1 do Dictionaries.Objects[i].Free;
 Dictionaries.Free;
end;

end.
