unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  xsdins, StdCtrls, strs, xmls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    XMLInspector1: TXMLInspector;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure XMLInspector1DrawProperty(Sender: TXMLInspector;
      ARow: Integer; AEditor: TXSDSchemaEditor; AFont: TFont;
      var AColor: TColor);
  private
    { Private declarations }
  public
    Schema: TXMLNode;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
   // Load XSD scheme
   Schema := TXMLNode.CreateFromFile(ExtractFilePath(ParamStr(0)) + 'scheme.xsd');

   // Find the scheme node for object LegalCustomer
   XMLInspector1.Schema := Schema.NodebyAttr('name', 'LegalCustomer');

   // Try to load a stored XML-object or create a new one
   try
    XMLInspector1.CurNode := TXMLNode.CreatefromFile(ExtractFilePath(ParamStr(0)) + 'object.xml')
   except
    XMLInspector1.CurNode := CreateXMLTemplate(XMLInspector1.Schema, True);
   end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  // Save a current XML-object to a file
  StrtoFile(XMLInspector1.CurNode.FormattedCode(' '), ExtractFilePath(ParamStr(0)) + 'object.xml');
end;

procedure TForm1.XMLInspector1DrawProperty(Sender: TXMLInspector;
  ARow: Integer; AEditor: TXSDSchemaEditor; AFont: TFont;
  var AColor: TColor);
begin
  if Pos('SEND', AnsiUpperCase(AEditor.GetName)) <> 0 then AFont.Style := [fsBold];
  if Pos('NAME', AnsiUpperCase(AEditor.GetName)) <> 0 then AFont.Style := [fsBold, fsItalic];
  if AEditor.GetValue = '' then AFont.Color := clBlue;
end;

end.
