
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, DB, DBTables, Grids, DBGrids, ExtCtrls, xsdedit, strs,
  xmls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Table1: TTable;
    Panel2: TPanel;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    SchemeC: TComboBox;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
var XE: TXSDEditor; SN: TXMLNode;
begin
 // Create an editor with XMLInspector
 SN := nil;
 XE := TXSDEditor.Create(Self);
 try
  // Generate XSD scheme for editing a table record
  SN := TXMLNode.Create(FileToStr(ExtractFilePath(ParamStr(0)) + SchemeC.Items[SchemeC.ItemIndex]));

  // Add a new record to a table or edit the current record
  if Sender = Button2 then begin
    Table1.Append;
    XE.Caption := 'New Employee';
  end
  else begin
    Table1.Edit;
    XE.Caption := 'Edit Employee';
  end;

  // Run a dialog form with XMLInspector and store (or cancel) changes
  try
    XE.Run(SN[0], CreateXMLTemplate(SN[0], True), Table1);
    if XE.ModalResult = mrOk then Table1.Post else Table1.Cancel;
  except
    Table1.Cancel;
    raise;
  end;
 finally
  XE.Free;
  SN.Free;
 end;
end;

end.
