/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */
document.q_clientValidationSupport = true;

function q_Message(summary, detail, severity) {
  this.summary = summary;
  this.detail = detail;
  this.severity = severity;
}

function q_getValidators(input) {
  if (!input)
    return new Array();
  if (!input.validators) {
    input.validators = new Array();
  }
  return input.validators;
}

function q_getConverters(input) {
  var validators = q_getValidators(input);
  if (validators && validators.length > 0)
  {
    var converters = new Array();
    for (i = 0; i < validators.length; i++) {
      var validator = validators[i];
      if (validator && validator.type && validator.type == "converter")
      {
        converters.push(validator);
      }
    }
    return converters;
  }
  else
    return null;
}

function q_getValidatorsOnly(input) {
  var validators = q_getValidators(input);
  if (validators && validators.length > 0)
  {
    var result = new Array();
    for (i = 0; i < validators.length; i++) {
      var validator = validators[i];
      if ((!validator.type) || (!(validator.type && validator.type == "converter")))
      {
        result.push(validator);
      }
    }
    return result;
  }
  else
    return null;
}

function q_addValidator(input, validator) {
  var validators = q_getValidators(input);
  validators.push(validator);
}

function q_addValidatorsById(inputId, validators, clientValueFunction) {
  if (!inputId || !validators)
    return;
  var input = q__getElement(inputId);
  if (!input)
    return;
  q_getValidators(input).length = 0;
  for (var i = 0; i < validators.length; i++)
  {
    q_addValidator(input, validators[i]);
  }
  if (clientValueFunction) {
    input.q_clientValueFunction = clientValueFunction;
    input.q_clientValueFunctionExist = true;
  }

}

function q_mainValidate(input) {

  input.valid = true;

  q_getMessages(input).length = 0;

  var convertors = q_getConverters(input);
  var validators = q_getValidatorsOnly(input);

  if (convertors)
  {
    for (var i = 0; i < convertors.length; i++) {
      var converter = convertors[i];
      if (!converter.validate(input)) {
        input.valid = false;

      }
    }
  }

  if (input.valid == true && validators)
  {

    for (var i = 0; i < validators.length; i++) {
      var validator = validators[i];
      if (!validator.validate(input)) {
        input.valid = false;
      }
    }
  }

}

function q_autoValidate(input, fullValidation) {
  input.valid = true;
  if (!fullValidation) {
    if (input.autoValidate == false)
      return;
  }
  q_mainValidate(input);
}

function q_validate(input) {
  if (!input)
    q__assert(input, "q_validate: Input not found.");

  q_mainValidate(input);
  q_updateClientMessages();
  q_updateClientMessagesPosition();
  if (input.valid == false)
    return false;
  else
    return true;
}

function q_validateById(inputId) {

  var input = q__getElement(inputId);
  q__assert(input, "q_validateById: Element with" + inputId + " not found.");
  q_mainValidate(input);
  q_updateClientMessages();
  q_updateClientMessagesPosition();
  if (input.valid == false)
    return false;
  else
    return true;
}

function q_validateWithChildren(input) {
  var valid = q_validateRecursive(input, true);
  q_updateClientMessages();
  q_updateClientMessagesPosition();
  return valid;
}

function q_validateRecursive(element, fullValidation) {
  var valid = true;
  var children = element.childNodes;
  if (children && children.length > 0) {
    for (var i = 0; i < children.length; i++) {
      var child = children[i];
      if (child.validators || (q_getMessages(child) && q_getMessages(child).length > 0)) {
        q_autoValidate(child, fullValidation);
        if (!child.valid) {
          valid = false;
        }
      }
      if (!q_validateRecursive(child, fullValidation)) {
        valid = false;
      }
    }
  }
  return valid;
}

function q_validateForm(form) {

  if (form.q_skipValidation && form.q_skipValidation == true)
  {
    return true;
  }
  else {

    var valid = q_validateRecursive(form, true);
    q_updateClientMessages();
    return valid;
  }
}

function q__autoValidateForm(form) {
  if (form.q_skipValidation && form.q_skipValidation == true) {
    return true;
  } else {
    var valid = q_validateRecursive(form);
    q_updateClientMessages();
    return valid;
  }
}

function q_validateFormById(formId) {
  var form = q__getElement(formId);
  if (form)
    return q_validateForm(form);
  return false;
}

function q_validateEnclosingForm(element) {
  var form = q__findParentNode(element, "FORM");
  if (form) {
    var r = q_validateForm(form);
    return r;
  }
  return true;
}

function q_getValue(input) {
  if (input.q_clientValueFunctionExist == true) {
    return "" + input.q_clientValueFunction.call();
  }

  var value = '';

  if (input.tagName.toUpperCase() == "INPUT")
  {
    //validated component is input itself - so we will check input type
    if (input.type.toLowerCase == "checkbox" || input.type.toLowerCase == "radio") {
      if (input.checked)
        value = 'true';
      else
        value = 'false';
    }
    value = input.value;
  } else if (input.tagName.toUpperCase() == "SELECT") {
    if (input.type.toLowerCase() == "select-one") {
      for (var i = 0; i < input.options.length; i++) {
        if (input.options[i].selected)
          value = input.options[i].value;
      }

    } else {
      var selected = new Array();
      for (var i = 0; i < input.options.length; i++) {
        if (input.options[i].selected) {
          selected.push(input.options[i].value);
        }
      }
      if (selected.length > 0) {
        value = selected;
      }
    }

  } else if (input.tagName.toUpperCase() == "TEXTAREA") {
    value = input.value;
  } else
  {
    //validated component - it is a container - for example, html table with a group of inputs
    var inputs = input.getElementsByTagName("input");
    if (inputs && inputs.length > 0)
    {
      var selected = new Array();
      for (var i = 0; i < inputs.length; i++)
      {
        if (inputs[i].checked) {
          selected.push(inputs[i].value);
        }
      }

      if (selected.length > 0) {
        value = selected;
      }
    }
  }
  //alert("id: " + input.id + " ; value= " + value);
  return value;
}

function q_notEmpty(value) {
  return value && value.length > 0;
}

//TODO:resolve
function q_getMessages(input) {
  if (!input.q_messages)
  {
    try {
      input.q_messages = new Array();
    } catch(e) {
    }
  }
  return input.q_messages;
}

function q_getGlobalMessages() {
  if (!document.q_globalMessages)
  {
    document.q_globalMessages = new Array();
  }
  return document.q_globalMessages;
}

function q_getAllMessages(globalOnly) {
  if (!globalOnly)
  {
    var messages = new Array();
    q_getAllMessageRecursive(document, messages);
    return messages;
  } else
    return q_getGlobalMessages();
}

function q_getAllMessageRecursive(element, messages) {
  var children = element.childNodes;
  if (children && children.length > 0) {
    for (var i = 0; i < children.length; i++) {
      var child = children[i];
      q_addMessageFromChild(messages, child);
      q_getAllMessageRecursive(child, messages);
    }
  }
}

function q_addMessageFromChild(messages, child) {
  try {
    var im = q_getMessages(child);
    for (var i = 0; i < im.length; i++) {
      messages.push(im[i]);
    }
  } catch(e) {
    //todo: to something
  }

}


function q_addMessage(input, summary, detail, severity) {
  var messages = q_getMessages(input);
  if (!severity)
    severity = 'error';
  var message = new q_Message(summary, detail, severity);
  messages.push(message);

}

function q_addMessageById(inputId, summary, detail, severity) {
  var input = document.getElementById(inputId);
  q_addMessage(input, summary, detail, severity);
}

function q_addGlobalMessage(summary, detail, severity) {
  var messages = q_getGlobalMessages();
  var message = new q_Message(summary, detail, severity);
  messages.push(message);
}

function q_getClientMessageRenderers() {

  if (!document.td_clientMessageRenderers) {
    document.td_clientMessageRenderers = new Array();
  }
  return document.td_clientMessageRenderers;
}

function q_getMessagesRenderers() {
  if (!document.q_messagesRenderers) {
    document.q_messagesRenderers = new Array();
  }
  return document.q_messagesRenderers;
}

function q_addClientMessageRenderer(clientMessageRenderer) {
  var clientMessageRenderers = q_getClientMessageRenderers();
  clientMessageRenderers.push(clientMessageRenderer);
}

function q_addMessagesRenderer(messagesRenderer) {
  var messagesRenderers = q_getMessagesRenderers();
  messagesRenderers.push(messagesRenderer);
}

function q_updateClientMessages() {

  var messagesRenderers = q_getMessagesRenderers();
  for (var i = 0; i < messagesRenderers.length; i++) {
    messagesRenderers[i].update();
  }

  var clientMessageRenderers = q_getClientMessageRenderers();
  for (var i = 0; i < clientMessageRenderers.length; i++) {
    clientMessageRenderers[i].update();
  }
}

function q_updateClientMessagesPosition() {
  var clientMessageRenderers = q_getClientMessageRenderers();
  for (var i = 0; i < clientMessageRenderers.length; i++) {
    var clientMessageRenderer = clientMessageRenderers[i];
    if (clientMessageRenderer.position) {
      clientMessageRenderer.position();
    }
  }
}

function q_addOnSubmitEvent(func, frmId) {
  // var element = document.getElementById(elementId);
  // q__assert(element, "q_addOnSubmitEvent: Element with id: " + elementId + " not found.");
  //var frm = q__findParentNode(element, "FORM");
  //q__assert(frm, "q_addOnSubmitEvent: Enclosing form not found for element with id: " + elementId);
  var frm = q__getElement(frmId);
  q__assert(frm, "q_addOnSubmitEvent: Form not found. id: " + frmId);
  var oldonsubmit = frm.onsubmit;

  if (typeof frm.onsubmit != 'function') {
    frm.onsubmit = function() {
      return func(frm);
    }
  } else {
    frm.onsubmit = function() {
      oldonsubmit();
      return func(frm);
    }
  }

}


function q_isLong(value) {
  if (!/^[+-]?\d+$/.test(value)) {
    return false;
  }
  ivalue = parseInt(value);
  if (ivalue > 0x7fffffffffffffff) {
    return false;
  }
  if (ivalue < -0x8000000000000000) {
    return false;
  }
  return true;
}

function q_getLong(value) {
  if (!q_isLong(value))
    return null;
  return parseInt(value);
}

function q_isInt(value) {
  if (!/^[+-]?\d+$/.test(value)) {
    return false;
  }
  ivalue = parseInt(value);
  if (ivalue > 0x7fffffff) {
    return false;
  }
  if (ivalue < -0x80000000) {
    return false;
  }
  return true;
}


function q_isBigInt(value) {
  if (!/^[+-]?\d+$/.test(value)) {
    return false;
  }
  return true;
}


function q_isBigDecimal(value) {
  if (isNaN(value)) {
    return false;
  }
  fvalue = parseFloat(value);
  return true;
}

//TODO: fix
function q_isCharacter(value) {
  return true;
}

function q_isShort(value) {
  if (!/^[+-]?\d+$/.test(value)) {
    return false;
  }
  ivalue = parseInt(value);
  if (ivalue > 32767) {
    return false;
  }
  if (ivalue < -32768) {
    return false;
  }
  return true;
}

function q_isByte(value) {
  if (!/^[+-]?\d+$/.test(value)) {
    return false;
  }
  ivalue = parseInt(value);
  if (ivalue > 127) {
    return false;
  }
  if (ivalue < -128) {
    return false;
  }
  return true;
}

function q_isFloat(value) {
  if (isNaN(value)) {
    return false;
  }
  fvalue = parseFloat(value);
  if (fvalue > 3.4028235e+38) {
    return false;
  }
  if (fvalue < -3.4028235e+38) {
    return false;
  }
  return true;
}

function q_isDouble(value) {
  if (isNaN(value)) {
    return false;
  }
  fvalue = parseFloat(value);
  if (fvalue > 1.7976931348623157e+308) {
    return false;
  }
  if (fvalue < -1.7976931348623157e+308) {
    return false;
  }
  return true;
}

function q_matchRegExp(value, regExp) {
  return regExp.test(value);
}

function q_addNotValidatedInputs(ids) {
  if (!ids)
    return;
  if (ids.length == 0)
    return;
  for (var i = ids.length - 1; i >= 0; i--)
  {
    var element = document.getElementById(ids[i]);
    q__assert(element, "q_addNotValidatedInputs: Element not found. id: " + ids[i]);
    if (element)
      element.autoValidate = false;
  }
}

function q_addNotValidatedInput(id) {
  if (!id)
    return;
  var element = document.getElementById(id);
  q__assert(element, "q_addNotValidatedInputs: Element not found. id: " + id);
  if (element)
    element.autoValidate = false;
}

function q_addServerSideMessagesElements(elements) {
  return;
}

function q_submitWithoutValidation(element) {

  var form = q__findParentNode(element, "FORM");
  q__assert(form, "q_submitWithoutValidation: Enclosing form not found.");
  if (form) {
    form.q_skipValidation = true;
    if (form.onsubmit)
      if (!form.onsubmit()) {
        form.q_skipValidation = false;
        return;
      }
    form.submit();
  }
}

function q_switchOnValidation(element) {

  var form = q__findParentNode(element, "FORM");
  q__assert(form, "q_switchOnValidation: Enclosing form not found.");
  if (form) {
    form.q_skipValidation = false;
  }
}

function q_switchOffValidation(element) {

  var form = q__findParentNode(element, "FORM");
  q__assert(form, "q_switchOffValidation: Enclosing form not found.");
  if (form) {
    form.q_skipValidation = true;
  }
}

function q_getElTop(element) {
  if (!element)
  {
    q__assert(element, "q_getElTop: Element is undefined.");
    return 0;
  }
  var obj = element;
  var curtop = 0;
  if (obj.offsetParent)
  {
    while (obj.offsetParent)
    {
      curtop += obj.offsetTop
      obj = obj.offsetParent;
    }
  }
  else if (obj.y)
    curtop += obj.y;
  return curtop;
}

function q_getElLeft(element) {
  if (!element)
  {
    q__assert(element, "q_getElLeft: Element is undefined.");
    return 0;
  }
  var obj = element;

  var curleft = 0;
  if (obj.offsetParent)
  {
    while (obj.offsetParent)
    {
      curleft += obj.offsetLeft
      obj = obj.offsetParent;
    }
  }
  else if (obj.x)
    curleft += obj.x;
  return curleft;
}

function q_addRegularUpdate(timeout) {
  if (!timeout)
    timeout == 0;
  window.setTimeout("q_positionsUpdate();", timeout);
}
function q_positionsUpdate() {
  q_updateClientMessagesPosition();
  q_addRegularUpdate(500);
}

function q__ltrim(value) {
  var re = /\s*((\S+\s*)*)/;
  return value.replace(re, "$1");
}

function q__rtrim(value) {
  var re = /((\s*\S+)*)\s*/;
  return value.replace(re, "$1");
}

function q__trim(value) {
  return q__ltrim(q__rtrim(value));
}

function q__presentationExistsForAllComponents() {
  window.q__presentationExistsForAllComponentsField = true;
}

function q__isPresentationExistsForAllComponents() {
  return window.q__presentationExistsForAllComponentsField;
}

function q__presentationExistsForComponent(componentId) {
  q__getComponentsWithPresentation().push(componentId);
}

function q__getComponentsWithPresentation() {
  var componentsWithPresentation = window.q__componentsWithPresentation;
  if (!componentsWithPresentation) {
    componentsWithPresentation = new Array();
    window.q__componentsWithPresentation = componentsWithPresentation;
  }
  return componentsWithPresentation;
}

function q__isComponentHasPresentation(componentId) {
  if (q__isPresentationExistsForAllComponents()) {
    return true;
  }
  var componentsWithPresentation = q__getComponentsWithPresentation();
  for (var i = 0; i < componentsWithPresentation.length; i++) {
    if (componentId == componentsWithPresentation[i]) {
      return true;
    }
  }
  return false;
}

function q__scheduleUpdateMessagesPosition() {
  setTimeout(function() {
    q_updateClientMessagesPosition();
    q__scheduleUpdateMessagesPosition();
  }, 100);
}

q__invokeOnce(q__scheduleUpdateMessagesPosition, "q__scheduleUpdateMessagesPosition");