function RequestHelper()
{

  /* Formats placeholders in a format specification with supplied replacements. This method demonstrates fixed and variable arguments. */

  /*
  this["format"] = function(format, args, callback)
  {
      return call('format', [ format, args ], callback);
  }*/


  var self = this;
  var nextId = 0;
  //headers = [{name:teamdev_ajax_VALIDATOR, value:validator}]
  this["call"] = function (url, params, headers, callback) //, params, callback)
  {
    if (!callback)
    {
      var request = { id : nextId++, params : params };
      //params };
      return callSync(url, request, headers);
      //return callback == null ?
      //    callSync(request) : callAsync(request, callback);
    } else
    {
      var request = {id : nextId++, params : params };
      return callAsync(url, request, headers, callback);
    }
  }

  function callSync(url, request, headers)
  {
    var http = newHTTP();
    http.open('POST', url + "?" + Math.random(), false);
    if (headers && headers.length > 0)
    {
      for (var i = 0; i < headers.length; i++)
      {
        setupHeaders(http, headers[i].name, headers[i].value);
      }
    }

    http.send(JSON.stringify(request));

    if (http.status != 200)
      throw { message : http.status + ' ' + http.statusText, toString : function() {
        return message;
      } };
    var response = http.responseText;

    return response;
  }

  function callAsync(url, request, headers, callback)
  {
    var http = newHTTP();
    http.open('POST', url, true);
    if (headers && headers.length > 0)
    {
      for (var i = 0; i < headers.length; i++)
      {
        setupHeaders(http, headers[i].name, headers[i].value);
      }
    }

    http.onreadystatechange = function() {
      http_onreadystatechange(http, callback);
    }
    http.send(JSON.stringify(request));
    return request.id;
  }

  function setupHeaders(http, name, value)
  {
    //http.setRequestHeader('Content-Type', 'text/plain; charset=utf-8');
    //http.setRequestHeader('teamdev_ajax_VALIDATOR', 'validator');
    //    http.setRequestHeader('teamdev_ajax', 'validator');
    if (!name || !value)
      return;

    http.setRequestHeader(name, value);
  }

  function http_onreadystatechange(sender, callback)
  {
    if (sender.readyState == /* complete */ 4)
      callback(sender.responseText);
  }

  function newHTTP()
  {
    return typeof(ActiveXObject) === 'function' ?
            new ActiveXObject('Microsoft.XMLHTTP') : /* IE 5 */
            new XMLHttpRequest();
    /* Safari 1.2, Mozilla 1.0/Firefox, and Netscape 7 */
  }

}
