/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

function q_LengthValidator(minimum, maximum, minimumSummary, minimumDetail, maximumSummary, maximumDetail) {
  this.minimum = minimum;
  this.maximum = maximum;
  this.minimumSummary = minimumSummary;
  this.minimumDetail = minimumDetail;
  this.maximumSummary = maximumSummary;
  this.maximumDetail = maximumDetail;
}

q_LengthValidator.prototype.validate = function(input) {
  var value = q_getValue(input);
  if (q_notEmpty(value)) {
    var length = value.length;
    if (this.maximum) {
      if (length > this.maximum) {
        q_addMessage(input, this.maximumSummary, this.maximumDetail);
        return false;
      }
    }
    if (this.minimum) {
      if (length < this.minimum) {
        q_addMessage(input, this.minimumSummary, this.minimumDetail);
        return false;
      }
    }
  }
  return true;
}
