/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */
function q__initTwoListSelection(controlId,
                                 onAddScript,
                                 onRemoveScript,
                                 allowAddRemoveAll,
                                 allowItemsOrdering,
                                 selectAllBtnId,
                                 selectBtnId,
                                 removeBtnId,
                                 removeAllBtnId,
                                 moveUpBtnId,
                                 moveDownBtnId) {
  var tls = document.getElementById(controlId);
  tls._leftSelectionField = q__getControl(controlId + "_left_listBox_selection");
  tls._rightSelectionField = q__getControl(controlId + "_right_listBox_selection");
  tls._leftListBox = q__getControl(controlId + "_left");
  tls._rightListBox = q__getControl(controlId + "_right");

  tls._leftCaption = q__getControl(controlId + "_left_caption");
  tls._rightCaption = q__getControl(controlId + "_right_caption");
  tls._ascImage = q__getControl(controlId + "_sort_asc")
  tls._desImage = q__getControl(controlId + "_sort_desc")

  if (allowAddRemoveAll) {
    tls._selectAllBtn = q__getControl(selectAllBtnId);
    tls._removeAllBtn = q__getControl(removeAllBtnId);
  }
  if (allowItemsOrdering) {
    tls._moveUpBtn = q__getControl(moveUpBtnId);
    tls._moveDownBtn = q__getControl(moveDownBtnId);
  }
  tls._selectBtn = q__getControl(selectBtnId);
  tls._removeBtn = q__getControl(removeBtnId);

  if (q__isExplorer()) {
    setTimeout("q__tls_updateButtonsWidth('" + tls.id + "');", 100);
  } else {
    q__tls_updateButtonsWidth(tls.id);
  }

  tls._selectedItemsField = q__getControl(controlId + "_selected_items");
  tls._allowAddRemoveAll = allowAddRemoveAll
  if (onAddScript != null) {
    tls._onAddScript = onAddScript;
  } else {
    tls._onAddScript = function() {
    };
  }
  if (onRemoveScript != null) {
    tls._onRemoveScript = onRemoveScript;
  } else {
    tls._onRemoveScript = function() {
    };
  }
  q__tls_updateListBoxes(controlId, true);

  var lb = tls._leftListBox;
  lb.onchange = function() {
    q__tls_changeSelection(controlId, 'left');
    q__tls_updateListBoxes(controlId);
  };

  lb = tls._rightListBox;
  lb.onchange = function() {
    q__tls_changeSelection(controlId, 'right');
    q__tls_updateListBoxes(controlId);
  };

  if (tls._ascImage != undefined) {
    tls._sortingDirection = false;

    // todo move it to default style for sortable list caption in TwoListSelectionRanderer, when "JSFC-497 TwoListSelection: make first list sortable" is done
    tls._rightCaption.style.cursor = "pointer";
    //-------------

    tls._rightCaption.onclick = function () {
      q__tls_sortSelection(tls.id);
    }
  }
  //value getter
  tls.getValue = function () {
    return q_getTLSValue(tls.id);
  };

  //value setter
  tls.setValue = function(value) {
    q_setTLSValue(tls.id, value);
  };

  //client validation support
  tls.q_clientValueFunctionExist = true;
  tls.q_clientValueFunction = function () {
    return tls.getValue();
  }
}
/**
 *  value getter by ID
 **/
function q_getTLSValue(controlId) {
  var tls = document.getElementById(controlId);
  var res = q__getArrayFromString(tls._selectedItemsField.value, ',');
  return res;
}

/**
 * value setter by ID
 **/
function q_setTLSValue(controlId, value) {
  var tls = document.getElementById(controlId);
  var res = "";
  if (value && value.length > 0) {
    for (var i = 0; i < value.length; i ++) {
      res += value[i];
      if (i < value.length - 1) {
        res += ",";
      }
    }
  }
  tls._selectedItemsField.value = res;
  q__tls_applyValue(controlId, tls._selectedItemsField.value);
  q__tls_updateListBoxes(controlId);
}

function q__tls_getButtonWidth(button, curWidth) {
  if (button.offsetWidth > curWidth) {
    return button.offsetWidth;
  } else {
    return curWidth;
  }
}

function q__tls_updateButtonsWidth(id) {
  var tls = q__getControl(id);
  var maxBtnWidth = 50;
  if (tls._selectAllBtn) {
    maxBtnWidth = q__tls_getButtonWidth(tls._selectAllBtn, maxBtnWidth);
  }
  if (tls._removeAllBtn) {
    maxBtnWidth = q__tls_getButtonWidth(tls._removeAllBtn, maxBtnWidth);
  }
  if (tls._moveUpBtn) {
    maxBtnWidth = q__tls_getButtonWidth(tls._moveUpBtn, maxBtnWidth);
  }
  if (tls._moveDownBtn) {
    maxBtnWidth = q__tls_getButtonWidth(tls._moveDownBtn, maxBtnWidth);
  }
  maxBtnWidth = q__tls_getButtonWidth(tls._selectBtn, maxBtnWidth);
  maxBtnWidth = q__tls_getButtonWidth(tls._removeBtn, maxBtnWidth);

  if (tls._selectAllBtn) {
    tls._selectAllBtn.style.width = maxBtnWidth + "px";
  }
  if (tls._removeAllBtn) {
    tls._removeAllBtn.style.width = maxBtnWidth + "px";
  }
  if (tls._moveUpBtn) {
    tls._moveUpBtn.style.width = maxBtnWidth + "px";
  }
  if (tls._moveDownBtn) {
    tls._moveDownBtn.style.width = maxBtnWidth + "px";
  }
  tls._selectBtn.style.width = maxBtnWidth + "px";
  tls._removeBtn.style.width = maxBtnWidth + "px";
}

function q__tls_applyValue(tlsId, value) {
  var tls = document.getElementById(tlsId);
  var leftListBox = tls._leftListBox;
  var rightListBox = tls._rightListBox;
  q__tls_moveAllLeft(tlsId);
  var values = q__getArrayFromString(value, ',');

  for (var i = 0; i < values.length; i ++) {
    var newValue = values[i];
    for (var j = 0; j < leftListBox.options.length; j ++) {
      var option = leftListBox.options[j];
      if (option.value == newValue && !option.disabled) {
        q__tls_moveOption(leftListBox, rightListBox, option, j);
        break;
      }
    }
  }
}

function q__tls_updateListBoxes(tlsId, isSubmit) {
  var tls = document.getElementById(tlsId);
  var leftListbox = tls._leftListBox;
  var rightListBox = tls._rightListBox;
  var leftSelectionField = tls._leftSelectionField;
  var rightSelectionField = tls._rightSelectionField;

  if (leftSelectionField.value && leftSelectionField.value.length > 0) {
    var vals = q__getArrayFromString(leftSelectionField.value, ",");
    if (vals) {
      for (var i = 0; i < vals.length; i ++) {
        var value = vals[i];
        for (var j = 0; j < leftListbox.options.length; j ++) {
          var option = leftListbox.options[j];
          if (option.value == value) {
            if (isSubmit) {
              option.selected = true;
            }
            break;
          }
        }
      }
    }
    tls._selectBtn.disabled = false;
  } else if (!leftSelectionField.value || leftSelectionField.value.length == 0) {
    tls._selectBtn.disabled = true;
  }
  if (tls._allowAddRemoveAll) {
    if (leftListbox.options.length == 0) {
      tls._selectAllBtn.disabled = true;
    } else {
      var found = false;
      for (var i = 0; i < leftListbox.options.length; i ++) {
        if (!leftListbox.options[i].disabled) {
          found = true;
          break;
        }
      }
      tls._selectAllBtn.disabled = !found;
    }
  }

  if (tls._moveUpBtn) {
    tls._moveUpBtn.disabled = true;
    tls._moveDownBtn.disabled = true;
  }
  if (rightSelectionField.value && rightSelectionField.value.length > 0) {
    var vals = q__getArrayFromString(rightSelectionField.value, ",");
    if (vals) {
      var firstSelectedIndex = -1;
      for (var i = 0; i < vals.length; i ++) {
        var value = vals[i];
        for (var j = 0; j < rightListBox.options.length; j ++) {
          var option = rightListBox.options[j];
          if (option.value == value) {
            if (isSubmit) {
              option.selected = true;
            }
            if (firstSelectedIndex == -1) {
              firstSelectedIndex = j;
            }
            break;
          }
        }
      }

      if (rightListBox.options.length > 1) {
        if (firstSelectedIndex > 0 && tls._moveUpBtn) {
          tls._moveUpBtn.disabled = false;
        }
        if (firstSelectedIndex < (rightListBox.options.length - 1) && tls._moveDownBtn) {
          tls._moveDownBtn.disabled = false;
        }
      }
    }
    tls._removeBtn.disabled = false;
  } else if (!rightSelectionField.value || rightSelectionField.value.length == 0) {
    tls._removeBtn.disabled = true;
  }
  if (tls._allowAddRemoveAll) {
    if (rightListBox.options.length == 0) {
      tls._removeAllBtn.disabled = true;
    } else {
      var found = false;
      for (var i = 0; i < rightListBox.options.length; i ++) {
        if (!rightListBox.options[i].disabled) {
          found = true;
          break;
        }
      }
      tls._removeAllBtn.disabled = !found;
    }
  }

  var selectedItemsField = tls._selectedItemsField;
  var result = "";
  for (var i = 0; i < rightListBox.options.length; i ++) {
    var obj = rightListBox.options[i];
    result += obj.value;
    if (i < rightListBox.options.length - 1) {
      result += ",";
    }
  }
  selectedItemsField.value = result;
}


function q__tls_hideOrderingIcon(tls) {
  if (tls._ascImage) {
    tls._ascImage.style.display = "none";
    tls._desImage.style.display = "none";
  }
}

function q__tls_changeSelection(controlId, listbox) {
  var tls = document.getElementById(controlId);
  var listBox;
  var selectionField;
  if (listbox == "left") {
    listBox = tls._leftListBox;
    selectionField = tls._leftSelectionField;
  } else {
    listBox = tls._rightListBox;
    selectionField = tls._rightSelectionField;
  }
  var result = "";
  for (var i = 0; i < listBox.options.length; i ++) {
    if (listBox.options[i].selected && listBox.options[i].disabled)
      listBox.options[i].selected = false;
    if (listBox.options[i].selected) {
      result += listBox.options[i].value;
      if (i < listBox.options.length - 1) {
        result += ",";
      }
    }
  }
  if (result.lastIndexOf(",") == result.length - 1) {
    result = result.substring(0, result.length - 1)
  }
  selectionField.value = result;
}

function q__tls_moveRight(controlId) {
  var tls = document.getElementById(controlId);
  var leftList = tls._leftListBox;
  var rightList = tls._rightListBox;
  var fireOnAdd = false;
  var selectedIndex = -1;
  for (var i = 0; i < leftList.options.length; i ++) {
    var lo = leftList.options[i];
    if (lo.selected && !lo.disabled) {
      fireOnAdd = true;

      q__tls_moveOption(leftList, rightList, lo, i);
      if (selectedIndex = -1)
        selectedIndex = i;
      i --;
      q__tls_changeSelection(controlId, 'left');
      q__tls_updateListBoxes(controlId);
    }
  }
  if (selectedIndex == -1)
    return;
  q__tls_setSelection(leftList, selectedIndex, tls._selectBtn);
  q__tls_changeSelection(controlId, 'right');
  q__tls_changeSelection(controlId, 'left');
  q__tls_updateListBoxes(controlId);
  q__tls_hideOrderingIcon(tls);
  if (fireOnAdd)
    q__tls_OnAdd(tls._onAddScript);
}

function q__tls_moveOption(from, to, option, index) {
  to.options[to.options.length] = new Option(option.text, option.value);
  if (q__isExplorer()) {
    from.options.remove(index);
  } else {
    from.options[index] = null;
  }
}

function q__tls_setSelection(listBox, selectedIndex, button) {
  //there are items lower
  if (listBox.options.length > (selectedIndex + 1)) {
    var selected = false;
    for (var i = selectedIndex; i < listBox.options.length; i ++) {
      var option = listBox.options[i];
      if (!option.disabled) {
        option.selected = "true";
        selected = true;
        break;
      }
    }
    if (!selected) {
      //go up
      for (var i = listBox.options.length - 1; i >= 0; i --) {
        var option = listBox.options[i];
        if (!option.disabled) {
          option.selected = "true";
          selected = true;
          break;
        }
      }
    }
  } else { //there are no items lower. select upper
    for (var i = listBox.options.length - 1; i >= 0; i --) {
      var option = listBox.options[i];
      if (!option.disabled) {
        option.selected = "true";
        selected = true;
        break;
      }
    }
  }
  if (selected) {
    button.disabled = false;
  } else {
    button.disabled = true;
  }
}

function q__tls_moveAllRight(controlId) {
  var tls = document.getElementById(controlId);
  var leftList = tls._leftListBox;
  var rightList = tls._rightListBox;
  var fireOnAdd = false;
  for (var i = 0; i < leftList.options.length; i ++) {
    var lo = leftList.options[i];
    if (!lo.disabled) {
      fireOnAdd = true;
      q__tls_moveOption(leftList, rightList, lo, i);
      i --;
    }
  }
  q__tls_hideOrderingIcon(tls);
  if (fireOnAdd) {
    q__tls_changeSelection(controlId, 'left');
    q__tls_updateListBoxes(controlId);
    q__tls_OnAdd(tls._onAddScript);
  }
}

function q__tls_moveLeft(controlId) {
  var tls = document.getElementById(controlId);
  var leftList = tls._leftListBox;
  var rightList = tls._rightListBox;
  var fireOnRemove = false;
  var selectedIndex = -1;
  for (var i = 0; i < rightList.options.length; i ++) {
    var ro = rightList.options[i];
    if (ro.selected && !ro.disabled) {
      fireOnRemove = true;
      q__tls_moveOption(rightList, leftList, ro, i);
      if (selectedIndex == -1) {
        selectedIndex = i;
      }
      i --;
      q__tls_changeSelection(controlId, 'right');
      q__tls_updateListBoxes(controlId);
    }
  }
  if (selectedIndex == -1)
    return;
  q__tls_setSelection(rightList, selectedIndex, tls._removeBtn);
  q__tls_changeSelection(controlId, 'left');
  q__tls_changeSelection(controlId, 'right');
  q__tls_updateListBoxes(controlId);
  if (fireOnRemove)
    q__tls_OnRemove(tls._onRemoveScript);
}

function q__tls_moveUp(controlId) {
  q__tls_switchOptionWithNeibor(controlId, "up")
}

function q__tls_moveDown(controlId) {
  q__tls_switchOptionWithNeibor(controlId, "down")
}

function q__tls_switchOptionWithNeibor(controlId, direction) {
  var tls = document.getElementById(controlId);
  var optionsList = tls._rightListBox;
  for (var i = 0; i < optionsList.options.length; i ++) {
    var currentOption = optionsList.options[i];
    if (currentOption.selected && !currentOption.disabled) {
      var neibor = null;
      var neiborIndex = 0;
      if (direction == "down") {
        if (i < (optionsList.length - 1)) {
          neiborIndex = i + 1;
          neibor = optionsList.options[neiborIndex];
        }
      } else if (i > 0) {
        neiborIndex = i - 1;
        neibor = optionsList.options[neiborIndex];
      }

      if (neibor != null) {
        var storeOption1 = new Option(currentOption.text, currentOption.value);
        var storeOption2 = new Option(neibor.text, neibor.value);
        storeOption2.style.cssText = neibor.style.cssText;
        if (neibor.disabled) {
          storeOption2.disabled = true;
        }
        optionsList.options[i] = storeOption2;
        optionsList.options[i].selected = false;

        optionsList.options[neiborIndex] = storeOption1;
        optionsList.options[neiborIndex].selected = true;
        q__tls_changeSelection(controlId, 'right');
        q__tls_updateListBoxes(controlId);
      }

      break;
    }
  }
  q__tls_hideOrderingIcon(tls);
}

function q__tls_moveAllLeft(controlId) {
  var tls = document.getElementById(controlId);
  var leftList = tls._leftListBox;
  var rightList = tls._rightListBox;
  var fireOnRemove = false;
  for (var i = 0; i < rightList.options.length; i ++) {
    var ro = rightList.options[i];
    if (!ro.disabled) {
      fireOnRemove = true;
      q__tls_moveOption(rightList, leftList, ro, i);
      i--;
    }
  }
  if (fireOnRemove) {
    q__tls_changeSelection(controlId, 'right');
    q__tls_updateListBoxes(controlId);
    q__tls_OnRemove(tls._onRemoveScript);
  }
}

function q__tls_sortSelection(controlId) {
  var tls = q__getControl(controlId);

  tls._sortingDirection = !tls._sortingDirection;

  var rightList = tls._rightListBox;
  var options = new Array();
  for (var i = 0; i < rightList.options.length; i ++) {
    options[options.length] = rightList.options[i];
  }
  if (tls._sortingDirection) {
    options.sort(q__tls_compareAsc);
  } else {
    options.sort(q__tls_compareDesc);
  }
  while (rightList.options.length > 0) {
    if (q__isExplorer()) {
      rightList.options.remove(0);
    } else {
      rightList.options[0] = null;
    }
  }
  for (var i = 0; i < options.length; i ++) {
    rightList.options[rightList.options.length] = options[i];
  }
  q__tls_changeSelection(controlId, 'right');
  q__tls_updateListBoxes(controlId);

  if (tls._sortingDirection) {
    tls._ascImage.style.display = "block";
    tls._desImage.style.display = "none";
  } else {
    tls._ascImage.style.display = "none";
    tls._desImage.style.display = "block";
  }
}

function q__tls_compareAsc(a, b) {
  if (a.text < b.text) return -1;
  if (a.text > b.text) return 1;
  if (a.text == b.text) return 0;
}

function q__tls_compareDesc(a, b) {
  if (a.text > b.text) return -1;
  if (a.text < b.text) return 1;
  if (a.text == b.text) return 0;
}

function q__tls_OnAdd(foo) {
  foo();
}

function q__tls_OnRemove(foo) {
  foo();
}
