/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

// ================================== PUBLIC API METHODS

function q_getTabSetSelectedIndex(tabSetId) {
  if (!tabSetId)
    throw "q_getTabSetSelectedIndex: tabSet's clientId must be passed as a parameter";
  var tabset = document.getElementById(tabSetId);
  if (!tabset)
    throw "q_getTabSetSelectedIndex: Invalid clientId passed - no such component was found: " + tabSetId;
  return tabset._index;
}

function q_setTabSetSelectedIndex(tabSetId, index) {
  if (!tabSetId)
    throw "q_setTabSetSelectedIndex: tabSet's clientId must be passed as a parameter";
  var tabset = document.getElementById(tabSetId);
  if (!tabset)
    throw "q_setTabSetSelectedIndex: Invalid clientId passed - no such component was found: " + tabSetId;
  if (!tabset._tabs)
    throw "q_setTabSetSelectedIndex: TabSet has no tabs: " + tabSetId;
  if (index < 0)
    throw "q_setTabSetSelectedIndex: Invalid index passed - index can not be < 0";
  if (index >= tabset._tabs.length)
    throw "q_setTabSetSelectedIndex: Invalid index passed - value '" + index + "' is out of bound. Tab amount is " + tabset._tabs.length;

  tabset.setSelectedIndex(index);
}

// ================================== END OF PUBLIC API METHODS

function q__initTabSet(tabSetId, tabIds, selectedIndex, submitOnChange, placement) {
  var tabset = q__getControl(tabSetId);

  tabset._index = selectedIndex;
  tabset._indexField = q__getControl(tabSetId + "::selected");
  tabset.submitOnChange = submitOnChange;
  tabset._placement = placement;

  tabset._tabs = new Array();
  for (var i = 0; i < tabIds.length; i++) {
    var tabId = tabIds[i];
    var separatorIndex = tabId.lastIndexOf("::");
    var idxStr = tabId.substring(separatorIndex + "::".length);
    var absoluteIndex = parseInt(idxStr, 10);
    var tab = q__getControl(tabId);
    tab._absoluteIndex = absoluteIndex;
    tab.onclick = function () {
      tabset.setSelectedIndex(this._absoluteIndex);
    }
    tabset._tabs[i] = tab;
  }

  tabset.getSelectedIndex = function () {
    return tabset._index;
  }

  tabset._getTabByAbsoluteIndex = function (absoluteTabIndex) {
    var tab = null;
    for (var i = 0, count = tabset._tabs.length; i < count; i++) {
      var currTab = tabset._tabs[i];
      if (currTab._absoluteIndex == absoluteTabIndex) {
        tab = currTab;
        break;
      }
    }
    return tab;
  }

  tabset.setSelectedIndex = function (index) {
    var tab = this._getTabByAbsoluteIndex(index);
    if (tab == null)
      throw "An attempt to select non-rendered or non-existing tab has been made. index =  " + index + "; TabSet id = " + tabset.id;
    
    if (index == tabset._index)
      return;
    tabset._index = tab._absoluteIndex;
    tabset._indexField.value = tab._absoluteIndex;
    if (tabset.onchange) {
      tabset.onchange(tab._absoluteIndex);
    }
    if (tabset.submitOnChange) {
      q__submitEnclosingForm(tabset);
    } else {
      tabset._refreshTabs();
      tab.className = tabset.completeRolloverSelectTabClass + ' ' + tabset.frontBorderClass;
    }
  }


  tabset._setTabStyles = function (tabClass, selectTabClass, rolloverTabClass, rolloverSelectTabClass) {
    tabset.tabClass = tabClass;
    tabset.selectTabClass = selectTabClass;
    tabset.rolloverTabClass = rolloverTabClass;
    tabset.rolloverSelectTabClass = rolloverSelectTabClass;

    tabset.completeTabClass = tabset.tabClass;
    tabset.completeSelectTabClass = tabset.tabClass + " " + tabset.selectTabClass;
    tabset.completeRolloverTabClass = tabset.tabClass + " " + tabset.rolloverTabClass;
    tabset.completeRolloverSelectTabClass = tabset.completeSelectTabClass + " " + tabset.rolloverTabClass + " " + tabset.rolloverSelectTabClass;

    tabset._refreshTabs();
  }

  tabset._setBorderClasses = function (frontBorderClass, backBorderClass1, backBorderClass2) {
    tabset.frontBorderClass = frontBorderClass;
    if (placement == 'top' || placement == 'right') {
      tabset.backBorderClass1 = backBorderClass1;
      tabset.backBorderClass2 = backBorderClass2;
    } else {
      tabset.backBorderClass1 = backBorderClass2;
      tabset.backBorderClass2 = backBorderClass1;
    }
    tabset._refreshTabs();
  }

  tabset._refreshTabs = function () {
    if (!tabset._tabs)
      return;
    
    for (var i = 0, tabCount = tabset._tabs.length; i < tabCount; i++) {
      var tab = tabset._tabs[i];

      if (tab._absoluteIndex < tabset._index) {
        q__initTabSet_Tab(tabset, tab, tabset.completeTabClass, tabset.completeRolloverTabClass, tabset.backBorderClass1);
      } else if (tab._absoluteIndex == tabset._index) {
        q__initTabSet_Tab(tabset, tab, tabset.completeSelectTabClass, tabset.completeRolloverSelectTabClass, tabset.frontBorderClass);
      } else {
        q__initTabSet_Tab(tabset, tab, tabset.completeTabClass, tabset.completeRolloverTabClass, tabset.backBorderClass2);
      }
    }

    q__repaintAreaForOpera(tabset, true); // JSFC-2229
  }
}

function q__initTabSet_Tab(tabset, tab, tabClass, rolloverTabClass, borderClass) {

  tab.onmouseover = function () {
    tab.className = rolloverTabClass + ' ' + borderClass;
    q__repaintAreaForOpera(tabset, true);
  }
  
  tab.onmouseout = function () {
    tab.className = tabClass  + ' ' + borderClass;
    q__repaintAreaForOpera(tabset, true); // JSFC-2229
  }

  tab.className = tabClass + ' ' + borderClass;
}
