/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

var CURRENT_MONTH = 1;
var NON_CURRENT_MONTH = 2;
var SELECTED_DAY = 3;

var CELL_SUFFIX = "::cell_";

var DAY_COUNTS = new Array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);

function q_getSelectedDate(calendarId) {
  var cal = q__getControl(calendarId);
  var valueHolder = q__getControl(cal._valueHolderId);
  if (!valueHolder.value) {
    return null;
  } else {
    var date = new Date();
    date.setTime(valueHolder.value);
    return date;
  }
}

function q_setSelectedDate(calendarId, date) {
  var cal = q__getControl(calendarId);
  var valueHolder = q__getControl(cal._valueHolderId);
  if (date) {
    valueHolder.value = date.getTime();
    q__updateCalendar(cal, date, true);
  } else {
    valueHolder.value = "";
    if (cal._showFooter) {
      var none = q__getControl(cal._noneSelectorId);
      none.style.color = "#808080";
      none.style.cursor = "default";
      if (q__isExplorer()) {
        none.onclick = null;
      } else {
        none.onclick = undefined;
      }
    }
  }
  q__notifyDateChangeListeners(calendarId);
}


function q__initCalendar(controlId,
                         selectedDate,
                         dayClassName, rolloverDayClassName,
                         inactiveMonthDayClassName, rolloverInactiveMonthDayClassName,
                         selectedDayClassName, rolloverSelectedDayClassName,
                         todayClassName, rolloverTodayClassName,
                         weekendClassName, rolloverWeekendClassName,
                         disabledDayClassName, rolloverDisabledDayClassName,
                         firstDayOfWeek,
                         fireServerDateChange,
                         headerClassName,
                         dateRanges,
                         showWeekNumber,
                         localeStr,
                         required,
        showFooter) {
  var cal = q__getControl(controlId);

  cal._weekNumberId = controlId + "::week_num";
  cal._monthSelectorId = controlId + "--month";
  cal._decMonthSelectorId = controlId + "::month_decrease";
  cal._incMonthSelectorId = controlId + "::month_increase";
  cal._yearSelectorId = controlId + "--year";
  cal._decYearSelectorId = controlId + "::year_decrease";
  cal._incYearSelectorId = controlId + "::year_increase";

  cal._todaySelectorId = controlId + "::today";
  cal._noneSelectorId = controlId + "::none";

  cal._valueHolderId = controlId + "::date_holder";
  cal._dropSuffix = "--drop";

  cal._dayClassName = dayClassName;
  cal._rolloverDayClassName = rolloverDayClassName;
  cal._inactiveMonthDayClassName = inactiveMonthDayClassName;
  cal._rolloverInactiveMonthDayClassName = rolloverInactiveMonthDayClassName;
  cal._selectedDayClassName = selectedDayClassName;
  cal._rolloverSelectedDayClassName = rolloverSelectedDayClassName;
  cal._todayClassName = todayClassName;
  cal._rolloverTodayClassName = rolloverTodayClassName;
  cal._weekendClassName = weekendClassName;
  cal._rolloverWeekendClassName = rolloverWeekendClassName;
  cal._disabledDayClassName = disabledDayClassName;
  cal._rolloverDisabledDayClassName = rolloverDisabledDayClassName;
  cal._headerClassName = headerClassName;

  cal._firstDayOfWeek = firstDayOfWeek;

  cal._fireServerDateChange = fireServerDateChange;
  cal._dateRanges = dateRanges;

  cal._showWeekNumber = showWeekNumber;
  cal._localeStr = localeStr;

  cal._required = required;
  cal._showFooter = showFooter;

  cal._dateChange_listeners = null;
  cal._addDateChangeListener = function(listenerObjectFunction) {
    if (!this._dateChange_listeners) {
      this._dateChange_listeners = new Array();
    }
    this._dateChange_listeners[this._dateChange_listeners.length] = listenerObjectFunction;
  };
  var valueHolder = q__getControl(cal._valueHolderId);
  if (selectedDate) {
    valueHolder.value = selectedDate;
    q__updateCalendar(cal, new Date(selectedDate));
  } else {
    valueHolder.value = "";
    q__updateCalendar(cal);
  }

  var decMonthSelector = q__getControl(cal._decMonthSelectorId);
  //  decMonthSelector.className = cal._headerClassName;
  decMonthSelector._calId = controlId;
  decMonthSelector.onclick = function() {
    q__decMonthClick(this._calId);
  };
  var incMonthSelector = q__getControl(cal._incMonthSelectorId);
  //  incMonthSelector.className = cal._headerClassName;
  incMonthSelector._calId = controlId;
  incMonthSelector.onclick = function() {
    q__incMonthClick(this._calId);
  };

  var monthSelector = q__getControl(cal._monthSelectorId);
  //  monthSelector.className = cal._headerClassName;
  monthSelector._dropId = monthSelector.id + cal._dropSuffix;
  monthSelector._calendar = cal;
  monthSelector.onclick = function() {
    q__calendar_showDrop(this._calendar, this._dropId);
  };

  var decYS = q__getControl(cal._decYearSelectorId);
  //  decYS.className = cal._headerClassName;
  decYS._calId = controlId;
  decYS.onclick = function() {
    q__decYearClick(this._calId);
  };

  var incYS = q__getControl(cal._incYearSelectorId);
  //  incYS.className = cal._headerClassName;
  incYS._calId = controlId;
  incYS.onclick = function() {
    q__incYearClick(this._calId);
  };

  var yearSelector = q__getControl(cal._yearSelectorId);
  //  yearSelector.className = cal._headerClassName;
  yearSelector._dropId = yearSelector.id + cal._dropSuffix;
  yearSelector._calendar = cal;
  yearSelector.onclick = function() {
    q__calendar_showDrop(this._calendar, this._dropId);
  };

  if (cal._showFooter) {
    var todayS = q__getControl(cal._todaySelectorId);
    todayS._calId = controlId;

    var noneS = q__getControl(cal._noneSelectorId);
    noneS._calId = controlId;
    if (required || !selectedDate) {
      noneS.style.color = "#808080";
      noneS.style.cursor = "default";
      if (q__isExplorer()) {
        noneS.onclick = null;
      } else {
        noneS.onclick = undefined;
      }
    } else {
      noneS.style.color = "";
      noneS.style.cursor = "pointer";
      noneS.onclick = function() {
        q__noneClick(this._calId);
      };
    }
  }

  cal.q_clientValueFunctionExist = true;
  cal.q_clientValueFunction = function () {
    var valueHolder = q__getControl(cal._valueHolderId);
    return valueHolder.value;
  }

  cal.getSelectedDate = function () {
    return q_getSelectedDate(cal.id);
  };

  cal.setSelectedDate = function (date) {
    q_setSelectedDate(cal.id, date);
  };
}

function q__notifyDateChangeListeners(controlId) {
  var cal = q__getControl(controlId);
  var listeners = cal._dateChange_listeners;
  if (listeners && listeners != null && listeners.length > 0) {
    for (var i = 0; i < listeners.length; i ++) {
      var listener = listeners[i];
      listener(q_getSelectedDate(controlId));
    }
  }
}

function q__updateCalendar(calendar, selectedDate, updateSelectedDateOnly) {
  var monthYearChanged = false;
  var today = new Date();
  var dates;
  var none = q__getControl(calendar._noneSelectorId);
  var todaySel = q__getControl(calendar._todaySelectorId);
  if (selectedDate) {
    calendar._currentMonth = selectedDate.getMonth();
    calendar._currentYear = selectedDate.getFullYear();
    dates = q__buildDatesArray(calendar, selectedDate, true);
  } else {
    if (!q__checkMonth(calendar._currentMonth) || !calendar._currentYear) {
      calendar._currentYear = today.getFullYear();
      calendar._currentMonth = today.getMonth();
    }
    dates = q__buildDatesArray_YMD(calendar, calendar._currentYear, calendar._currentMonth);
    monthYearChanged = true;
  }

  var tempDate = q_getSelectedDate(calendar.id);
  if (calendar._showFooter) {
    if (tempDate) {
      if (calendar._required) {
        none.style.color = "#808080";
        none.style.cursor = "default";
        if (q__isExplorer()) {
          none.onclick = null;
        } else {
          none.onclick = undefined;
        }
      } else {
        none.style.color = "";
        none.style.cursor = "pointer";
        none.onclick = function() {
          q__noneClick(this._calId);
        };
      }
    } else {
      none.style.color = "#808080";
      none.style.cursor = "default";
      if (q__isExplorer()) {
        none.onclick = null;
      } else {
        none.onclick = undefined;
      }
    }
  }

  var dateRanges = calendar._dateRanges;
  var drStyleClassName;
  var drRolloverStyleClassName;
  var disableExcluded;
  var disableIncluded;
  if (dateRanges) {
    drStyleClassName = dateRanges._styleClassName;
    drRolloverStyleClassName = dateRanges._rolloverStyleClassName;
    disableExcluded = dateRanges._disableExcluded;
    disableIncluded = dateRanges._disableIncluded;
  }

  calendar._todayInBound = false;
  calendar._applyOnclick4today = true;

  var iterator = 0;
  var idPrefix = calendar.id + CELL_SUFFIX;
  var dayClassName = calendar._dayClassName;
  var rolloverDayClassName = calendar._rolloverDayClassName;
  var inactiveMonthDayClassName = calendar._inactiveMonthDayClassName;
  var rolloverInactiveMonthDayClassName = calendar._rolloverInactiveMonthDayClassName;
  var weekendClassName = calendar._weekendClassName;
  var rolloverWeekendClassName = calendar._rolloverWeekendClassName;
  for (var row = 0; row < 6; row++) {
    var cellIdPrefix = idPrefix + row + "_";
    for (var col = 0; col < 7; col++) {
      var cellId = cellIdPrefix + col;
      var cell = q__getControl(cellId);
      var pair = dates[iterator++];
      var type = pair[0];
      var date = pair[1];
      var thisIsToday = pair._today;

      cell._type = type;

      cell.onmouseover = function(e) {
        if (this._rolloverClassName)
          q__appendClassNames(this, [this._rolloverClassName]);
        q__operaStrictWorkaround();
        calendar._lastHoveredCell = this;
      }

      cell.onmouseout = function(e) {
        if (this._rolloverClassName)
          q__excludeClassNames(this, [this._rolloverClassName]);
        q__operaStrictWorkaround();
      }
      // 1
      cell.className = dayClassName;
      cell._rolloverClassName = rolloverDayClassName;

      // 2
      //set WEEKEND style
      var day = date.getDay();
      if (day == 0 || day == 6) {
        cell.className += " " + weekendClassName;
        cell._rolloverClassName += " " + rolloverWeekendClassName;
      }

      // 3
      switch (type) {
        case CURRENT_MONTH:
          cell._isCurrentMonth = true;
          break;
        case NON_CURRENT_MONTH:
          cell.className += " " + inactiveMonthDayClassName;
          cell._rolloverClassName += " " + rolloverInactiveMonthDayClassName;
          cell._isCurrentMonth = false;
          break;
      }

      var foundInRange = false;

      if (dateRanges) { // 4
        var ranges = dateRanges.getDateRanges();
        for (var i = 0; i < ranges.length; i ++) {
          if (ranges[i].isDateInRange(date)) {
            cell.className += " " + ranges[i]._styleClassName;
            cell._rolloverClassName += " " + ranges[i]._rolloverStyleClassName;
            foundInRange = true;
          }
        }
        if (foundInRange) {
          cell.className += " " + dateRanges._styleClassName;
          cell._rolloverClassName += " " + dateRanges._rolloverStyleClassName;
        }

        if ((!foundInRange && disableExcluded) || (foundInRange && disableIncluded)) {
          cell.className += " " + calendar._disabledDayClassName;
          cell._rolloverClassName += " " + calendar._rolloverDisabledDayClassName;
          if (type == NON_CURRENT_MONTH) {
            cell._rolloverClassName = cell._rolloverClassName.replace(rolloverInactiveMonthDayClassName, "");
          }
        }
      }

      /*
            if ((dateRanges && ((foundInRange && !disableIncluded) || (!foundInRange && !disableExcluded)))
                    || !dateRanges) {
      */
      // 5
      //set TODAY style
      if (thisIsToday) {
        calendar._todayInBound = true;
        cell.className += " " + calendar._todayClassName;
        cell._rolloverClassName += " " + calendar._rolloverTodayClassName;
        cell._isToday = true;
        if (calendar._showFooter) {
          todaySel._todayCell = cell;
        }
      } else {
        cell._isToday = false;
      }
      /*
            }
      */
      if (thisIsToday && dateRanges && ((foundInRange && disableIncluded) || (!foundInRange && disableExcluded))) {
        calendar._applyOnclick4today = false;
      }
      // 6
      if (type == SELECTED_DAY) {
        cell.className += " " + calendar._selectedDayClassName;
        cell._rolloverClassName += " " + calendar._rolloverSelectedDayClassName;
        calendar._selectedCell = cell;
        cell._isSelected = true;
      } else {
        cell._isSelected = false;
      }

      cell._calendar = calendar;
      cell._date = date;
      cell.innerHTML = date.getDate();

      q__calendar_updateDateRangesSelectedStyles(calendar, cell);

      //      cell.title = "Day of year: " + q__getDayOfYear(date); todo: title doesn't work on cells under IE and Opera
      if (!dateRanges ||
          (dateRanges && ((foundInRange && !disableIncluded) || (!foundInRange && !disableExcluded)))) {
        if (type == NON_CURRENT_MONTH) {
          cell.onclick = function() {
            q__cellClick(this._calendar, this._date);
          };
        } else if (type == SELECTED_DAY) {
          if (q__isExplorer()) {
            cell.onclick = null;
          } else {
            cell.onclick = undefined;
          }
        } else if (type == CURRENT_MONTH) {
          cell.onclick = function() {
            q__calendar_updateWithinMonth(this._calendar, this._date, this);
          };
        }
      } else {
        if (q__isExplorer()) {
          cell.onclick = null;
        } else {
          cell.onclick = undefined;
        }
      }
    }
  }
  if (calendar._showFooter) {
    q__calendar_updateToday(calendar);
  }


  var ms = q__getControl(calendar._monthSelectorId);
  var ys = q__getControl(calendar._yearSelectorId);
  var wn = q__getControl(calendar._weekNumberId);

  var dtf = q__getDateTimeFormatObject(calendar._localeStr);
  if (!dtf) return;
  var months = dtf.getMonths();
  if (selectedDate) {
    ms.innerHTML = months[selectedDate.getMonth()];
    ys.innerHTML = selectedDate.getFullYear();
    if (calendar._showWeekNumber) {
      var weekNo = q__getWeekNumber(selectedDate);
      wn.innerHTML = weekNo < 10 ? "&#160;" + weekNo : weekNo;
    }
  } else {
    if (monthYearChanged) {
      ms.innerHTML = months[calendar._currentMonth];
      ys.innerHTML = calendar._currentYear;
      if (calendar._showWeekNumber) {
        var weekNo = q__getWeekNumber(new Date(calendar._currentYear, calendar._currentMonth, 1));
        wn.innerHTML = weekNo < 10 ? "&#160;" + weekNo : weekNo;
      }

    } else {
      ms.innerHTML = months[today.getMonth()];
      ys.innerHTML = today.getFullYear();
      if (calendar._showWeekNumber) {
        var weekNo = q__getWeekNumber(today);
        wn.innerHTML = weekNo < 10 ? "&#160;" + weekNo : weekNo;
      }
    }
  }
  if (calendar._onPeriodChange) {
    calendar._onPeriodChange();
  }
  calendar._dropsInitialized = false;
  q__repaintAreaForOpera(calendar, true);
}

function q__calendar_updateToday(calendar) {
  var date = q_getSelectedDate(calendar.id);
  var today = new Date();
  if (date && date.getFullYear() == today.getFullYear()
          && date.getMonth() == today.getMonth()
          && date.getDate() == today.getDate()
          && calendar._applyOnclick4today) {
    calendar._applyOnclick4today = false;
  }

  if (calendar._dateRanges && calendar._applyOnclick4today) {
    var foundInRange = false;
    var ranges = calendar._dateRanges.getDateRanges();
    for (var i = 0; i < ranges.length; i ++) {
      if (ranges[i].isDateInRange(today)) {
        foundInRange = true;
        break;
      }
    }
    if ((foundInRange && calendar._dateRanges._disableIncluded)
            || (!foundInRange && calendar._dateRanges._disableExcluded)) {
      calendar._applyOnclick4today = false;
    }
  }
  var todaySel = q__getControl(calendar._todaySelectorId);
  if (calendar._todayInBound) { //apply inbound onclick for today
    if (calendar._applyOnclick4today) {
      todaySel.style.color = "";
      todaySel.style.cursor = "pointer";
      todaySel._calendar = calendar;
      if (calendar._currentMonth == today.getMonth() && calendar._currentYear == today.getFullYear()) {
        todaySel.onclick = function() {
          q__calendar_updateWithinMonth(this._calendar, this._todayCell._date, this._todayCell);
        };
      } else {
        todaySel.onclick = function() {
          q__todayClick(this._calId);
        };
      }
    } else {
      todaySel.style.color = "#808080";
      todaySel.style.cursor = "default";
      if (q__isExplorer()) {
        todaySel.onclick = null;
      } else {
        todaySel.onclick = null;
      }
    }
  } else { //apply whole calendar update onclick for today
    if (calendar._applyOnclick4today) {
      todaySel.style.color = "";
      todaySel.style.cursor = "pointer";
      todaySel.onclick = function() {
        q__todayClick(this._calId);
      };
    } else {
      todaySel.style.color = "#808080";
      todaySel.style.cursor = "default";
      if (q__isExplorer()) {
        todaySel.onclick = null;
      } else {
        todaySel.onclick = null;
      }
    }
  }
}

function q__cellClick(cal, date) {
  q_setSelectedDate(cal.id, q__cloneDate(date));
  if (cal._fireServerDateChange) {
    q__submitEnclosingForm(cal);
  }
  if (cal._onDateChange) {
    cal._onDateChange();
  }
}

function q__buildDatesArray_YMD(calendar, year, month, day) {
  if (!year) {
    return q__buildDatesArray(calendar, null, false);
  }
  if (!q__checkMonth(month)) {
    alert("Month check: " + month);
    return q__buildDatesArray(calendar, null, false);
  }
  if (!day) {
    var date = new Date(year, month, 1);
    return q__buildDatesArray(calendar, date, false);
  }
  return q__buildDatesArray(calendar, new Date(year, month, day), false);
}

function q__checkMonth(month) {
  return month >= 0 && month < 12;
}

function q__buildDatesArray(calendar, date, isSelected) {
  var today = new Date();
  if (!date)
    date = today;

  var incYear = date.getFullYear();
  var incMonth = date.getMonth();
  var incDay = date.getDate();

  var todayYear = today.getFullYear();
  var todayMonth = today.getMonth();
  var todayDate = today.getDate();

  var monthStartDate = new Date(incYear, incMonth, 1);
  var dayOfWeek = monthStartDate.getDay();
  var preDays;
  var firstDayOfWeek = calendar._firstDayOfWeek;

  preDays = dayOfWeek - firstDayOfWeek;
  if (preDays > 6) preDays -= 7;
  else if (preDays < 0) preDays += 7;

  monthStartDate.setDate(monthStartDate.getDate() - preDays);
  var today = new Date();
  var dates = new Array();

  var storedSelectedDate = q_getSelectedDate(calendar.id);
  if (storedSelectedDate) {
    storedSelectedDate_date = storedSelectedDate.getDate();
    storedSelectedDate_month = storedSelectedDate.getMonth();
    storedSelectedDate_fullYear = storedSelectedDate.getFullYear();
  }
  for (var i = 0; i < 42; i ++) {
    var y = monthStartDate.getFullYear();
    var m = monthStartDate.getMonth();
    var d = monthStartDate.getDate();

    var pair = new Array();

    if (y < incYear || m < incMonth) {
      pair[0] = NON_CURRENT_MONTH;
    } else if (y > incYear || m > incMonth) {
      pair[0] = NON_CURRENT_MONTH;
    } else if ((d == incDay && isSelected)
            || (storedSelectedDate
            && storedSelectedDate_date == d
            && storedSelectedDate_month == m
            && storedSelectedDate_fullYear == y)) {
      pair[0] = SELECTED_DAY;
    } else {
      pair[0] = CURRENT_MONTH;
    }
    pair[1] = q__cloneDate(monthStartDate);
    if (d == todayDate && m == todayMonth && y == todayYear)
      pair._today = true;

    dates[dates.length] = pair;
    monthStartDate.setDate(d + 1);
  }
  return dates;
}

function q__cloneDate(date) {
  return new Date(date.getFullYear(), date.getMonth(), date.getDate());
}

function q__calendar_compareDates(date1, date2) {
  if (date1.getFullYear() < date2.getFullYear()) return -1;
  else if (date1.getFullYear() == date2.getFullYear()
          && date1.getMonth() < date2.getMonth()) return -1;
  else if (date1.getFullYear() == date2.getFullYear()
          && date1.getMonth() == date2.getMonth()
          && date1.getDate() < date2.getDate()) return -1;
  else if (date1.getFullYear() == date2.getFullYear()
          && date1.getMonth() == date2.getMonth()
          && date1.getDate() == date2.getDate()) return 0;
  else if (date1.getFullYear() > date2.getFullYear()) return 1;
  else if (date1.getFullYear() == date2.getFullYear()
          && date1.getMonth() > date2.getMonth()) return 1;
  else return 1;
}

function q__decMonthClick(controlId) {
  var cal = q__getControl(controlId);
  var month = cal._currentMonth;
  if (month == 0) {
    month = 11;
    cal._currentYear = cal._currentYear - 1;
  } else {
    month = month - 1;
  }
  cal._currentMonth = month;
  q__updateCalendar(cal);
}

function q__incMonthClick(controlId) {
  var cal = q__getControl(controlId);
  var month = cal._currentMonth;
  if (month == 11) {
    month = 0
    cal._currentYear = cal._currentYear + 1;
  } else {
    month = month + 1;
  }
  cal._currentMonth = month;
  q__updateCalendar(cal);
}

function q__decYearClick(controlId) {
  var cal = q__getControl(controlId);
  cal._currentYear -= 1;
  q__updateCalendar(cal);
}

function q__incYearClick(controlId) {
  var cal = q__getControl(controlId);
  cal._currentYear += 1;
  q__updateCalendar(cal);
}

function q__todayClick(controlId) {
  var cal = q__getControl(controlId);
  var date = new Date();

  if (cal._dateRanges) {
    var found = false;
    var ranges = cal._dateRanges.getDateRanges();
    for (var i = 0; i < ranges.length; i ++) {
      if (ranges[i].isDateInRange(date)) {
        found = true;
        break;
      }
    }
    if ((found && !cal._dateRanges._disableIncluded)
            || (!found && !cal._dateRanges._disableExcluded)) {
      q__calendar_setTodaySettings(controlId, date);
    }
  } else {
    q__calendar_setTodaySettings(controlId, date);
  }
}

function q__calendar_setTodaySettings(controlId, date) {
  var cal = q__getControl(controlId);
  q_setSelectedDate(controlId, date);

  if (cal._fireServerDateChange) {
    q__submitEnclosingForm(cal);
  }
  if (cal._onDateChange) {
    cal._onDateChange();
  }
}

function q__noneClick(controlId) {
  var calendar = q__getControl(controlId);
  q_setSelectedDate(controlId);
  calendar._applyOnclick4today = true;
  q__calendar_updateToday(calendar);
  //todo: clear selection from cell

  var selectedCell = calendar._selectedCell;
  if (selectedCell) {
    var className = selectedCell.className;
    var rolloverClassName = selectedCell._rolloverClassName;
    selectedCell.className = className.replace(calendar._selectedDayClassName, "");
    selectedCell._rolloverClassName = rolloverClassName.replace(calendar._rolloverSelectedDayClassName, "");
    calendar._selectedCell = null;
    if (calendar._dateRanges) {
      selectedCell.className = selectedCell.className.replace(calendar._dateRanges._selectedDayClassName, "");
      selectedCell._rolloverClassName
              = selectedCell._rolloverClassName.replace(calendar._dateRanges._rolloverSelectedDayClassName, "");
      var ranges = calendar._dateRanges.getDateRanges();
      for (var i = 0; i < ranges.length; i ++) {
        var simpleRange = ranges[i];
        if (simpleRange.isDateInRange(selectedCell._date) && !calendar._dateRanges._disableIncluded) {
          if (simpleRange._selectedDayStyleClassName) {
            selectedCell.className = selectedCell.className.replace(simpleRange._selectedDayStyleClassName, "");
          }
          if (simpleRange._rolloverSelectedDayStyleClassName) {
            selectedCell._rolloverClassName
                    = selectedCell._rolloverClassName.replace(simpleRange._rolloverSelectedDayStyleClassName, "");
          }
        }
      }
    }
    if (selectedCell._isCurrentMonth) {
      selectedCell.onclick = function () {
        q__calendar_updateWithinMonth(this._calendar, this._date, this);
      };
    } else {
      selectedCell.onclick = function () {
        q__cellClick(this._calendar, this._date);
      };
    }
  }
  if (calendar._fireServerDateChange) {
    q__submitEnclosingForm(calendar);
  }
  if (calendar._onDateChange) {
    calendar._onDateChange();
  }
}

function q__getWeekNumber(toDate) {
  var curY = toDate.getFullYear();
  var curM = toDate.getMonth();
  var curD = toDate.getDate();

  var dayCounter = q__getDayOfYear(toDate);

  var fromDate = new Date(curY, 0, 1);
  var firstDay = fromDate.getDay();
  /////
  var periodStartDayOfWeek = (toDate.getDay() - 1 - dayCounter + 1) % 7;
  if (periodStartDayOfWeek < 0) {
    periodStartDayOfWeek += 7;
  }

  var weekNo = (dayCounter + periodStartDayOfWeek - 1) / 7;

  if ((7 - periodStartDayOfWeek) >= (7 - (firstDay == 0 ? 7 : firstDay))) {
    weekNo ++;
  }
  weekNo = Math.floor(weekNo);
  return weekNo;
}

function q__getDayOfYear(date) {
  var dayCounter = DAY_COUNTS[date.getMonth()] + date.getDate();
  var year = date.getFullYear();
  if (q__isLeapYear(year))
    dayCounter++;
  return dayCounter;
}

function q__isLeapYear(year) {
  var key = "leapYearFlag" + year;
  if (window[key] == true)
    return true;
  if (window[key] == false)
    return false;
  var testDate = new Date(year, 1, 28);
  testDate.setDate(testDate.getDate() + 1);
  var result = (testDate.getMonth() == 1);
  window[key] = result;
  return result;
}

function q__fillDrop(calendar, dropTable, items, onclickHandler, boldIndex) {
  var rolloverClass = calendar._selectedDayClassName;
  dropTable.className = calendar._headerClassName;

  var nodeChildren = dropTable.childNodes;
  var copiedCildren = new Array();
  for (var i = 0; i < nodeChildren.length; i++) {
    copiedCildren[i] = nodeChildren[i];
  }
  for (var i = 0; i < copiedCildren.length; i++) {
    var child = copiedCildren[i];
    dropTable.removeChild(child);
  }

  var tbody = document.createElement("tbody");
  dropTable.appendChild(tbody);

  var parentFontFamily = q__calculateStyleProperty(dropTable, "font-family");
  var parentFontSize = q__calculateStyleProperty(dropTable, "font-size");
  var parentFontWeight = q__calculateStyleProperty(dropTable, "font-weight");
  var parentFontStyle = q__calculateStyleProperty(dropTable, "font-style");

  for (var i = 0, count = items.length; i < count; i ++) {
    var tr = document.createElement("tr");
    var td = document.createElement("td");
    tr.appendChild(td);
    var div = document.createElement("div");
    td.appendChild(div);
    div.style.fontFamily = parentFontFamily;
    div.style.fontSize = parentFontSize;
    div.style.fontWeight = parentFontWeight;
    div.style.fontStyle = parentFontStyle;
    div.id = dropTable.id + "_" + i;
    div.innerHTML = items[i];
    div._rolloverClass = rolloverClass;
    div.style.width = "100%";

    tr._itemNo = i;
    tr._item = items[i];

    var applyOnclick = true;
    if (i == boldIndex) {
      div.style.fontWeight = 'bold';
      tr._isBold = true;
      applyOnclick = false;
    }

    tr.onmouseover = function() {
      q__calendar_dropItemMouseOver(this);
      q__operaStrictWorkaround();
    };
    tr.onmouseout = function () {
      q__calendar_dropItemMouseOut(this);
      q__operaStrictWorkaround();
    };
    tr._calendar = calendar;
    if (applyOnclick) {
      tr.onclick = onclickHandler;
      tr.style.cursor = "pointer";
    } else {
      tr.style.cursor = "default";
    }
    tr._drop = dropTable;
    tbody.appendChild(tr);
  }

  dropTable.style.border = '1px solid black';
  dropTable.onmouseout = function () {
    if (this._timeout) {
      clearTimeout(this._timeout);
    }
    this._timeout = setTimeout(function() {
      q__calendar_hideDrop(dropTable.id)
    }, 3000);
  };
  dropTable.onmouseover = function() {
    if (this._timeout) {
      clearTimeout(this._timeout);
    }
  };
}

function q__calendar_initializeDrops(cal) {
  if (cal._dropsInitialized)
    return;
  cal._dropsInitialized = true;
  var monthSelector = q__getControl(cal._monthSelectorId);
  var yearSelector = q__getControl(cal._yearSelectorId);

  var monthDrop = q__getControl(cal._monthSelectorId + cal._dropSuffix);
  var dtf = q__getDateTimeFormatObject(cal._localeStr);
  if (!dtf) return;
  var months = dtf.getMonths();
  q__fillDrop(cal, monthDrop, months, function() {
    q__calendar_monthDropItemClick(this._calendar, this);
  }, cal._currentMonth);

  monthDrop.style.width = '11ex';

  var yearDrop = q__getControl(cal._yearSelectorId + cal._dropSuffix);

  var yearsBefore = 4;
  var yearsAfter = 4;
  var curYear = cal._currentYear;
  var firstYear = curYear - yearsBefore;
  var lastYear = curYear + yearsAfter;
  var years = new Array();

  for (var i = firstYear; i <= lastYear; i++)
    years.push(i);

  q__fillDrop(cal, yearDrop, years, function() {
    q__calendar_yearDropItemClick(this._calendar, this);
  }, yearsBefore);

  yearDrop.style.width = '6ex';
}

function q__calendar_hideDrop(controlId) {
  var drop = q__getControl(controlId);
  if (drop._timeout) {
    clearTimeout(drop._timeout);
  }
  drop.hide();
}

function q__calendar_hideDrops(calId) {
  var cal = q__getControl(calId);
  var monthDropId = cal._monthSelectorId + cal._dropSuffix;
  var yearDropId = cal._yearSelectorId + cal._dropSuffix;
  q__calendar_hideDrop(monthDropId);
  q__calendar_hideDrop(yearDropId);
}

function q__calendar_showDrop(calendar, controlId) {
  q__calendar_initializeDrops(calendar);
  var drop = q__getControl(controlId);
  drop.show();
  q__operaStrictWorkaround();
}

function q__calendar_dropItemMouseOver(dropItem) {
  //  dropItem.className = dropItem._rolloverClass;
  dropItem.style.background = !q__isSafari() ? "Highlight" : "blue";
  dropItem.style.color = !q__isSafari() ? "HighlightText" : "white";
  dropItem.style.cursor = 'pointer';
  if (dropItem._isBold) {
    dropItem.style.fontWeight = 'bold';
  }
}

function q__calendar_dropItemMouseOut(dropItem) {
  //  dropItem.style.cssText = "";
  dropItem.style.background = q__isSafari() ? "none" : "";
  dropItem.style.color = "";
  dropItem.style.cursor = 'pointer';
  if (dropItem._isBold) {
    dropItem.style.fontWeight = 'bold';
  }
}

function q__calendar_monthDropItemClick(cal, item) {
  q__calendar_hideDrop(item._drop.id);
  cal._currentMonth = item._itemNo;
  q__updateCalendar(cal);
}

function q__calendar_yearDropItemClick(cal, item) {
  q__calendar_hideDrop(item._drop.id);
  cal._currentYear = item._item;
  q__updateCalendar(cal);
}

function q__findDateInRange(date, range) {
  var dates = range.getDates();
  for (var i = 0; i < dates.length; i ++) {
    if (q__calendar_compareDates(date, dates[i]) == 0) return true;
  }
  return false;
}

function q__operaStrictWorkaround() {
  if (!q__isOpera())
    return;
  var body = document.getElementsByTagName("body")[0];
  body.style.visibility = "hidden";
  body.style.visibility = "visible";
}

function q__calendar_updateWithinMonth(calendar, date, cell) {
  var selectedCell = calendar._selectedCell;
  if (selectedCell) {
    selectedCell._isSelected = false;
    var className = selectedCell.className;
    var rolloverClassName = selectedCell._rolloverClassName;

    selectedCell.className = className.replace(calendar._selectedDayClassName, "");
    selectedCell._rolloverClassName = rolloverClassName.replace(calendar._rolloverSelectedDayClassName, "");
    selectedCell.onclick = function() {
      q__calendar_updateWithinMonth(this._calendar, this._date, this);
    };
  }
  cell.className += " " + calendar._selectedDayClassName;
  cell._rolloverClassName += " " + calendar._rolloverSelectedDayClassName;
  cell._isSelected = true;
  if (q__isExplorer()) {
    cell.onclick = null;
  } else {
    cell.onclick = undefined;
  }
  calendar._selectedCell = cell;

  if (calendar._showFooter) {
    var none = q__getControl(calendar._noneSelectorId);
    none.style.color = "";
    none.style.cursor = "pointer";
    none.onclick = function() {
      q__noneClick(this._calId);
    };
  }

  calendar._applyOnclick4today = true;

  var valueHolder = q__getControl(calendar._valueHolderId);
  valueHolder.value = q__cloneDate(date).getTime();
  calendar._currentMonth = date.getMonth();
  calendar._currentYear = date.getFullYear();

  if (calendar._dateRanges) {
    if (selectedCell) {
      selectedCell.className = selectedCell.className.replace(calendar._dateRanges._selectedDayClassName, "");
      selectedCell._rolloverClassName
              = selectedCell._rolloverClassName.replace(calendar._dateRanges._rolloverSelectedDayClassName, "");
      var ranges = calendar._dateRanges.getDateRanges();
      for (var i = 0; i < ranges.length; i++) {
        var simpleRange = ranges[i];
        if (simpleRange.isDateInRange(selectedCell._date)) {
          if (!calendar._dateRanges._disableIncluded) {
            if (simpleRange._selectedDayStyleClassName) {
              selectedCell.className = selectedCell.className.replace(simpleRange._selectedDayStyleClassName, "");
            }
            if (simpleRange._rolloverSelectedDayStyleClassName) {
              selectedCell._rolloverClassName
                      = selectedCell._rolloverClassName.replace(simpleRange._rolloverSelectedDayStyleClassName, "");
            }
          }
        }
      }
    }
    q__calendar_updateDateRangesSelectedStyles(calendar, cell);
  }

  if (calendar._showFooter) {
    q__calendar_updateToday(calendar);
  }
  if (calendar._fireServerDateChange) {
    q__submitEnclosingForm(calendar);
  }
  if (calendar._onDateChange) {
    calendar._onDateChange();
  }
  q__notifyDateChangeListeners(calendar.id);
}

function q__calendar_updateDateRangesSelectedStyles(calendar, cell) {
  var dateRanges = calendar._dateRanges;
  if (dateRanges) {
    var foundInRange = false;
    var ranges = dateRanges.getDateRanges();
    for (var i = 0; i < ranges.length; i ++) {
      if (ranges[i].isDateInRange(cell._date)) {
        foundInRange = true;
        var simpleRange = ranges[i];
        if (!dateRanges._disableIncluded) {
          if (cell._isSelected) {
            if (simpleRange._selectedDayStyleClassName) {
              cell.className = cell.className.replace(calendar._selectedDayClassName, "");
              cell.className += " " + simpleRange._selectedDayStyleClassName;
            }
            if (simpleRange._rolloverSelectedDayStyleClassName) {
              cell._rolloverClassName = cell._rolloverClassName.replace(calendar._rolloverSelectedDayClassName, "");
              cell._rolloverClassName += " " + simpleRange._rolloverSelectedDayStyleClassName;
            }
          }
        }
      }
    }
    if (foundInRange && !dateRanges._disableIncluded) {
      if (cell._isSelected) {
        if (dateRanges._selectedDayClassName) {
          cell.className = cell.className.replace(calendar._selectedDayClassName, "");
          cell.className += " " + dateRanges._selectedDayClassName;
        }
        if (dateRanges._rolloverSelectedDayClassName) {
          cell._rolloverClassName = cell._rolloverClassName.replace(calendar._rolloverSelectedDayClassName, "");
          cell._rolloverClassName += " " + dateRanges._rolloverSelectedDayClassName;
        }

        if (cell._isToday && dateRanges._rolloverSelectedDayClassName) {
          cell._rolloverClassName = cell._rolloverClassName.replace(calendar._rolloverTodayClassName, "");
        }
      } else {
        if (cell._isToday) {
          cell._rolloverClassName = cell._rolloverClassName.replace(calendar._rolloverTodayClassName, "");
        }
      }
    }
  }
}