/*
 * Copyright (c) 1998-2006 TeamDev Ltd. All Rights Reserved.
 * Use is subject to license terms.
 */

function q__initEventHandler() {
  if (document.q__clickHandler) {
    return;
  }
  document.q__clickHandler = q__popupClicked;
  var _clickHandler = q__getEventHandlerFunction('q__clickHandler', null, document);
  document._addClickListener(_clickHandler);
}

q__initEventHandler();

function q__initPopup(popupId) {
  var popup = q__getControl(popupId);

  if (!document.TC__POPUPS_ON_PAGE) {
    document.TC__POPUPS_ON_PAGE = new Array();
  }
  document.TC__POPUPS_ON_PAGE[document.TC__POPUPS_ON_PAGE.length] = popupId;

  popup._visibilityChangeListeners = null;
  popup._addVisibilityChangeListener = function(listenerObjectFunction) {
    if (!this._visibilityChangeListeners) {
      this._visibilityChangeListeners = new Array();
    }
    this._visibilityChangeListeners[this._visibilityChangeListeners.length] = listenerObjectFunction;
  }


  /*
    popup.setLeft = function(left) {
      this.style.left = left + "px";
    }

    popup.setTop = function(top) {
      this.style.top = top + "px";
    }
  */
  popup.setLeft = function (left) {
    if (q__isExplorer()) {
      var outerDiv = popup._outerIEDiv;
      if (outerDiv) {
        outerDiv.style.left = left + "px";
      } else {
        popup.style.left = left + "px";
      }
    } else {
      popup.style.left = left + "px";
    }
  }

  popup.setTop = function (top) {
    if (q__isExplorer()) {
      var outerDiv = popup._outerIEDiv;
      if (outerDiv) {
        outerDiv.style.top = top + "px";
      } else {
        popup.style.top = top + "px";
      }
    } else {
      popup.style.top = top + "px";
    }
  }

  popup.setWidth = function(width) {
    this.style.width = width;
  }

  popup.show = function() {
    if (this.isVisible())
      return;

    if (q__isExplorer())
      q__createIEDragControl(this);

    //    q__hideControlsUnderPopup(this);
    this.style.visibility = 'visible';
    q__popup_notifyVisibilityChangeListeners(this.id);
  }

  popup.hide = function() {
    if (!this.isVisible())
      return;

    if (q__isExplorer())
      q__removeIEDragControl(this);

    //      q__unhideControlsUnderPopup(this);
    this.style.visibility = 'hidden';
    q__popup_notifyVisibilityChangeListeners(this.id);
  }

  popup.isVisible = function() {
    var visible = (this.style.visibility == 'visible');
    return visible;
  }
}

function q__popup_notifyVisibilityChangeListeners(popupId) {
  var popup = q__getControl(popupId);
  var listeners = popup._visibilityChangeListeners;
  if (listeners && listeners.length > 0) {
    for (var i = 0; i < listeners.length; i ++) {
      listeners[i](popup.isVisible());
    }
  }
}

function q__popupClicked(e) {
  var evt = e ? e : event;
  if (!evt) return;

  var clickedElement;
  if (evt.target) {
    clickedElement = evt.target;
  } else {
    clickedElement = evt.srcElement;
  }


  var clickedElementId = clickedElement.id;

  if (document.TC__POPUPS_ON_PAGE)
    for (var i = 0; i < document.TC__POPUPS_ON_PAGE.length; i ++) {
      var popupId = document.TC__POPUPS_ON_PAGE[i];
      var popup = q__getControl(popupId);
      if (!popup)
        continue; // popup can be removed from page with A4J
      var clickedOnChild = q__isChild(popup, clickedElement);
      if (popupId == clickedElementId || clickedOnChild) {
        continue;
      } else {
        popup.hide();
      }
    }
}
