/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class XYSeriesCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYSeriesCollectionTests.class);
    }

    public XYSeriesCollectionTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series"));
        s1.add(1.0, 1.1);
        XYSeriesCollection c1 = new XYSeriesCollection();
        c1.addSeries(s1);
        XYSeries s2 = new XYSeries((Comparable)((Object)"Series"));
        s2.add(1.0, 1.1);
        XYSeriesCollection c2 = new XYSeriesCollection();
        c2.addSeries(s2);
        XYSeriesCollectionTests.assertTrue((boolean)c1.equals(c2));
        XYSeriesCollectionTests.assertTrue((boolean)c2.equals(c1));
        c1.addSeries(new XYSeries((Comparable)((Object)"Empty Series")));
        XYSeriesCollectionTests.assertFalse((boolean)c1.equals(c2));
        c2.addSeries(new XYSeries((Comparable)((Object)"Empty Series")));
        XYSeriesCollectionTests.assertTrue((boolean)c1.equals(c2));
    }

    public void testCloning() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series"));
        s1.add(1.0, 1.1);
        XYSeriesCollection c1 = new XYSeriesCollection();
        c1.addSeries(s1);
        XYSeriesCollection c2 = null;
        try {
            c2 = (XYSeriesCollection)c1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYSeriesCollectionTests.assertTrue((c1 != c2 ? 1 : 0) != 0);
        XYSeriesCollectionTests.assertTrue((c1.getClass() == c2.getClass() ? 1 : 0) != 0);
        XYSeriesCollectionTests.assertTrue((boolean)c1.equals(c2));
    }

    public void testSerialization() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series"));
        s1.add(1.0, 1.1);
        XYSeriesCollection c1 = new XYSeriesCollection();
        c1.addSeries(s1);
        XYSeriesCollection c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(c1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            c2 = (XYSeriesCollection)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYSeriesCollectionTests.assertEquals((Object)c1, c2);
    }

    public void test1170825() {
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series1"));
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(s1);
        try {
            dataset.getSeries(1);
        }
        catch (IllegalArgumentException e) {
        }
        catch (IndexOutOfBoundsException e) {
            XYSeriesCollectionTests.assertTrue((boolean)false);
        }
    }
}

