/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.xy.OHLCDataItem;

public class OHLCDataItemTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(OHLCDataItemTests.class);
    }

    public OHLCDataItemTests(String name) {
        super(name);
    }

    public void testEquals() {
        OHLCDataItem i1 = new OHLCDataItem(new Date(1L), 1.0, 2.0, 3.0, 4.0, 5.0);
        OHLCDataItem i2 = new OHLCDataItem(new Date(1L), 1.0, 2.0, 3.0, 4.0, 5.0);
        OHLCDataItemTests.assertTrue((boolean)i1.equals(i2));
        OHLCDataItemTests.assertTrue((boolean)i2.equals(i1));
    }

    public void testCloning() {
        OHLCDataItem i1 = new OHLCDataItem(new Date(1L), 1.0, 2.0, 3.0, 4.0, 5.0);
        OHLCDataItemTests.assertFalse((boolean)(i1 instanceof Cloneable));
    }

    public void testSerialization() {
        OHLCDataItem i1 = new OHLCDataItem(new Date(1L), 1.0, 2.0, 3.0, 4.0, 5.0);
        OHLCDataItem i2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(i1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            i2 = (OHLCDataItem)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OHLCDataItemTests.assertEquals((Object)i1, i2);
    }
}

