/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.TimePeriodFormatException;
import org.jfree.data.time.Year;

public class YearTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(YearTests.class);
    }

    public YearTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testEqualsSelf() {
        Year year = new Year();
        YearTests.assertTrue((boolean)year.equals(year));
    }

    public void testEquals() {
        Year year1 = new Year(2002);
        Year year2 = new Year(2002);
        YearTests.assertTrue((boolean)year1.equals(year2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Date d1 = new Date(1009843199999L);
        Date d2 = new Date(1009843200000L);
        Year y1 = new Year(d1, zone);
        Year y2 = new Year(d2, zone);
        YearTests.assertEquals((int)2001, (int)y1.getYear());
        YearTests.assertEquals((long)1009843199999L, (long)y1.getLastMillisecond(zone));
        YearTests.assertEquals((int)2002, (int)y2.getYear());
        YearTests.assertEquals((long)1009843200000L, (long)y2.getFirstMillisecond(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("America/Los_Angeles");
        Year y1 = new Year(new Date(1009871999999L), zone);
        Year y2 = new Year(new Date(1009872000000L), zone);
        YearTests.assertEquals((int)2001, (int)y1.getYear());
        YearTests.assertEquals((long)1009871999999L, (long)y1.getLastMillisecond(zone));
        YearTests.assertEquals((int)2002, (int)y2.getYear());
        YearTests.assertEquals((long)1009872000000L, (long)y2.getFirstMillisecond(zone));
    }

    public void test1900Previous() {
        Year current = new Year(1900);
        Year previous = (Year)current.previous();
        YearTests.assertNull((Object)previous);
    }

    public void test1900Next() {
        Year current = new Year(1900);
        Year next = (Year)current.next();
        YearTests.assertEquals((int)1901, (int)next.getYear());
    }

    public void test9999Previous() {
        Year current = new Year(9999);
        Year previous = (Year)current.previous();
        YearTests.assertEquals((int)9998, (int)previous.getYear());
    }

    public void test9999Next() {
        Year current = new Year(9999);
        Year next = (Year)current.next();
        YearTests.assertNull((Object)next);
    }

    public void testParseYear() {
        Year year = null;
        try {
            year = Year.parseYear("2000");
        }
        catch (TimePeriodFormatException e) {
            year = new Year(1900);
        }
        YearTests.assertEquals((int)2000, (int)year.getYear());
        try {
            year = Year.parseYear(" 2001 ");
        }
        catch (TimePeriodFormatException e) {
            year = new Year(1900);
        }
        YearTests.assertEquals((int)2001, (int)year.getYear());
        try {
            year = Year.parseYear("99");
        }
        catch (TimePeriodFormatException e) {
            year = new Year(1900);
        }
        YearTests.assertEquals((int)1900, (int)year.getYear());
    }

    public void testSerialization() {
        Year y1 = new Year(1999);
        Year y2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(y1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            y2 = (Year)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        YearTests.assertEquals((Object)y1, y2);
    }

    public void testNotCloneable() {
        Year y = new Year(1999);
        YearTests.assertFalse((boolean)(y instanceof Cloneable));
    }

    public void testHashcode() {
        Year y1 = new Year(1988);
        Year y2 = new Year(1988);
        YearTests.assertTrue((boolean)y1.equals(y2));
        int h1 = y1.hashCode();
        int h2 = y2.hashCode();
        YearTests.assertEquals((int)h1, (int)h2);
    }
}

