/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Week;

public class WeekTests
extends TestCase {
    private Week w1Y1900;
    private Week w2Y1900;
    private Week w51Y9999;
    private Week w52Y9999;

    public static Test suite() {
        return new TestSuite(WeekTests.class);
    }

    public WeekTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.w1Y1900 = new Week(1, 1900);
        this.w2Y1900 = new Week(2, 1900);
        this.w51Y9999 = new Week(51, 9999);
        this.w52Y9999 = new Week(52, 9999);
    }

    public void testEquals() {
        Week w1 = new Week(1, 2002);
        Week w2 = new Week(1, 2002);
        WeekTests.assertTrue((boolean)w1.equals(w2));
        WeekTests.assertTrue((boolean)w2.equals(w1));
        w1 = new Week(2, 2002);
        WeekTests.assertFalse((boolean)w1.equals(w2));
        w2 = new Week(2, 2002);
        WeekTests.assertTrue((boolean)w1.equals(w2));
        w1 = new Week(2, 2003);
        WeekTests.assertFalse((boolean)w1.equals(w2));
        w2 = new Week(2, 2003);
        WeekTests.assertTrue((boolean)w1.equals(w2));
    }

    public void testW1Y1900Previous() {
        Week previous = (Week)this.w1Y1900.previous();
        WeekTests.assertNull((Object)previous);
    }

    public void testW1Y1900Next() {
        Week next = (Week)this.w1Y1900.next();
        WeekTests.assertEquals((Object)this.w2Y1900, (Object)next);
    }

    public void testW52Y9999Previous() {
        Week previous = (Week)this.w52Y9999.previous();
        WeekTests.assertEquals((Object)this.w51Y9999, (Object)previous);
    }

    public void testW52Y9999Next() {
        Week next = (Week)this.w52Y9999.next();
        WeekTests.assertNull((Object)next);
    }

    public void testSerialization() {
        Week w1 = new Week(24, 1999);
        Week w2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(w1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            w2 = (Week)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        WeekTests.assertEquals((Object)w1, w2);
    }

    public void testHashcode() {
        Week w1 = new Week(2, 2003);
        Week w2 = new Week(2, 2003);
        WeekTests.assertTrue((boolean)w1.equals(w2));
        int h1 = w1.hashCode();
        int h2 = w2.hashCode();
        WeekTests.assertEquals((int)h1, (int)h2);
    }

    public void testNotCloneable() {
        Week w = new Week(1, 1999);
        WeekTests.assertFalse((boolean)(w instanceof Cloneable));
    }

    public void testWeek12005() {
        Week w1 = new Week(1, 2005);
        Calendar c1 = Calendar.getInstance(TimeZone.getTimeZone("Europe/London"), Locale.UK);
        c1.setMinimalDaysInFirstWeek(4);
        WeekTests.assertEquals((long)1104710400000L, (long)w1.getFirstMillisecond(c1));
        WeekTests.assertEquals((long)1105315199999L, (long)w1.getLastMillisecond(c1));
        Calendar c2 = Calendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRANCE);
        c2.setMinimalDaysInFirstWeek(4);
        WeekTests.assertEquals((long)1104706800000L, (long)w1.getFirstMillisecond(c2));
        WeekTests.assertEquals((long)1105311599999L, (long)w1.getLastMillisecond(c2));
        Calendar c3 = Calendar.getInstance(TimeZone.getTimeZone("America/New_York"), Locale.US);
        WeekTests.assertEquals((long)1104037200000L, (long)w1.getFirstMillisecond(c3));
        WeekTests.assertEquals((long)1104641999999L, (long)w1.getLastMillisecond(c3));
    }

    public void testWeek532005() {
        Week w1 = new Week(53, 2004);
        Calendar c1 = Calendar.getInstance(TimeZone.getTimeZone("Europe/London"), Locale.UK);
        c1.setMinimalDaysInFirstWeek(4);
        WeekTests.assertEquals((long)1104105600000L, (long)w1.getFirstMillisecond(c1));
        WeekTests.assertEquals((long)1104710399999L, (long)w1.getLastMillisecond(c1));
        Calendar c2 = Calendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRANCE);
        c2.setMinimalDaysInFirstWeek(4);
        WeekTests.assertEquals((long)1104102000000L, (long)w1.getFirstMillisecond(c2));
        WeekTests.assertEquals((long)1104706799999L, (long)w1.getLastMillisecond(c2));
        w1 = new Week(53, 2005);
        Calendar c3 = Calendar.getInstance(TimeZone.getTimeZone("America/New_York"), Locale.US);
        WeekTests.assertEquals((long)1135486800000L, (long)w1.getFirstMillisecond(c3));
        WeekTests.assertEquals((long)1136091599999L, (long)w1.getLastMillisecond(c3));
    }
}

