/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class TimeSeriesCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TimeSeriesCollectionTests.class);
    }

    public TimeSeriesCollectionTests(String name) {
        super(name);
    }

    public void testEquals() {
        TimeSeriesCollection c1 = new TimeSeriesCollection();
        TimeSeriesCollection c2 = new TimeSeriesCollection();
        TimeSeries s1 = new TimeSeries("Series 1");
        TimeSeries s2 = new TimeSeries("Series 2");
        boolean b1 = c1.equals(c2);
        TimeSeriesCollectionTests.assertTrue((String)"b1", (boolean)b1);
        c1.addSeries(s1);
        c1.addSeries(s2);
        boolean b2 = c1.equals(c2);
        TimeSeriesCollectionTests.assertFalse((String)"b2", (boolean)b2);
        c2.addSeries(s1);
        c2.addSeries(s2);
        boolean b3 = c1.equals(c2);
        TimeSeriesCollectionTests.assertTrue((String)"b3", (boolean)b3);
        c2.removeSeries(s2);
        boolean b4 = c1.equals(c2);
        TimeSeriesCollectionTests.assertFalse((String)"b4", (boolean)b4);
        c1.removeSeries(s2);
        boolean b5 = c1.equals(c2);
        TimeSeriesCollectionTests.assertTrue((String)"b5", (boolean)b5);
    }

    public void testRemoveSeries() {
        TimeSeriesCollection c1 = new TimeSeriesCollection();
        TimeSeries s1 = new TimeSeries("Series 1");
        TimeSeries s2 = new TimeSeries("Series 2");
        TimeSeries s3 = new TimeSeries("Series 3");
        TimeSeries s4 = new TimeSeries("Series 4");
        c1.addSeries(s1);
        c1.addSeries(s2);
        c1.addSeries(s3);
        c1.addSeries(s4);
        c1.removeSeries(s3);
        TimeSeries s = c1.getSeries(2);
        boolean b1 = s.equals(s4);
        TimeSeriesCollectionTests.assertTrue((boolean)b1);
    }

    public void testGetSurroundingItems() {
        TimeSeries series = new TimeSeries("Series 1", Day.class);
        TimeSeriesCollection collection = new TimeSeriesCollection(series);
        collection.setXPosition(TimePeriodAnchor.MIDDLE);
        int[] result = collection.getSurroundingItems(0, 1000L);
        TimeSeriesCollectionTests.assertTrue((result[0] == -1 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((result[1] == -1 ? 1 : 0) != 0);
        Day today = new Day();
        long start1 = today.getFirstMillisecond();
        long middle1 = today.getMiddleMillisecond();
        long end1 = today.getLastMillisecond();
        series.add((RegularTimePeriod)today, 99.9);
        result = collection.getSurroundingItems(0, start1);
        TimeSeriesCollectionTests.assertTrue((result[0] == -1 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((result[1] == 0 ? 1 : 0) != 0);
        result = collection.getSurroundingItems(0, middle1);
        TimeSeriesCollectionTests.assertTrue((result[0] == 0 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((result[1] == 0 ? 1 : 0) != 0);
        result = collection.getSurroundingItems(0, end1);
        TimeSeriesCollectionTests.assertTrue((result[0] == 0 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((result[1] == -1 ? 1 : 0) != 0);
        Day tomorrow = (Day)today.next();
        long start2 = tomorrow.getFirstMillisecond();
        long middle2 = tomorrow.getMiddleMillisecond();
        long end2 = tomorrow.getLastMillisecond();
        series.add((RegularTimePeriod)tomorrow, 199.9);
        result = collection.getSurroundingItems(0, start2);
        TimeSeriesCollectionTests.assertTrue((result[0] == 0 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((result[1] == 1 ? 1 : 0) != 0);
        result = collection.getSurroundingItems(0, middle2);
        TimeSeriesCollectionTests.assertTrue((result[0] == 1 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((result[1] == 1 ? 1 : 0) != 0);
        result = collection.getSurroundingItems(0, end2);
        TimeSeriesCollectionTests.assertTrue((result[0] == 1 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((result[1] == -1 ? 1 : 0) != 0);
        Day yesterday = (Day)today.previous();
        long start3 = yesterday.getFirstMillisecond();
        long middle3 = yesterday.getMiddleMillisecond();
        long end3 = yesterday.getLastMillisecond();
        series.add((RegularTimePeriod)yesterday, 1.23);
        result = collection.getSurroundingItems(0, start3);
        TimeSeriesCollectionTests.assertTrue((result[0] == -1 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((result[1] == 0 ? 1 : 0) != 0);
        result = collection.getSurroundingItems(0, middle3);
        TimeSeriesCollectionTests.assertTrue((result[0] == 0 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((result[1] == 0 ? 1 : 0) != 0);
        result = collection.getSurroundingItems(0, end3);
        TimeSeriesCollectionTests.assertTrue((result[0] == 0 ? 1 : 0) != 0);
        TimeSeriesCollectionTests.assertTrue((result[1] == 1 ? 1 : 0) != 0);
    }

    public void testSerialization() {
        TimeSeriesCollection c1 = new TimeSeriesCollection(this.createSeries());
        TimeSeriesCollection c2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(c1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            c2 = (TimeSeriesCollection)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        TimeSeriesCollectionTests.assertEquals((Object)c1, c2);
    }

    private TimeSeries createSeries() {
        RegularTimePeriod t = new Day();
        TimeSeries series = new TimeSeries("Test");
        series.add(t, 1.0);
        t = t.next();
        series.add(t, 2.0);
        t = t.next();
        series.add(t, null);
        t = t.next();
        series.add(t, 4.0);
        return series;
    }

    public void test1170825() {
        TimeSeries s1 = new TimeSeries("Series1");
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s1);
        try {
            dataset.getSeries(1);
        }
        catch (IllegalArgumentException e) {
        }
        catch (IndexOutOfBoundsException e) {
            TimeSeriesCollectionTests.assertTrue((boolean)false);
        }
    }
}

