/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.TimePeriodFormatException;

public class QuarterTests
extends TestCase {
    private Quarter q1Y1900;
    private Quarter q2Y1900;
    private Quarter q3Y9999;
    private Quarter q4Y9999;

    public static Test suite() {
        return new TestSuite(QuarterTests.class);
    }

    public QuarterTests(String name) {
        super(name);
    }

    protected void setUp() {
        this.q1Y1900 = new Quarter(1, 1900);
        this.q2Y1900 = new Quarter(2, 1900);
        this.q3Y9999 = new Quarter(3, 9999);
        this.q4Y9999 = new Quarter(4, 9999);
    }

    public void testEqualsSelf() {
        Quarter quarter = new Quarter();
        QuarterTests.assertTrue((boolean)quarter.equals(quarter));
    }

    public void testEquals() {
        Quarter q1 = new Quarter(2, 2002);
        Quarter q2 = new Quarter(2, 2002);
        QuarterTests.assertTrue((boolean)q1.equals(q2));
    }

    public void testDateConstructor1() {
        TimeZone zone = TimeZone.getTimeZone("GMT");
        Quarter q1 = new Quarter(new Date(1017619199999L), zone);
        Quarter q2 = new Quarter(new Date(1017619200000L), zone);
        QuarterTests.assertEquals((int)1, (int)q1.getQuarter());
        QuarterTests.assertEquals((long)1017619199999L, (long)q1.getLastMillisecond(zone));
        QuarterTests.assertEquals((int)2, (int)q2.getQuarter());
        QuarterTests.assertEquals((long)1017619200000L, (long)q2.getFirstMillisecond(zone));
    }

    public void testDateConstructor2() {
        TimeZone zone = TimeZone.getTimeZone("Europe/Istanbul");
        Quarter q1 = new Quarter(new Date(1017608399999L), zone);
        Quarter q2 = new Quarter(new Date(1017608400000L), zone);
        QuarterTests.assertEquals((int)1, (int)q1.getQuarter());
        QuarterTests.assertEquals((long)1017608399999L, (long)q1.getLastMillisecond(zone));
        QuarterTests.assertEquals((int)2, (int)q2.getQuarter());
        QuarterTests.assertEquals((long)1017608400000L, (long)q2.getFirstMillisecond(zone));
    }

    public void testQ1Y1900Previous() {
        Quarter previous = (Quarter)this.q1Y1900.previous();
        QuarterTests.assertNull((Object)previous);
    }

    public void testQ1Y1900Next() {
        Quarter next = (Quarter)this.q1Y1900.next();
        QuarterTests.assertEquals((Object)this.q2Y1900, (Object)next);
    }

    public void testQ4Y9999Previous() {
        Quarter previous = (Quarter)this.q4Y9999.previous();
        QuarterTests.assertEquals((Object)this.q3Y9999, (Object)previous);
    }

    public void testQ4Y9999Next() {
        Quarter next = (Quarter)this.q4Y9999.next();
        QuarterTests.assertNull((Object)next);
    }

    public void testParseQuarter() {
        Quarter quarter = null;
        try {
            quarter = Quarter.parseQuarter("Q1-2000");
        }
        catch (TimePeriodFormatException e) {
            quarter = new Quarter(1, 1900);
        }
        QuarterTests.assertEquals((int)1, (int)quarter.getQuarter());
        QuarterTests.assertEquals((int)2000, (int)quarter.getYear().getYear());
        try {
            quarter = Quarter.parseQuarter("2001-Q2");
        }
        catch (TimePeriodFormatException e) {
            quarter = new Quarter(1, 1900);
        }
        QuarterTests.assertEquals((int)2, (int)quarter.getQuarter());
        QuarterTests.assertEquals((int)2001, (int)quarter.getYear().getYear());
        try {
            quarter = Quarter.parseQuarter("Q3, 2002");
        }
        catch (TimePeriodFormatException e) {
            quarter = new Quarter(1, 1900);
        }
        QuarterTests.assertEquals((int)3, (int)quarter.getQuarter());
        QuarterTests.assertEquals((int)2002, (int)quarter.getYear().getYear());
    }

    public void testSerialization() {
        Quarter q1 = new Quarter(4, 1999);
        Quarter q2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(q1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            q2 = (Quarter)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        QuarterTests.assertEquals((Object)q1, q2);
    }

    public void testHashcode() {
        Quarter q1 = new Quarter(2, 2003);
        Quarter q2 = new Quarter(2, 2003);
        QuarterTests.assertTrue((boolean)q1.equals(q2));
        int h1 = q1.hashCode();
        int h2 = q2.hashCode();
        QuarterTests.assertEquals((int)h1, (int)h2);
    }

    public void testNotCloneable() {
        Quarter q = new Quarter(2, 2003);
        QuarterTests.assertFalse((boolean)(q instanceof Cloneable));
    }
}

