/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.statistics.SimpleHistogramBin;

public class SimpleHistogramBinTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(SimpleHistogramBinTests.class);
    }

    public SimpleHistogramBinTests(String name) {
        super(name);
    }

    public void testAccepts() {
        SimpleHistogramBin bin1 = new SimpleHistogramBin(1.0, 2.0);
        SimpleHistogramBinTests.assertFalse((boolean)bin1.accepts(0.0));
        SimpleHistogramBinTests.assertTrue((boolean)bin1.accepts(1.0));
        SimpleHistogramBinTests.assertTrue((boolean)bin1.accepts(1.5));
        SimpleHistogramBinTests.assertTrue((boolean)bin1.accepts(2.0));
        SimpleHistogramBinTests.assertFalse((boolean)bin1.accepts(2.1));
        SimpleHistogramBinTests.assertFalse((boolean)bin1.accepts(Double.NaN));
        SimpleHistogramBin bin2 = new SimpleHistogramBin(1.0, 2.0, false, false);
        SimpleHistogramBinTests.assertFalse((boolean)bin2.accepts(0.0));
        SimpleHistogramBinTests.assertFalse((boolean)bin2.accepts(1.0));
        SimpleHistogramBinTests.assertTrue((boolean)bin2.accepts(1.5));
        SimpleHistogramBinTests.assertFalse((boolean)bin2.accepts(2.0));
        SimpleHistogramBinTests.assertFalse((boolean)bin2.accepts(2.1));
        SimpleHistogramBinTests.assertFalse((boolean)bin2.accepts(Double.NaN));
    }

    public void testOverlapsWidth() {
        SimpleHistogramBin b1 = new SimpleHistogramBin(1.0, 2.0);
        SimpleHistogramBin b2 = new SimpleHistogramBin(2.0, 3.0);
        SimpleHistogramBin b3 = new SimpleHistogramBin(3.0, 4.0);
        SimpleHistogramBin b4 = new SimpleHistogramBin(0.0, 5.0);
        SimpleHistogramBin b5 = new SimpleHistogramBin(2.0, 3.0, false, true);
        SimpleHistogramBin b6 = new SimpleHistogramBin(2.0, 3.0, true, false);
        SimpleHistogramBinTests.assertTrue((boolean)b1.overlapsWith(b2));
        SimpleHistogramBinTests.assertTrue((boolean)b2.overlapsWith(b1));
        SimpleHistogramBinTests.assertFalse((boolean)b1.overlapsWith(b3));
        SimpleHistogramBinTests.assertFalse((boolean)b3.overlapsWith(b1));
        SimpleHistogramBinTests.assertTrue((boolean)b1.overlapsWith(b4));
        SimpleHistogramBinTests.assertTrue((boolean)b4.overlapsWith(b1));
        SimpleHistogramBinTests.assertFalse((boolean)b1.overlapsWith(b5));
        SimpleHistogramBinTests.assertFalse((boolean)b5.overlapsWith(b1));
        SimpleHistogramBinTests.assertTrue((boolean)b1.overlapsWith(b6));
        SimpleHistogramBinTests.assertTrue((boolean)b6.overlapsWith(b1));
    }

    public void testEquals() {
        SimpleHistogramBin b1 = new SimpleHistogramBin(1.0, 2.0);
        SimpleHistogramBin b2 = new SimpleHistogramBin(1.0, 2.0);
        SimpleHistogramBinTests.assertTrue((boolean)b1.equals(b2));
        SimpleHistogramBinTests.assertTrue((boolean)b2.equals(b1));
        b1 = new SimpleHistogramBin(1.1, 2.0, true, true);
        SimpleHistogramBinTests.assertFalse((boolean)b1.equals(b2));
        b2 = new SimpleHistogramBin(1.1, 2.0, true, true);
        SimpleHistogramBinTests.assertTrue((boolean)b1.equals(b2));
        b1 = new SimpleHistogramBin(1.1, 2.2, true, true);
        SimpleHistogramBinTests.assertFalse((boolean)b1.equals(b2));
        b2 = new SimpleHistogramBin(1.1, 2.2, true, true);
        SimpleHistogramBinTests.assertTrue((boolean)b1.equals(b2));
        b1 = new SimpleHistogramBin(1.1, 2.2, false, true);
        SimpleHistogramBinTests.assertFalse((boolean)b1.equals(b2));
        b2 = new SimpleHistogramBin(1.1, 2.2, false, true);
        SimpleHistogramBinTests.assertTrue((boolean)b1.equals(b2));
        b1 = new SimpleHistogramBin(1.1, 2.2, false, false);
        SimpleHistogramBinTests.assertFalse((boolean)b1.equals(b2));
        b2 = new SimpleHistogramBin(1.1, 2.2, false, false);
        SimpleHistogramBinTests.assertTrue((boolean)b1.equals(b2));
        b1.setItemCount(99);
        SimpleHistogramBinTests.assertFalse((boolean)b1.equals(b2));
        b2.setItemCount(99);
        SimpleHistogramBinTests.assertTrue((boolean)b1.equals(b2));
    }

    public void testCloning() {
        SimpleHistogramBin b1 = new SimpleHistogramBin(1.1, 2.2, false, true);
        b1.setItemCount(99);
        SimpleHistogramBin b2 = null;
        try {
            b2 = (SimpleHistogramBin)b1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        SimpleHistogramBinTests.assertTrue((b1 != b2 ? 1 : 0) != 0);
        SimpleHistogramBinTests.assertTrue((b1.getClass() == b2.getClass() ? 1 : 0) != 0);
        SimpleHistogramBinTests.assertTrue((boolean)b1.equals(b2));
        b2.setItemCount(111);
        SimpleHistogramBinTests.assertFalse((boolean)b1.equals(b2));
    }

    public void testSerialization() {
        SimpleHistogramBin b1 = new SimpleHistogramBin(1.0, 2.0, false, true);
        b1.setItemCount(123);
        SimpleHistogramBin b2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(b1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            b2 = (SimpleHistogramBin)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        SimpleHistogramBinTests.assertEquals((Object)b1, b2);
    }
}

