/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.util.SortOrder;

public class DefaultKeyedValuesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultKeyedValuesTests.class);
    }

    public DefaultKeyedValuesTests(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testGetValue() {
        DefaultKeyedValues v1 = new DefaultKeyedValues();
        try {
            v1.getValue(-1);
            DefaultKeyedValuesTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            v1.getValue(0);
            DefaultKeyedValuesTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        DefaultKeyedValues v2 = new DefaultKeyedValues();
        v2.addValue((Comparable)((Object)"K1"), new Integer(1));
        v2.addValue((Comparable)((Object)"K2"), new Integer(2));
        v2.addValue((Comparable)((Object)"K3"), new Integer(3));
        DefaultKeyedValuesTests.assertEquals((Object)new Integer(3), (Object)v2.getValue(2));
    }

    public void testGetKey() {
        DefaultKeyedValues v1 = new DefaultKeyedValues();
        try {
            v1.getKey(-1);
            DefaultKeyedValuesTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            v1.getKey(0);
            DefaultKeyedValuesTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        DefaultKeyedValues v2 = new DefaultKeyedValues();
        v2.addValue((Comparable)((Object)"K1"), new Integer(1));
        v2.addValue((Comparable)((Object)"K2"), new Integer(2));
        v2.addValue((Comparable)((Object)"K3"), new Integer(3));
        DefaultKeyedValuesTests.assertEquals((Object)"K2", (Object)v2.getKey(1));
    }

    public void testGetIndex() {
        DefaultKeyedValues v1 = new DefaultKeyedValues();
        DefaultKeyedValuesTests.assertEquals((int)-1, (int)v1.getIndex((Comparable)((Object)"K1")));
        DefaultKeyedValues v2 = new DefaultKeyedValues();
        v2.addValue((Comparable)((Object)"K1"), new Integer(1));
        v2.addValue((Comparable)((Object)"K2"), new Integer(2));
        v2.addValue((Comparable)((Object)"K3"), new Integer(3));
        DefaultKeyedValuesTests.assertEquals((int)2, (int)v2.getIndex((Comparable)((Object)"K3")));
    }

    public void testCloning() {
        DefaultKeyedValues v1 = new DefaultKeyedValues();
        v1.addValue((Comparable)((Object)"V1"), new Integer(1));
        v1.addValue((Comparable)((Object)"V2"), null);
        v1.addValue((Comparable)((Object)"V3"), new Integer(3));
        DefaultKeyedValues v2 = null;
        try {
            v2 = (DefaultKeyedValues)v1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        DefaultKeyedValuesTests.assertTrue((v1 != v2 ? 1 : 0) != 0);
        DefaultKeyedValuesTests.assertTrue((v1.getClass() == v2.getClass() ? 1 : 0) != 0);
        DefaultKeyedValuesTests.assertTrue((boolean)v1.equals(v2));
        v2.setValue((Comparable)((Object)"V1"), new Integer(44));
        DefaultKeyedValuesTests.assertFalse((boolean)v1.equals(v2));
    }

    public void testInsertAndRetrieve() {
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"A"), new Double(1.0));
        data.addValue((Comparable)((Object)"B"), new Double(2.0));
        data.addValue((Comparable)((Object)"C"), new Double(3.0));
        data.addValue((Comparable)((Object)"D"), null);
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(0), (Object)"A");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(1), (Object)"B");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(2), (Object)"C");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(3), (Object)"D");
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"A")), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"B")), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"C")), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"D")), null);
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(0), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(1), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(2), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(3), null);
    }

    public void testSortByKeyAscending() {
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"C"), new Double(1.0));
        data.addValue((Comparable)((Object)"B"), null);
        data.addValue((Comparable)((Object)"D"), new Double(3.0));
        data.addValue((Comparable)((Object)"A"), new Double(2.0));
        data.sortByKeys(SortOrder.ASCENDING);
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(0), (Object)"A");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(1), (Object)"B");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(2), (Object)"C");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(3), (Object)"D");
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"B")), null);
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(0), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(1), null);
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(2), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(3), (Object)new Double(3.0));
    }

    public void testSortByKeyDescending() {
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"C"), new Double(1.0));
        data.addValue((Comparable)((Object)"B"), null);
        data.addValue((Comparable)((Object)"D"), new Double(3.0));
        data.addValue((Comparable)((Object)"A"), new Double(2.0));
        data.sortByKeys(SortOrder.DESCENDING);
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(0), (Object)"D");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(1), (Object)"C");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(2), (Object)"B");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(3), (Object)"A");
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"B")), null);
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(0), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(1), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(2), null);
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(3), (Object)new Double(2.0));
    }

    public void testSortByValueAscending() {
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"C"), new Double(1.0));
        data.addValue((Comparable)((Object)"B"), null);
        data.addValue((Comparable)((Object)"D"), new Double(3.0));
        data.addValue((Comparable)((Object)"A"), new Double(2.0));
        data.sortByValues(SortOrder.ASCENDING);
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(0), (Object)"C");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(1), (Object)"A");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(2), (Object)"D");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(3), (Object)"B");
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"B")), null);
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(0), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(1), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(2), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(3), null);
    }

    public void testSortByValueDescending() {
        DefaultKeyedValues data = new DefaultKeyedValues();
        data.addValue((Comparable)((Object)"C"), new Double(1.0));
        data.addValue((Comparable)((Object)"B"), null);
        data.addValue((Comparable)((Object)"D"), new Double(3.0));
        data.addValue((Comparable)((Object)"A"), new Double(2.0));
        data.sortByValues(SortOrder.DESCENDING);
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(0), (Object)"D");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(1), (Object)"A");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(2), (Object)"C");
        DefaultKeyedValuesTests.assertEquals((Object)data.getKey(3), (Object)"B");
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"A")), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"B")), null);
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"C")), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue((Comparable)((Object)"D")), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(0), (Object)new Double(3.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(1), (Object)new Double(2.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(2), (Object)new Double(1.0));
        DefaultKeyedValuesTests.assertEquals((Object)data.getValue(3), null);
    }

    public void testSerialization() {
        DefaultKeyedValues v1 = new DefaultKeyedValues();
        v1.addValue((Comparable)((Object)"Key 1"), new Double(23.0));
        v1.addValue((Comparable)((Object)"Key 2"), null);
        v1.addValue((Comparable)((Object)"Key 3"), new Double(42.0));
        DefaultKeyedValues v2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(v1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            v2 = (DefaultKeyedValues)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        DefaultKeyedValuesTests.assertEquals((Object)v1, v2);
    }
}

