/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DatasetUtilitiesTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(DatasetUtilitiesTests.class);
    }

    public DatasetUtilitiesTests(String name) {
        super(name);
    }

    public void testJava() {
        DatasetUtilitiesTests.assertTrue((boolean)Double.isNaN(Math.min(1.0, Double.NaN)));
        DatasetUtilitiesTests.assertTrue((boolean)Double.isNaN(Math.max(1.0, Double.NaN)));
    }

    public void testCalculatePieDatasetTotal() {
        DefaultPieDataset d = new DefaultPieDataset();
        DatasetUtilitiesTests.assertEquals((double)0.0, (double)DatasetUtilities.calculatePieDatasetTotal(d), (double)1.0E-10);
        d.setValue((Comparable)((Object)"A"), 1.0);
        DatasetUtilitiesTests.assertEquals((double)1.0, (double)DatasetUtilities.calculatePieDatasetTotal(d), (double)1.0E-10);
        d.setValue((Comparable)((Object)"B"), 3.0);
        DatasetUtilitiesTests.assertEquals((double)4.0, (double)DatasetUtilities.calculatePieDatasetTotal(d), (double)1.0E-10);
    }

    public void testFindDomainBounds() {
        XYDataset dataset = this.createXYDataset1();
        Range r = DatasetUtilities.findDomainBounds(dataset);
        DatasetUtilitiesTests.assertEquals((double)1.0, (double)r.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)3.0, (double)r.getUpperBound(), (double)1.0E-10);
    }

    public void testIterateDomainBounds() {
        XYDataset dataset = this.createXYDataset1();
        Range r = DatasetUtilities.iterateDomainBounds(dataset);
        DatasetUtilitiesTests.assertEquals((double)1.0, (double)r.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)3.0, (double)r.getUpperBound(), (double)1.0E-10);
    }

    public void testFindRangeBounds1() {
        CategoryDataset dataset = this.createCategoryDataset1();
        Range r = DatasetUtilities.findRangeBounds(dataset);
        DatasetUtilitiesTests.assertEquals((double)1.0, (double)r.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)6.0, (double)r.getUpperBound(), (double)1.0E-10);
    }

    public void testFindRangeBounds2() {
        XYDataset dataset = this.createXYDataset1();
        Range r = DatasetUtilities.findRangeBounds(dataset);
        DatasetUtilitiesTests.assertEquals((double)100.0, (double)r.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)105.0, (double)r.getUpperBound(), (double)1.0E-10);
    }

    public void testIterateCategoryRangeBounds() {
        CategoryDataset dataset = this.createCategoryDataset1();
        Range r = DatasetUtilities.iterateCategoryRangeBounds(dataset, false);
        DatasetUtilitiesTests.assertEquals((double)1.0, (double)r.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)6.0, (double)r.getUpperBound(), (double)1.0E-10);
    }

    public void testIterateXYRangeBounds() {
        XYDataset dataset = this.createXYDataset1();
        Range r = DatasetUtilities.iterateXYRangeBounds(dataset);
        DatasetUtilitiesTests.assertEquals((double)100.0, (double)r.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)105.0, (double)r.getUpperBound(), (double)1.0E-10);
    }

    public void testFindMinimumDomainValue() {
        XYDataset dataset = this.createXYDataset1();
        Number minimum = DatasetUtilities.findMinimumDomainValue(dataset);
        DatasetUtilitiesTests.assertEquals((Object)new Double(1.0), (Object)minimum);
    }

    public void testFindMaximumDomainValue() {
        XYDataset dataset = this.createXYDataset1();
        Number maximum = DatasetUtilities.findMaximumDomainValue(dataset);
        DatasetUtilitiesTests.assertEquals((Object)new Double(3.0), (Object)maximum);
    }

    public void testFindMinimumRangeValue() {
        CategoryDataset d1 = this.createCategoryDataset1();
        Number min1 = DatasetUtilities.findMinimumRangeValue(d1);
        DatasetUtilitiesTests.assertEquals((Object)new Double(1.0), (Object)min1);
        XYDataset d2 = this.createXYDataset1();
        Number min2 = DatasetUtilities.findMinimumRangeValue(d2);
        DatasetUtilitiesTests.assertEquals((Object)new Double(100.0), (Object)min2);
    }

    public void testFindMaximumRangeValue() {
        CategoryDataset d1 = this.createCategoryDataset1();
        Number max1 = DatasetUtilities.findMaximumRangeValue(d1);
        DatasetUtilitiesTests.assertEquals((Object)new Double(6.0), (Object)max1);
        XYDataset dataset = this.createXYDataset1();
        Number maximum = DatasetUtilities.findMaximumRangeValue(dataset);
        DatasetUtilitiesTests.assertEquals((Object)new Double(105.0), (Object)maximum);
    }

    public void testMinMaxRange() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(100.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 1"));
        dataset.addValue(101.1, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 2"));
        Number min = DatasetUtilities.findMinimumRangeValue(dataset);
        DatasetUtilitiesTests.assertTrue((min.doubleValue() < 100.1 ? 1 : 0) != 0);
        Number max = DatasetUtilities.findMaximumRangeValue(dataset);
        DatasetUtilitiesTests.assertTrue((max.doubleValue() > 101.0 ? 1 : 0) != 0);
    }

    public void test803660() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(100.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 1"));
        dataset.addValue(101.1, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 2"));
        Number n = DatasetUtilities.findMaximumRangeValue(dataset);
        DatasetUtilitiesTests.assertTrue((n.doubleValue() > 101.0 ? 1 : 0) != 0);
    }

    public void testCumulativeRange1() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(10.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Start"));
        dataset.addValue(15.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 1"));
        dataset.addValue(-7.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 2"));
        Range range = DatasetUtilities.findCumulativeRangeBounds(dataset);
        DatasetUtilitiesTests.assertEquals((double)0.0, (double)range.getLowerBound(), (double)1.0E-8);
        DatasetUtilitiesTests.assertEquals((double)25.0, (double)range.getUpperBound(), (double)1.0E-8);
    }

    public void testCumulativeRange2() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(-21.4, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Start Value"));
        dataset.addValue(11.57, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 1"));
        dataset.addValue(3.51, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 2"));
        dataset.addValue(-12.36, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 3"));
        dataset.addValue(3.39, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 4"));
        dataset.addValue(38.68, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 5"));
        dataset.addValue(-43.31, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 6"));
        dataset.addValue(-29.59, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 7"));
        dataset.addValue(35.3, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 8"));
        dataset.addValue(5.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 9"));
        Range range = DatasetUtilities.findCumulativeRangeBounds(dataset);
        DatasetUtilitiesTests.assertEquals((double)-49.51, (double)range.getLowerBound(), (double)1.0E-8);
        DatasetUtilitiesTests.assertEquals((double)23.39, (double)range.getUpperBound(), (double)1.0E-8);
    }

    public void testCreateCategoryDataset1() {
        String[] rowKeys = new String[]{"R1", "R2", "R3"};
        String[] columnKeys = new String[]{"C1", "C2"};
        double[][] data = new double[][]{{1.1, 1.2}, {2.1, 2.2}, {3.1, 3.2}};
        CategoryDataset dataset = DatasetUtilities.createCategoryDataset((Comparable[])rowKeys, (Comparable[])columnKeys, (double[][])data);
        DatasetUtilitiesTests.assertTrue((dataset.getRowCount() == 3 ? 1 : 0) != 0);
        DatasetUtilitiesTests.assertTrue((dataset.getColumnCount() == 2 ? 1 : 0) != 0);
    }

    public void testCreateCategoryDataset2() {
        boolean pass = false;
        String[] rowKeys = new String[]{"R1", "R2", "R3"};
        String[] columnKeys = new String[]{"C1", "C2"};
        double[][] data = new double[][]{{1.1, 1.2, 1.3}, {2.1, 2.2, 2.3}};
        CategoryDataset dataset = null;
        try {
            dataset = DatasetUtilities.createCategoryDataset((Comparable[])rowKeys, (Comparable[])columnKeys, (double[][])data);
        }
        catch (IllegalArgumentException e) {
            pass = true;
        }
        DatasetUtilitiesTests.assertTrue((boolean)pass);
        DatasetUtilitiesTests.assertTrue((dataset == null ? 1 : 0) != 0);
    }

    public void testMaximumStackedRangeValue() {
        double v1 = 24.3;
        double v2 = 14.2;
        double v3 = 33.2;
        double v4 = 32.4;
        double v5 = 26.3;
        double v6 = 22.6;
        Double answer = new Double(Math.max(v1 + v2 + v3, v4 + v5 + v6));
        DefaultCategoryDataset d = new DefaultCategoryDataset();
        d.addValue(v1, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 0"));
        d.addValue(v2, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 0"));
        d.addValue(v3, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 0"));
        d.addValue(v4, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 1"));
        d.addValue(v5, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        d.addValue(v6, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 1"));
        Number max = DatasetUtilities.findMaximumStackedRangeValue(d);
        DatasetUtilitiesTests.assertTrue((boolean)max.equals(answer));
    }

    public void testFindStackedRangeBoundsForCategoryDataset1() {
        CategoryDataset d1 = this.createCategoryDataset1();
        Range r = DatasetUtilities.findStackedRangeBounds(d1);
        DatasetUtilitiesTests.assertEquals((double)0.0, (double)r.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)15.0, (double)r.getUpperBound(), (double)1.0E-10);
        d1 = this.createCategoryDataset2();
        r = DatasetUtilities.findStackedRangeBounds(d1);
        DatasetUtilitiesTests.assertEquals((double)-2.0, (double)r.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)2.0, (double)r.getUpperBound(), (double)1.0E-10);
    }

    public void testFindStackedRangeBoundsForCategoryDataset2() {
        DefaultCategoryDataset d1 = new DefaultCategoryDataset();
        Range r = DatasetUtilities.findStackedRangeBounds(d1);
        DatasetUtilitiesTests.assertTrue((r == null ? 1 : 0) != 0);
    }

    public void testFindStackedRangeBoundsForTableXYDataset1() {
        TableXYDataset d2 = this.createTableXYDataset1();
        Range r = DatasetUtilities.findStackedRangeBounds(d2);
        DatasetUtilitiesTests.assertEquals((double)-2.0, (double)r.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)2.0, (double)r.getUpperBound(), (double)1.0E-10);
    }

    public void testFindStackedRangeBoundsForTableXYDataset2() {
        DefaultTableXYDataset d = new DefaultTableXYDataset();
        Range r = DatasetUtilities.findStackedRangeBounds(d);
        DatasetUtilitiesTests.assertEquals((Object)r, (Object)new Range(0.0, 0.0));
    }

    public void testStackedRangeWithMap() {
        CategoryDataset d = this.createCategoryDataset1();
        KeyToGroupMap map = new KeyToGroupMap((Comparable)((Object)"G0"));
        map.mapKeyToGroup((Comparable)((Object)"R2"), (Comparable)((Object)"G1"));
        Range r = DatasetUtilities.findStackedRangeBounds(d, map);
        DatasetUtilitiesTests.assertEquals((double)0.0, (double)r.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)9.0, (double)r.getUpperBound(), (double)1.0E-10);
    }

    public void testLimitPieDataset() {
        DefaultPieDataset d1 = new DefaultPieDataset();
        PieDataset d2 = DatasetUtilities.createConsolidatedPieDataset(d1, (Comparable)((Object)"Other"), 0.05);
        DatasetUtilitiesTests.assertEquals((int)0, (int)d2.getItemCount());
        d1.setValue((Comparable)((Object)"Item 1"), 1.0);
        d1.setValue((Comparable)((Object)"Item 2"), 49.5);
        d1.setValue((Comparable)((Object)"Item 3"), 49.5);
        d2 = DatasetUtilities.createConsolidatedPieDataset(d1, (Comparable)((Object)"Other"), 0.05);
        DatasetUtilitiesTests.assertEquals((int)3, (int)d2.getItemCount());
        DatasetUtilitiesTests.assertEquals((Object)"Item 1", (Object)d2.getKey(0));
        DatasetUtilitiesTests.assertEquals((Object)"Item 2", (Object)d2.getKey(1));
        DatasetUtilitiesTests.assertEquals((Object)"Item 3", (Object)d2.getKey(2));
        d1.setValue((Comparable)((Object)"Item 4"), 1.0);
        d2 = DatasetUtilities.createConsolidatedPieDataset(d1, (Comparable)((Object)"Other"), 0.05, 2);
        DatasetUtilitiesTests.assertEquals((int)3, (int)d2.getItemCount());
        DatasetUtilitiesTests.assertEquals((Object)"Item 2", (Object)d2.getKey(0));
        DatasetUtilitiesTests.assertEquals((Object)"Item 3", (Object)d2.getKey(1));
        DatasetUtilitiesTests.assertEquals((Object)"Other", (Object)d2.getKey(2));
        DatasetUtilitiesTests.assertEquals((Object)new Double(2.0), (Object)d2.getValue((Comparable)((Object)"Other")));
    }

    private CategoryDataset createCategoryDataset1() {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        result.addValue(1.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C0"));
        result.addValue(1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C0"));
        result.addValue(1.0, (Comparable)((Object)"R2"), (Comparable)((Object)"C0"));
        result.addValue(4.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
        result.addValue(5.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        result.addValue(6.0, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
        return result;
    }

    private CategoryDataset createCategoryDataset2() {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        result.addValue(1.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C0"));
        result.addValue(-2.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C0"));
        result.addValue(2.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
        result.addValue(-1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        return result;
    }

    private XYDataset createXYDataset1() {
        XYSeries series1 = new XYSeries((Comparable)((Object)"S1"));
        series1.add(1.0, 100.0);
        series1.add(2.0, 101.0);
        series1.add(3.0, 102.0);
        XYSeries series2 = new XYSeries((Comparable)((Object)"S2"));
        series2.add(1.0, 103.0);
        series2.add(2.0, (Number)null);
        series2.add(3.0, 105.0);
        XYSeriesCollection result = new XYSeriesCollection();
        result.addSeries(series1);
        result.addSeries(series2);
        result.setIntervalWidth(0.0);
        return result;
    }

    private TableXYDataset createTableXYDataset1() {
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        XYSeries s1 = new XYSeries((Comparable)((Object)"Series 1"), true, false);
        s1.add(1.0, 1.0);
        s1.add(2.0, 2.0);
        dataset.addSeries(s1);
        XYSeries s2 = new XYSeries((Comparable)((Object)"Series 2"), true, false);
        s2.add(1.0, -2.0);
        s2.add(2.0, -1.0);
        dataset.addSeries(s2);
        return dataset;
    }
}

