/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title.junit;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.ui.RectangleInsets;

public class CompositeTitleTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CompositeTitleTests.class);
    }

    public CompositeTitleTests(String name) {
        super(name);
    }

    public void testEquals() {
        CompositeTitle t1 = new CompositeTitle(new BlockContainer());
        CompositeTitle t2 = new CompositeTitle(new BlockContainer());
        CompositeTitleTests.assertEquals((Object)t1, (Object)t2);
        CompositeTitleTests.assertEquals((Object)t2, (Object)t1);
        t1.setMargin(new RectangleInsets(1.0, 2.0, 3.0, 4.0));
        CompositeTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setMargin(new RectangleInsets(1.0, 2.0, 3.0, 4.0));
        CompositeTitleTests.assertTrue((boolean)t1.equals(t2));
        t1.setBorder(new BlockBorder(Color.red));
        CompositeTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setBorder(new BlockBorder(Color.red));
        CompositeTitleTests.assertTrue((boolean)t1.equals(t2));
        t1.setPadding(new RectangleInsets(1.0, 2.0, 3.0, 4.0));
        CompositeTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.setPadding(new RectangleInsets(1.0, 2.0, 3.0, 4.0));
        CompositeTitleTests.assertTrue((boolean)t1.equals(t2));
        t1.getContainer().add(new TextTitle("T1"));
        CompositeTitleTests.assertFalse((boolean)t1.equals(t2));
        t2.getContainer().add(new TextTitle("T1"));
        CompositeTitleTests.assertTrue((boolean)t1.equals(t2));
    }

    public void testHashcode() {
        CompositeTitle t1 = new CompositeTitle(new BlockContainer());
        t1.getContainer().add(new TextTitle("T1"));
        CompositeTitle t2 = new CompositeTitle(new BlockContainer());
        t2.getContainer().add(new TextTitle("T1"));
        CompositeTitleTests.assertTrue((boolean)t1.equals(t2));
        int h1 = t1.hashCode();
        int h2 = t2.hashCode();
        CompositeTitleTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        CompositeTitle t1 = new CompositeTitle(new BlockContainer());
        t1.getContainer().add(new TextTitle("T1"));
        CompositeTitle t2 = null;
        try {
            t2 = (CompositeTitle)t1.clone();
        }
        catch (CloneNotSupportedException e) {
            CompositeTitleTests.fail((String)e.toString());
        }
        CompositeTitleTests.assertTrue((t1 != t2 ? 1 : 0) != 0);
        CompositeTitleTests.assertTrue((t1.getClass() == t2.getClass() ? 1 : 0) != 0);
        CompositeTitleTests.assertTrue((boolean)t1.equals(t2));
    }

    public void testSerialization() {
        CompositeTitle t1 = new CompositeTitle(new BlockContainer());
        t1.getContainer().add(new TextTitle("T1"));
        CompositeTitle t2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(t1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            t2 = (CompositeTitle)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CompositeTitleTests.assertEquals((Object)t1, t2);
    }
}

