/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.XYDotRenderer;

public class XYDotRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYDotRendererTests.class);
    }

    public XYDotRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        XYDotRenderer r1 = new XYDotRenderer();
        XYDotRenderer r2 = new XYDotRenderer();
        XYDotRendererTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        XYDotRenderer r1 = new XYDotRenderer();
        XYDotRenderer r2 = new XYDotRenderer();
        XYDotRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        XYDotRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        XYDotRenderer r1 = new XYDotRenderer();
        XYDotRenderer r2 = null;
        try {
            r2 = (XYDotRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        XYDotRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        XYDotRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        XYDotRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        XYDotRenderer r1 = new XYDotRenderer();
        XYDotRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (XYDotRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        XYDotRendererTests.assertEquals((Object)r1, r2);
    }
}

