/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.WindItemRenderer;

public class WindItemRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(WindItemRendererTests.class);
    }

    public WindItemRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        WindItemRenderer r1 = new WindItemRenderer();
        WindItemRenderer r2 = new WindItemRenderer();
        WindItemRendererTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        WindItemRenderer r1 = new WindItemRenderer();
        WindItemRenderer r2 = new WindItemRenderer();
        WindItemRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        WindItemRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        WindItemRenderer r1 = new WindItemRenderer();
        WindItemRenderer r2 = null;
        try {
            r2 = (WindItemRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        WindItemRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        WindItemRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        WindItemRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        WindItemRenderer r1 = new WindItemRenderer();
        WindItemRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (WindItemRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        WindItemRendererTests.assertEquals((Object)r1, r2);
    }
}

