/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.CandlestickRenderer;

public class CandlestickRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CandlestickRendererTests.class);
    }

    public CandlestickRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        CandlestickRenderer r1 = new CandlestickRenderer();
        CandlestickRenderer r2 = new CandlestickRenderer();
        CandlestickRendererTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        CandlestickRenderer r1 = new CandlestickRenderer();
        CandlestickRenderer r2 = new CandlestickRenderer();
        CandlestickRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        CandlestickRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        CandlestickRenderer r1 = new CandlestickRenderer();
        CandlestickRenderer r2 = null;
        try {
            r2 = (CandlestickRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        CandlestickRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        CandlestickRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        CandlestickRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        CandlestickRenderer r1 = new CandlestickRenderer();
        CandlestickRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (CandlestickRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CandlestickRendererTests.assertEquals((Object)r1, r2);
    }
}

