/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class AbstractXYItemRendererTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(AbstractXYItemRendererTests.class);
    }

    public AbstractXYItemRendererTests(String name) {
        super(name);
    }

    private XYDataset createDataset1() {
        XYSeries series = new XYSeries((Comparable)((Object)"Series"));
        series.add(1.0, 1.0);
        series.add(2.0, 2.0);
        series.add(3.0, 3.0);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    public void testFindDomainBounds() {
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        XYDataset dataset = this.createDataset1();
        Range r = renderer.findDomainBounds(dataset);
        AbstractXYItemRendererTests.assertEquals((double)1.0, (double)r.getLowerBound(), (double)1.0E-10);
        AbstractXYItemRendererTests.assertEquals((double)3.0, (double)r.getUpperBound(), (double)1.0E-10);
        AbstractXYItemRendererTests.assertTrue((renderer.findDomainBounds(null) == null ? 1 : 0) != 0);
    }

    public void testFindRangeBounds() {
        StandardXYItemRenderer renderer = new StandardXYItemRenderer();
        AbstractXYItemRendererTests.assertTrue((renderer.findRangeBounds(null) == null ? 1 : 0) != 0);
    }
}

