/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;

public class StackedBarRenderer3DTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StackedBarRenderer3DTests.class);
    }

    public StackedBarRenderer3DTests(String name) {
        super(name);
    }

    public void testEquals() {
        StackedBarRenderer3D r1 = new StackedBarRenderer3D();
        StackedBarRenderer3D r2 = new StackedBarRenderer3D();
        StackedBarRenderer3DTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        StackedBarRenderer3D r1 = new StackedBarRenderer3D();
        StackedBarRenderer3D r2 = new StackedBarRenderer3D();
        StackedBarRenderer3DTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        StackedBarRenderer3DTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        StackedBarRenderer3D r1 = new StackedBarRenderer3D();
        StackedBarRenderer3D r2 = null;
        try {
            r2 = (StackedBarRenderer3D)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StackedBarRenderer3DTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        StackedBarRenderer3DTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        StackedBarRenderer3DTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        StackedBarRenderer3D r1 = new StackedBarRenderer3D();
        StackedBarRenderer3D r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (StackedBarRenderer3D)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StackedBarRenderer3DTests.assertEquals((Object)r1, r2);
    }
}

