/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.IntervalBarRenderer;

public class IntervalBarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(IntervalBarRendererTests.class);
    }

    public IntervalBarRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        IntervalBarRenderer r1 = new IntervalBarRenderer();
        IntervalBarRenderer r2 = new IntervalBarRenderer();
        IntervalBarRendererTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        IntervalBarRenderer r1 = new IntervalBarRenderer();
        IntervalBarRenderer r2 = new IntervalBarRenderer();
        IntervalBarRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        IntervalBarRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        IntervalBarRenderer r1 = new IntervalBarRenderer();
        IntervalBarRenderer r2 = null;
        try {
            r2 = (IntervalBarRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        IntervalBarRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        IntervalBarRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        IntervalBarRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        IntervalBarRenderer r1 = new IntervalBarRenderer();
        IntervalBarRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (IntervalBarRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        IntervalBarRendererTests.assertEquals((Object)r1, r2);
    }
}

