/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.AreaRenderer;

public class AreaRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(AreaRendererTests.class);
    }

    public AreaRendererTests(String name) {
        super(name);
    }

    public void testEquals() {
        AreaRenderer r1 = new AreaRenderer();
        AreaRenderer r2 = new AreaRenderer();
        AreaRendererTests.assertEquals((Object)r1, (Object)r2);
    }

    public void testHashcode() {
        AreaRenderer r1 = new AreaRenderer();
        AreaRenderer r2 = new AreaRenderer();
        AreaRendererTests.assertTrue((boolean)r1.equals(r2));
        int h1 = r1.hashCode();
        int h2 = r2.hashCode();
        AreaRendererTests.assertEquals((int)h1, (int)h2);
    }

    public void testCloning() {
        AreaRenderer r1 = new AreaRenderer();
        AreaRenderer r2 = null;
        try {
            r2 = (AreaRenderer)r1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        AreaRendererTests.assertTrue((r1 != r2 ? 1 : 0) != 0);
        AreaRendererTests.assertTrue((r1.getClass() == r2.getClass() ? 1 : 0) != 0);
        AreaRendererTests.assertTrue((boolean)r1.equals(r2));
    }

    public void testSerialization() {
        AreaRenderer r1 = new AreaRenderer();
        AreaRenderer r2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(r1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            r2 = (AreaRenderer)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        AreaRendererTests.assertEquals((Object)r1, r2);
    }
}

