/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.RingPlot;

public class RingPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(RingPlotTests.class);
    }

    public RingPlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        RingPlot plot1 = new RingPlot(null);
        RingPlot plot2 = new RingPlot(null);
        RingPlotTests.assertTrue((boolean)plot1.equals(plot2));
        RingPlotTests.assertTrue((boolean)plot2.equals(plot1));
        plot1.setSeparatorsVisible(false);
        RingPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSeparatorsVisible(false);
        RingPlotTests.assertTrue((boolean)plot1.equals(plot2));
        BasicStroke s = new BasicStroke(1.1f);
        plot1.setSeparatorStroke(s);
        RingPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSeparatorStroke(s);
        RingPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setSeparatorPaint(Color.red);
        RingPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setSeparatorPaint(Color.red);
        RingPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setInnerSeparatorExtension(0.01);
        RingPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setInnerSeparatorExtension(0.01);
        RingPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setOuterSeparatorExtension(0.02);
        RingPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setOuterSeparatorExtension(0.02);
        RingPlotTests.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        RingPlot p1 = new RingPlot(null);
        RingPlot p2 = null;
        try {
            p2 = (RingPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        RingPlotTests.assertTrue((p1 != p2 ? 1 : 0) != 0);
        RingPlotTests.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        RingPlotTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization() {
        RingPlot p1 = new RingPlot(null);
        RingPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (RingPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        RingPlotTests.assertEquals((Object)p1, p2);
    }
}

