/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultValueDataset;

public class MeterPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(MeterPlotTests.class);
    }

    public MeterPlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        MeterPlot plot1 = new MeterPlot();
        MeterPlot plot2 = new MeterPlot();
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setUnits("mph");
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setUnits("mph");
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setRange(new Range(50.0, 70.0));
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setRange(new Range(50.0, 70.0));
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.addInterval(new MeterInterval("Normal", new Range(55.0, 60.0)));
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.addInterval(new MeterInterval("Normal", new Range(55.0, 60.0)));
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDialOutlinePaint(Color.red);
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDialOutlinePaint(Color.red);
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDialShape(DialShape.CHORD);
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDialShape(DialShape.CHORD);
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDialBackgroundPaint(Color.yellow);
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDialBackgroundPaint(Color.yellow);
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setNeedlePaint(Color.black);
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setNeedlePaint(Color.black);
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setValueFont(new Font("Serif", 0, 6));
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setValueFont(new Font("Serif", 0, 6));
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setValuePaint(Color.black);
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setValuePaint(Color.black);
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setTickLabelsVisible(false);
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setTickLabelsVisible(false);
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setTickLabelFont(new Font("Serif", 0, 6));
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setTickLabelFont(new Font("Serif", 0, 6));
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setTickLabelFormat(new DecimalFormat("0"));
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setTickLabelFormat(new DecimalFormat("0"));
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setDrawBorder(!plot1.getDrawBorder());
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setDrawBorder(plot1.getDrawBorder());
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
        plot1.setMeterAngle(22);
        MeterPlotTests.assertFalse((boolean)plot1.equals(plot2));
        plot2.setMeterAngle(22);
        MeterPlotTests.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testCloning() {
        MeterPlot p1 = new MeterPlot();
        MeterPlot p2 = null;
        try {
            p2 = (MeterPlot)p1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        MeterPlotTests.assertTrue((p1 != p2 ? 1 : 0) != 0);
        MeterPlotTests.assertTrue((p1.getClass() == p2.getClass() ? 1 : 0) != 0);
        MeterPlotTests.assertTrue((boolean)p1.equals(p2));
        MeterPlotTests.assertTrue((p1.getDataset() == p2.getDataset() ? 1 : 0) != 0);
        p1.getTickLabelFormat().setMinimumIntegerDigits(99);
        MeterPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.getTickLabelFormat().setMinimumIntegerDigits(99);
        MeterPlotTests.assertTrue((boolean)p1.equals(p2));
        p1.addInterval(new MeterInterval("Test", new Range(1.234, 5.678)));
        MeterPlotTests.assertFalse((boolean)p1.equals(p2));
        p2.addInterval(new MeterInterval("Test", new Range(1.234, 5.678)));
        MeterPlotTests.assertTrue((boolean)p1.equals(p2));
    }

    public void testSerialization1() {
        MeterPlot p1 = new MeterPlot(null);
        MeterPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (MeterPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        MeterPlotTests.assertEquals((Object)p1, p2);
    }

    public void testSerialization2() {
        MeterPlot p1 = new MeterPlot(new DefaultValueDataset(1.23));
        MeterPlot p2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(p1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            p2 = (MeterPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MeterPlotTests.assertEquals((Object)p1, p2);
    }
}

