/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CombinedRangeXYPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CombinedRangeXYPlotTests.class);
    }

    public CombinedRangeXYPlotTests(String name) {
        super(name);
    }

    public void testEquals() {
        CombinedRangeXYPlot plot1 = this.createPlot();
        CombinedRangeXYPlot plot2 = this.createPlot();
        CombinedRangeXYPlotTests.assertTrue((boolean)plot1.equals(plot2));
        CombinedRangeXYPlotTests.assertTrue((boolean)plot2.equals(plot1));
    }

    public void testRemoveSubplot() {
        CombinedRangeXYPlot plot = new CombinedRangeXYPlot();
        XYPlot plot1 = new XYPlot();
        XYPlot plot2 = new XYPlot();
        plot.add(plot1);
        plot.add(plot2);
        plot.remove(plot2);
        List plots = plot.getSubplots();
        CombinedRangeXYPlotTests.assertTrue((plots.get(0) == plot1 ? 1 : 0) != 0);
    }

    public void testCloning() {
        CombinedRangeXYPlot plot1 = this.createPlot();
        CombinedRangeXYPlot plot2 = null;
        try {
            plot2 = (CombinedRangeXYPlot)plot1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        CombinedRangeXYPlotTests.assertTrue((plot1 != plot2 ? 1 : 0) != 0);
        CombinedRangeXYPlotTests.assertTrue((plot1.getClass() == plot2.getClass() ? 1 : 0) != 0);
        CombinedRangeXYPlotTests.assertTrue((boolean)plot1.equals(plot2));
    }

    public void testSerialization() {
        CombinedRangeXYPlot plot1 = this.createPlot();
        CombinedRangeXYPlot plot2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(plot1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            plot2 = (CombinedRangeXYPlot)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CombinedRangeXYPlotTests.assertEquals((Object)plot1, plot2);
    }

    private XYDataset createDataset1() {
        XYSeries series1 = new XYSeries((Comparable)((Object)"Series 1"));
        series1.add(10.0, 12353.3);
        series1.add(20.0, 13734.4);
        series1.add(30.0, 14525.3);
        series1.add(40.0, 13984.3);
        series1.add(50.0, 12999.4);
        series1.add(60.0, 14274.3);
        series1.add(70.0, 15943.5);
        series1.add(80.0, 14845.3);
        series1.add(90.0, 14645.4);
        series1.add(100.0, 16234.6);
        series1.add(110.0, 17232.3);
        series1.add(120.0, 14232.2);
        series1.add(130.0, 13102.2);
        series1.add(140.0, 14230.2);
        series1.add(150.0, 11235.2);
        XYSeries series2 = new XYSeries((Comparable)((Object)"Series 2"));
        series2.add(10.0, 15000.3);
        series2.add(20.0, 11000.4);
        series2.add(30.0, 17000.3);
        series2.add(40.0, 15000.3);
        series2.add(50.0, 14000.4);
        series2.add(60.0, 12000.3);
        series2.add(70.0, 11000.5);
        series2.add(80.0, 12000.3);
        series2.add(90.0, 13000.4);
        series2.add(100.0, 12000.6);
        series2.add(110.0, 13000.3);
        series2.add(120.0, 17000.2);
        series2.add(130.0, 18000.2);
        series2.add(140.0, 16000.2);
        series2.add(150.0, 17000.2);
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(series1);
        collection.addSeries(series2);
        return collection;
    }

    private XYDataset createDataset2() {
        XYSeries series2 = new XYSeries((Comparable)((Object)"Series 3"));
        series2.add(10.0, 16853.2);
        series2.add(20.0, 19642.3);
        series2.add(30.0, 18253.5);
        series2.add(40.0, 15352.3);
        series2.add(50.0, 13532.0);
        series2.add(100.0, 12635.3);
        series2.add(110.0, 13998.2);
        series2.add(120.0, 11943.2);
        series2.add(130.0, 16943.9);
        series2.add(140.0, 17843.2);
        series2.add(150.0, 16495.3);
        series2.add(160.0, 17943.6);
        series2.add(170.0, 18500.7);
        series2.add(180.0, 19595.9);
        return new XYSeriesCollection(series2);
    }

    private CombinedRangeXYPlot createPlot() {
        XYDataset data1 = this.createDataset1();
        StandardXYItemRenderer renderer1 = new StandardXYItemRenderer();
        NumberAxis rangeAxis1 = new NumberAxis("Range 1");
        XYPlot subplot1 = new XYPlot(data1, null, rangeAxis1, renderer1);
        subplot1.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        XYTextAnnotation annotation = new XYTextAnnotation("Hello!", 50.0, 10000.0);
        annotation.setFont(new Font("SansSerif", 0, 9));
        annotation.setRotationAngle(0.7853981633974483);
        subplot1.addAnnotation(annotation);
        XYDataset data2 = this.createDataset2();
        StandardXYItemRenderer renderer2 = new StandardXYItemRenderer();
        NumberAxis rangeAxis2 = new NumberAxis("Range 2");
        rangeAxis2.setAutoRangeIncludesZero(false);
        XYPlot subplot2 = new XYPlot(data2, null, rangeAxis2, renderer2);
        subplot2.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        CombinedRangeXYPlot plot = new CombinedRangeXYPlot(new NumberAxis("Range"));
        plot.setGap(10.0);
        plot.add(subplot1, 1);
        plot.add(subplot2, 1);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }
}

