/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardXYZToolTipGenerator;

public class StandardXYZToolTipGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardXYZToolTipGeneratorTests.class);
    }

    public StandardXYZToolTipGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        String f1 = "{1}";
        String f2 = "{2}";
        DecimalFormat xnf1 = new DecimalFormat("0.00");
        DecimalFormat xnf2 = new DecimalFormat("0.000");
        DecimalFormat ynf1 = new DecimalFormat("0.00");
        DecimalFormat ynf2 = new DecimalFormat("0.000");
        DecimalFormat znf1 = new DecimalFormat("0.00");
        DecimalFormat znf2 = new DecimalFormat("0.000");
        SimpleDateFormat xdf1 = new SimpleDateFormat("d-MMM");
        SimpleDateFormat xdf2 = new SimpleDateFormat("d-MMM-yyyy");
        SimpleDateFormat ydf1 = new SimpleDateFormat("d-MMM");
        SimpleDateFormat ydf2 = new SimpleDateFormat("d-MMM-yyyy");
        SimpleDateFormat zdf1 = new SimpleDateFormat("d-MMM");
        SimpleDateFormat zdf2 = new SimpleDateFormat("d-MMM-yyyy");
        StandardXYZToolTipGenerator g1 = null;
        StandardXYZToolTipGenerator g2 = null;
        g1 = new StandardXYZToolTipGenerator(f1, xnf1, ynf1, znf1);
        g2 = new StandardXYZToolTipGenerator(f1, xnf1, ynf1, znf1);
        StandardXYZToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYZToolTipGenerator(f2, xnf1, ynf1, znf1);
        StandardXYZToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYZToolTipGenerator(f2, xnf1, ynf1, znf1);
        StandardXYZToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYZToolTipGenerator(f2, xnf2, ynf1, znf1);
        StandardXYZToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYZToolTipGenerator(f2, xnf2, ynf1, znf1);
        StandardXYZToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYZToolTipGenerator(f2, xnf2, ynf2, znf1);
        StandardXYZToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYZToolTipGenerator(f2, xnf2, ynf2, znf1);
        StandardXYZToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYZToolTipGenerator(f2, xnf2, ynf2, znf2);
        StandardXYZToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYZToolTipGenerator(f2, xnf2, ynf2, znf2);
        StandardXYZToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYZToolTipGenerator(f2, xdf1, ydf1, zdf1);
        g2 = new StandardXYZToolTipGenerator(f2, xdf1, ydf1, zdf1);
        StandardXYZToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYZToolTipGenerator(f2, xdf2, ydf1, zdf1);
        StandardXYZToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYZToolTipGenerator(f2, xdf2, ydf1, zdf1);
        StandardXYZToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYZToolTipGenerator(f2, xdf2, ydf2, zdf1);
        StandardXYZToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYZToolTipGenerator(f2, xdf2, ydf2, zdf1);
        StandardXYZToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYZToolTipGenerator(f2, xdf2, ydf2, zdf2);
        StandardXYZToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYZToolTipGenerator(f2, xdf2, ydf2, zdf2);
        StandardXYZToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        StandardXYZToolTipGenerator g1 = new StandardXYZToolTipGenerator();
        StandardXYZToolTipGenerator g2 = null;
        try {
            g2 = (StandardXYZToolTipGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StandardXYZToolTipGeneratorTests.assertTrue((g1 != g2 ? 1 : 0) != 0);
        StandardXYZToolTipGeneratorTests.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        StandardXYZToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        StandardXYZToolTipGenerator g1 = new StandardXYZToolTipGenerator();
        StandardXYZToolTipGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (StandardXYZToolTipGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StandardXYZToolTipGeneratorTests.assertEquals((Object)g1, g2);
    }
}

