/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;

public class StandardXYLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardXYLabelGeneratorTests.class);
    }

    public StandardXYLabelGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        String f1 = "{1}";
        String f2 = "{2}";
        DecimalFormat xnf1 = new DecimalFormat("0.00");
        DecimalFormat xnf2 = new DecimalFormat("0.000");
        DecimalFormat ynf1 = new DecimalFormat("0.00");
        DecimalFormat ynf2 = new DecimalFormat("0.000");
        StandardXYItemLabelGenerator g1 = null;
        StandardXYItemLabelGenerator g2 = null;
        g1 = new StandardXYItemLabelGenerator(f1, xnf1, (NumberFormat)ynf1);
        g2 = new StandardXYItemLabelGenerator(f1, xnf1, (NumberFormat)ynf1);
        StandardXYLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        StandardXYLabelGeneratorTests.assertTrue((boolean)g2.equals(g1));
        g1 = new StandardXYItemLabelGenerator(f2, xnf1, (NumberFormat)ynf1);
        StandardXYLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYItemLabelGenerator(f2, xnf1, (NumberFormat)ynf1);
        StandardXYLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYItemLabelGenerator(f2, xnf2, (NumberFormat)ynf1);
        StandardXYLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYItemLabelGenerator(f2, xnf2, (NumberFormat)ynf1);
        StandardXYLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYItemLabelGenerator(f2, xnf2, (NumberFormat)ynf2);
        StandardXYLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYItemLabelGenerator(f2, xnf2, (NumberFormat)ynf2);
        StandardXYLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        SimpleDateFormat xdf1 = new SimpleDateFormat("d-MMM");
        SimpleDateFormat xdf2 = new SimpleDateFormat("d-MMM-yyyy");
        SimpleDateFormat ydf1 = new SimpleDateFormat("d-MMM");
        SimpleDateFormat ydf2 = new SimpleDateFormat("d-MMM-yyyy");
        g1 = new StandardXYItemLabelGenerator(f1, (DateFormat)xdf1, ydf1);
        g2 = new StandardXYItemLabelGenerator(f1, (DateFormat)xdf1, ydf1);
        StandardXYLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        StandardXYLabelGeneratorTests.assertTrue((boolean)g2.equals(g1));
        g1 = new StandardXYItemLabelGenerator(f1, (DateFormat)xdf2, ydf1);
        StandardXYLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYItemLabelGenerator(f1, (DateFormat)xdf2, ydf1);
        StandardXYLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardXYItemLabelGenerator(f1, (DateFormat)xdf2, ydf2);
        StandardXYLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardXYItemLabelGenerator(f1, (DateFormat)xdf2, ydf2);
        StandardXYLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        StandardXYItemLabelGenerator g1 = new StandardXYItemLabelGenerator();
        StandardXYItemLabelGenerator g2 = null;
        try {
            g2 = (StandardXYItemLabelGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Clone failed.");
        }
        StandardXYLabelGeneratorTests.assertTrue((g1 != g2 ? 1 : 0) != 0);
        StandardXYLabelGeneratorTests.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        StandardXYLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        StandardXYItemLabelGenerator g1 = new StandardXYItemLabelGenerator();
        StandardXYItemLabelGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (StandardXYItemLabelGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StandardXYLabelGeneratorTests.assertEquals((Object)g1, g2);
    }
}

