/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;

public class StandardPieItemLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardPieItemLabelGeneratorTests.class);
    }

    public StandardPieItemLabelGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        StandardPieItemLabelGenerator g1 = new StandardPieItemLabelGenerator();
        StandardPieItemLabelGenerator g2 = new StandardPieItemLabelGenerator();
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)g2.equals(g1));
        g1 = new StandardPieItemLabelGenerator("{0}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardPieItemLabelGenerator("{0}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0.00"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), NumberFormat.getPercentInstance());
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), new DecimalFormat("0.000%"));
        StandardPieItemLabelGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardPieItemLabelGenerator("{0} {1}", new DecimalFormat("#,##0"), new DecimalFormat("0.000%"));
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        StandardPieItemLabelGenerator g1 = new StandardPieItemLabelGenerator();
        StandardPieItemLabelGenerator g2 = null;
        try {
            g2 = (StandardPieItemLabelGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StandardPieItemLabelGeneratorTests.assertTrue((g1 != g2 ? 1 : 0) != 0);
        StandardPieItemLabelGeneratorTests.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        StandardPieItemLabelGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        StandardPieItemLabelGenerator g1 = new StandardPieItemLabelGenerator();
        StandardPieItemLabelGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (StandardPieItemLabelGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StandardPieItemLabelGeneratorTests.assertEquals((Object)g1, g2);
    }
}

