/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;

public class StandardCategoryToolTipGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardCategoryToolTipGeneratorTests.class);
    }

    public StandardCategoryToolTipGeneratorTests(String name) {
        super(name);
    }

    public void testEquals() {
        StandardCategoryToolTipGenerator g1 = new StandardCategoryToolTipGenerator();
        StandardCategoryToolTipGenerator g2 = new StandardCategoryToolTipGenerator();
        StandardCategoryToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        StandardCategoryToolTipGeneratorTests.assertTrue((boolean)g2.equals(g1));
        g1 = new StandardCategoryToolTipGenerator("{0}", new DecimalFormat("0.000"));
        StandardCategoryToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardCategoryToolTipGenerator("{0}", new DecimalFormat("0.000"));
        StandardCategoryToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardCategoryToolTipGenerator("{1}", new DecimalFormat("0.000"));
        StandardCategoryToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardCategoryToolTipGenerator("{1}", new DecimalFormat("0.000"));
        StandardCategoryToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
        g1 = new StandardCategoryToolTipGenerator("{2}", new SimpleDateFormat("d-MMM"));
        StandardCategoryToolTipGeneratorTests.assertFalse((boolean)g1.equals(g2));
        g2 = new StandardCategoryToolTipGenerator("{2}", new SimpleDateFormat("d-MMM"));
        StandardCategoryToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testCloning() {
        StandardCategoryToolTipGenerator g1 = new StandardCategoryToolTipGenerator();
        StandardCategoryToolTipGenerator g2 = null;
        try {
            g2 = (StandardCategoryToolTipGenerator)g1.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone.");
        }
        StandardCategoryToolTipGeneratorTests.assertTrue((g1 != g2 ? 1 : 0) != 0);
        StandardCategoryToolTipGeneratorTests.assertTrue((g1.getClass() == g2.getClass() ? 1 : 0) != 0);
        StandardCategoryToolTipGeneratorTests.assertTrue((boolean)g1.equals(g2));
    }

    public void testSerialization() {
        StandardCategoryToolTipGenerator g1 = new StandardCategoryToolTipGenerator("{2}", DateFormat.getInstance());
        StandardCategoryToolTipGenerator g2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(g1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            g2 = (StandardCategoryToolTipGenerator)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        StandardCategoryToolTipGeneratorTests.assertEquals((Object)g1, g2);
    }
}

